package com.businesslogic.ireport;

import java.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'CompatibilityForm'
 * created in the main() method.
 */
public class CompatibilityForm extends Form
{
	public CompatibilityForm()
	{
		super();

		// Required for Visual J++ Form Designer support
		initForm();		
		load();

		// TODO: Add any constructor code after initForm call
	}

	/**
	 * CompatibilityForm overrides dispose so it can clean up the
	 * component list.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void CompatibilityForm_click(Object source, Event e)
	{
		
	}

	private void btnOk_click(Object source, Event e)
	{
		save();
		close();
	}

	private void CompatibilityForm_closing(Object source, CancelEvent e)
	{
	  save();
	}
	
	private void save()
	{
		CompatibilitySupport.saveEllipse = cbxSaveEllipse.getChecked();
		CompatibilitySupport.saveRoundedRectangle = cbxSaveRounded.getChecked();
		CompatibilitySupport.saveVerticalAlignemnt = cbxSaveVerticalAlignement.getChecked();
		
		CompatibilitySupport.saveImgVerticalAlignement = cbxSaveImgVerticalAlignement.getChecked();	
		CompatibilitySupport.saveImgHorizontalAlignement = cbxSaveImgHorizontalAlignement.getChecked();	
		
		CompatibilitySupport.saveBackground = cbxSaveBackground.getChecked();	
		
	}
	
	private void load()
	{
		cbxSaveEllipse.setChecked( CompatibilitySupport.saveEllipse );
		cbxSaveRounded.setChecked( CompatibilitySupport.saveRoundedRectangle );
		cbxSaveVerticalAlignement.setChecked( CompatibilitySupport.saveVerticalAlignemnt );	
		
		cbxSaveImgVerticalAlignement.setChecked( CompatibilitySupport.saveImgVerticalAlignement );		
		cbxSaveImgHorizontalAlignement.setChecked( CompatibilitySupport.saveImgHorizontalAlignement );		
		
		cbxSaveBackground.setChecked( CompatibilitySupport.saveBackground );		
	}



	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	GroupBox groupBox1 = new GroupBox();
	CheckBox cbxSaveEllipse = new CheckBox();
	CheckBox cbxSaveRounded = new CheckBox();
	CheckBox cbxSaveVerticalAlignement = new CheckBox();
	Button btnOk = new Button();
	GroupBox groupBox2 = new GroupBox();
	CheckBox cbxSaveImgVerticalAlignement = new CheckBox();
	CheckBox cbxSaveImgHorizontalAlignement = new CheckBox();
	CheckBox cbxSaveBackground = new CheckBox();

	private void initForm()
	{
		this.setText("CompatibilityForm");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setClientSize(new Point(300, 300));
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);
		this.addOnClick(new EventHandler(this.CompatibilityForm_click));
		this.addOnClosing(new CancelEventHandler(this.CompatibilityForm_closing));

		groupBox1.setSize(new Point(296, 104));
		groupBox1.setTabIndex(1);
		groupBox1.setTabStop(false);
		groupBox1.setText("Jasper 0.4.5");

		cbxSaveEllipse.setLocation(new Point(16, 72));
		cbxSaveEllipse.setSize(new Point(136, 23));
		cbxSaveEllipse.setTabIndex(0);
		cbxSaveEllipse.setText("Save ellipse");

		cbxSaveRounded.setLocation(new Point(16, 48));
		cbxSaveRounded.setSize(new Point(136, 23));
		cbxSaveRounded.setTabIndex(1);
		cbxSaveRounded.setText("Save rounded rectangle");

		cbxSaveVerticalAlignement.setLocation(new Point(16, 24));
		cbxSaveVerticalAlignement.setSize(new Point(136, 23));
		cbxSaveVerticalAlignement.setTabIndex(2);
		cbxSaveVerticalAlignement.setText("Save vertical alignement");

		btnOk.setLocation(new Point(232, 272));
		btnOk.setSize(new Point(64, 24));
		btnOk.setTabIndex(2);
		btnOk.setText("Ok");
		btnOk.addOnClick(new EventHandler(this.btnOk_click));

		groupBox2.setLocation(new Point(0, 108));
		groupBox2.setSize(new Point(296, 104));
		groupBox2.setTabIndex(0);
		groupBox2.setTabStop(false);
		groupBox2.setText("Jasper 0.4.6");

		cbxSaveImgVerticalAlignement.setLocation(new Point(16, 24));
		cbxSaveImgVerticalAlignement.setSize(new Point(184, 23));
		cbxSaveImgVerticalAlignement.setTabIndex(2);
		cbxSaveImgVerticalAlignement.setText("Save image vertical alignement");

		cbxSaveImgHorizontalAlignement.setLocation(new Point(16, 48));
		cbxSaveImgHorizontalAlignement.setSize(new Point(208, 23));
		cbxSaveImgHorizontalAlignement.setTabIndex(1);
		cbxSaveImgHorizontalAlignement.setText("Save image horizontal alignement");

		cbxSaveBackground.setLocation(new Point(16, 72));
		cbxSaveBackground.setSize(new Point(208, 23));
		cbxSaveBackground.setTabIndex(0);
		cbxSaveBackground.setText("Save background band");

		this.setNewControls(new Control[] {
							groupBox2, 
							btnOk, 
							groupBox1});
		groupBox1.setNewControls(new Control[] {
								 cbxSaveVerticalAlignement, 
								 cbxSaveRounded, 
								 cbxSaveEllipse});
		groupBox2.setNewControls(new Control[] {
								 cbxSaveBackground, 
								 cbxSaveImgHorizontalAlignement, 
								 cbxSaveImgVerticalAlignement});
	}

	/**
	 * The main entry point for the application. 
	 *
	 * @param args Array of parameters passed to the application
	 * via the command line.
	 */
	public static void main(String args[])
	{
		Application.run(new CompatibilityForm());
	}
}
