/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRTextField;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillObjectFactory;
import dori.jasper.engine.fill.JRFillTextElement;
import dori.jasper.engine.fill.JRTemplatePrintText;
import dori.jasper.engine.fill.JRTemplateText;
import dori.jasper.engine.util.JRStringUtil;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Map;

public class JRFillTextField
extends JRFillTextElement
implements JRTextField {
    private JRGroup evaluationGroup = null;
    private String text = null;
    private Format format = null;
    private boolean isValueRepeating = false;
    private String oldText = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Number;

    protected JRFillTextField(JRBaseFiller filler, JRTextField textField, Map fillObjectsMap) {
        super(filler, textField, fillObjectsMap);
        this.evaluationGroup = JRFillObjectFactory.getGroup(filler, textField.getEvaluationGroup(), fillObjectsMap);
        JRExpression expression = textField.getExpression();
        String pattern = textField.getPattern();
        if (expression != null && pattern != null && pattern.length() > 0) {
            Class expressionClass = expression.getValueClass();
            if (expressionClass.equals(class$java$util$Date == null ? (class$java$util$Date = JRFillTextField.class$("java.util.Date")) : class$java$util$Date) || expressionClass.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRFillTextField.class$("java.sql.Timestamp")) : class$java$sql$Timestamp) || expressionClass.equals(class$java$sql$Time == null ? (class$java$sql$Time = JRFillTextField.class$("java.sql.Time")) : class$java$sql$Time)) {
                this.format = new SimpleDateFormat(pattern);
            } else if (expressionClass.getSuperclass().equals(class$java$lang$Number == null ? (class$java$lang$Number = JRFillTextField.class$("java.lang.Number")) : class$java$lang$Number)) {
                this.format = new DecimalFormat(pattern);
            }
        }
    }

    public boolean isStretchWithOverflow() {
        return ((JRTextField)this.parent).isStretchWithOverflow();
    }

    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
    }

    public byte getEvaluationTime() {
        return ((JRTextField)this.parent).getEvaluationTime();
    }

    public String getPattern() {
        return ((JRTextField)this.parent).getPattern();
    }

    public void setPattern(String pattern) {
    }

    public boolean isBlankWhenNull() {
        return ((JRTextField)this.parent).isBlankWhenNull();
    }

    public void setBlankWhenNull(boolean isBlank) {
    }

    public byte getHyperlinkType() {
        return ((JRTextField)this.parent).getHyperlinkType();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return ((JRTextField)this.parent).getExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRTextField)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRTextField)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRTextField)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRTextField)this.parent).getHyperlinkPageExpression();
    }

    protected String getText() {
        return this.text;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected JRTemplateText getJRTemplateText() {
        if (this.template == null) {
            this.template = new JRTemplateText((JRTextField)this.parent);
        }
        return (JRTemplateText)this.template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateText(evaluation);
        }
    }

    protected void evaluateText(byte evaluation) throws JRException {
        String oldText;
        Object textFieldValue = this.filler.calculator.evaluate(this.getExpression(), evaluation);
        if (textFieldValue == null) {
            if (this.isBlankWhenNull()) {
                textFieldValue = "";
            }
        } else if (this.format != null) {
            textFieldValue = this.format.format(textFieldValue);
        }
        String newText = JRStringUtil.treatNewLineChars(String.valueOf(textFieldValue));
        this.oldText = oldText = this.getText();
        this.text = newText;
        this.setTextStart(0);
        this.setTextEnd(0);
        this.isValueRepeating = oldText == null && newText == null || oldText != null && oldText.equals(newText);
        this.anchorName = (String)this.filler.calculator.evaluate(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.filler.calculator.evaluate(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.filler.calculator.evaluate(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.filler.calculator.evaluate(this.getHyperlinkPageExpression(), evaluation);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == 1) {
            if (isOverflow) {
                if (this.getPositionType() == 3) {
                    this.setTextStart(0);
                    this.setTextEnd(0);
                }
                if (this.getTextEnd() >= this.getText().length() || !this.isStretchWithOverflow()) {
                    if (this.isPrintWhenDetailOverflows()) {
                        this.setTextStart(0);
                        this.setTextEnd(0);
                        isReprinted = true;
                    } else {
                        isToPrint = false;
                    }
                }
                if (isToPrint && this.isPrintWhenExpressionNull() && !this.isPrintRepeatedValues() && this.isValueRepeating) {
                    isToPrint = false;
                }
            } else if (!(!this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating || this.isPrintInFirstWholeBand() && this.getBand().isNewPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()))) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (this.getTextEnd() < this.getText().length() && availableStretchHeight >= this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                    if (this.isStretchWithOverflow()) {
                        this.chopTextElement(availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY());
                        if (this.getTextEnd() < this.getText().length() - 1) {
                            willOverflow = true;
                        }
                    } else {
                        this.chopTextElement(0);
                    }
                } else {
                    if (this.getText().length() > 0) {
                        isToPrint = false;
                    }
                    if (this.getTextEnd() < this.getText().length() - 1) {
                        willOverflow = true;
                    }
                }
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getText().substring(this.getTextStart(), this.getTextEnd()).trim().length() == 0) {
                isToPrint = false;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintText text = null;
        text = new JRTemplatePrintText(this.getJRTemplateText());
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        text.setHeight(this.getStretchHeight());
        text.setAbsoluteLineSpacing(this.getAbsoluteLineSpacing());
        text.setAbsoluteLeading(this.getAbsoluteLeading());
        text.setTextHeight(this.getTextHeight());
        switch (this.getEvaluationTime()) {
            case 2: {
                this.filler.reportBoundTexts.put(text, this);
                break;
            }
            case 3: {
                this.filler.pageBoundTexts.put(text, this);
                break;
            }
            case 4: {
                this.filler.columnBoundTexts.put(text, this);
                break;
            }
            case 5: {
                Map specificGroupBoundTexts = (Map)this.filler.groupBoundTexts.get(this.getEvaluationGroup().getName());
                specificGroupBoundTexts.put(text, this);
                break;
            }
            default: {
                text.setText(this.getText().substring(this.getTextStart(), this.getTextEnd()));
                text.setAnchorName(this.getAnchorName());
                text.setHyperlinkReference(this.getHyperlinkReference());
                text.setHyperlinkAnchor(this.getHyperlinkAnchor());
                text.setHyperlinkPage(this.getHyperlinkPage());
            }
        }
        return text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

