/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.fill.JRFillGroup;
import dori.jasper.engine.fill.JRFillVariable;
import java.math.BigDecimal;
import java.util.Map;

public abstract class JRCalculator {
    protected Map parsm = null;
    protected Map fldsm = null;
    protected Map varsm = null;
    protected JRFillVariable[] variables = null;
    protected JRFillGroup[] groups = null;
    private JRFillVariable pageNumber = null;
    private JRFillVariable columnNumber = null;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    protected JRCalculator(Map parametersMap, Map fieldsMap, Map variablesMap, JRFillVariable[] vars, JRFillGroup[] grps) throws JRException {
        this.parsm = parametersMap;
        this.fldsm = fieldsMap;
        this.varsm = variablesMap;
        this.variables = vars;
        this.groups = grps;
        this.pageNumber = (JRFillVariable)variablesMap.get("PAGE_NUMBER");
        this.columnNumber = (JRFillVariable)variablesMap.get("COLUMN_NUMBER");
    }

    protected JRFillVariable getPageNumber() {
        return this.pageNumber;
    }

    protected JRFillVariable getColumnNumber() {
        return this.columnNumber;
    }

    protected void calculateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            JRFillVariable variable = null;
            Object expressionValue = null;
            Object newValue = null;
            int i = 0;
            while (i < this.variables.length) {
                variable = this.variables[i];
                expressionValue = this.evaluate(variable.getExpression());
                newValue = this.calculateVariable(variable, expressionValue);
                variable.setValue(newValue);
                variable.setInitialized(false);
                ++i;
            }
        }
    }

    protected void estimateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            JRFillVariable variable = null;
            Object expressionValue = null;
            Object newValue = null;
            int i = 0;
            while (i < this.variables.length) {
                variable = this.variables[i];
                expressionValue = this.evaluateEstimated(variable.getExpression());
                newValue = this.calculateVariable(variable, expressionValue);
                variable.setEstimatedValue(newValue);
                variable.setInitialized(false);
                ++i;
            }
        }
    }

    protected void estimateGroupRuptures() throws JRException {
        this.estimateVariables();
        JRFillGroup group = null;
        Object oldValue = null;
        Object estimatedValue = null;
        boolean groupHasChanged = false;
        if (this.groups != null && this.groups.length > 0) {
            int i = 0;
            while (i < this.groups.length) {
                group = this.groups[i];
                oldValue = this.evaluateOld(group.getExpression());
                estimatedValue = this.evaluateEstimated(group.getExpression());
                if (oldValue == null && estimatedValue != null || oldValue != null && !oldValue.equals(estimatedValue) || groupHasChanged) {
                    groupHasChanged = true;
                    group.setHasChanged(true);
                } else {
                    group.setHasChanged(false);
                }
                ++i;
            }
        }
    }

    private Object calculateVariable(JRFillVariable variable, Object expressionValue) throws JRException {
        Object retValue = null;
        switch (variable.getCalculation()) {
            case 1: {
                if (variable.getValueClass().equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRCalculator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    BigDecimal value = (BigDecimal)variable.getValue();
                    if (value == null || variable.isInitialized()) {
                        value = new BigDecimal("0");
                    }
                    BigDecimal newValue = null;
                    newValue = expressionValue == null ? value : value.add(new BigDecimal("1"));
                    retValue = newValue;
                    break;
                }
                Number value = (Number)variable.getValue();
                if (value == null || variable.isInitialized()) {
                    value = new Double(0.0);
                }
                Number newValue = null;
                newValue = expressionValue == null ? (Number)value : (Number)new Double(value.doubleValue() + 1.0);
                retValue = this.convertToVariableClass(variable, newValue);
                break;
            }
            case 2: {
                Number newValue;
                if (variable.getValueClass().equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRCalculator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    BigDecimal newValue2;
                    BigDecimal value = (BigDecimal)variable.getValue();
                    if (value == null || variable.isInitialized()) {
                        value = new BigDecimal("0");
                    }
                    if ((newValue2 = (BigDecimal)expressionValue) == null) {
                        newValue2 = new BigDecimal("0");
                    }
                    newValue2 = value.add(newValue2);
                    retValue = newValue2;
                    break;
                }
                Number value = (Number)variable.getValue();
                if (value == null || variable.isInitialized()) {
                    value = new Double(0.0);
                }
                if ((newValue = (Number)expressionValue) == null) {
                    newValue = new Double(0.0);
                }
                newValue = new Double(value.doubleValue() + newValue.doubleValue());
                retValue = this.convertToVariableClass(variable, newValue);
                break;
            }
            case 3: {
                if (variable.getValueClass().equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRCalculator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    BigDecimal newValue = null;
                    long count = ((Number)((JRFillVariable)variable.getCountVariable()).getValue()).longValue();
                    if (count > 0L) {
                        BigDecimal countValue = BigDecimal.valueOf(count);
                        BigDecimal sumValue = (BigDecimal)((JRFillVariable)variable.getSumVariable()).getValue();
                        newValue = sumValue.divide(countValue, 4);
                    }
                    retValue = newValue;
                    break;
                }
                Number newValue = null;
                Number countValue = (Number)((JRFillVariable)variable.getCountVariable()).getValue();
                if (countValue.longValue() > 0L) {
                    Number sumValue = (Number)((JRFillVariable)variable.getSumVariable()).getValue();
                    newValue = this.convertToVariableClass(variable, new Double(sumValue.doubleValue() / countValue.doubleValue()));
                }
                retValue = newValue;
                break;
            }
            case 4: {
                Comparable value = (Comparable)variable.getValue();
                Comparable newValue = (Comparable)expressionValue;
                if (!(value == null || variable.isInitialized() || newValue != null && value.compareTo(newValue) >= 0)) {
                    newValue = value;
                }
                retValue = newValue;
                break;
            }
            case 5: {
                Comparable value = (Comparable)variable.getValue();
                Comparable newValue = (Comparable)expressionValue;
                if (!(value == null || variable.isInitialized() || newValue != null && value.compareTo(newValue) <= 0)) {
                    newValue = value;
                }
                retValue = newValue;
                break;
            }
            case 6: {
                if (variable.getValueClass().equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRCalculator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    BigDecimal varianceValue = (BigDecimal)((JRFillVariable)variable.getVarianceVariable()).getValue();
                    BigDecimal newValue = new BigDecimal(Math.sqrt(varianceValue.doubleValue()));
                    retValue = newValue;
                    break;
                }
                Number varianceValue = (Number)((JRFillVariable)variable.getVarianceVariable()).getValue();
                Double newValue = new Double(Math.sqrt(varianceValue.doubleValue()));
                retValue = this.convertToVariableClass(variable, newValue);
                break;
            }
            case 7: {
                if (variable.getValueClass().equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRCalculator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    BigDecimal value = (BigDecimal)variable.getValue();
                    if (value == null || variable.isInitialized()) {
                        value = new BigDecimal("0");
                    }
                    BigDecimal countValue = BigDecimal.valueOf(((Number)((JRFillVariable)variable.getCountVariable()).getValue()).longValue());
                    BigDecimal sumValue = (BigDecimal)((JRFillVariable)variable.getSumVariable()).getValue();
                    BigDecimal newValue = (BigDecimal)expressionValue;
                    newValue = countValue.intValue() == 1 ? new BigDecimal("0") : countValue.subtract(new BigDecimal("1")).multiply(value).divide(countValue, 4).add(sumValue.divide(countValue, 4).subtract(newValue).multiply(sumValue.divide(countValue, 4).subtract(newValue)).divide(countValue.subtract(new BigDecimal("1")), 4));
                    retValue = newValue;
                    break;
                }
                Number value = (Number)variable.getValue();
                if (value == null || variable.isInitialized()) {
                    value = new Double(0.0);
                }
                Number countValue = (Number)((JRFillVariable)variable.getCountVariable()).getValue();
                Number sumValue = (Number)((JRFillVariable)variable.getSumVariable()).getValue();
                Number newValue = (Number)expressionValue;
                newValue = countValue.intValue() == 1 ? new Double(0.0) : new Double((countValue.doubleValue() - 1.0) * value.doubleValue() / countValue.doubleValue() + (sumValue.doubleValue() / countValue.doubleValue() - newValue.doubleValue()) * (sumValue.doubleValue() / countValue.doubleValue() - newValue.doubleValue()) / (countValue.doubleValue() - 1.0));
                retValue = this.convertToVariableClass(variable, newValue);
                break;
            }
            case 8: {
                retValue = variable.getValue();
                break;
            }
            default: {
                retValue = expressionValue;
            }
        }
        return retValue;
    }

    protected Number convertToVariableClass(JRFillVariable variable, Number newValue) throws JRException {
        Class valueClass = variable.getValueClass();
        if (valueClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JRCalculator.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            newValue = new Byte(newValue.byteValue());
        } else if (valueClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = JRCalculator.class$("java.lang.Short")) : class$java$lang$Short)) {
            newValue = new Short(newValue.shortValue());
        } else if (valueClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JRCalculator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            newValue = new Integer(newValue.intValue());
        } else if (valueClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = JRCalculator.class$("java.lang.Long")) : class$java$lang$Long)) {
            newValue = new Long(newValue.longValue());
        } else if (valueClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = JRCalculator.class$("java.lang.Float")) : class$java$lang$Float)) {
            newValue = new Float(newValue.floatValue());
        } else if (valueClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = JRCalculator.class$("java.lang.Double")) : class$java$lang$Double)) {
            newValue = new Double(newValue.doubleValue());
        }
        return newValue;
    }

    protected void initializeVariables(byte resetType) throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            int i = 0;
            while (i < this.variables.length) {
                this.initializeVariable(this.variables[i], resetType);
                ++i;
            }
        }
    }

    private void initializeVariable(JRFillVariable variable, byte resetType) throws JRException {
        if (variable.getResetType() != 5) {
            boolean toInitialize = false;
            switch (resetType) {
                case 1: {
                    toInitialize = true;
                    break;
                }
                case 2: {
                    toInitialize = variable.getResetType() == 2 || variable.getResetType() == 3;
                    break;
                }
                case 3: {
                    toInitialize = variable.getResetType() == 3;
                    break;
                }
                case 4: {
                    if (variable.getResetType() != 4) break;
                    JRFillGroup group = (JRFillGroup)variable.getResetGroup();
                    toInitialize = group.hasChanged();
                    break;
                }
            }
            if (toInitialize) {
                variable.setValue(this.evaluate(variable.getInitialValueExpression()));
                variable.setInitialized(true);
            }
        } else {
            variable.setValue(this.evaluate(variable.getExpression()));
        }
    }

    protected Object evaluate(JRExpression expression, byte evaluationType) throws JRException {
        Object value = null;
        switch (evaluationType) {
            case 1: {
                value = this.evaluateOld(expression);
                break;
            }
            case 2: {
                value = this.evaluateEstimated(expression);
                break;
            }
            default: {
                value = this.evaluate(expression);
            }
        }
        return value;
    }

    protected Object evaluateOld(JRExpression expression) throws JRException {
        Object value = null;
        try {
            value = this.evaluateOld(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            throw new JRException("Error evaluating expression old value : " + expression.getName(), e);
        }
        return value;
    }

    protected Object evaluateEstimated(JRExpression expression) throws JRException {
        Object value = null;
        try {
            value = this.evaluateEstimated(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            throw new JRException("Error evaluating expression estimated value : " + expression.getName(), e);
        }
        return value;
    }

    protected Object evaluate(JRExpression expression) throws JRException {
        Object value = null;
        try {
            value = this.evaluate(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            throw new JRException("Error evaluating expression value : " + expression.getName(), e);
        }
        return value;
    }

    protected abstract Object evaluateOld(int var1) throws Exception;

    protected abstract Object evaluateEstimated(int var1) throws Exception;

    protected abstract Object evaluate(int var1) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

