package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "BandsForm"
 * non viene creato nel metodo main().
 */
public class BandsForm extends Form
{
	public int[] heights;
	public String[] expressions;
	MainForm mf=null;
	Report report=null;
	public BandsForm(MainForm mf)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		
		this.mf = mf;
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	/**
	 * BandsForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	public void setValues(Report report)
	{
		this.report = report;
		Enumeration enum = report.bands.elements();
		int i=0;
		
		heights = new int[report.bands.size()];
		expressions = new String[report.bands.size()];
		
		while (enum.hasMoreElements())
		{
			Band b = (Band)enum.nextElement();
			listBox1.addItem(b.name);
			heights[i] = b.height;
			expressions[i] = b.printWhenExpression;
			i++;
		}
		
		setSelectedBand(0);
		this.listBox1.setSelectedIndex(0);
	}

	public void setSelectedBand(int index)
	{
		numberEdit1.setValue(heights[index]);
		richEdit1.setText(expressions[index]);
	}
	
	private void button1_click(Object source, Event e)
	{
		
	}

	private void button2_click(Object source, Event e)
	{
		this.setDialogResult(DialogResult.OK);
	}

	private void listBox1_selectedIndexChanged(Object source, Event e)
	{
		this.setSelectedBand( listBox1.getSelectedIndex() );
	}

	private void richEdit1_textChanged(Object source, Event e)
	{
		if (listBox1.getSelectedIndex()<0) return;

		expressions[ listBox1.getSelectedIndex() ] =  (String)richEdit1.getText(); 		

		if ( mf.ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 mf.ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = richEdit1.getSelectionStart();
		richEdit1.setRTF( report.formatExpression( richEdit1.getText()  ));
		richEdit1.setSelectionStart(pos);
	}

	private void richEdit1_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(richEdit1 , new Point(e.x,e.y));
	}

	private void menuItem4_click(Object source, Event e)
	{
		source = this.getActiveControl();
		if (source instanceof RichEdit)
		{
			ExpressionGeneratorForm ef = new ExpressionGeneratorForm(this.report);
			ef.setExpression(((RichEdit)source).getText());
			if (ef.showDialog() == DialogResult.OK)
			{
				((RichEdit)source).setRTF(this.report.formatExpression(ef.getExpression()));
			}
		}
	}

	private void numberEdit1_valueChanged(Object source, Event e)
	{
		this.heights[ listBox1.getSelectedIndex() ] = (int)numberEdit1.getValue();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	RichEdit richEdit1 = new RichEdit();
	GroupBox groupBox1 = new GroupBox();
	ListBox listBox1 = new ListBox();
	Label label2 = new Label();
	NumberEdit numberEdit1 = new NumberEdit();
	Label label1 = new Label();
	Button button2 = new Button();
	Button button1 = new Button();
	ContextMenu contextMenu2 = new ContextMenu();
	MenuItem menuItem4 = new MenuItem();

	private void initForm()
	{
		// REMARQUE: cette feuille stocke des informations sur les ressources
		// dans un fichier externe. Ne modifiez le paramtre de chane d'aucun
		// appel de fonction resources.getObject(). Par exemple,
		// ne modifiez pas "foo1_location" dans la ligne de code
		// suivante, mme si le nom de l'objet Foo change: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "BandsForm");
		this.setText("Report bands");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_SINGLE);
		this.setClientSize(new Point(421, 231));
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setMaximizeBox(false);
		this.setMinimizeBox(false);
		this.setShowInTaskbar(false);

		richEdit1.setFont(Font.DEFAULT_GUI);
		richEdit1.setForeColor(Color.WINDOWTEXT);
		richEdit1.setLocation(new Point(8, 72));
		richEdit1.setSize(new Point(280, 112));
		richEdit1.setTabIndex(3);
		richEdit1.setText("richEdit1");
		richEdit1.addOnMouseUp(new MouseEventHandler(this.richEdit1_mouseUp));
		richEdit1.addOnTextChanged(new EventHandler(this.richEdit1_textChanged));

		groupBox1.setLocation(new Point(120, 0));
		groupBox1.setSize(new Point(296, 192));
		groupBox1.setTabIndex(1);
		groupBox1.setTabStop(false);
		groupBox1.setText("Band properties");

		listBox1.setFont(Font.DEFAULT_GUI);
		listBox1.setLocation(new Point(4, 4));
		listBox1.setSize(new Point(112, 188));
		listBox1.setTabIndex(0);
		listBox1.setText("listBox1");
		listBox1.setIntegralHeight(false);
		listBox1.setUseTabStops(true);
		listBox1.addOnSelectedIndexChanged(new EventHandler(this.listBox1_selectedIndexChanged));

		label2.setLocation(new Point(8, 56));
		label2.setSize(new Point(152, 20));
		label2.setTabIndex(1);
		label2.setTabStop(false);
		label2.setText("\"printWhen\" expression ");

		numberEdit1.setLocation(new Point(8, 32));
		numberEdit1.setSize(new Point(64, 20));
		numberEdit1.setTabIndex(2);
		numberEdit1.setText("0");
		numberEdit1.setIsDouble(false);
		numberEdit1.setDecimals(0);
		numberEdit1.setValue(0.0d);
		numberEdit1.setViewPlus(false);
		numberEdit1.setSeparatoreMigliaia(true);
		numberEdit1.addOnValueChanged(new EventHandler(this.numberEdit1_valueChanged));

		label1.setLocation(new Point(8, 16));
		label1.setSize(new Point(100, 20));
		label1.setTabIndex(0);
		label1.setTabStop(false);
		label1.setText("Height");

		button2.setLocation(new Point(276, 200));
		button2.setSize(new Point(68, 24));
		button2.setTabIndex(3);
		button2.setText("Ok");
		button2.addOnClick(new EventHandler(this.button2_click));

		button1.setLocation(new Point(348, 200));
		button1.setSize(new Point(68, 24));
		button1.setTabIndex(4);
		button1.setText("Cancel");
		button1.setDialogResult(DialogResult.CANCEL);
		button1.addOnClick(new EventHandler(this.button1_click));

		menuItem4.setText("Edit with JasperExpression editor...");
		menuItem4.addOnClick(new EventHandler(this.menuItem4_click));

		contextMenu2.setMenuItems(new MenuItem[] {
								  menuItem4});
		/* @designTimeOnly contextMenu2.setLocation(new Point(184, 124)); */

		this.setNewControls(new Control[] {
							button2, 
							button1, 
							groupBox1, 
							listBox1});
		groupBox1.setNewControls(new Control[] {
								 richEdit1, 
								 label2, 
								 numberEdit1, 
								 label1});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new BandsForm(null));
	}
}
