/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfField;
import com.lowagie.text.rtf.RtfTOCEntry;
import com.lowagie.text.rtf.RtfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTOC
extends Chunk
implements RtfField {
    private String defaultText = "Klicken Sie mit der rechten Maustaste auf diesen Text, um das Inhaltsverzeichnis zu aktualisieren!";
    private boolean addTOCAsTOCEntry = false;
    private Font entryFont = null;
    private String entryName = null;

    public RtfTOC(String string, Font font) {
        super(string, font);
    }

    public void write(RtfWriter rtfWriter, OutputStream outputStream) throws IOException {
        rtfWriter.writeInitialFontSignature(outputStream, this);
        outputStream.write(RtfWriter.filterSpecialChar(this.content()).getBytes());
        rtfWriter.writeFinishingFontSignature(outputStream, this);
        if (this.addTOCAsTOCEntry) {
            RtfTOCEntry rtfTOCEntry = new RtfTOCEntry(this.entryName, this.entryFont);
            rtfTOCEntry.hideText();
            try {
                rtfWriter.add(rtfTOCEntry);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
                throw new RuntimeException("underlying " + documentException.getMessage());
            }
        }
        outputStream.write(92);
        outputStream.write(RtfWriter.paragraph);
        outputStream.write(32);
        outputStream.write(123);
        outputStream.write(92);
        outputStream.write(RtfWriter.field);
        outputStream.write(123);
        outputStream.write(92);
        outputStream.write(RtfWriter.fieldContent);
        outputStream.write(32);
        outputStream.write("TOC".getBytes());
        outputStream.write(32);
        outputStream.write(92);
        outputStream.write(92);
        outputStream.write("f".getBytes());
        outputStream.write(32);
        outputStream.write(92);
        outputStream.write(92);
        outputStream.write("h".getBytes());
        outputStream.write(32);
        outputStream.write(32);
        outputStream.write(92);
        outputStream.write(92);
        outputStream.write("u".getBytes());
        outputStream.write(32);
        outputStream.write(32);
        outputStream.write(92);
        outputStream.write(92);
        outputStream.write("o".getBytes());
        outputStream.write(32);
        outputStream.write("\"1-5\"".getBytes());
        outputStream.write(32);
        outputStream.write(125);
        outputStream.write(123);
        outputStream.write(92);
        outputStream.write(RtfWriter.fieldDisplay);
        outputStream.write(32);
        outputStream.write(this.defaultText.getBytes());
        outputStream.write(32);
        outputStream.write(125);
        outputStream.write(125);
    }

    public void addTOCAsTOCEntry(String string, Font font) {
        this.addTOCAsTOCEntry = true;
        this.entryFont = font;
        this.entryName = string;
    }

    public void setDefaultText(String string) {
        this.defaultText = string;
    }
}

