/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "FieldForm"
 * non viene creato nel metodo main().
 */
public class FieldForm extends Form
{
	String name="";
	String classType ="";
	String description="";
	public FieldForm()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
		comboBoxType.setSelectedIndex(0);
	}

	/**
	 * FieldForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void groupBox1_enter(Object source, Event e)
	{
		
	}

	private void button2_click(Object source, Event e)
	{
		if (editName.getText().trim().length() == 0)
		{
			MessageBox.show("Please, insert a valid field name!","Error!",MessageBox.ICONEXCLAMATION);
			return;
		}
		
		name = this.editName.getText();
		classType = this.comboBoxType.getText();
		
		this.setDialogResult(DialogResult.OK);
		this.dispose();
	}
	
	public void setFieldName(String name)
	{
		this.name = name;
		editName.setText(name);
	}
	public void setClassType(String type)
	{
		this.classType = type;
		comboBoxType.setSelectedItem(type);
	}
	public String getFieldName()
	{
		return name;
	}
	public String getClassType()
	{
		return classType;
	}
	
	public void setDesc(String desc)
	{
		this.description  = desc;
		this.editDescription.setText(desc);
	}
	
	public String getDesc()
	{
		return this.description;
	}

	private void editDescription_textChanged(Object source, Event e)
	{
		description = editDescription.getText();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Edit editName = new Edit();
	Label label1 = new Label();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Button button2 = new Button();
	Label label2 = new Label();
	ComboBox comboBoxType = new ComboBox();
	Edit editDescription = new Edit();
	Label label3 = new Label();

	private void initForm()
	{
		this.setText("Field properties");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(302, 207));

		editName.setLocation(new Point(8, 20));
		editName.setSize(new Point(276, 20));
		editName.setTabIndex(0);
		editName.setText("");

		label1.setLocation(new Point(8, 4));
		label1.setSize(new Point(100, 16));
		label1.setTabIndex(6);
		label1.setTabStop(false);
		label1.setText("Field name");

		groupBox1.setLocation(new Point(4, 168));
		groupBox1.setSize(new Point(292, 4));
		groupBox1.setTabIndex(8);
		groupBox1.setTabStop(false);
		groupBox1.setText("");
		groupBox1.addOnEnter(new EventHandler(this.groupBox1_enter));

		button1.setLocation(new Point(228, 180));
		button1.setSize(new Point(68, 24));
		button1.setTabIndex(4);
		button1.setText("Cancel");
		button1.setDialogResult(DialogResult.CANCEL);

		button2.setLocation(new Point(156, 180));
		button2.setSize(new Point(64, 24));
		button2.setTabIndex(3);
		button2.setText("Ok");
		button2.addOnClick(new EventHandler(this.button2_click));

		label2.setLocation(new Point(8, 48));
		label2.setSize(new Point(100, 16));
		label2.setTabIndex(5);
		label2.setTabStop(false);
		label2.setText("Field type");

		comboBoxType.setLocation(new Point(8, 68));
		comboBoxType.setSize(new Point(276, 21));
		comboBoxType.setTabIndex(1);
		comboBoxType.setText("");
		comboBoxType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxType.setItems(new Object[] {
							  "java.lang.String", 
							  "java.lang.Object", 
							  "java.lang.Boolean", 
							  "java.lang.Byte", 
							  "java.util.Date", 
							  "java.sql.Timestamp", 
							  "java.lang.Double", 
							  "java.lang.Float", 
							  "java.lang.Integer", 
							  "java.io.InputStream", 
							  "java.lang.Long", 
							  "java.lang.Short", 
							  "java.math.BigDecimal"});

		editDescription.setLocation(new Point(8, 116));
		editDescription.setSize(new Point(276, 44));
		editDescription.setTabIndex(2);
		editDescription.setText("");
		editDescription.setMultiline(true);
		editDescription.addOnTextChanged(new EventHandler(this.editDescription_textChanged));

		label3.setLocation(new Point(8, 100));
		label3.setSize(new Point(140, 16));
		label3.setTabIndex(7);
		label3.setTabStop(false);
		label3.setText("Field description");

		this.setNewControls(new Control[] {
							label3, 
							editDescription, 
							comboBoxType, 
							label2, 
							button2, 
							button1, 
							groupBox1, 
							label1, 
							editName});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new FieldForm());
	}
}
