/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import com.businesslogic.ireport.ui.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import com.ms.xml.om.*;
import com.ms.xml.util.*;

import java.util.*;
import java.io.*;


/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "Form1"
 * non viene creato nel metodo main().
 */
public class MainForm extends Form
{
	public ElementProperties ep=null;
	boolean propertiesOpened = false;
	public ElementsBrowser bf=null;
	public VariablesForm  vf=null;
	public GroupsForm gf=null;
	public FontsForm fontf=null;
	public DBConnectionsForm cf=null;
	public QueryForm qf=null;
	boolean browserOpened = false;
	boolean variablesFormOpened = false;
	boolean groupsFormOpened = false;
	boolean connectionsFormOpened = false;
	boolean queryFormOpened = false;
	boolean fontsOpened = false;
	public String programDir="";
	
	public Properties connProperties;
	public Properties ireportProperties;
	Vector clipboardObjects;
	public String propfile_name="";
	public String config_name="";
	
	public Vector toolBarControls;
	boolean wait=false;
	
	boolean isActive=false;
	
	 
		
	
	
	public Vector fonts;
	public java.util.Hashtable fontsht;
	

	public MainForm(String args[])
	{
		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();	
		StringBuffer str = new StringBuffer(1024);
		this.GetModuleFileName( GetModuleHandle(null),str,1024);
		
		programDir = com.ms.wfc.io.File.getDirectory(""+str);
		com.ms.wfc.io.File.setCurrentDirectory(	programDir );		
		
		
		//---- ToolBar controls... ---
		
		toolBarControls = new Vector();
		toolBarControls.addElement(buttonNew);      //New
		toolBarControls.addElement(GTImageButton1); //Open
		toolBarControls.addElement(GTImageButton2); //Save
		toolBarControls.addElement(null);		    //Space
		toolBarControls.addElement(buttonCut);		//Cut
		toolBarControls.addElement(buttonCopy);		//Cut
		toolBarControls.addElement(buttonPaste);	//Cut
		toolBarControls.addElement(buttonPointer);	//Cut
		toolBarControls.addElement(buttonLine);		//Cut
		toolBarControls.addElement(buttonRectangle);//Cut
		toolBarControls.addElement(buttonRoundRect);//Cut
		toolBarControls.addElement(buttonCircle);//Cut
		toolBarControls.addElement(buttonImage);	//Cut
		toolBarControls.addElement(buttonText );	//Cut
		toolBarControls.addElement(buttonField);	//Cut
		toolBarControls.addElement(buttonSR);		//Cut
		toolBarControls.addElement(buttonVariables);//Cut
		toolBarControls.addElement(buttonGroups);   //Cut
		toolBarControls.addElement(buttonBands);   //Cut
		toolBarControls.addElement(buttonDatabase); //Cut
		toolBarControls.addElement(buttonLens);     //Cut
		toolBarControls.addElement(panelLens );  //Cut
		toolBarControls.addElement(compilerButton); //Cut
		
		toolBarControls.addElement(null); //Cut
		toolBarControls.addElement(buttonAlignLeft); //Cut
		toolBarControls.addElement(buttonAlignCenter); //Cut
		toolBarControls.addElement(buttonAlignRight); //CutGTImageButton3
		toolBarControls.addElement(buttonAlignJustify); //Cut
		
		
		//---- End ToolBar controls... ----
		
		clipboardObjects = new Vector();
		fontsht = new java.util.Hashtable();
		fonts = new Vector();
		loadFonts();
		TextReportElement.mf = this;

		Application.addOnIdle( new EventHandler(MainForm_Idle));
		
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
		numberComboBox1.addItem(new NumberComboValue("25%",25));
		numberComboBox1.addItem(new NumberComboValue("50%",50));
		numberComboBox1.addItem(new NumberComboValue("100%",100));
		numberComboBox1.addItem(new NumberComboValue("150%",150));
		numberComboBox1.addItem(new NumberComboValue("200%",200));
		numberComboBox1.addItem(new NumberComboValue("Fit to page",-5));
		
		numberComboBox1.setText("100%");
			
		connProperties = new Properties();
		propfile_name= com.ms.wfc.io.File.combine(programDir,"connections.properties");
		try {
			FileInputStream fio = new FileInputStream(propfile_name);
			connProperties.load(fio);
			fio.close();
		} catch (Exception ex)
		{
		}
		
		
		ireportProperties = new Properties();
		config_name= com.ms.wfc.io.File.combine(programDir,"ireport.properties");
		try {
			FileInputStream fio = new FileInputStream(config_name);
			ireportProperties.load(fio);
			fio.close();
		} catch (FileNotFoundException ex)
		{
		} catch (Exception ex)
		{
		}
		
			if ( (String)ireportProperties.getProperty("BORDER_COLOR")!=null )
		{
				int rgb = Integer.parseInt((String)ireportProperties.getProperty("BORDER_COLOR"));
				if (rgb==-1) ReportElement.lightcolor = null;
				else
					ReportElement.lightcolor = new Color(rgb);
		}
		else
				ReportElement.lightcolor = Color.LIGHTGRAY;
		
		String cp = (String)connProperties.get("CLASSPATH");
		if (cp==null) cp="";
		if (cp.indexOf(";.;") < 0) cp += ";.";
		if (cp.indexOf(programDir+";") < 0) cp += ";"+programDir;
		if (cp.indexOf(com.ms.wfc.io.File.combine(programDir,"lib")+";") < 0) cp += ";"+com.ms.wfc.io.File.combine(programDir,"lib");
		if (cp.indexOf(com.ms.wfc.io.File.combine(programDir,"..\\lib")+";") < 0) cp += ";"+com.ms.wfc.io.File.combine(programDir,"..\\lib");
		// Add to path all jar files in libs...
		String[] jars;
		try {
			if (com.ms.wfc.io.File.exists(com.ms.wfc.io.File.combine(programDir,"lib")) )
			{
				jars = com.ms.wfc.io.File.getFiles( com.ms.wfc.io.File.combine(programDir,"lib\\*.jar"));
				for (int ji = 0; ji < jars.length; ++ji)
				{
					cp += ";"+com.ms.wfc.io.File.combine(programDir,"lib\\"+jars[ji]);
				}
			}
			//else
			//	MessageBox.show(com.ms.wfc.io.File.combine(programDir,"lib")+" non esiste!");
		} catch (Exception ex){
		}
		
		try {
			if (com.ms.wfc.io.File.exists(com.ms.wfc.io.File.combine(programDir,"..\\lib")) )
			{
				jars = com.ms.wfc.io.File.getFiles( com.ms.wfc.io.File.combine(programDir,"..\\lib\\*.jar"));
				for (int ji = 0; ji < jars.length; ++ji)
				{
					//MessageBox.show(com.ms.wfc.io.File.combine(programDir,"..\\lib\\"+jars[ji]));
					cp += ";"+com.ms.wfc.io.File.combine(programDir,"..\\lib\\"+jars[ji]);
				}
			}
		} catch (Exception ex){ 
		}
		
		// Remove duplicates....
		StringTokenizer st = new StringTokenizer(cp,";");
		Vector v = new Vector();
		while (st.hasMoreTokens())
		{
			String token = st.nextToken();
			if (!v.contains(token))
				v.addElement(token);
		}
		Enumeration enum = v.elements();
		cp="";
		boolean is_first = true;
		while (enum.hasMoreElements())
		{
			if (!is_first) cp +=";";
			cp += enum.nextElement();
			is_first = false;
		}
		
		// Setting classpath....
		ClasspathForm.SetEnvironmentVariable("classpath",cp);
		updateRecentFileList();		
		
		// if it is the first start open welcome document...
		if (ireportProperties.getProperty("WELCOME007") == null)
		{
			ireportProperties.put("WELCOME007","NO");
			saveProperties();
			openDocument( com.ms.wfc.io.File.getCurrentDirectory() +"\\welcome.xml");
		}
		
		if (args.length>0)
		{
			if (com.ms.wfc.io.File.exists(args[0]))
				openDocument(args[0]);
		}
		
	}
	
	public void loadFonts()
	{
		com.ms.wfc.app.RegistryKey  ks =  com.ms.wfc.app.Registry.LOCAL_MACHINE;
		ks = ks.getSubKey("Software\\Microsoft\\windows\\CurrentVersion\\Fonts");
		if (ks == null)
		{
			ks = com.ms.wfc.app.Registry.LOCAL_MACHINE;
			ks = ks.getSubKey("Software\\Microsoft\\Windows NT\\CurrentVersion\\Fonts");
		}
		if (ks == null)
		{
			return;
		}
		String[] vals = ks.getValueNames();
		for (int i=0; i< vals.length; ++i)
		{
			String fname = vals[i];
			if (fname.indexOf("(TrueType)") > 0)
			{
				FontFile f = new FontFile();
				
				f.filename = (String)ks.getValue(fname);
				f.fontname = fname.substring(0, fname.indexOf("(TrueType)")).trim();
				fonts.addElement(f);
				fontsht.put( f.filename, f.fontname);
			}
		}
	}
	
	public String getFontName(String filename)
	{
		if (fontsht.containsKey(filename))
		{
		  return (String)fontsht.get(filename);
		}
		return null;
	}
	
	public void updateRecentFileList()
	{
		
		if (ireportProperties == null) return; 
		
		//Clear actual list...
		
		
		int i=0;
		boolean find = false;
		for (i=0; i <menuItem1.getMenuItemCount(); ++i)
		{
			char c = menuItem1.getMenuItem(i).getText().charAt(0);
			if (c >= '0' && c <='9')
			{
				find = true;
				menuItem1.remove(i);
				i--;
			}
		}
		if (find)
			menuItem1.remove( menuItem1.getMenuItemCount()-2);
		
		for (i=0;; ++i)
		{
			if (ireportProperties.getProperty("MRU"+i+"_NAME") == null)
				break;  	
			else
			{
				String filename =ireportProperties.getProperty("MRU"+i+"_NAME");
				String n = filename.substring( filename.lastIndexOf('\\'));
				if (filename.substring(0, filename.lastIndexOf('\\')).length() > 10)
					filename = filename.substring(0, filename.indexOf("\\",10)+1 )+"..."+n;
				MenuItem menuItem = new MenuItem((i+1) + " " + filename,new EventHandler(menuItemMRU_click) );
				menuItem1.add( menuItem);
				menuItem.setIndex(menuItem1.getMenuItemCount()-2);
			}
		}
		if (i>0)
		{
			MenuItem menuItem = new MenuItem("-");
			menuItem1.add( menuItem);
			menuItem.setIndex(menuItem1.getMenuItemCount()-2);
		}
	}
	
	public void addToRecentFileList(String file_name)
	{
		// 1. Modify properties...
		Vector v = new Vector();
		int i=0;
		for (i=0;; ++i)
		{
			if (ireportProperties.getProperty("MRU"+i+"_NAME") == null)
				break;  	
			else
			{
				v.addElement(ireportProperties.getProperty("MRU"+i+"_NAME"));
				ireportProperties.remove(ireportProperties.getProperty("MRU"+i+"_NAME"));
			}
		}
		
		// 2. Save properties...
		int max = 4;
		if (ireportProperties.getProperty("MAX_MRU") != null)
		{
				max = Integer.parseInt(ireportProperties.getProperty("MAX_MRU")+"");
		}
		
		Enumeration enum = v.elements();
		i=0;
		if (max > 0)
		{
			ireportProperties.put("MRU0_NAME", file_name);
			i=1;
		}
		while (enum.hasMoreElements())
		{
			if (i >= max)
			{
				if (ireportProperties.containsKey("MRU"+i+"_NAME"))
					ireportProperties.remove("MRU"+i+"_NAME");
				else
					break;
				continue;
			}
			
			String item = (String)enum.nextElement();
			if (item.equalsIgnoreCase(file_name)) continue;
			ireportProperties.put("MRU"+i+"_NAME", item);
			i++;
		}
	}
	
	private void menuItemMRU_click(Object source, Event e)
	{
		if (source instanceof MenuItem)
		{
			String cod = ((MenuItem)source).getText();
			cod = cod.substring(0,cod.indexOf(" "));
			cod = ""+(Integer.parseInt(cod)-1);
			String filename = (String)ireportProperties.get("MRU"+cod+"_NAME");
			//MessageBox.show("Open file:" + filename +" ("+  cod +")" );
			if (filename != null &&	com.ms.wfc.io.File.exists(filename))
				openDocument(filename);
			else MessageBox.show(filename+ " not found!");
		}	
	}
		
	public ReportForm openDocument(String filename)
	{
			String cd = com.ms.wfc.io.File.getCurrentDirectory();
			try {
				com.ms.wfc.io.File.setCurrentDirectory(com.ms.wfc.io.File.getDirectory( filename ));
			} catch (Exception ex)
			{
				MessageBox.show("Error changing directory to: "+com.ms.wfc.io.File.getDirectory( filename ));
			}
			this.setCursor(Cursor.WAIT);
			
			addToRecentFileList( filename );
			updateRecentFileList();
			saveProperties();

			try {
				
				//com.ms.wfc.io.TextReader fis = new com.ms.wfc.io.TextReader( filename);

				
				if ( (com.ms.wfc.io.File.getAttributes(filename) & com.ms.wfc.io.FileAttribute.READONLY) == com.ms.wfc.io.FileAttribute.READONLY )
				{
						com.ms.wfc.io.File.setAttributes(filename, com.ms.wfc.io.File.getAttributes(filename) & ~com.ms.wfc.io.FileAttribute.READONLY);
				}
				
				// Read first encoding...
				String xml_file  = "";
				char[] buffer = new char[1024*512];
				java.io.InputStreamReader fis = new  java.io.InputStreamReader(new  java.io.FileInputStream( filename));
				int dim = fis.read( buffer,0,200);
				String encoding = new String(buffer,0,dim);
				if (encoding.indexOf("encoding=\"") >=0)
				{
					encoding = encoding.substring(encoding.indexOf("encoding=\"")+10);
					encoding = encoding.substring(0,encoding.indexOf("\""));
				}
				else
					encoding = "";
				fis.close();
				//MessageBox.show("Encoding: "+encoding);
				if (encoding.length() > 0)
				{
					if (encoding.equalsIgnoreCase("UTF-8"))
						encoding = "UTF8";
					fis = new  java.io.InputStreamReader(new  java.io.FileInputStream( filename),encoding); //UTF8
				}				
				else
					fis = new  java.io.InputStreamReader(new  java.io.FileInputStream( filename));
				
				// Modify intestation...
				
				dim=0;

				while ((dim = fis.read( buffer,0,1024*512))>0)
				{
					xml_file += new String(buffer,0,dim);
				}
				fis.close();
				
				
				// Strip <!DOCTYPE...> directive....
				int begin = xml_file.indexOf("<!DOCTYPE");
				if (begin > -1)
				{
					int end  = xml_file.substring(begin+1).indexOf(">");
				
					xml_file = xml_file.substring(0,begin)+xml_file.substring(begin+end+2);
					//MessageBox.show(xml_file.substring(0,300));
				}

				java.io.StringBufferInputStream sbis = new java.io.StringBufferInputStream( xml_file);
				
				com.ms.xml.om.Document doc = new com.ms.xml.om.Document();
				//doc.setEncoding("UTF8");
				this.specialDocumentLoad(doc, sbis, xml_file);
				
				fis.close();
				//loadXMLTree(doc);	
				Report r = new Report(doc,filename);
				r.encoding = doc.getEncoding();
				ReportForm rf = new ReportForm(r);
				rf.setMDIParent(this);
				rf.show();
				rf.refreshAll();
				
				this.addToRecentFileList(filename);
				saveProperties();
				this.updateRecentFileList();
				
				this.setCursor(Cursor.DEFAULT);
				return rf;
			} catch (Exception ex)
			{
				this.setCursor(Cursor.DEFAULT);
				MessageBox.show(ex.getMessage());
				java.io.StringWriter s = new java.io.StringWriter();
				ex.printStackTrace(new java.io.PrintWriter(s));
				MessageBox.show(ex.getMessage()+" "+s);
				
			}
			this.setCursor(Cursor.DEFAULT);
			return null;
	}
	
	public void saveProperties()
	{
		try {
			FileOutputStream fio = new FileOutputStream(config_name);
			ireportProperties.save(fio,"");
			fio.close();
		} catch (Exception ex)
		{
		}
	}

	/**
	 * Form1 esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}
	
	private void menuItem2_click(Object source, Event e)
	{
		Vector no_valid_names = new Vector();
		
		ReportPropertiesForm rpf = new ReportPropertiesForm(this);
		
		Form[] forms =  this.getMDIChildren();
		for (int i=0; i<forms.length; ++i)
		{
			if (forms[i] instanceof ReportForm)
			{
				no_valid_names.addElement( ((ReportForm)forms[i]).getReport().getReportName() );
			}
		}
		boolean valid_name = false;
		for (int i=1;; ++i)
		{
			String name = "Untitled_report_" + i;
			if (!no_valid_names.contains(name))
			{
				rpf.setReportName(name);
				break;
			}
		}	
		
		if (rpf.showDialog() == DialogResult.OK)
		{
			Point  size = rpf.getPageSize();
			String name = rpf.getReportName();
			String format = rpf.getReportFormat();
			Report rep = new Report(name,size,format);
			rep.topMargin =  rpf.margin_top;
			rep.leftMargin =  rpf.margin_left;
			rep.bottomMargin =  rpf.margin_bottom;
			rep.rightMargin =  rpf.margin_right;
			rep.columnCount =  rpf.columns;
			rep.columnSpacing =  rpf.column_spacig;
			rep.columnWidth =  rpf.column_width;
			rep.setReportFormat(rpf.format);
			rep.setReportName( rpf.name );
			
			rep.orientation = rpf.orientation;
			rep.whenNoDataType = rpf.whenNoDataType;
			rep.scriptletClass = rpf.scriptletClass;
			rep.printOrder = rpf.printOrder;
			rep.isSummaryNewPage = rpf.isSummaryNewPage;
			rep.isTitleNewPage = rpf.isTitleNewPage;
			
			rep.encoding = rpf.encoding;
			
			ReportForm rf = new ReportForm(rep);
			rf.setMDIParent(this);
			rf.show();
		}
	}

	private void menuItem7_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			menuItem7.setChecked(!menuItem7.getChecked());
			((ReportForm)form).setRighelloVisible( menuItem7.getChecked() );
			
		}
	}
	
	public void loadXMLTree(Document doc)
	{
		//treeView1.removeAll();
		ElementCollection ec = doc.getChildren();
		TreeNode tn = new TreeNode("XML document");
		for (int i=0; i<ec.getLength(); i++)
		{
			Element el = ec.getChild(i);
			addTreeElement(el, tn);
		}
		//treeView1.addNode(tn);
	}
	
	public void addTreeElement(Element el, TreeNode parent)
	{
		String name = ""+el.getTagName();
		if (name.equalsIgnoreCase("text"))
		{
			name += " ("+el.getText()+")";
		}
		TreeNode tn = new TreeNode(name);
		
		// Add attributes...
		Enumeration enum = el.getAttributes();
		while (enum.hasMoreElements())
		{
			Attribute a = (Attribute)enum.nextElement();
			tn.addNode(a.getName()+"="+a.getValue());
			
		}
		ElementCollection ec = el.getChildren();
		for (int i=0; i<ec.getLength(); i++)
		{
			Element el2 = ec.getChild(i);
			addTreeElement(el2, tn);
		}
		parent.addNode(tn);
	}

	private void menuItem4_click(Object source, Event e)
	{
		// Scelta file XML...
		OpenFileDialog ofd = new OpenFileDialog();
		ofd.setCheckFileExists(true);
		ofd.setFilter("Jasper XML Report *.xml|*.xml");
		ofd.setDefaultExt("xml");
		int result = ofd.showDialog();
		if (result == DialogResult.OK)
		{
			openDocument(ofd.getFileName());
			
		}
	}

	private void menuItem9_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.NULL_ELEMENT  );	
		}
	}

	private void MainForm_keyPress(Object source, KeyPressEvent e)
	{
		
	}

	private void menuItem10_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			ReportPropertiesForm rpf = new ReportPropertiesForm(this);
			rpf.setReport( ((ReportForm)form).getReport() );
			if (rpf.showDialog() == DialogResult.OK)
			{
				Report rep =  ((ReportForm)form).getReport();
				rep.setPagesize( rpf.getPageSize());
				int top_delta = rpf.margin_top - rep.topMargin;
				rep.topMargin =  rpf.margin_top;
				int left_delta = rpf.margin_left - rep.leftMargin;
				rep.leftMargin =  rpf.margin_left;
				rep.bottomMargin =  rpf.margin_bottom;
				rep.rightMargin =  rpf.margin_right;
				rep.columnCount =  rpf.columns;
				rep.columnSpacing =  rpf.column_spacig;
				rep.columnWidth =  rpf.column_width;
				rep.setReportFormat(rpf.format);
				rep.setReportName( rpf.name );
				
				rep.orientation = rpf.orientation;
				rep.whenNoDataType = rpf.whenNoDataType;
				rep.scriptletClass = rpf.scriptletClass;
				rep.printOrder = rpf.printOrder;
				rep.isSummaryNewPage = rpf.isSummaryNewPage;
				rep.isTitleNewPage = rpf.isTitleNewPage;
				
				rep.encoding = rpf.encoding;
				
				// Aggiorniamo  le posizioni di tutti i campi...
				Enumeration enum = rep.elements.elements();
				while (enum.hasMoreElements())
				{
					ReportElement elem = (ReportElement)enum.nextElement();
					elem.trasform(new Point(left_delta, top_delta), TransformationType.TRANSFORMATION_MOVE); 
				}
			
				((ReportForm)form).refreshAll();
			}
		}
	}

	private void menuItem11_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.RECTANGLE_ELEMENT);	
		}
	}

	private void menuItem13_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.IMAGE_ELEMENT);	
		}
	}

	private void menuItem14_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.STATICTEXT_ELEMENT);	
		}
	}

	private void menuItem16_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			if (((ReportForm)form).selectedElements.size()>0)
			{
				initReportForm();
				ep.setEelement((ReportForm)form, (ReportElement)((ReportForm)form).selectedElements.firstElement() );
				ep.setOwner(this);
				ep.show();
			}
		}
		
	}
	
	public void initReportForm()
	{
		if (ep == null)
		{
			ep = new  ElementProperties();
			ep.setOwner(this);
			ep.setFonts(fonts);
			ep.addOnDispose(new EventHandler(ElementProprties_dispose));
			propertiesOpened = true;
		}
	}
	
	public void initFontsForm(Report report)
	{
		if (fontf == null)
		{
			fontf = new FontsForm(this);
			fontf.setReport(report);
			fontf.setOwner(this);
			fontf.addOnDispose(new EventHandler(FontsForm_dispose));
			fontsOpened = true;
		}
	}
	
	public void initBrowserForm()
	{
		if (bf == null)
		{
			bf = new  ElementsBrowser();
			bf.addOnDispose(new EventHandler(ElementsBrowser_dispose));
			browserOpened = true;
		}
	}
	
	public void initVariablesForm()
	{
		if (vf == null)
		{
			vf = new  VariablesForm();
			vf.addOnDispose(new EventHandler(VariablesForm_dispose));
			variablesFormOpened  = true;
		}
	}
	
	public void initGroupsForm()
	{
		if (gf == null)
		{
			gf = new  GroupsForm();
			gf.addOnDispose(new EventHandler(GroupsForm_dispose));
			groupsFormOpened = true;
		}
	}
	
	public void initQueryForm()
	{
		if (qf == null)
		{
			qf = new  QueryForm();
			qf.fillConnectionCombo(getConnectionEntries());
			qf.addOnDispose(new EventHandler(QueryForm_dispose));
			queryFormOpened = true;
		}
	}
	
	public void initDBConnectionsForm()
	{
		if (cf == null)
		{
			cf = new  DBConnectionsForm(this);
			cf.addOnDispose(new EventHandler(DBConnectionsForm_dispose));
			connectionsFormOpened = true;
		}
	}

	private void ElementProprties_dispose(Object source, Event e)
	{
		
		ep = null;
		propertiesOpened = false;
	}
	
	private void FontsForm_dispose(Object source, Event e)
	{
		
		fontf = null;
		fontsOpened = false;
	}
	
	private void ElementsBrowser_dispose(Object source, Event e)
	{
		bf = null;
		browserOpened = false;
	}
	
	private void GroupsForm_dispose(Object source, Event e)
	{
		gf = null;
		groupsFormOpened = false;
	}
	
	private void QueryForm_dispose(Object source, Event e)
	{
		qf = null;
		queryFormOpened = false;
	}
	
	private void DBConnectionsForm_dispose(Object source, Event e)
	{
		cf = null;
		connectionsFormOpened = false;
	}
	
	public boolean isPropertiesOpened()
	{
		return propertiesOpened;
	}
	
	public boolean isVariablesFormOpened()
	{
		return variablesFormOpened;
	}
	
	public boolean isGroupsFormOpened()
	{
		return groupsFormOpened;
	}
	
	public boolean isDBConnectionsFormOpened()
	{
		return connectionsFormOpened;
	}
	
	public boolean isQueryFormOpened()
	{
		return queryFormOpened;
	}
	
	public boolean isFontsFormOpened()
	{
		return fontsOpened;
	}

	private void VariablesForm_dispose(Object source, Event e)
	{
		
		vf = null;
		variablesFormOpened = false;
	}
	private void menuItem17_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
				initBrowserForm();
				bf.setReportForm((ReportForm)form );
				bf.setOwner(this);
				bf.show();
		}
	}

	private void menuItem18_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
				ReportElement re = new ReportElement(10,10,100,100,new Brush(Color.RED));
				((ReportForm)form).getReport().getElements().addElement(re);
				((ReportForm)form).refreshAll();
		}
	}
	
	
	// Add LINE
	private void menuItem19_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.LINE_ELEMENT);	
		}
	}

	private void menuItem3_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			Report rp = ((ReportForm)form).getReport();
			if (rp.filename == null)
			{
				
				 menuItem20_click(source,e);
			}
			else
			{
				
				saveBackup( rp.filename); 
				rp.saveXMLFile();
				this.addToRecentFileList(rp.filename);
				saveProperties();
				this.updateRecentFileList();
			}
				
		}
	}

	private void menuItem20_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			Report rp = ((ReportForm)form).getReport();
			SaveFileDialog sfd = new SaveFileDialog();
			sfd.setFilter("Jasper XML Report *.xml|*.xml");
			sfd.setDefaultExt("xml");
			sfd.setFileName(""+rp.getReportName());
			if (sfd.showDialog() == DialogResult.OK)
			{
				rp.filename = sfd.getFileName();
				saveBackup( rp.filename); 
				rp.saveXMLFile();
				this.addToRecentFileList(rp.filename);
				saveProperties();
				this.updateRecentFileList();
			}
		}
	}
	
	public void saveBackup(String filename)
	{
		if (com.ms.wfc.io.File.exists(filename))
		{
			String path = com.ms.wfc.io.File.getDirectory(filename);
			String file = com.ms.wfc.io.File.getName(filename);
			
			if (ireportProperties.getProperty("BACKUP_DIR") != null &&
				(""+ireportProperties.getProperty("BACKUP_DIR")).length()>0)
					path = ireportProperties.getProperty("BACKUP_DIR");
			
			if (ireportProperties.getProperty("BACKUP_MODE") != null &&
				(""+ireportProperties.getProperty("BACKUP_MODE")).equalsIgnoreCase("0"))
			{
				return;
			} else if (ireportProperties.getProperty("BACKUP_MODE") != null &&
				(""+ireportProperties.getProperty("BACKUP_MODE")).equalsIgnoreCase("1"))
			{
				if (file.indexOf(".") > 0 && file.substring(file.indexOf(".")).length()>=3)
					file = file.substring(0,file.length()-3)+"bak";	
				else
					file += ".bak";
			} else {
				file += ".bak";
			}	
			try {
				com.ms.wfc.io.File.copyOver( filename, com.ms.wfc.io.File.combine(path,file)); 
			} catch (Exception ex)
			{
				MessageBox.show("Errore saving backup copy.\n"+ex.getMessage(),"",MessageBox.ICONERROR); 
			}
		}
	}

	private void menuItem21_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.TEXTFIELD_ELEMENT);	
		}
	}

	private void menuItem22_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			int i=1;
			String grpname = "mygroup";
			boolean newgrp=false;
			while (!newgrp)
			{
				grpname = "mygroup"+i;
				i++;
				boolean found = false;
				Enumeration enum = ((ReportForm)form).getReport().groups.elements();
				while (enum.hasMoreElements())
				{
					Group grp = (Group)enum.nextElement();
					if (grp.name.equalsIgnoreCase(grpname))
					{
						found = true;
						break;
					}
				}
				if (!found)
				{
					newgrp = true;
					break;
				}
			}
			
			((ReportForm)form).getReport().addGroup(new Group(grpname,30,30)); 	
			((ReportForm)form).refreshAll();
		}
	}

	private void numberEdit1_valueChanged(Object source, Event e)
	{

	}

	private void numberComboBox1_valueChanged(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			
			if (numberComboBox1.getValue() == -5)
			{
				int w = ((ReportForm)form).getReport().getPagesize().x+20;
				double s = (double)((ReportForm)form).getDisplayWidth()/(double)w;
				//MessageBox.show(""+w+" "+(double)((ReportForm)form).getDisplayWidth());
				numberComboBox1.setValue(s*100);
				numberComboBox1.setText(numberComboBox1.doubleToString(s*100));
				//setZoomFactor(numberComboBox1.getValue()/100);
				((ReportForm)form).setZoomFactor(s);
				return;
			}
			else if (numberComboBox1.getValue()<10 || numberComboBox1.getValue()>1000)
			{
				MessageBox.show("Min: 10 Max: 1000");
				return;	
			}
			
			((ReportForm)form).setZoomFactor(numberComboBox1.getValue()/100);	
		}
	}

	private void panel1_paint(Object source, PaintEvent e)
	{
		
	}
	
	public void setPressed(int element)
	{
		buttonPointer.setPressed((element == 0 ));
		buttonLine.setPressed((element == 1));
		buttonRectangle.setPressed((element == 2));
		buttonField.setPressed((element == 5));
		buttonText.setPressed((element == 4));
		buttonImage.setPressed((element == 3));
		//buttonImage.setPressed((element == 3));
		buttonLens.setPressed((element == 7));
		buttonSR.setPressed((element == 8));
		buttonRoundRect.setPressed((element == 9));
		buttonCircle.setPressed((element == 10));
	}

	private void buttonLine_stateChanged(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).setLensMode(	false );
			((ReportForm)form).prepareForNewElement(ReportElementType.LINE_ELEMENT);	
			setPressed(1);
		}
		else
		{
			 setPressed(0);
		}
	}

	private void buttonRectangle_click(Object source, Event e)
	{
				Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).setLensMode(	false );
			((ReportForm)form).prepareForNewElement(ReportElementType.RECTANGLE_ELEMENT);	
			setPressed(2);
		}
		else
		{
			 setPressed(0);
		}
	}

	private void buttonImage_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.IMAGE_ELEMENT);	
			setPressed(3);
		}
		else
		{
			 setPressed(0);
		}
	}

	private void buttonText_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).setLensMode(	false );
			((ReportForm)form).prepareForNewElement(ReportElementType.STATICTEXT_ELEMENT);	
			setPressed(4);
		}
		else
		{
			 setPressed(0);
		}
	}

	private void buttonField_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).setLensMode(	false );
			((ReportForm)form).prepareForNewElement(ReportElementType.TEXTFIELD_ELEMENT );	
			setPressed(5);
		}
		else
		{
			 setPressed(0);
		}
	}

	public void MainForm_MDIChildActivate(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			setPressed(0);
			this.buttonCopy.setEnabled(true);
			this.buttonCut.setEnabled(true);
			this.buttonPaste.setEnabled(true);
			this.buttonPointer.setEnabled(true);
			this.buttonLine.setEnabled(true);
			this.buttonRectangle.setEnabled(true);
			this.buttonImage.setEnabled(true);
			this.buttonText.setEnabled(true);
			this.buttonField.setEnabled(true);
			this.buttonVariables.setEnabled(true);
			this.buttonBands.setEnabled(true);
			this.buttonDatabase.setEnabled(true);
			this.buttonAlignLeft.setEnabled(true);
			this.buttonAlignRight.setEnabled(true);
			this.buttonAlignJustify.setEnabled(true);
			this.buttonAlignCenter.setEnabled(true);
			this.buttonLens.setEnabled(true);
			this.buttonGroups.setEnabled(true);
			this.buttonSR.setEnabled(true);
			this.buttonRoundRect.setEnabled(true);
			this.buttonCircle.setEnabled(true);
			
			// Set undo menu....
			updateUndoMenuState((ReportForm)form);
			
			/*
			if (((ReportForm)form).getReport().filename != null)
			{	
				com.ms.wfc.io.File f = new com.ms.wfc.io.File( ((ReportForm)form).getReport().filename, com.ms.wfc.io.FileMode.OPEN);
				if (((ReportForm)form).getReport().loadTime < f.getLastWriteTime().toLong())
				{
					if ( MessageBox.show(((ReportForm)form).getReport().filename+"\n\nThis file has been modified outside iReport.Do you want reload it?","iReport",MessageBox.ICONQUESTION|MessageBox.YESNO)==DialogResult.YES)
					{
						String filename = ((ReportForm)form).getReport().filename;
						ReportForm rf = openDocument(filename);
						form.dispose();
						rf.focus(); 
					}
				}
			}
			*/
		}
		else
		{
			this.buttonCopy.setEnabled(false);
			this.buttonCut.setEnabled(false);
			this.buttonPaste.setEnabled(false);
			this.buttonPointer.setEnabled(false);
			this.buttonLine.setEnabled(false);
			this.buttonRectangle.setEnabled(false);
			this.buttonText.setEnabled(false);
			this.buttonField.setEnabled(false);
			this.buttonImage.setEnabled(false);
			this.buttonVariables.setEnabled(false);
			this.buttonBands.setEnabled(false);
			this.buttonDatabase.setEnabled(false);
			this.buttonAlignLeft.setEnabled(false);
			this.buttonAlignRight.setEnabled(false);
			this.buttonAlignJustify.setEnabled(false);
			this.buttonAlignCenter.setEnabled(false);
			this.buttonLens.setEnabled(false);
			this.buttonGroups.setEnabled(false);
			this.buttonSR.setEnabled(false);
			this.buttonRoundRect.setEnabled(false);
			this.buttonCircle.setEnabled(false);
			
		}
	}

	private void buttonPointer_stateChanged(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).cancelNewObject();
			((ReportForm)form).setLensMode(	false );
		}
		setPressed(0);
	}

	private void buttonNew_buttonClick(Object source, Event e)
	{
		if (ireportProperties.getProperty("TEMPLATE_FILE") != null
			&& com.ms.wfc.io.File.exists(ireportProperties.getProperty("TEMPLATE_FILE")) )
		{
				
					
			ReportForm rpf = openDocument(ireportProperties.getProperty("TEMPLATE_FILE"));
			if (rpf == null) 
			{
				menuItem2_click(source, e);
				return;
			}
			Vector no_valid_names = new Vector();
			Form[] forms =  this.getMDIChildren();
			for (int i=0; i<forms.length; ++i)
			{
				if (forms[i] instanceof ReportForm)
				{
					no_valid_names.addElement( ((ReportForm)forms[i]).getReport().getReportName() );
				}
			}
			boolean valid_name = false;
			for (int i=1;; ++i)
			{
				String name = "Untitled_report_" + i;
				if (!no_valid_names.contains(name))
				{
					rpf.getReport().setReportName(name);
					break;
				}
			}
			rpf.getReport().filename = null;
		}
		else	
			menuItem2_click(source, e);
	}


	private void buttonCut_buttonClick(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).cut(clipboardObjects);
		}
	}

	private void buttonPaste_buttonClick(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).paste(clipboardObjects );
		}
	}

	private void buttonCopy_buttonClick(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).copy(clipboardObjects );
		}
	}

	private void GTImageButton1_buttonClick(Object source, Event e)
	{
		menuItem4_click(source, e);
	}

	private void GTImageButton2_buttonClick(Object source, Event e)
	{
		menuItem3_click(source, e);
	}

	private void menuItem23_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			this.initVariablesForm();
			vf.setReport(((ReportForm)form).getReport());
			vf.setOwner(this);
			vf.show();
		}
	}

	private void buttonLens_stateChanged(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm)
		{
			((ReportForm)form).setLensMode(	buttonLens.getPressed());
			
			setPressed((buttonLens.getPressed()) ? 7 : 0);
		}
		else
		{
			 setPressed(0);
		}
	}

	private void buttonVariables_buttonClick(Object source, Event e)
	{
		menuItem23_click(source, e);
	}

	private void panel2_paint(Object source, PaintEvent e)
	{
		
	}

	private void menuItem24_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			this.initGroupsForm();
			gf.setReport(((ReportForm)form).getReport());
			gf.setOwner(this);
			gf.show();
		}
	}

	private void buttonGroups_buttonClick(Object source, Event e)
	{
		menuItem24_click(source, e);
	}


	private void menuItemCut_click(Object source, Event e)
	{
		
	}

	private void menuItem5_click(Object source, Event e)
	{
		// See if they are open documents....
		// ...
		System.exit(0);
		
	}

	private void menuItem28_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_LEFT );
		}
	}
	

	private void menuItem29_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_RIGHT );
		}
	}

	private void menuItem30_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_TOP );
		}
	}

	private void menuItem31_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_BOTTOM );
		}
	}

	private void menuItem34_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_CENTER_HORIZONTALLY);
		}
	}

	private void menuItem35_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_CENTER_VERTICALLY);
		}
	}

	private void menuItem36_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_CENTER);
		}
	}

	private void menuItem32_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.SAME_WIDTH);
		}
	}

	private void menuItem37_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.SAME_HEIGHT);
		}
	}

	private void menuItem38_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.SAME_SIZE);
		}
	}

	private void menuItem46_click(Object source, Event e)
	{
		this.initDBConnectionsForm();
		cf.setOwner(this);
		cf.show();
	}

	private void menuItem45_click(Object source, Event e)
	{
		
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			this.initQueryForm();
			qf.setReport(((ReportForm)form).getReport() );
			qf.setOwner(this);
			qf.show();
		}
	}

	public Vector getConnectionEntries()
	{
		Vector v = new Vector();
		if (connProperties == null) return v; 
		for (int i=0; ; ++i)
		{
			if (connProperties.getProperty("CON"+i+"_NAME") == null)
				break;  	
			
			ConnectionEntry ce = new ConnectionEntry();
			ce.loadFromProperties(connProperties, i); 
			v.addElement(ce);
		}
		return v;
	}
	private void menuItem42_click(Object source, Event e)
	{
		ClasspathForm cp = new ClasspathForm(this);
		cp.showDialog();
	}
	
	public void updateUndoMenuState(ReportForm rf)
	{
		
		menuItemUndo.setEnabled( rf.undoIndex > 0);
		if (menuItemUndo.getEnabled())
		{
			menuItemUndo.setText("Undo "+ rf.undoOperations.elementAt(rf.undoIndex-1));
		}
		else
			menuItemUndo.setText("Undo");
		
		menuItemRedo.setEnabled( rf.undoIndex < rf.undoOperations.size());
		if (menuItemRedo.getEnabled())
		{
			menuItemRedo.setText("Redo "+ rf.undoOperations.elementAt(rf.undoIndex));
		}
		else
			menuItemRedo.setText("Redo");
		
	}

	private void menuItemUndo_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).undo();
		}
	}

	private void menuItemRedo_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).redo();
		}
	}

	private void menuItem47_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.ALIGN_TOP_TO_BAND);
		}
	}

	private void MainForm_activate(Object source, Event e)
	{
		if (wait) return;
		wait = true;
		Form[] forms = this.getMDIChildren();
		for (int i=0; i<forms.length; ++i)
		{
			Form form = forms[i];
			if (form instanceof ReportForm) 
			{
				if (((ReportForm)form).getReport().filename != null)
				{	
					try {
						com.ms.wfc.io.File f = new com.ms.wfc.io.File(((ReportForm)form).getReport().filename, com.ms.wfc.io.FileMode.OPEN);
						long time = f.getLastWriteTime().toLong();
						f.close();
						if (((ReportForm)form).getReport().loadTime < time)
						{
							if ( MessageBox.show(((ReportForm)form).getReport().filename+"\n\nThis file has been modified outside iReport.Do you want reload it?","iReport",MessageBox.ICONQUESTION|MessageBox.YESNO)==DialogResult.YES)
							{
								String filename = ((ReportForm)form).getReport().filename;
								ReportForm rf = openDocument(filename);
								form.dispose();
								rf.focus(); 
							}
							else
							{
								((ReportForm)form).getReport().loadTime = time;
							}
						}
					} catch (Exception ex) {}
				}
			}
		}
		wait = false;
		isActive = true;
	}

	private void menuItem49_click(Object source, Event e)
	{
		AboutForm af = new AboutForm();
		af.showDialog();
			
	}
	
	protected void onCreateHandle(Event e)   
	{  
        super.onCreateHandle(e);  
        this.setWindowState(this.getWindowState());  
	}   



	private void menuItem50_click(Object source, Event e)
	{
		String filename="";
		String query="";
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			filename = ((ReportForm)form).getReport().filename; 
			query = ((ReportForm)form).getReport().query; 
		}
		
		JasperReportForm jrf = new JasperReportForm( this);
		//jrf.setOwner(this);
		jrf.setFileName(filename);
		jrf.fillConnectionCombo(getConnectionEntries());
		jrf.setQuery(query);
		jrf.show();
	}


	private void menuItem51_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.BRING_TO_FRON);
		}
	}

	private void menuItem53_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.SEND__TO_BACK);
		}
	}

	private void GTImageButtonSR_buttonClick(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).setLensMode(	false );
			((ReportForm)form).prepareForNewElement(ReportElementType.SUBREPORT_ELEMENT );	
			setPressed(8);
		}
		else
		{
			 setPressed(0);
		}
	}

	private void menuItem52_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).prepareForNewElement(ReportElementType.SUBREPORT_ELEMENT);	
		}
	}

	private void menuItem55_click(Object source, Event e)
	{
		OptionsForm of = new OptionsForm(this);
		of.showDialog();
		
	}

	private void compilerButton_buttonClick(Object source, Event e)
	{
		menuItem50_click(source, e);
	}



	private void GTImageButton1_click(Object source, Event e)
	{
		
	}

	private void menuItem63_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.HSPACE_MAKE_EQUAL);
		}
	}

	private void menuItem65_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.HSPACE_INCREASE );
		}
	}

	private void menuItem64_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.HSPACE_DECREASE);
		}
	}

	private void menuItem66_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.HSPACE_REMOVE );
		}
	}

	private void menuItem67_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.VSPACE_MAKE_EQUAL);
		}
	}

	private void menuItem68_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.VSPACE_INCREASE);
		}
	}

	private void menuItem69_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.VSPACE_DECREASE );
		}
	}

	private void menuItem70_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			((ReportForm)form).makeOperation( OperationType.VSPACE_REMOVE);
		}
	}

	private void menuItem72_click(Object source, Event e)
	{
		this.layoutMDI(MDILayout.CASCADE);
	}

	private void menuItem73_click(Object source, Event e)
	{
		this.layoutMDI(MDILayout.TILE_HORIZONTAL);
	}

	private void menuItem74_click(Object source, Event e)
	{
		this.layoutMDI(MDILayout.TILE_VERTICAL);
	}

	private void menuItem75_click(Object source, Event e)
	{
		this.layoutMDI(MDILayout.ARRANGE_ICONS);
	}

	private void GTImageButton2_click(Object source, Event e)
	{
		
	}

	private void menuItem76_click(Object source, Event e)
	{
		ReportWizardForm rw = new ReportWizardForm(this);
		rw.fillConnectionCombo(getConnectionEntries());
		rw.setOwner(this);
		rw.showDialog();
	}

	
	public String getUntitledName()
	{
			Vector no_valid_names = new Vector();
			Form[] forms =  this.getMDIChildren();
			for (int i=0; i<forms.length; ++i)
			{
				if (forms[i] instanceof ReportForm)
				{
					no_valid_names.addElement( ((ReportForm)forms[i]).getReport().getReportName() );
				}
			}
			boolean valid_name = false;
			for (int i=1;; ++i)
			{
				String name = "Untitled_report_" + i;
				if (!no_valid_names.contains(name))
				{
					return name;
				}
			}
	}
	private void menuItem78_click(Object source, Event e)
	{
		// Save file in tmp file...
		wait  = true;
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			if ( ((ReportForm)form).getReport().filename == null )
			{
				if (MessageBox.show("You must save your file before editing it with an external editor!\nSave it now ?","", MessageBox.ICONWARNING|MessageBox.YESNO) == DialogResult.YES) 
				{
					menuItem3_click(source,e);
				}
				else
					return;
			}
			else
			{
				if (MessageBox.show("The document has been modified!\nWould you like to save it before to lunching external editor ?","", MessageBox.ICONQUESTION|MessageBox.YESNO) == DialogResult.YES) 
				{
					menuItem3_click(source,e);
				}
			}
			if (((ReportForm)form).getReport().filename == null) return;
			
			Runtime rt = Runtime.getRuntime(); 
			try {
			//MessageBox.show("notepad.exe "+ ((ReportForm)form).getReport().filename);
			String editor = "notepad.exe";
			if (this.ireportProperties.getProperty("EDITOR")!=null)
			 editor = (String)this.ireportProperties.getProperty("EDITOR");
				
			rt.exec(editor+ " \"" +((ReportForm)form).getReport().filename+"\"");
			} catch (Exception ex)
			{}
		}
		wait  = false;
		// Lunch texteditor...
	}

	private void MainForm_keyDown(Object source, KeyEvent e)
	{
		this.setText(""+e.getKeyCode());
	}

	private void MainForm_Idle(Object sender, Event e)
	{
		// Imposta statusBarStates
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm 
			&& isActive )  //!((ReportForm)form).isActive
			
		/*	(((ReportForm)form).panel9.getFocused() ||
			 ((ReportForm)form).panel8.getFocused() ||
			 ((ReportForm)form).panel7.getFocused() ||
			 ((ReportForm)form).panel6.getFocused() ||
			 ((ReportForm)form).panel5.getFocused() ||
			 ((ReportForm)form).panel4.getFocused() ||
			 ((ReportForm)form).panel3.getFocused() ||
			 ((ReportForm)form).panel2.getFocused() ||
			 ((ReportForm)form).panel1.getFocused())) */
		{
			
			if ((GetAsyncKeyState(VK_UP) & 1) == 1)
				((ReportForm)form).panel9_keyDown(this, new KeyEvent(VK_UP));
			else if ((GetAsyncKeyState(VK_DOWN) & 1) == 1)
				((ReportForm)form).panel9_keyDown(this, new KeyEvent(VK_DOWN));
			else if ((GetAsyncKeyState(VK_LEFT) & 1) == 1)
				((ReportForm)form).panel9_keyDown(this, new KeyEvent(VK_LEFT));
			else if ((GetAsyncKeyState(VK_RIGHT) & 1) == 1)
				((ReportForm)form).panel9_keyDown(this, new KeyEvent(VK_RIGHT));
			else if ((GetAsyncKeyState(VK_SHIFT) & 1) == 1)
				((ReportForm)form).panel9_keyDown(this, new KeyEvent(VK_SHIFT));
			
			//((ReportForm)form).panel9.focus();
			
		}
	}

	public static final int VK_CAPITAL = 0x14;
	public static final int VK_NUMLOCK = 0x90;
	public static final int VK_UP = 0x26;
	public static final int VK_RIGHT = 0x27;
	public static final int VK_DOWN = 0x28;
	public static final int VK_LEFT = 0x25;
	public static final int VK_SHIFT = 0x10;
	/**
	 * @dll.import("USER32",auto) 
	 */
	public static native short GetKeyState(int nVirtKey);
	
	/**
	 * @dll.import("USER32",auto) 
	 */
	public static native short GetAsyncKeyState(int nVirtKey);
	
	private void menuItem79_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			this.initFontsForm( ((ReportForm)form).getReport() );
			fontf.setOwner(this);
			fontf.show();
		}
	}

	private void menuItem80_click(Object source, Event e)
	{
		this.menuItemLock.setChecked(!menuItemLock.getChecked());
	}
	
	public boolean getLockElement()
	{
		return menuItemLock.getChecked();
	}
	
	
	
	public void saveReport(String filename)
	{
		Form[] forms =  this.getMDIChildren();
		for (int i=0; i<forms.length; ++i)
		{
			if (forms[i] instanceof ReportForm)
			{
				if (((ReportForm)forms[i]).getReport().filename != null &&
					((ReportForm)forms[i]).getReport().filename.equals(""+filename))
				{
					
					Report rp = ((ReportForm)forms[i]).getReport();
					saveBackup( rp.filename); 
					rp.saveXMLFile();
					this.addToRecentFileList(rp.filename);
					saveProperties();
					this.updateRecentFileList();
				}
			}
		}
	}

	private void menuItem81_click(Object source, Event e)
	{
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			BandsForm bandsForm = new BandsForm(this);
			bandsForm.setValues( ((ReportForm)form).getReport());
			if (bandsForm.showDialog() == DialogResult.OK)
			{
				Report report = ((ReportForm)form).getReport();
				
				Enumeration enumb = report.bands.elements();
				int i=0;
				while (enumb.hasMoreElements())
				{
					Band b = (Band)enumb.nextElement();
					// 1. Set expression.
					b.printWhenExpression = bandsForm.expressions[i];
					
					// 2. we set band height, but first we adjust elements position
					int delta = bandsForm.heights[i] - b.height;
					if (delta != 0)
					{
						int min_height = 0;
						int band_h =  report.getBandYLocation(b) +10;
						if (delta < -(  b.height-min_height) ) delta= -(b.height-min_height);
						if (report.getDesignHeight()+delta > report.getPagesize().y) delta = report.getPagesize().y- report.getDesignHeight();
					    // Redraw all under the min height...
						b.height += delta;
						int edge_y =  Math.min(report.getBandYLocation(b)+b.height,report.getBandYLocation(b)+b.height-delta);
						Enumeration enum = report.getElements().elements();
						while (enum.hasMoreElements())
						{
							ReportElement re = (ReportElement)enum.nextElement();
							if (re.position.y >= edge_y+10)	
							{
								// I should add the distance form the base of resized band, and my element... 
								int space_before_band = band_h - re.position.y - re.height;
								if (band_h <= report.getBandYLocation(re.band) +10)
									space_before_band = 0;
								re.setPosition(new Point(re.position.x,re.position.y+delta));	
							}	
						}			
					}
					i++;
				}			
				((ReportForm)form).refreshAll();
			}
		}
	}

	private void menuItem82_click(Object source, Event e)
	{

	}



	private void MainForm_resize(Object source, Event e)
	{
		// Adjust toolbar elements positions....
		if (toolBarControls == null ) return;
		Enumeration enum = toolBarControls.elements();
		int actualWidth=8;
		int actualHeight=0;
		int availWidth = this.panel1.getWidth()-8;
		while (enum.hasMoreElements())
		{
			Object obj = enum.nextElement();
			if (obj == null || ! (obj instanceof Control))
			{
				if (actualWidth != 8)
				{
					actualWidth += 8;
				}
			}
			else
			{
					Control ctl = (Control)obj;
					if (ctl.getVisible())
					{
						if ((actualWidth + ctl.getWidth()) > availWidth && (ctl.getWidth()+8 <= availWidth))
						{
							// Go to the next row...
							actualHeight += 32;
							actualWidth = 8;
						}
						ctl.setTop(actualHeight);
						ctl.setLeft(actualWidth);
						actualWidth += ctl.getWidth();
					}
			}
		}
		panel1.setHeight(actualHeight+34);
	}

	private void panelLens_paint(Object source, PaintEvent e)
	{
		e.graphics.clearRect(0,0,panelLens.getWidth(), panelLens.getHeight());
	    e.graphics.drawBorder3D(0,0,panelLens.getWidth(), panelLens.getHeight(),Border3DStyle.ETCHED);
	}


	/*
	Left
	Right
	Center
	Justified
	*/
	private void buttonAlignJustify_buttonClick(Object source, Event e)
	{
		setAlignment("Justified");
	}
	
	private void buttonAlignCenter_buttonClick(Object source, Event e)
	{
		setAlignment("Center");
	}
	
	private void buttonAlignLeft_buttonClick(Object source, Event e)
	{
		setAlignment("Left");
	}
	
	private void buttonAlignRight_buttonClick(Object source, Event e)
	{
		setAlignment("Right");
	}
	
		private void setAlignment(String s)
	{
		// align to justify all textfield delected
		Form form = this.getActiveMDIChild();
		if (form instanceof ReportForm) 
		{
			int i=0;
			ReportForm reportForm = (ReportForm)form;
			Enumeration enum = reportForm.selectedElements.elements() ;
			while (enum.hasMoreElements())
			{
				ReportElement re = (ReportElement)enum.nextElement();
				if (re instanceof TextReportElement)
				{
					i++;
					((TextReportElement)re).align = s;
					//reportForm.updateElement(re,null);
				}					
			}
			if (i>0) reportForm.refreshAll();
		}
	}
		
	public void specialDocumentLoad(Document doc,StringBufferInputStream sbin,  String xmlfile) throws com.ms.xml.parser.ParseException
	{
		doc.load(sbin);
		
		if (this.ireportProperties.getProperty("DISABLE_UTF_SUPPORT") != null &&
			this.ireportProperties.getProperty("DISABLE_UTF_SUPPORT").length() > 0 &&
			this.ireportProperties.getProperty("DISABLE_UTF_SUPPORT").equals("true"))
		{
			return;			
		}
		// Read all text of StaticTextElement and TextFieldElement
		Vector texts= new Vector();
		while (xmlfile.indexOf("<text>") != -1)
		{
			xmlfile = xmlfile.substring(xmlfile.indexOf("<text>")+6);
			String s = xmlfile.substring(0,  xmlfile.indexOf("</text>"));
			texts.addElement(s);
		}
		//MessageBox.show("Vector size:"+texts.size());
		// Navigate all the dom, searching text elements...
		Vector elements = new Vector();
		exploreDom("text",doc.getRoot(), elements);
		Enumeration enum = elements.elements();
		//MessageBox.show("Elements size:"+elements.size());
		int i=0;
		while (enum.hasMoreElements())
		{
			Element elem = (Element)enum.nextElement();
			elem.setAttribute("Unicode",parseCDATA((String)texts.elementAt(i)));
			i++;
		}
	}
	
	public void exploreDom(String text, Element e, Vector v)
	{
		if (v==null) return;
		if (e==null) return;
		if (text == null) return;
		
		for (int i=0; i<e.numElements(); ++i)
		{
			if (e.getChild(i) != null)
				exploreDom(text, e.getChild(i),  v);
		}
		
		if (e.getTagName() !=null && (e.getTagName().getName()+"").equalsIgnoreCase(text))
			v.addElement(e);
	}
	
	public String parseCDATA(String s)
	{
		if(s!=null && s.startsWith("<![CDATA["))
	    {
		   s = s.trim();
		   s = s.substring(9);
		   s = s.substring(0,s.length()-3);
		}
		return s;
	}

		private void MainForm_deactivate(Object source, Event e)
		{
			isActive = false;
		}

		private void buttonDatabase_click(Object source, Event e)
		{
			
		}

		private void buttonCircle_stateChanged(Object source, Event e)
		{
			Form form = this.getActiveMDIChild();
			if (form instanceof ReportForm) 
			{
				((ReportForm)form).setLensMode(	false );
				((ReportForm)form).prepareForNewElement(ReportElementType.ELLIPSE_ELEMENT);	
				setPressed(10);
			}
			else
			{
				 setPressed(0);
			}
		}

		private void buttonRoundRect_stateChanged(Object source, Event e)
		{
			Form form = this.getActiveMDIChild();
			if (form instanceof ReportForm) 
			{
				((ReportForm)form).setLensMode(	false );
				((ReportForm)form).prepareForNewElement(ReportElementType.ROUND_RECTANGLE_ELEMENT);	
				setPressed(9);
			}
			else
			{
				 setPressed(0);
			}
		}

		private void MainForm_dragDrop(Object source, DragEvent e)
		{
			if (e.data.getDataPresent(DataFormats.CF_HDROP)) { 
                String[] files=(String[])e.data.getData(DataFormats.CF_HDROP);

				openDocument(files[0]);
			}
		}

		private void MainForm_dragOver(Object source, DragEvent e)
		{
			if (e.data.getDataPresent (DataFormats.CF_HDROP))
			{ 
	            String[] sData = (String[])e.data.getData (DataFormats.CF_HDROP);
	            if (com.ms.wfc.io.File.isFile( sData[0]))
	                e.effect = DragDropEffect.COPY;
		    } 
			else
		        e.effect = DragDropEffect.NONE;
		}

		/**
		 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
		 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
		 * con l'Editor del codice.
		 */
		Container components = new Container();
		MainMenu mainMenu1 = new MainMenu();
		MenuItem menuItem1 = new MenuItem();
		MenuItem menuItem2 = new MenuItem();
		MenuItem menuItem3 = new MenuItem();
		MenuItem menuItem4 = new MenuItem();
		MenuItem menuItem5 = new MenuItem();
		MenuItem menuItem6 = new MenuItem();
		MenuItem menuItem7 = new MenuItem();
		MenuItem menuItem10 = new MenuItem();
		MenuItem menuItem8 = new MenuItem();
		MenuItem menuItem9 = new MenuItem();
		MenuItem menuItem11 = new MenuItem();
		MenuItem menuItem12 = new MenuItem();
		MenuItem menuItem13 = new MenuItem();
		MenuItem menuItem14 = new MenuItem();
		MenuItem menuItem15 = new MenuItem();
		MenuItem menuItem16 = new MenuItem();
		MenuItem menuItem17 = new MenuItem();
		MenuItem menuItem18 = new MenuItem();
		MenuItem menuItem19 = new MenuItem();
		MenuItem menuItem20 = new MenuItem();
		MenuItem menuItem21 = new MenuItem();
		MenuItem menuItem22 = new MenuItem();
		Panel panelLens = new Panel();
		GTImageButton GTImageButton1 = new GTImageButton();
		GTImageButton buttonCut = new GTImageButton();
		GTImageButton buttonPaste = new GTImageButton();
		GTImageButton buttonLine = new GTImageButton();
		GTImageButton buttonImage = new GTImageButton();
		GTImageButton buttonField = new GTImageButton();
		GTImageButton buttonNew = new GTImageButton();
		GTImageButton GTImageButton2 = new GTImageButton();
		GTImageButton buttonCopy = new GTImageButton();
		GTImageButton buttonPointer = new GTImageButton();
		GTImageButton buttonRectangle = new GTImageButton();
		GTImageButton buttonText = new GTImageButton();
		MenuItem menuItem23 = new MenuItem();
		GTImageButton buttonVariables = new GTImageButton();
		GTImageButton buttonLens = new GTImageButton();
		GTImageButton buttonGroups = new GTImageButton();
		NumberComboBox numberComboBox1 = new NumberComboBox();
		MenuItem menuItem24 = new MenuItem();
		MenuItem menuItemCopy = new MenuItem();
		MenuItem menuItemCut = new MenuItem();
		MenuItem menuItemPaste = new MenuItem();
		MenuItem menuItem25 = new MenuItem();
		MenuItem menuItem26 = new MenuItem();
		MenuItem menuItem27 = new MenuItem();
		MenuItem menuItem28 = new MenuItem();
		MenuItem menuItem29 = new MenuItem();
		MenuItem menuItem30 = new MenuItem();
		MenuItem menuItem31 = new MenuItem();
		MenuItem menuItem32 = new MenuItem();
		MenuItem menuItem33 = new MenuItem();
		MenuItem menuItem34 = new MenuItem();
		MenuItem menuItem35 = new MenuItem();
		MenuItem menuItem36 = new MenuItem();
		MenuItem menuItem37 = new MenuItem();
		MenuItem menuItem38 = new MenuItem();
		MenuItem menuItem39 = new MenuItem();
		MenuItem menuItem40 = new MenuItem();
		MenuItem menuItem41 = new MenuItem();
		MenuItem menuItem45 = new MenuItem();
		MenuItem menuItem46 = new MenuItem();
		MenuItem menuItem42 = new MenuItem();
		MenuItem menuItem43 = new MenuItem();
		MenuItem menuItemUndo = new MenuItem();
		MenuItem menuItemRedo = new MenuItem();
		MenuItem menuItem48 = new MenuItem();
		MenuItem menuItem47 = new MenuItem();
		MenuItem menuItem44 = new MenuItem();
		MenuItem menuItem49 = new MenuItem();
		MenuItem menuItem50 = new MenuItem();
		MenuItem menuItem51 = new MenuItem();
		MenuItem menuItem53 = new MenuItem();
		GTImageButton buttonSR = new GTImageButton();
		MenuItem menuItem52 = new MenuItem();
		ToolTip toolTip1 = new ToolTip(components);
		MenuItem menuItem54 = new MenuItem();
		MenuItem menuItem55 = new MenuItem();
		GTImageButton compilerButton = new GTImageButton();
		MenuItem menuItem56 = new MenuItem();
		MenuItem menuItem57 = new MenuItem();
		MenuItem menuItem58 = new MenuItem();
		MenuItem menuItem59 = new MenuItem();
		MenuItem menuItem60 = new MenuItem();
		MenuItem menuItem61 = new MenuItem();
		MenuItem menuItem62 = new MenuItem();
		MenuItem menuItem63 = new MenuItem();
		MenuItem menuItem64 = new MenuItem();
		MenuItem menuItem65 = new MenuItem();
		MenuItem menuItem66 = new MenuItem();
		MenuItem menuItem67 = new MenuItem();
		MenuItem menuItem68 = new MenuItem();
		MenuItem menuItem69 = new MenuItem();
		MenuItem menuItem70 = new MenuItem();
		MenuItem menuItem71 = new MenuItem();
		MenuItem menuItem72 = new MenuItem();
		MenuItem menuItem73 = new MenuItem();
		MenuItem menuItem74 = new MenuItem();
		MenuItem menuItem75 = new MenuItem();
		MenuItem menuItem76 = new MenuItem();
		MenuItem menuItem77 = new MenuItem();
		MenuItem menuItem78 = new MenuItem();
		MenuItem menuItem79 = new MenuItem();
		MenuItem menuItemLock = new MenuItem();
		MenuItem menuItem80 = new MenuItem();
		public RichEdit richEdit1 = new RichEdit();
		MenuItem menuItem81 = new MenuItem();
		ImageList imageList1 = new ImageList();
		Panel panel1 = new Panel();
		GTImageButton buttonBands = new GTImageButton();
		GTImageButton buttonAlignLeft = new GTImageButton();
		GTImageButton buttonAlignRight = new GTImageButton();
		GTImageButton buttonAlignCenter = new GTImageButton();
		GTImageButton buttonAlignJustify = new GTImageButton();
		GTImageButton buttonDatabase = new GTImageButton();
		GTImageButton buttonCircle = new GTImageButton();
		GTImageButton buttonRoundRect = new GTImageButton();

		private void initForm()
		{
			// NOTA: questo form contiene informazioni relative alle risorse in
			// un file esterno. Non modificare il parametro di tipo String delle
			// chiamate alla funzione resources.getObject(). Ad esempio, non
			// modificare"foo1_location" nella seguente riga di codice,
			// nemmeno se il nome dell'oggetto Foo viene modificato: 
			//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

			IResourceManager resources = new ResourceManager(this, "MainForm");
			menuItem2.setShortcut(Shortcut.CTRL_N);
			menuItem2.setText("New");
			menuItem2.addOnClick(new EventHandler(this.menuItem2_click));

			menuItem3.setShortcut(Shortcut.CTRL_S);
			menuItem3.setText("Save XML Jasper Report");
			menuItem3.addOnClick(new EventHandler(this.menuItem3_click));

			menuItem4.setShortcut(Shortcut.CTRL_O);
			menuItem4.setText("Load XML Jasper Report");
			menuItem4.addOnClick(new EventHandler(this.menuItem4_click));

			menuItem5.setText("&Quit");
			menuItem5.addOnClick(new EventHandler(this.menuItem5_click));

			menuItem7.setChecked(true);
			menuItem7.setText("Rules");
			menuItem7.addOnClick(new EventHandler(this.menuItem7_click));

			menuItem10.setShortcut(Shortcut.CTRL_R);
			menuItem10.setText("Report properties");
			menuItem10.addOnClick(new EventHandler(this.menuItem10_click));

			menuItem9.setText("Generic element (for debug use only)");
			menuItem9.addOnClick(new EventHandler(this.menuItem9_click));

			menuItem11.setText("Rectangle");
			menuItem11.addOnClick(new EventHandler(this.menuItem11_click));

			menuItem12.setText("-");

			menuItem13.setText("Image");
			menuItem13.addOnClick(new EventHandler(this.menuItem13_click));

			menuItem14.setText("Static text");
			menuItem14.addOnClick(new EventHandler(this.menuItem14_click));

			menuItem15.setText("-");

			menuItem16.setShortcut(Shortcut.CTRL_E);
			menuItem16.setText("Element properties");
			menuItem16.addOnClick(new EventHandler(this.menuItem16_click));

			menuItem17.setShortcut(Shortcut.CTRL_B);
			menuItem17.setText("Elements browser");
			menuItem17.addOnClick(new EventHandler(this.menuItem17_click));

			menuItem18.setText("-");

			menuItem19.setText("Line");
			menuItem19.addOnClick(new EventHandler(this.menuItem19_click));

			menuItem20.setText("Save XML Jasper Report as...");
			menuItem20.addOnClick(new EventHandler(this.menuItem20_click));

			menuItem21.setText("Text field");
			menuItem21.addOnClick(new EventHandler(this.menuItem21_click));

			panelLens.setLocation(new Point(560, 0));
			panelLens.setSize(new Point(88, 32));
			panelLens.setTabIndex(8);
			panelLens.setText("panel2");
			panelLens.addOnPaint(new PaintEventHandler(this.panelLens_paint));

			GTImageButton1.setEnabled(true);
			GTImageButton1.setLocation(new Point(40, 0));
			GTImageButton1.setSize(new Point(32, 32));
			GTImageButton1.setTabIndex(17);
			GTImageButton1.setText("buttonNew");
			GTImageButton1.setImg1((Bitmap)resources.getObject("GTImageButton1_img1"));
			GTImageButton1.setImg2((Bitmap)resources.getObject("GTImageButton1_img2"));
			GTImageButton1.setImg3(null);
			GTImageButton1.setToggle(false);
			GTImageButton1.addOnClick(new EventHandler(this.GTImageButton1_click));
			GTImageButton1.addOnButtonClick(new EventHandler(this.GTImageButton1_buttonClick));

			buttonCut.setEnabled(false);
			buttonCut.setLocation(new Point(112, 0));
			buttonCut.setSize(new Point(32, 32));
			buttonCut.setTabIndex(19);
			buttonCut.setText("GTImageButton3");
			buttonCut.setImg1((Bitmap)resources.getObject("buttonCut_img1"));
			buttonCut.setImg2((Bitmap)resources.getObject("buttonCut_img2"));
			buttonCut.setImg3((Bitmap)resources.getObject("buttonCut_img3"));
			buttonCut.setToggle(false);
			buttonCut.addOnButtonClick(new EventHandler(this.buttonCut_buttonClick));

			buttonPaste.setEnabled(false);
			buttonPaste.setLocation(new Point(176, 0));
			buttonPaste.setSize(new Point(32, 32));
			buttonPaste.setTabIndex(21);
			buttonPaste.setText("GTImageButton3");
			buttonPaste.setImg1((Bitmap)resources.getObject("buttonPaste_img1"));
			buttonPaste.setImg2((Bitmap)resources.getObject("buttonPaste_img2"));
			buttonPaste.setImg3((Bitmap)resources.getObject("buttonPaste_img3"));
			buttonPaste.setToggle(false);
			buttonPaste.addOnButtonClick(new EventHandler(this.buttonPaste_buttonClick));

			buttonLine.setEnabled(false);
			buttonLine.setLocation(new Point(240, 0));
			buttonLine.setSize(new Point(32, 32));
			buttonLine.setTabIndex(12);
			buttonLine.setText("GTImageButton9");
			buttonLine.setImg1((Bitmap)resources.getObject("buttonLine_img1"));
			buttonLine.setImg2((Bitmap)resources.getObject("buttonLine_img2"));
			buttonLine.setImg3((Bitmap)resources.getObject("buttonLine_img3"));
			buttonLine.setToggle(true);
			buttonLine.addOnStateChanged(new EventHandler(this.buttonLine_stateChanged));

			buttonImage.setEnabled(false);
			buttonImage.setLocation(new Point(304, 0));
			buttonImage.setSize(new Point(32, 32));
			buttonImage.setTabIndex(14);
			buttonImage.setText("GTImageButton11");
			buttonImage.setImg1((Bitmap)resources.getObject("buttonImage_img1"));
			buttonImage.setImg2((Bitmap)resources.getObject("buttonImage_img2"));
			buttonImage.setImg3((Bitmap)resources.getObject("buttonImage_img3"));
			buttonImage.setToggle(true);
			buttonImage.addOnClick(new EventHandler(this.buttonImage_click));

			buttonField.setEnabled(false);
			buttonField.setLocation(new Point(368, 0));
			buttonField.setSize(new Point(32, 32));
			buttonField.setTabIndex(11);
			buttonField.setText("GTImageButton13");
			buttonField.setImg1((Bitmap)resources.getObject("buttonField_img1"));
			buttonField.setImg2((Bitmap)resources.getObject("buttonField_img2"));
			buttonField.setImg3((Bitmap)resources.getObject("buttonField_img3"));
			buttonField.setToggle(true);
			buttonField.addOnClick(new EventHandler(this.buttonField_click));

			buttonNew.setEnabled(true);
			buttonNew.setLocation(new Point(8, 0));
			buttonNew.setSize(new Point(32, 32));
			buttonNew.setTabIndex(18);
			buttonNew.setText("");
			buttonNew.setImg1((Bitmap)resources.getObject("buttonNew_img1"));
			buttonNew.setImg2((Bitmap)resources.getObject("buttonNew_img2"));
			buttonNew.setImg3(null);
			buttonNew.setToggle(false);
			buttonNew.addOnButtonClick(new EventHandler(this.buttonNew_buttonClick));

			GTImageButton2.setEnabled(true);
			GTImageButton2.setLocation(new Point(72, 0));
			GTImageButton2.setSize(new Point(32, 32));
			GTImageButton2.setTabIndex(16);
			GTImageButton2.setText("buttonSave");
			GTImageButton2.setImg1((Bitmap)resources.getObject("GTImageButton2_img1"));
			GTImageButton2.setImg2((Bitmap)resources.getObject("GTImageButton2_img2"));
			GTImageButton2.setImg3(null);
			GTImageButton2.setToggle(false);
			GTImageButton2.addOnClick(new EventHandler(this.GTImageButton2_click));
			GTImageButton2.addOnButtonClick(new EventHandler(this.GTImageButton2_buttonClick));

			buttonCopy.setEnabled(false);
			buttonCopy.setLocation(new Point(144, 0));
			buttonCopy.setSize(new Point(32, 32));
			buttonCopy.setTabIndex(20);
			buttonCopy.setText("");
			buttonCopy.setImg1((Bitmap)resources.getObject("buttonCopy_img1"));
			buttonCopy.setImg2((Bitmap)resources.getObject("buttonCopy_img2"));
			buttonCopy.setImg3((Bitmap)resources.getObject("buttonCopy_img3"));
			buttonCopy.setToggle(false);
			buttonCopy.addOnButtonClick(new EventHandler(this.buttonCopy_buttonClick));

			buttonPointer.setEnabled(false);
			buttonPointer.setLocation(new Point(208, 0));
			buttonPointer.setSize(new Point(32, 32));
			buttonPointer.setTabIndex(15);
			buttonPointer.setText("");
			buttonPointer.setImg1((Bitmap)resources.getObject("buttonPointer_img1"));
			buttonPointer.setImg2((Bitmap)resources.getObject("buttonPointer_img2"));
			buttonPointer.setImg3((Bitmap)resources.getObject("buttonPointer_img3"));
			buttonPointer.setToggle(true);
			buttonPointer.addOnStateChanged(new EventHandler(this.buttonPointer_stateChanged));

			buttonRectangle.setEnabled(false);
			buttonRectangle.setLocation(new Point(272, 0));
			buttonRectangle.setSize(new Point(32, 32));
			buttonRectangle.setTabIndex(8);
			buttonRectangle.setText("GTImageButton10");
			buttonRectangle.setImg1((Bitmap)resources.getObject("buttonRectangle_img1"));
			buttonRectangle.setImg2((Bitmap)resources.getObject("buttonRectangle_img2"));
			buttonRectangle.setImg3((Bitmap)resources.getObject("buttonRectangle_img3"));
			buttonRectangle.setToggle(true);
			buttonRectangle.addOnClick(new EventHandler(this.buttonRectangle_click));

			buttonText.setEnabled(false);
			buttonText.setLocation(new Point(336, 0));
			buttonText.setSize(new Point(32, 32));
			buttonText.setTabIndex(13);
			buttonText.setText("GTImageButton12");
			buttonText.setImg1((Bitmap)resources.getObject("buttonText_img1"));
			buttonText.setImg2((Bitmap)resources.getObject("buttonText_img2"));
			buttonText.setImg3((Bitmap)resources.getObject("buttonText_img3"));
			buttonText.setToggle(true);
			buttonText.addOnClick(new EventHandler(this.buttonText_click));

			menuItem23.setText("Values form");
			menuItem23.addOnClick(new EventHandler(this.menuItem23_click));

			buttonVariables.setEnabled(false);
			buttonVariables.setLocation(new Point(432, 0));
			buttonVariables.setSize(new Point(32, 32));
			buttonVariables.setTabIndex(10);
			buttonVariables.setText("GTImageButton3");
			buttonVariables.setImg1((Bitmap)resources.getObject("buttonVariables_img1"));
			buttonVariables.setImg2((Bitmap)resources.getObject("buttonVariables_img2"));
			buttonVariables.setImg3((Bitmap)resources.getObject("buttonVariables_img3"));
			buttonVariables.setToggle(false);
			buttonVariables.addOnButtonClick(new EventHandler(this.buttonVariables_buttonClick));

			buttonLens.setEnabled(false);
			buttonLens.setLocation(new Point(528, 0));
			buttonLens.setSize(new Point(32, 32));
			buttonLens.setTabIndex(7);
			buttonLens.setText("GTImageButton3");
			buttonLens.setImg1((Bitmap)resources.getObject("buttonLens_img1"));
			buttonLens.setImg2((Bitmap)resources.getObject("buttonLens_img2"));
			buttonLens.setImg3((Bitmap)resources.getObject("buttonLens_img3"));
			buttonLens.setToggle(true);
			buttonLens.addOnStateChanged(new EventHandler(this.buttonLens_stateChanged));

			buttonGroups.setEnabled(false);
			buttonGroups.setLocation(new Point(464, 0));
			buttonGroups.setSize(new Point(32, 32));
			buttonGroups.setTabIndex(9);
			buttonGroups.setText("");
			buttonGroups.setImg1((Bitmap)resources.getObject("buttonGroups_img1"));
			buttonGroups.setImg2((Bitmap)resources.getObject("buttonGroups_img2"));
			buttonGroups.setImg3((Bitmap)resources.getObject("buttonGroups_img3"));
			buttonGroups.setToggle(false);
			buttonGroups.addOnButtonClick(new EventHandler(this.buttonGroups_buttonClick));

			numberComboBox1.setCursor(Cursor.DEFAULT);
			numberComboBox1.setLocation(new Point(8, 4));
			numberComboBox1.setSize(new Point(72, 21));
			numberComboBox1.setTabIndex(0);
			numberComboBox1.setText("0");
			numberComboBox1.setIsDouble(false);
			numberComboBox1.setDecimals(0);
			numberComboBox1.setValue(0.0d);
			numberComboBox1.setViewPlus(false);
			numberComboBox1.setSeparatoreMigliaia(false);
			numberComboBox1.addOnValueChanged(new EventHandler(this.numberComboBox1_valueChanged));

			menuItem24.setShortcut(Shortcut.CTRL_G);
			menuItem24.setText("Groups");
			menuItem24.addOnClick(new EventHandler(this.menuItem24_click));

			menuItemCopy.setShortcut(Shortcut.CTRL_C);
			menuItemCopy.setText("Copy");
			menuItemCopy.addOnClick(new EventHandler(this.buttonCopy_buttonClick));

			menuItemCut.setShortcut(Shortcut.CTRL_X);
			menuItemCut.setText("Cut");
			menuItemCut.addOnClick(new EventHandler(this.buttonCut_buttonClick));

			menuItemPaste.setShortcut(Shortcut.CTRL_V);
			menuItemPaste.setText("Paste");
			menuItemPaste.addOnClick(new EventHandler(this.buttonPaste_buttonClick));

			menuItem28.setText("Align Left");
			menuItem28.addOnClick(new EventHandler(this.menuItem28_click));

			menuItem29.setText("Align Right");
			menuItem29.addOnClick(new EventHandler(this.menuItem29_click));

			menuItem30.setText("Align Top");
			menuItem30.addOnClick(new EventHandler(this.menuItem30_click));

			menuItem31.setText("Align Bottom");
			menuItem31.addOnClick(new EventHandler(this.menuItem31_click));

			menuItem32.setText("Same Width");
			menuItem32.addOnClick(new EventHandler(this.menuItem32_click));

			menuItem34.setText("Center Horizontally");
			menuItem34.addOnClick(new EventHandler(this.menuItem34_click));

			menuItem35.setText("Center Vertically (band based)");
			menuItem35.addOnClick(new EventHandler(this.menuItem35_click));

			menuItem36.setText("Center in band");
			menuItem36.addOnClick(new EventHandler(this.menuItem36_click));

			menuItem37.setText("Same Height");
			menuItem37.addOnClick(new EventHandler(this.menuItem37_click));

			menuItem38.setText("Same Size");
			menuItem38.addOnClick(new EventHandler(this.menuItem38_click));

			menuItem27.setMenuItems(new MenuItem[] {
									menuItem32, 
									menuItem37, 
									menuItem38});
			menuItem27.setText("Size...");

			menuItem39.setText("Align vertical axis");

			menuItem40.setText("Align horizontal axis");

			menuItem45.setText("Report query");
			menuItem45.addOnClick(new EventHandler(this.menuItem45_click));

			menuItem46.setText("Connections");
			menuItem46.addOnClick(new EventHandler(this.menuItem46_click));

			menuItem42.setText("Classpath...");
			menuItem42.addOnClick(new EventHandler(this.menuItem42_click));

			menuItem43.setText("-");

			menuItem41.setMenuItems(new MenuItem[] {
									menuItem46, 
									menuItem42, 
									menuItem43, 
									menuItem45});
			menuItem41.setText("Database");

			menuItemUndo.setEnabled(false);
			menuItemUndo.setShortcut(Shortcut.CTRL_Z);
			menuItemUndo.setText("Undo");
			menuItemUndo.addOnClick(new EventHandler(this.menuItemUndo_click));

			menuItemRedo.setEnabled(false);
			menuItemRedo.setShortcut(Shortcut.CTRL_Y);
			menuItemRedo.setText("Redo ");
			menuItemRedo.addOnClick(new EventHandler(this.menuItemRedo_click));

			menuItem48.setText("-");

			menuItem47.setText("Align Top to band");
			menuItem47.addOnClick(new EventHandler(this.menuItem47_click));

			menuItem26.setMenuItems(new MenuItem[] {
									menuItem28, 
									menuItem29, 
									menuItem30, 
									menuItem31, 
									menuItem39, 
									menuItem40, 
									menuItem47});
			menuItem26.setText("Align...");

			menuItem49.setText("About iReport");
			menuItem49.addOnClick(new EventHandler(this.menuItem49_click));

			menuItem44.setMenuItems(new MenuItem[] {
									menuItem49});
			menuItem44.setText("&?");

			menuItem50.setText("IReportCompiler...");
			menuItem50.addOnClick(new EventHandler(this.menuItem50_click));

			menuItem51.setText("Bring to front");
			menuItem51.addOnClick(new EventHandler(this.menuItem51_click));

			menuItem53.setText("Send to back");
			menuItem53.addOnClick(new EventHandler(this.menuItem53_click));

			buttonSR.setEnabled(false);
			buttonSR.setLocation(new Point(400, 0));
			buttonSR.setSize(new Point(32, 32));
			buttonSR.setTabIndex(6);
			buttonSR.setText("");
			buttonSR.setImg1((Bitmap)resources.getObject("buttonSR_img1"));
			buttonSR.setImg2((Bitmap)resources.getObject("buttonSR_img2"));
			buttonSR.setImg3((Bitmap)resources.getObject("buttonSR_img3"));
			buttonSR.setToggle(true);
			buttonSR.addOnClick(new EventHandler(this.GTImageButtonSR_buttonClick));

			menuItem52.setText("Subreport");
			menuItem52.addOnClick(new EventHandler(this.menuItem52_click));

			menuItem22.setMenuItems(new MenuItem[] {
									menuItem9, 
									menuItem11, 
									menuItem13, 
									menuItem14, 
									menuItem19, 
									menuItem21, 
									menuItem52});
			menuItem22.setText("Add");

			toolTip1.setActivate(true);
			toolTip1.setToolTip(GTImageButton1, "Open a report");
			toolTip1.setToolTip(buttonCut, "Cut");
			toolTip1.setToolTip(buttonPaste, "Paste");
			toolTip1.setToolTip(buttonLine, "Line tool");
			toolTip1.setToolTip(buttonImage, "Image tool");
			toolTip1.setToolTip(buttonField, "TextField tool");
			toolTip1.setToolTip(buttonNew, "New report");
			toolTip1.setToolTip(GTImageButton2, "Save the report");
			toolTip1.setToolTip(buttonCopy, "Copy");
			toolTip1.setToolTip(buttonPointer, "Activate poiter mode");
			toolTip1.setToolTip(buttonRectangle, "Rectangle tool");
			toolTip1.setToolTip(buttonText, "Static text tool");
			toolTip1.setToolTip(buttonVariables, "open variables window");
			toolTip1.setToolTip(buttonLens, "Lens tool");
			toolTip1.setToolTip(buttonGroups, "Open groups window");
			toolTip1.setToolTip(buttonSR, "Subreport tool");
			toolTip1.setToolTip(compilerButton, "Open compiler window");
			toolTip1.setToolTip(buttonBands, "Open bands window");
			toolTip1.setToolTip(buttonAlignLeft, "Align text to left");
			toolTip1.setToolTip(buttonAlignRight, "Align text to right");
			toolTip1.setToolTip(buttonAlignCenter, "Center text");
			toolTip1.setToolTip(buttonAlignJustify, "Align text justified");
			toolTip1.setToolTip(buttonDatabase, "Open database window");
			toolTip1.setToolTip(buttonCircle, "Ellipse Tool");
			toolTip1.setToolTip(buttonRoundRect, "Round rectangle Tool");
			/* @designTimeOnly toolTip1.setLocation(new Point(140, 96)); */

			menuItem55.setText("Options...");
			menuItem55.addOnClick(new EventHandler(this.menuItem55_click));

			menuItem54.setMenuItems(new MenuItem[] {
									menuItem50, 
									menuItem55});
			menuItem54.setText("Tools");

			compilerButton.setEnabled(true);
			compilerButton.setLocation(new Point(648, 0));
			compilerButton.setSize(new Point(32, 32));
			compilerButton.setTabIndex(5);
			compilerButton.setText("buttonCompiler");
			compilerButton.setImg1((Bitmap)resources.getObject("compilerButton_img1"));
			compilerButton.setImg2((Bitmap)resources.getObject("compilerButton_img2"));
			compilerButton.setImg3((Bitmap)resources.getObject("compilerButton_img3"));
			compilerButton.setToggle(false);
			compilerButton.addOnButtonClick(new EventHandler(this.compilerButton_buttonClick));

			menuItem56.setText("IReportCompiler...");
			menuItem56.addOnClick(new EventHandler(this.menuItem50_click));

			menuItem57.setText("Join sides left");

			menuItem58.setText("Join sides right");

			menuItem33.setMenuItems(new MenuItem[] {
									menuItem34, 
									menuItem35, 
									menuItem36, 
									menuItem57, 
									menuItem58});
			menuItem33.setText("Position...");

			menuItem59.setText("-");

			menuItem62.setText("-");

			menuItem63.setText("Make equal");
			menuItem63.addOnClick(new EventHandler(this.menuItem63_click));

			menuItem64.setText("Decrease");
			menuItem64.addOnClick(new EventHandler(this.menuItem64_click));

			menuItem65.setText("Increase");
			menuItem65.addOnClick(new EventHandler(this.menuItem65_click));

			menuItem66.setText("Remove");
			menuItem66.addOnClick(new EventHandler(this.menuItem66_click));

			menuItem61.setMenuItems(new MenuItem[] {
									menuItem63, 
									menuItem65, 
									menuItem64, 
									menuItem66});
			menuItem61.setText("Horizontal Spacing");

			menuItem67.setText("Make equal");
			menuItem67.addOnClick(new EventHandler(this.menuItem67_click));

			menuItem68.setText("Increase");
			menuItem68.addOnClick(new EventHandler(this.menuItem68_click));

			menuItem69.setText("Decrease");
			menuItem69.addOnClick(new EventHandler(this.menuItem69_click));

			menuItem70.setText("Remove");
			menuItem70.addOnClick(new EventHandler(this.menuItem70_click));

			menuItem60.setMenuItems(new MenuItem[] {
									menuItem67, 
									menuItem68, 
									menuItem69, 
									menuItem70});
			menuItem60.setText("Vertical spacing");

			menuItem25.setMenuItems(new MenuItem[] {
									menuItem26, 
									menuItem27, 
									menuItem33, 
									menuItem59, 
									menuItem61, 
									menuItem60, 
									menuItem62, 
									menuItem51, 
									menuItem53});
			menuItem25.setText("Format");

			menuItem72.setText("Cascade");
			menuItem72.addOnClick(new EventHandler(this.menuItem72_click));

			menuItem73.setText("Tile horizontal");
			menuItem73.addOnClick(new EventHandler(this.menuItem73_click));

			menuItem74.setText("Tile vertical");
			menuItem74.addOnClick(new EventHandler(this.menuItem74_click));

			menuItem75.setText("Arrange Icons");
			menuItem75.addOnClick(new EventHandler(this.menuItem75_click));

			menuItem71.setMenuItems(new MenuItem[] {
									menuItem72, 
									menuItem73, 
									menuItem74, 
									menuItem75});
			menuItem71.setMDIList(true);
			menuItem71.setText("Window");

			menuItem76.setShortcut(Shortcut.CTRL_W);
			menuItem76.setText("Report Wizard");
			menuItem76.addOnClick(new EventHandler(this.menuItem76_click));

			menuItem1.setMenuItems(new MenuItem[] {
								   menuItem2, 
								   menuItem76, 
								   menuItem4, 
								   menuItem3, 
								   menuItem20, 
								   menuItem15, 
								   menuItem5});
			menuItem1.setText("File");

			menuItem77.setText("-");

			menuItem78.setText("Edit XML source...");
			menuItem78.addOnClick(new EventHandler(this.menuItem78_click));

			menuItem79.setText("Fonts");
			menuItem79.addOnClick(new EventHandler(this.menuItem79_click));

			menuItemLock.setText("Disable elements mouse move");
			menuItemLock.addOnClick(new EventHandler(this.menuItem80_click));

			menuItem80.setText("-");

			menuItem8.setMenuItems(new MenuItem[] {
								   menuItemUndo, 
								   menuItemRedo, 
								   menuItem12, 
								   menuItemCut, 
								   menuItemCopy, 
								   menuItemPaste, 
								   menuItem48, 
								   menuItemLock, 
								   menuItem80, 
								   menuItem22, 
								   menuItem56, 
								   menuItem77, 
								   menuItem78});
			menuItem8.setText("Edit");

			richEdit1.setFont(Font.DEFAULT_GUI);
			richEdit1.setForeColor(Color.WINDOWTEXT);
			richEdit1.setLocation(new Point(24, 176));
			richEdit1.setSize(new Point(36, 32));
			richEdit1.setTabIndex(7);
			richEdit1.setText("richEdit1");
			richEdit1.setVisible(false);

			menuItem81.setShortcut(Shortcut.F1);
			menuItem81.setText("Bands");
			menuItem81.addOnClick(new EventHandler(this.menuItem81_click));

			menuItem6.setMenuItems(new MenuItem[] {
								   menuItem7, 
								   menuItem18, 
								   menuItem10, 
								   menuItem16, 
								   menuItem17, 
								   menuItem23, 
								   menuItem24, 
								   menuItem79, 
								   menuItem81});
			menuItem6.setText("View");

			mainMenu1.setMenuItems(new MenuItem[] {
								   menuItem1, 
								   menuItem8, 
								   menuItem6, 
								   menuItem25, 
								   menuItem41, 
								   menuItem54, 
								   menuItem71, 
								   menuItem44});
			/* @designTimeOnly mainMenu1.setLocation(new Point(292, 140)); */

			this.setAllowDrop(true);
			this.setText("iReport (c) 2002 by Giulio Toffoli");
			this.setAutoScaleBaseSize(new Point(5, 13));
			this.setClientSize(new Point(727, 490));
			this.setIcon((Icon)resources.getObject("this_icon"));
			this.setIsMDIContainer(true);
			this.setMenu(mainMenu1);
			this.setStartPosition(FormStartPosition.CENTER_SCREEN);
			this.setWindowState(FormWindowState.MAXIMIZED);
			this.addOnKeyDown(new KeyEventHandler(this.MainForm_keyDown));
			this.addOnDragOver(new DragEventHandler(this.MainForm_dragOver));
			this.addOnDragDrop(new DragEventHandler(this.MainForm_dragDrop));
			this.addOnResize(new EventHandler(this.MainForm_resize));
			this.addOnActivate(new EventHandler(this.MainForm_activate));
			this.addOnDeactivate(new EventHandler(this.MainForm_deactivate));
			this.addOnMDIChildActivate(new EventHandler(this.MainForm_MDIChildActivate));

			imageList1.setImageSize(new Point(32, 32));
			imageList1.setColorDepth(ColorDepth.COLORDEPTH_MILLIONS_OF_COLORS);
			imageList1.setImageStream((ImageListStreamer)resources.getObject("imageList1_imageStream"));
			/* @designTimeOnly imageList1.setLocation(new Point(164, 224)); */

			panel1.setBackColor(Color.CONTROL);
			panel1.setDock(ControlDock.TOP);
			panel1.setSize(new Point(727, 32));
			panel1.setTabIndex(9);
			panel1.setText("panel1");

			buttonBands.setEnabled(false);
			buttonBands.setLocation(new Point(496, 0));
			buttonBands.setSize(new Point(32, 32));
			buttonBands.setTabIndex(0);
			buttonBands.setText("");
			buttonBands.setImg1((Bitmap)resources.getObject("buttonBands_img1"));
			buttonBands.setImg2((Bitmap)resources.getObject("buttonBands_img2"));
			buttonBands.setImg3((Bitmap)resources.getObject("buttonBands_img3"));
			buttonBands.setToggle(false);
			buttonBands.addOnButtonClick(new EventHandler(this.menuItem81_click));

			buttonAlignLeft.setEnabled(false);
			buttonAlignLeft.setLocation(new Point(384, 0));
			buttonAlignLeft.setSize(new Point(32, 32));
			buttonAlignLeft.setTabIndex(4);
			buttonAlignLeft.setText("");
			buttonAlignLeft.setImg1((Bitmap)resources.getObject("buttonAlignLeft_img1"));
			buttonAlignLeft.setImg2((Bitmap)resources.getObject("buttonAlignLeft_img2"));
			buttonAlignLeft.setImg3((Bitmap)resources.getObject("buttonAlignLeft_img3"));
			buttonAlignLeft.setToggle(false);
			buttonAlignLeft.addOnButtonClick(new EventHandler(this.buttonAlignLeft_buttonClick));

			buttonAlignRight.setEnabled(false);
			buttonAlignRight.setLocation(new Point(424, 0));
			buttonAlignRight.setSize(new Point(32, 32));
			buttonAlignRight.setTabIndex(3);
			buttonAlignRight.setText("");
			buttonAlignRight.setImg1((Bitmap)resources.getObject("buttonAlignRight_img1"));
			buttonAlignRight.setImg2((Bitmap)resources.getObject("buttonAlignRight_img2"));
			buttonAlignRight.setImg3((Bitmap)resources.getObject("buttonAlignRight_img3"));
			buttonAlignRight.setToggle(false);
			buttonAlignRight.addOnButtonClick(new EventHandler(this.buttonAlignRight_buttonClick));

			buttonAlignCenter.setEnabled(false);
			buttonAlignCenter.setLocation(new Point(320, 0));
			buttonAlignCenter.setSize(new Point(32, 32));
			buttonAlignCenter.setTabIndex(2);
			buttonAlignCenter.setText("");
			buttonAlignCenter.setImg1((Bitmap)resources.getObject("buttonAlignCenter_img1"));
			buttonAlignCenter.setImg2((Bitmap)resources.getObject("buttonAlignCenter_img2"));
			buttonAlignCenter.setImg3((Bitmap)resources.getObject("buttonAlignCenter_img3"));
			buttonAlignCenter.setToggle(false);
			buttonAlignCenter.addOnButtonClick(new EventHandler(this.buttonAlignCenter_buttonClick));

			buttonAlignJustify.setEnabled(false);
			buttonAlignJustify.setLocation(new Point(164, 0));
			buttonAlignJustify.setSize(new Point(32, 32));
			buttonAlignJustify.setTabIndex(1);
			buttonAlignJustify.setText("");
			buttonAlignJustify.setImg1((Bitmap)resources.getObject("buttonAlignJustify_img1"));
			buttonAlignJustify.setImg2((Bitmap)resources.getObject("buttonAlignJustify_img2"));
			buttonAlignJustify.setImg3((Bitmap)resources.getObject("buttonAlignJustify_img3"));
			buttonAlignJustify.setToggle(false);
			buttonAlignJustify.addOnButtonClick(new EventHandler(this.buttonAlignJustify_buttonClick));

			buttonDatabase.setEnabled(false);
			buttonDatabase.setLocation(new Point(456, 0));
			buttonDatabase.setSize(new Point(32, 32));
			buttonDatabase.setTabIndex(2);
			buttonDatabase.setText("");
			buttonDatabase.setImg1((Bitmap)resources.getObject("buttonDatabase_img1"));
			buttonDatabase.setImg2((Bitmap)resources.getObject("buttonDatabase_img2"));
			buttonDatabase.setImg3((Bitmap)resources.getObject("buttonDatabase_img3"));
			buttonDatabase.setToggle(false);
			buttonDatabase.addOnClick(new EventHandler(this.buttonDatabase_click));
			buttonDatabase.addOnButtonClick(new EventHandler(this.menuItem45_click));

			buttonCircle.setEnabled(false);
			buttonCircle.setLocation(new Point(444, 0));
			buttonCircle.setSize(new Point(32, 32));
			buttonCircle.setTabIndex(1);
			buttonCircle.setText("");
			buttonCircle.setImg1((Bitmap)resources.getObject("buttonCircle_img1"));
			buttonCircle.setImg2((Bitmap)resources.getObject("buttonCircle_img2"));
			buttonCircle.setImg3((Bitmap)resources.getObject("buttonCircle_img3"));
			buttonCircle.setToggle(true);
			buttonCircle.addOnStateChanged(new EventHandler(this.buttonCircle_stateChanged));

			buttonRoundRect.setEnabled(false);
			buttonRoundRect.setLocation(new Point(520, 0));
			buttonRoundRect.setSize(new Point(32, 32));
			buttonRoundRect.setTabIndex(0);
			buttonRoundRect.setText("");
			buttonRoundRect.setImg1((Bitmap)resources.getObject("buttonRoundRect_img1"));
			buttonRoundRect.setImg2((Bitmap)resources.getObject("buttonRoundRect_img2"));
			buttonRoundRect.setImg3((Bitmap)resources.getObject("buttonRoundRect_img3"));
			buttonRoundRect.setToggle(true);
			buttonRoundRect.addOnButtonClick(new EventHandler(this.menuItem45_click));
			buttonRoundRect.addOnStateChanged(new EventHandler(this.buttonRoundRect_stateChanged));

			this.setNewControls(new Control[] {
								buttonRoundRect, 
								buttonCircle, 
								buttonDatabase, 
								panelLens, 
								panel1, 
								richEdit1});
			panelLens.setNewControls(new Control[] {
									 numberComboBox1});
			panel1.setNewControls(new Control[] {
								  buttonAlignJustify, 
								  buttonAlignCenter, 
								  buttonAlignRight, 
								  buttonAlignLeft, 
								  buttonBands, 
								  compilerButton, 
								  buttonLens, 
								  buttonGroups, 
								  buttonVariables, 
								  buttonSR, 
								  buttonField, 
								  buttonText, 
								  buttonImage, 
								  buttonRectangle, 
								  buttonLine, 
								  buttonPointer, 
								  buttonPaste, 
								  buttonCopy, 
								  buttonCut, 
								  GTImageButton2, 
								  GTImageButton1, 
								  buttonNew});
		}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		//MessageBox.show("I'st incredible, but this message box solve a very strange bug\n"
		//				+"on creating an MDI application in VisualJ++.\n\nWelcome to iReport.","Welcome to iReport",MessageBox.ICONINFORMATION);
		Application.run(new MainForm(args));
	}

	/**
	 * @dll.import("KERNEL32", auto) 
	 */
	public static native int GetModuleFileName(int hModule, StringBuffer lpFilename, int nSize);
	

	/**
	 * @dll.import("KERNEL32", auto) 
	 */
	public static native int GetModuleHandle(String lpModuleName);
}
