/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import com.businesslogic.ireport.ui.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;

public class EllipseReportElement extends GraphicReportElement 
{
	public EllipseReportElement(int x, int y, int width, int height, Brush hached)
	{
		super(x,y,width,height,hached);
		graphicElementPen  = "Thin";
		this.bgcolor = Color.WHITE;
		this.fgcolor = Color.BLACK;
	}
	
	public void drawObject(Graphics g,double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		this.zoom_factor = zoom_factor;
		position.x -= 10;
		position.y -= 10;
		x_shift_origin -= 10;
		y_shift_origin -= 10;
		
		if (!mode.equalsIgnoreCase("Transparent"))
			g.fill(Region.createElliptical(getZoomedDim(position.x) - x_shift_origin,getZoomedDim(position.y) - y_shift_origin,
					getZoomedDim(width),
					getZoomedDim(height)),new Brush(bgcolor, BrushStyle.SOLID) );
			
		position.x += 10;
		position.y += 10;
		x_shift_origin += 10;
		y_shift_origin += 10;
		
		drawGraphicsElement(g,graphicElementPen,zoom_factor, x_shift_origin, y_shift_origin);
	}
	
	public ReportElement cloneMe()
	{
		RectangleReportElement newReportElement = new RectangleReportElement(position.x, position.y, width, height, hached);
		newReportElement.name = new String(name);
		newReportElement.bgcolor = bgcolor;
		newReportElement.fgcolor = fgcolor;
		newReportElement.mode = new String(newReportElement.mode);
		newReportElement.graphicElementPen = graphicElementPen;
		return newReportElement;
	}
	
	
	public void  drawGraphicsElement(Graphics g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		
		this.zoom_factor = zoom_factor;
		int penp = 0;
		if (pen==null || pen.equalsIgnoreCase("None")) return;
		
		position.x -= 10;
		position.y -= 10;
		x_shift_origin -= 10;
		y_shift_origin -= 10;
		
		if (pen.equalsIgnoreCase("Thin"))   penp=(int)(Math.max(1,1.0*zoom_factor));
		else if (pen.equalsIgnoreCase("1Point")) penp=(int)(Math.max(1,1.0*zoom_factor));
		else if (pen.equalsIgnoreCase("2Point")) penp=(int)(Math.max(1,2.0*zoom_factor));
		else if (pen.equalsIgnoreCase("4Point")) penp=(int)(Math.max(1,4.0*zoom_factor));
		else if (pen.equalsIgnoreCase("Dotted"))
		{
			penp=(int)(Math.max(1,1.0*zoom_factor));
			// 6_2_6_2...
			Pen oldp  = g.getPen();
			g.setPen(new Pen( fgcolor,PenStyle.INSIDEFRAME, penp ));
			
			
			int i=0;
			for ( i= getZoomedDim(position.x) ; i< getZoomedDim(position.x+width)-1; i+=getZoomedDim(8))
			{
				g.drawLine( i-x_shift_origin, getZoomedDim(position.y)-y_shift_origin,
							Math.min(i+getZoomedDim(6),getZoomedDim(position.x+width)-1)-x_shift_origin,getZoomedDim(position.y)-y_shift_origin);
				g.drawLine( i-x_shift_origin, getZoomedDim(position.y+height)-1-y_shift_origin,
							Math.min(i+getZoomedDim(6),getZoomedDim(position.x+width)-1)-x_shift_origin,getZoomedDim(position.y+height)-1-y_shift_origin);
			}
			
			for (i=getZoomedDim(position.y); i< getZoomedDim(position.y+height)-1; i+=getZoomedDim(8))
			{
				g.drawLine( getZoomedDim(position.x)-x_shift_origin ,i-y_shift_origin,
							getZoomedDim(position.x)-x_shift_origin,Math.min(i+getZoomedDim(6),getZoomedDim(position.y+height)-1)-y_shift_origin );
				g.drawLine( getZoomedDim(position.x+width)-1-x_shift_origin, i-x_shift_origin,
							getZoomedDim(position.x+width)-1-x_shift_origin,Math.min(i+getZoomedDim(6),getZoomedDim(position.y+height)-1)-y_shift_origin);
			}
			g.setPen(oldp);
			position.x += 10;
			position.y += 10;
			return;
		}
		
		Pen oldp  = g.getPen();
		g.setPen(new Pen(fgcolor,PenStyle.INSIDEFRAME, penp ));
		/*
		g.drawLines(new Point[]{new Point( getZoomedDim(position.x)-x_shift_origin,
										   getZoomedDim(position.y)-y_shift_origin),
							new Point(getZoomedDim(position.x+width)-1-x_shift_origin,
									  getZoomedDim(position.y)-y_shift_origin ),
							new Point(getZoomedDim(position.x+width)-1-x_shift_origin,
									  getZoomedDim(position.y+height)-1-x_shift_origin),
							new Point(getZoomedDim(position.x)-x_shift_origin,
									  getZoomedDim(position.y+height)-1-x_shift_origin),
							new Point(getZoomedDim(position.x)-x_shift_origin,
									  getZoomedDim(position.y)-y_shift_origin )});
		*/
		Region r = new Region();
		r = r.createElliptical(getZoomedDim(position.x)-x_shift_origin, 
								getZoomedDim(position.y)-y_shift_origin,
								getZoomedDim(width),
								getZoomedDim(height));
		
		Region r2 = new Region();
		r2 = r.createElliptical(getZoomedDim(position.x)+penp-x_shift_origin,
								 getZoomedDim(position.y)+penp-y_shift_origin,
								 getZoomedDim(width)-2*penp,
								 getZoomedDim(height)-2*penp);
		r = r.xorWith(r2);
		g.fill(r, new Brush(fgcolor,BrushStyle.SOLID )); 
		g.setPen(oldp);

		position.x += 10;
		position.y += 10;
	}
}
