/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.hsqldb.Trace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Trace
extends PrintWriter {
    public static final boolean TRACE = false;
    public static final boolean STOP = false;
    public static final boolean ASSERT = false;
    private static Trace tTracer = new Trace();
    private static int iLine;
    private static String sTrace;
    private static int iStop;
    static final int DATABASE_ALREADY_IN_USE = 0;
    static final int CONNECTION_IS_CLOSED = 1;
    static final int CONNECTION_IS_BROKEN = 2;
    static final int DATABASE_IS_SHUTDOWN = 3;
    static final int COLUMN_COUNT_DOES_NOT_MATCH = 4;
    static final int DIVISION_BY_ZERO = 5;
    static final int INVALID_ESCAPE = 6;
    static final int INTEGRITY_CONSTRAINT_VIOLATION = 7;
    static final int VIOLATION_OF_UNIQUE_INDEX = 8;
    static final int TRY_TO_INSERT_NULL = 9;
    static final int UNEXPECTED_TOKEN = 10;
    static final int UNEXPECTED_END_OF_COMMAND = 11;
    static final int UNKNOWN_FUNCTION = 12;
    static final int NEED_AGGREGATE = 13;
    static final int SUM_OF_NON_NUMERIC = 14;
    static final int WRONG_DATA_TYPE = 15;
    static final int SINGLE_VALUE_EXPECTED = 16;
    static final int SERIALIZATION_FAILURE = 17;
    static final int TRANSFER_CORRUPTED = 18;
    static final int FUNCTION_NOT_SUPPORTED = 19;
    static final int TABLE_ALREADY_EXISTS = 20;
    static final int TABLE_NOT_FOUND = 21;
    static final int INDEX_ALREADY_EXISTS = 22;
    static final int SECOND_PRIMARY_KEY = 23;
    static final int DROP_PRIMARY_KEY = 24;
    static final int INDEX_NOT_FOUND = 25;
    static final int COLUMN_ALREADY_EXISTS = 26;
    static final int COLUMN_NOT_FOUND = 27;
    static final int FILE_IO_ERROR = 28;
    static final int WRONG_DATABASE_FILE_VERSION = 29;
    static final int DATABASE_IS_READONLY = 30;
    static final int ACCESS_IS_DENIED = 31;
    static final int INPUTSTREAM_ERROR = 32;
    static final int NO_DATA_IS_AVAILABLE = 33;
    static final int USER_ALREADY_EXISTS = 34;
    static final int USER_NOT_FOUND = 35;
    static final int ASSERT_FAILED = 36;
    static final int EXTERNAL_STOP = 37;
    static final int GENERAL_ERROR = 38;
    static final int WRONG_OUT_PARAMETER = 39;
    static final int ERROR_IN_FUNCTION = 40;
    static final int TRIGGER_NOT_FOUND = 21;
    private static String[] sDescription;

    static SQLException getError(int n, String string) {
        String string2 = Trace.getMessage(n);
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        return Trace.getError(string2);
    }

    static String getMessage(int n) {
        return sDescription[n];
    }

    static String getMessage(SQLException sQLException) {
        return sQLException.getSQLState() + " " + sQLException.getMessage();
    }

    static SQLException getError(String string) {
        return new SQLException(string.substring(6), string.substring(0, 5));
    }

    static SQLException error(int n) {
        return Trace.getError(n, null);
    }

    static SQLException error(int n, String string) {
        return Trace.getError(n, string);
    }

    static SQLException error(int n, int n2) {
        return Trace.getError(n, "" + n2);
    }

    static void assert(boolean bl) throws SQLException {
        Trace.assert(bl, null);
    }

    static void assert(boolean bl, String string) throws SQLException {
        if (!bl) {
            Trace.printStack();
            throw Trace.getError(36, string);
        }
    }

    static void check(boolean bl, int n) throws SQLException {
        Trace.check(bl, n, null);
    }

    static void check(boolean bl, int n, String string) throws SQLException {
        if (!bl) {
            throw Trace.getError(n, string);
        }
    }

    public void println(char[] cArray) {
        if (iLine++ == 2) {
            String string = new String(cArray);
            int n = string.indexOf(46);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if ((n = string.indexOf(40)) != -1) {
                string = string.substring(0, n);
            }
            sTrace = string;
        }
    }

    Trace() {
        super(System.out);
    }

    static void trace(long l) {
        Trace.traceCaller("" + l);
    }

    static void trace(int n) {
        Trace.traceCaller("" + n);
    }

    static void trace() {
        Trace.traceCaller("");
    }

    static void trace(String string) {
        Trace.traceCaller(string);
    }

    static void stop() throws SQLException {
        Trace.stop(null);
    }

    static void stop(String string) throws SQLException {
        if (iStop++ % 10000 != 0) {
            return;
        }
        if (new File("trace.stop").exists()) {
            Trace.printStack();
            throw Trace.getError(37, string);
        }
    }

    private static void printStack() {
        class TraceException
        extends Exception {
            TraceException() {
                super("Trace");
            }
        }
        TraceException traceException = new TraceException();
        traceException.printStackTrace();
    }

    private static void traceCaller(String string) {
        class TraceCallerException
        extends Exception {
            TraceCallerException() {
                super("TraceCaller");
            }
        }
        TraceCallerException traceCallerException = new TraceCallerException();
        iLine = 0;
        traceCallerException.printStackTrace(tTracer);
        string = sTrace + "\t" + string;
        System.out.println(string);
    }

    static {
        iStop = 0;
        sDescription = new String[]{"08001 The database is already in use by another process", "08003 Connection is closed", "08003 Connection is broken", "08003 The database is shutdown", "21S01 Column count does not match", "22012 Division by zero", "22019 Invalid escape character", "23000 Integrity constraint violation", "23000 Violation of unique index", "23000 Try to insert null into a non-nullable column", "37000 Unexpected token", "37000 Unexpected end of command", "37000 Unknown function", "37000 Need aggregate function or group by", "37000 Sum on non-numeric data not allowed", "37000 Wrong data type", "37000 Single value expected", "40001 Serialization failure", "40001 Transfer corrupted", "IM001 This function is not supported", "S0001 Table already exists", "S0002 Table not found", "S0011 Index already exists", "S0011 Attempt to define a second primary key", "S0011 Attempt to drop the primary key", "S0012 Index not found", "S0021 Column already exists", "S0022 Column not found", "S1000 File input/output error", "S1000 Wrong database file version", "S1000 The database is in read only mode", "S1000 Access is denied", "S1000 InputStream error", "S1000 No data is available", "S1000 User already exists", "S1000 User not found", "S1000 Assert failed", "S1000 External stop request", "S1000 General error", "S1009 Wrong OUT parameter", "S1010 Error in function", "S0002 Trigger not found"};
    }
}

