/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.xmlrules;

import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSetBase;
import org.apache.commons.digester.xmlrules.DigesterRuleParser;
import org.apache.commons.digester.xmlrules.XmlLoadException;

public class FromXmlRuleSet
extends RuleSetBase {
    public static final String DIGESTER_DTD_PATH = "org/apache/commons/digester/xmlrules/digester-rules.dtd";
    private URL xmlRules;
    private DigesterRuleParser parser;

    public FromXmlRuleSet(URL rulesXml) {
        this(rulesXml, new DigesterRuleParser());
    }

    public FromXmlRuleSet(URL rulesXml, DigesterRuleParser parser) {
        this.xmlRules = rulesXml;
        this.parser = parser;
    }

    public void addRuleInstances(Digester digester) throws XmlLoadException {
        URL dtdURL = this.getClass().getClassLoader().getResource(DIGESTER_DTD_PATH);
        if (dtdURL == null) {
            throw new XmlLoadException("Cannot find resource \"org/apache/commons/digester/xmlrules/digester-rules.dtd\"");
        }
        this.parser.setDigesterRulesDTD(dtdURL.toString());
        this.parser.setTarget(digester);
        Digester rulesDigester = new Digester();
        rulesDigester.addRuleSet(this.parser);
        rulesDigester.push(this.parser);
        try {
            rulesDigester.parse(this.xmlRules.openStream());
        }
        catch (Exception ex) {
            throw new XmlLoadException(ex);
        }
    }

    static {
        DIGESTER_DTD_PATH = DIGESTER_DTD_PATH;
    }
}

