/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperExportManager;
import dori.jasper.engine.JasperFillManager;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.JasperPrintManager;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.util.JRLoader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Map;

public class JasperRunManager {
    public static String runReportToPdfFile(String sourceFileName, Map parameters, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, conn);
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, conn);
        JasperPrintManager.printReportToPdfStream(jasperPrint, outputStream);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, conn);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, conn);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static String runReportToPdfFile(String sourceFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, jrDataSource);
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, jrDataSource);
        JasperPrintManager.printReportToPdfStream(jasperPrint, outputStream);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, jrDataSource);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, jrDataSource);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static String runReportToHtmlFile(String sourceFileName, Map parameters, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, conn);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
    }

    public static String runReportToHtmlFile(String sourceFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, jrDataSource);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
    }
}

