package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "OptionsForm"
 * non viene creato nel metodo main().
 */
public class OptionsForm extends Form
{
	MainForm mf = null;
	public OptionsForm(MainForm mf)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		this.mf = mf;
		
		this.comboBoxUM.setSelectedIndex(0);
		
		// Setting properties...
		if (mf.ireportProperties.getProperty("MAX_MRU")!=null)
			numberEditMRU.setValue(Integer.parseInt(	mf.ireportProperties.getProperty("MAX_MRU") ) );
		else
			numberEditMRU.setValue(4 );
		if (mf.ireportProperties.getProperty("RULES")!=null)
			checkBoxRules.setChecked(	((String)mf.ireportProperties.getProperty("RULES")).equals("true") );
		if (mf.ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null)
			checkBoxSyntax.setChecked(	((String)mf.ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")).equals("true") );
		if (mf.ireportProperties.getProperty("DEFAULT_UNITS")!=null)
			comboBoxUM.setSelectedItem( (String)mf.ireportProperties.getProperty("DEFAULT_UNITS") );
		if (mf.ireportProperties.getProperty("TEMPLATE_FILE")!=null)
			editTemplate.setText((String)mf.ireportProperties.getProperty("TEMPLATE_FILE") );
		if (mf.ireportProperties.getProperty("COMPILER_GENPDF")!=null)
			checkBoxPDF.setChecked(	((String)mf.ireportProperties.getProperty("COMPILER_GENPDF")).equals("true") );
		
		if (mf.ireportProperties.getProperty("DISABLE_UTF_SUPPORT")!=null)
			checkBoxUTF8Support.setChecked(	!((String)mf.ireportProperties.getProperty("DISABLE_UTF_SUPPORT")).equals("true") );
		
		if (mf.ireportProperties.getProperty("COMPILER_OUT_DIR")!=null)
			editCOutdir.setText((String)mf.ireportProperties.getProperty("COMPILER_OUT_DIR") );
		if (mf.ireportProperties.getProperty("BACKUP_DIR")!=null)
			editBakdir.setText((String)mf.ireportProperties.getProperty("BACKUP_DIR") );
		if (mf.ireportProperties.getProperty("BACKUP_MODE")!=null)
		{
			if (((String)mf.ireportProperties.getProperty("BACKUP_MODE")).equals("0"))
				radioButtonNB.setChecked(true);
			if (((String)mf.ireportProperties.getProperty("BACKUP_MODE")).equals("1"))
				radioButtonRB.setChecked(true);
			if (((String)mf.ireportProperties.getProperty("BACKUP_MODE")).equals("2"))
				radioButtonAB.setChecked(true);
		}
		else
			radioButtonAB.setChecked(true);
		if (mf.ireportProperties.getProperty("EDITOR")!=null)
			editEditor.setText((String)mf.ireportProperties.getProperty("EDITOR") );
		else
			editEditor.setText("notepad.exe");
		if ( (String)mf.ireportProperties.getProperty("COMPILER_SAVE")!=null )
		{
				if (((String)mf.ireportProperties.getProperty("COMPILER_SAVE")).equalsIgnoreCase("false"))
				checkBoxASBeforeCompiling.setChecked(false);
		}
		if ( (String)mf.ireportProperties.getProperty("BORDER_COLOR")!=null )
		{
				int rgb = Integer.parseInt((String)mf.ireportProperties.getProperty("BORDER_COLOR"));
				if (rgb==-1)
				{
					panelColor.setBackColor(Color.LIGHTGRAY);
					this.checkBox1.setChecked(false);
				}
				else
				{
					this.checkBox1.setChecked(true);
					panelColor.setBackColor(new Color(rgb));
				}
		}
		else
		{
			this.checkBox1.setChecked(true);
			panelColor.setBackColor(Color.LIGHTGRAY);
		}
	}

	/**
	 * OptionsForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void button6_click(Object source, Event e)
	{
		OpenFileDialog ofd = new OpenFileDialog();
		ofd.setCheckFileExists(true);
		ofd.setFilter("Jasper XML Report *.xml|*.xml");
		ofd.setDefaultExt("xml");
		int result = ofd.showDialog();
		if (result == DialogResult.OK)
		{
			editTemplate.setText(ofd.getFileName());
		}
	}

	private void button5_click(Object source, Event e)
	{
			com.businesslogic.ireport.ui.directorydialog.FileExplorer fe = new com.businesslogic.ireport.ui.directorydialog.FileExplorer(this.mf.programDir);
		if (fe.showDialog() == DialogResult.OK)
		{
			this.editCOutdir.setText( fe.getDirectory() );
		}
	}

	private void button4_click(Object source, Event e)
	{
					com.businesslogic.ireport.ui.directorydialog.FileExplorer fe = new com.businesslogic.ireport.ui.directorydialog.FileExplorer(this.mf.programDir);
		if (fe.showDialog() == DialogResult.OK)
		{
			this.editBakdir.setText( fe.getDirectory() );
		}
	}

	private void button1_click(Object source, Event e)
	{
		this.dispose();
	}

	private void button2_click(Object source, Event e)
	{
		mf.ireportProperties.put("MAX_MRU",""+(int)numberEditMRU.getValue());
		mf.ireportProperties.put("RULES",""+checkBoxRules.getChecked());
		mf.ireportProperties.put("DEFAULT_UNITS",""+comboBoxUM.getSelectedItem() );
		mf.ireportProperties.put("TEMPLATE_FILE",""+editTemplate.getText());
		mf.ireportProperties.put("COMPILER_GENPDF",""+checkBoxPDF.getChecked());
		mf.ireportProperties.put("COMPILER_OUT_DIR",""+editCOutdir.getText());
		mf.ireportProperties.put("BACKUP_DIR",""+editBakdir.getText());
		mf.ireportProperties.put("EDITOR",""+editEditor.getText());
		mf.ireportProperties.put("COMPILER_SAVE",""+checkBoxASBeforeCompiling.getChecked());
		mf.ireportProperties.put("SYNTAX_HIGHLIGHTING",""+checkBoxSyntax.getChecked());
		
		
		if (this.checkBox1.getChecked())
		{
			ReportElement.lightcolor = panelColor.getBackColor();
			mf.ireportProperties.put("BORDER_COLOR",""+panelColor.getBackColor().getRGB());
		}
		else
		{
			ReportElement.lightcolor = null;
			mf.ireportProperties.put("BORDER_COLOR","-1");
		}
		
		mf.ireportProperties.put("DISABLE_UTF_SUPPORT",""+!checkBoxUTF8Support.getChecked());
			
			
		int mode = 2;
		if (radioButtonNB.getChecked()) mode = 0;
		else if (radioButtonRB.getChecked()) mode = 1;
		else if (radioButtonAB.getChecked()) mode = 2;
		mf.ireportProperties.put("BACKUP_MODE",""+mode);
		mf.saveProperties();
	}

	private void button3_click(Object source, Event e)
	{
		button2_click(source,e);
		this.dispose();
	}

	private void button7_click(Object source, Event e)
	{
		OpenFileDialog ofd = new OpenFileDialog();
		ofd.setCheckFileExists(true);
		ofd.setFilter("Executable *.exe|*.exe|All files|*.*");
		ofd.setDefaultExt("xml");
		int result = ofd.showDialog();
		if (result == DialogResult.OK)
		{
			editEditor.setText(ofd.getFileName());
		}
	}

	private void groupBox2_enter(Object source, Event e)
	{
		
	}

	private void checkBox1_click(Object source, Event e)
	{
		
	}

	private void panelColor_click(Object source, Event e)
	{
		ColorDialog cd = new ColorDialog();
		if (cd.showDialog() == DialogResult.OK)
		{
			panelColor.setBackColor(cd.getColor());
		}
	}

	private void checkBox1_checkedChanged(Object source, Event e)
	{
		if (checkBox1.getChecked())
		{
			this.panelColor.setEnabled(true);
			this.labelPanelColor.setEnabled(true);
		}
		else
		{
			this.panelColor.setEnabled(false);
			this.labelPanelColor.setEnabled(false);
		}
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	TabControl tabControl1 = new TabControl();
	TabPage tabPage1 = new TabPage();
	TabPage tabPage2 = new TabPage();
	Button button1 = new Button();
	Button button2 = new Button();
	Button button3 = new Button();
	TabPage tabPage3 = new TabPage();
	GroupBox groupBox1 = new GroupBox();
	RadioButton radioButtonNB = new RadioButton();
	RadioButton radioButtonRB = new RadioButton();
	RadioButton radioButtonAB = new RadioButton();
	Label label1 = new Label();
	Edit editBakdir = new Edit();
	Button button4 = new Button();
	ComboBox comboBoxUM = new ComboBox();
	CheckBox checkBoxRules = new CheckBox();
	Label label3 = new Label();
	Edit editCOutdir = new Edit();
	Button button5 = new Button();
	Label label4 = new Label();
	NumberEdit numberEditMRU = new NumberEdit();
	Label label2 = new Label();
	GroupBox groupBox2 = new GroupBox();
	Label label5 = new Label();
	Label label6 = new Label();
	Edit editTemplate = new Edit();
	Button button6 = new Button();
	CheckBox checkBoxPDF = new CheckBox();
	TabPage tabPage4 = new TabPage();
	GroupBox groupBox3 = new GroupBox();
	Button button7 = new Button();
	Edit editEditor = new Edit();
	CheckBox checkBoxASBeforeCompiling = new CheckBox();
	CheckBox checkBoxSyntax = new CheckBox();
	Label label7 = new Label();
	CheckBox checkBox1 = new CheckBox();
	Panel panelColor = new Panel();
	Label labelPanelColor = new Label();
	Label label8 = new Label();
	CheckBox checkBoxUTF8Support = new CheckBox();

	private void initForm()
	{
		this.setText("iReport options");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(343, 254));

		tabControl1.setLocation(new Point(4, 4));
		tabControl1.setSize(new Point(336, 216));
		tabControl1.setTabIndex(0);
		tabControl1.setText("tabControl1");
		tabControl1.setSelectedIndex(0);

		tabPage1.setLocation(new Point(4, 25));
		tabPage1.setSize(new Point(328, 187));
		tabPage1.setTabIndex(0);
		tabPage1.setText("General");

		tabPage2.setLocation(new Point(4, 25));
		tabPage2.setSize(new Point(328, 187));
		tabPage2.setTabIndex(1);
		tabPage2.setText("Compiler");

		button1.setLocation(new Point(268, 224));
		button1.setSize(new Point(72, 24));
		button1.setTabIndex(3);
		button1.setText("&Cancel");
		button1.addOnClick(new EventHandler(this.button1_click));

		button2.setLocation(new Point(192, 224));
		button2.setSize(new Point(72, 24));
		button2.setTabIndex(2);
		button2.setText("&Apply");
		button2.addOnClick(new EventHandler(this.button2_click));

		button3.setLocation(new Point(116, 224));
		button3.setSize(new Point(72, 24));
		button3.setTabIndex(1);
		button3.setText("&OK");
		button3.addOnClick(new EventHandler(this.button3_click));

		tabPage3.setLocation(new Point(4, 25));
		tabPage3.setSize(new Point(328, 187));
		tabPage3.setTabIndex(2);
		tabPage3.setText("Backup");

		groupBox1.setLocation(new Point(8, 8));
		groupBox1.setSize(new Point(312, 84));
		groupBox1.setTabIndex(0);
		groupBox1.setTabStop(false);
		groupBox1.setText("Backup Files on Save");

		radioButtonNB.setLocation(new Point(12, 16));
		radioButtonNB.setSize(new Point(100, 23));
		radioButtonNB.setTabIndex(2);
		radioButtonNB.setText("No backup");

		radioButtonRB.setLocation(new Point(12, 36));
		radioButtonRB.setSize(new Point(156, 23));
		radioButtonRB.setTabIndex(1);
		radioButtonRB.setText("Replace extension with .BAK");

		radioButtonAB.setLocation(new Point(12, 56));
		radioButtonAB.setSize(new Point(228, 23));
		radioButtonAB.setTabIndex(0);
		radioButtonAB.setText("Append .BAK to exsisting extension");

		label1.setLocation(new Point(12, 100));
		label1.setSize(new Point(172, 16));
		label1.setTabIndex(1);
		label1.setTabStop(false);
		label1.setText("Default backup directory");

		editBakdir.setLocation(new Point(12, 116));
		editBakdir.setSize(new Point(256, 20));
		editBakdir.setTabIndex(2);
		editBakdir.setText("");

		button4.setLocation(new Point(272, 112));
		button4.setSize(new Point(52, 24));
		button4.setTabIndex(3);
		button4.setText("Browse");
		button4.addOnClick(new EventHandler(this.button4_click));

		comboBoxUM.setLocation(new Point(196, 44));
		comboBoxUM.setSize(new Point(80, 21));
		comboBoxUM.setTabIndex(6);
		comboBoxUM.setText("");
		comboBoxUM.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxUM.setItems(new Object[] {
							"cm", 
							"inches", 
							"pixels"});

		checkBoxRules.setLocation(new Point(100, 44));
		checkBoxRules.setSize(new Point(24, 23));
		checkBoxRules.setTabIndex(5);
		checkBoxRules.setText("");
		checkBoxRules.setChecked(true);
		checkBoxRules.setCheckState(CheckState.CHECKED);

		label3.setLocation(new Point(8, 8));
		label3.setSize(new Point(172, 16));
		label3.setTabIndex(0);
		label3.setTabStop(false);
		label3.setText("Default compilation directory");

		editCOutdir.setLocation(new Point(8, 24));
		editCOutdir.setSize(new Point(256, 20));
		editCOutdir.setTabIndex(1);
		editCOutdir.setText("");

		button5.setLocation(new Point(268, 20));
		button5.setSize(new Point(52, 24));
		button5.setTabIndex(2);
		button5.setText("Browse");
		button5.addOnClick(new EventHandler(this.button5_click));

		label4.setLocation(new Point(116, 48));
		label4.setSize(new Point(76, 16));
		label4.setTabIndex(2);
		label4.setTabStop(false);
		label4.setText("Default units");
		label4.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditMRU.setLocation(new Point(196, 16));
		numberEditMRU.setSize(new Point(44, 20));
		numberEditMRU.setTabIndex(1);
		numberEditMRU.setText("0");
		numberEditMRU.setTextAlign(HorizontalAlignment.CENTER);
		numberEditMRU.setIsDouble(false);
		numberEditMRU.setDecimals(0);
		numberEditMRU.setValue(0.0d);
		numberEditMRU.setViewPlus(false);
		numberEditMRU.setSeparatoreMigliaia(true);

		label2.setLocation(new Point(16, 20));
		label2.setSize(new Point(172, 20));
		label2.setTabIndex(0);
		label2.setTabStop(false);
		label2.setText("Num. of recent files on file menu");
		label2.setTextAlign(HorizontalAlignment.RIGHT);

		groupBox2.setLocation(new Point(8, 4));
		groupBox2.setSize(new Point(312, 136));
		groupBox2.setTabIndex(0);
		groupBox2.setTabStop(false);
		groupBox2.setText("General");
		groupBox2.addOnEnter(new EventHandler(this.groupBox2_enter));

		label5.setLocation(new Point(40, 48));
		label5.setSize(new Point(48, 24));
		label5.setTabIndex(10);
		label5.setTabStop(false);
		label5.setText("View rules");
		label5.setTextAlign(HorizontalAlignment.RIGHT);

		label6.setLocation(new Point(8, 144));
		label6.setSize(new Point(252, 16));
		label6.setTabIndex(1);
		label6.setTabStop(false);
		label6.setText("Use this file as template for new documents");

		editTemplate.setLocation(new Point(8, 160));
		editTemplate.setSize(new Point(256, 20));
		editTemplate.setTabIndex(2);
		editTemplate.setText("");

		button6.setLocation(new Point(268, 156));
		button6.setSize(new Point(52, 24));
		button6.setTabIndex(3);
		button6.setText("Browse");
		button6.addOnClick(new EventHandler(this.button6_click));

		checkBoxPDF.setLocation(new Point(8, 52));
		checkBoxPDF.setSize(new Point(152, 23));
		checkBoxPDF.setTabIndex(3);
		checkBoxPDF.setText("Generate PDF preview");
		checkBoxPDF.setChecked(true);
		checkBoxPDF.setCheckState(CheckState.CHECKED);

		tabPage4.setLocation(new Point(4, 25));
		tabPage4.setSize(new Point(328, 187));
		tabPage4.setTabIndex(3);
		tabPage4.setText("Editor");

		groupBox3.setLocation(new Point(4, 40));
		groupBox3.setSize(new Point(324, 60));
		groupBox3.setTabIndex(0);
		groupBox3.setTabStop(false);
		groupBox3.setText("External code editor");

		button7.setLocation(new Point(240, 20));
		button7.setSize(new Point(76, 24));
		button7.setTabIndex(0);
		button7.setText("Browse");
		button7.addOnClick(new EventHandler(this.button7_click));

		editEditor.setLocation(new Point(8, 24));
		editEditor.setSize(new Point(228, 20));
		editEditor.setTabIndex(1);
		editEditor.setText("");

		checkBoxASBeforeCompiling.setLocation(new Point(8, 76));
		checkBoxASBeforeCompiling.setSize(new Point(156, 23));
		checkBoxASBeforeCompiling.setTabIndex(4);
		checkBoxASBeforeCompiling.setText("Auto save before compiling");
		checkBoxASBeforeCompiling.setChecked(true);
		checkBoxASBeforeCompiling.setCheckState(CheckState.CHECKED);

		checkBoxSyntax.setForeColor(Color.WINDOWTEXT);
		checkBoxSyntax.setLocation(new Point(12, 8));
		checkBoxSyntax.setSize(new Point(172, 23));
		checkBoxSyntax.setTabIndex(1);
		checkBoxSyntax.setText("Use syntax highlighting");
		checkBoxSyntax.setChecked(true);
		checkBoxSyntax.setCheckState(CheckState.CHECKED);

		label7.setLocation(new Point(20, 72));
		label7.setSize(new Point(172, 20));
		label7.setTabIndex(9);
		label7.setTabStop(false);
		label7.setText("View border for text elements");
		label7.setTextAlign(HorizontalAlignment.RIGHT);

		checkBox1.setLocation(new Point(200, 68));
		checkBox1.setSize(new Point(20, 20));
		checkBox1.setTabIndex(4);
		checkBox1.setText("");
		checkBox1.setChecked(true);
		checkBox1.setCheckState(CheckState.CHECKED);
		checkBox1.addOnClick(new EventHandler(this.checkBox1_click));
		checkBox1.addOnCheckedChanged(new EventHandler(this.checkBox1_checkedChanged));

		panelColor.setBackColor(new Color(224, 224, 224));
		panelColor.setLocation(new Point(200, 88));
		panelColor.setSize(new Point(40, 20));
		panelColor.setTabIndex(11);
		panelColor.setText("panel1");
		panelColor.setBorderStyle(BorderStyle.FIXED_3D);
		panelColor.addOnClick(new EventHandler(this.panelColor_click));

		labelPanelColor.setLocation(new Point(128, 92));
		labelPanelColor.setSize(new Point(64, 20));
		labelPanelColor.setTabIndex(7);
		labelPanelColor.setTabStop(false);
		labelPanelColor.setText("Border color");
		labelPanelColor.setTextAlign(HorizontalAlignment.RIGHT);

		label8.setLocation(new Point(24, 112));
		label8.setSize(new Point(168, 20));
		label8.setTabIndex(8);
		label8.setTabStop(false);
		label8.setText("Enable support for UTF-8 loading");
		label8.setTextAlign(HorizontalAlignment.RIGHT);

		checkBoxUTF8Support.setLocation(new Point(200, 108));
		checkBoxUTF8Support.setSize(new Point(20, 20));
		checkBoxUTF8Support.setTabIndex(3);
		checkBoxUTF8Support.setText("");
		checkBoxUTF8Support.setChecked(true);
		checkBoxUTF8Support.setCheckState(CheckState.CHECKED);
		checkBoxUTF8Support.addOnClick(new EventHandler(this.checkBox1_click));
		checkBoxUTF8Support.addOnCheckedChanged(new EventHandler(this.checkBox1_checkedChanged));

		this.setNewControls(new Control[] {
							button3, 
							button2, 
							button1, 
							tabControl1});
		tabControl1.setNewControls(new Control[] {
								   tabPage1, 
								   tabPage2, 
								   tabPage3, 
								   tabPage4});
		tabPage1.setNewControls(new Control[] {
								button6, 
								editTemplate, 
								label6, 
								groupBox2});
		tabPage2.setNewControls(new Control[] {
								checkBoxASBeforeCompiling, 
								checkBoxPDF, 
								button5, 
								editCOutdir, 
								label3});
		tabPage3.setNewControls(new Control[] {
								button4, 
								editBakdir, 
								label1, 
								groupBox1});
		groupBox1.setNewControls(new Control[] {
								 radioButtonAB, 
								 radioButtonRB, 
								 radioButtonNB});
		groupBox2.setNewControls(new Control[] {
								 checkBoxUTF8Support, 
								 label8, 
								 labelPanelColor, 
								 panelColor, 
								 checkBox1, 
								 label7, 
								 label5, 
								 comboBoxUM, 
								 checkBoxRules, 
								 label4, 
								 numberEditMRU, 
								 label2});
		tabPage4.setNewControls(new Control[] {
								checkBoxSyntax, 
								groupBox3});
		groupBox3.setNewControls(new Control[] {
								 editEditor, 
								 button7});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new OptionsForm(null));
	}
}
