package com.businesslogic.ireport.ui;
import com.businesslogic.ireport.*;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "FontsForm"
 * non viene creato nel metodo main().
 */
public class FontsForm extends Form
{
	Report report;
	MainForm mf;
	public FontsForm(MainForm mf)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		this.mf = mf;

	}

	public void setReport(Report report)
	{
		this.report = report;
		Enumeration enum = report.fonts.elements(); 
		while (enum.hasMoreElements())
		{
			IFont f = (IFont)enum.nextElement();
			DataListItem lid = new DataListItem(f,f.name,0);
			lid.setSubItem(0,f.isDefault+"");
			listViewFonts.addItem(lid);
		}
	}
	
	/**
	 * FontsForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void buttonClose_click(Object source, Event e)
	{
		this.dispose();
	}

	private void buttonAdd_click(Object source, Event e)
	{
		FontForm f = new FontForm(mf);	
		IFont font = new IFont();
		f.setIFont(font);
		if (f.showDialog() == DialogResult.OK)
		{
			font.fontName = f.font.fontName;
			font.isBold = f.font.isBold;
			font.isItalic = f.font.isItalic;
			font.isPdfEmbedded = f.font.isPdfEmbedded;
			font.isStrikeThrough = f.font.isStrikeThrough;
			font.isUnderline = f.font.isUnderline;
			font.name = f.font.name;
			font.pdfEncoding = f.font.pdfEncoding;
			font.pdfFontName = f.font.pdfFontName;
			font.size = f.font.size;
		
			report.fonts.addElement(font);
			DataListItem lid = new DataListItem(font,font.name+" ("+ font.pdfFontName+")" ,0);
			lid.setSubItem(0,font.isDefault+"");
			listViewFonts.addItem(lid);
		}
	}

	private void buttonMod_click(Object source, Event e)
	{
		if (listViewFonts.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewFonts.getSelectedItems()[0]);
			IFont font = (IFont)dli.getData();
			FontForm f = new FontForm(mf);	
			f.setOwner(this);
			f.setIFont(font);
			if (f.showDialog() == DialogResult.OK)
			{
				font.fontName = f.font.fontName;
				font.isBold = f.font.isBold;
				font.isItalic = f.font.isItalic;
				font.isPdfEmbedded = f.font.isPdfEmbedded;
				font.isStrikeThrough = f.font.isStrikeThrough;
				font.isUnderline = f.font.isUnderline;
				font.name = f.font.name;
				font.pdfEncoding = f.font.pdfEncoding;
				font.pdfFontName = f.font.pdfFontName;
				font.size = f.font.size;		
				dli.setText(font.name+" ("+ font.pdfFontName+")");
				dli.setSubItem(0,font.isDefault+"");
			}
		}
	}

	private void buttonDel_click(Object source, Event e)
	{
		while (listViewFonts.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewFonts.getSelectedItems()[0]);
			IFont font = (IFont)dli.getData();
			report.fonts.removeElement(font);
			listViewFonts.removeItem(dli);
	    }
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	ListView listViewFonts = new ListView();
	Panel panel1 = new Panel();
	ColumnHeader columnHeader1 = new ColumnHeader();
	Button buttonAdd = new Button();
	Button buttonMod = new Button();
	Button buttonDel = new Button();
	Button buttonClose = new Button();
	ColumnHeader columnHeader2 = new ColumnHeader();

	private void initForm()
	{
		this.setText("Fonts");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setClientSize(new Point(370, 227));
		this.setMaximizeBox(false);
		this.setMinimizeBox(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		panel1.setDock(ControlDock.RIGHT);
		panel1.setLocation(new Point(270, 0));
		panel1.setSize(new Point(100, 227));
		panel1.setTabIndex(1);
		panel1.setText("panel1");

		columnHeader1.setText("Font Name");
		columnHeader1.setWidth(174);

		buttonAdd.setLocation(new Point(4, 4));
		buttonAdd.setSize(new Point(92, 24));
		buttonAdd.setTabIndex(0);
		buttonAdd.setText("Add font");
		buttonAdd.addOnClick(new EventHandler(this.buttonAdd_click));

		buttonMod.setLocation(new Point(4, 32));
		buttonMod.setSize(new Point(92, 24));
		buttonMod.setTabIndex(1);
		buttonMod.setText("Modify");
		buttonMod.addOnClick(new EventHandler(this.buttonMod_click));

		buttonDel.setLocation(new Point(4, 60));
		buttonDel.setSize(new Point(92, 24));
		buttonDel.setTabIndex(2);
		buttonDel.setText("Remove");
		buttonDel.addOnClick(new EventHandler(this.buttonDel_click));

		buttonClose.setAnchor(ControlAnchor.BOTTOMRIGHT);
		buttonClose.setLocation(new Point(4, 200));
		buttonClose.setSize(new Point(92, 24));
		buttonClose.setTabIndex(3);
		buttonClose.setText("Close");
		buttonClose.addOnClick(new EventHandler(this.buttonClose_click));

		columnHeader2.setText("Default");
		columnHeader2.setWidth(90);

		listViewFonts.setDock(ControlDock.FILL);
		listViewFonts.setSize(new Point(270, 227));
		listViewFonts.setTabIndex(0);
		listViewFonts.setText("listView1");
		listViewFonts.setFullRowSelect(true);
		listViewFonts.setGridLines(true);
		listViewFonts.setHideSelection(false);
		listViewFonts.setView(ViewEnum.REPORT);
		listViewFonts.setColumns(new ColumnHeader[] {
								 columnHeader1, 
								 columnHeader2});

		this.setNewControls(new Control[] {
							panel1, 
							listViewFonts});
		panel1.setNewControls(new Control[] {
							  buttonClose, 
							  buttonDel, 
							  buttonMod, 
							  buttonAdd});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new FontsForm(null));
	}
}
