/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;
import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.*;
import java.sql.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "QueryForm"
 * non viene creato nel metodo main().
 */
public class QueryForm extends Form
{
	Report report=null;
	public QueryForm()
	{
		super();
		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
	
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}
	
	public void fillConnectionCombo(Vector v)
	{
		if (v == null) return;
		Enumeration enum = v.elements();
		while (enum.hasMoreElements())
		{
			comboBoxConnections.addItem( enum.nextElement() );
		}
	}

	public void setReport(Report rep)
	{
		report = rep;
		this.editQuery.setText(report.query);
	}
	/**
	 * QueryForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void button1_click(Object source, Event e)
	{
		// Get ConnectionEntry...
		if (comboBoxConnections.getSelectedIndex() >= 0)
		{
				ConnectionEntry ce = (ConnectionEntry)comboBoxConnections.getSelectedItem(); 
				String password = ce.password;
				if (password == null || password.trim().length() == 0)
				{
					PasswordForm pf = new PasswordForm();
					pf.setUsername(ce.username);
					if (pf.showDialog() == DialogResult.OK)
					{
						password = pf.getPassword();	
					}
					else
						return;
				}
				
				ElaborationForm ef = new ElaborationForm();
				ef.setConnectionEntry(ce);
				ef.setPassword(password);
				ef.setQuery(editQuery.getText());
				if (ef.showDialog() == DialogResult.OK)
				{
					this.listViewFields.removeAllItems();
					Vector v = ef.getFields();
					Enumeration enum = v.elements();
					while (enum.hasMoreElements())
					{
						JRField f = (JRField)enum.nextElement();
						DataListItem dli = new DataListItem(f, f.name,0);
						dli.setSubItem(0,f.classType);
						listViewFields.addItem(dli);
					}
				}
				
		} else {
			MessageBox.show("Please select first a connection!");
		}
	}
	


	private void button3_click(Object source, Event e)
	{
		for (int i=0; i< listViewFields.getItemCount(); ++i)
		{		
			JRField f =  (JRField)((DataListItem)listViewFields.getItem(i)).getData();
			//Search fot f in fields...
			boolean found=false;
			Enumeration enum = this.report.fields.elements();
			while (enum.hasMoreElements())
			{
				JRField f_tmp =  (JRField)enum.nextElement();
				if (f.name.equals(f_tmp.name))
				{
					found = true;
					break;
				}
			}
			
			if (!found)
				this.report.fields.addElement(f);  
		}
	}

	private void button4_click(Object source, Event e)
	{
		this.report.query = editQuery.getText().trim();
	}

	private void button2_click(Object source, Event e)
	{
		this.dispose();
	}

	private void QueryForm_deactivate(Object source, Event e)
	{
		if (this.report.reportForm != null)
		this.report.reportForm.focus();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Panel panel1 = new Panel();
	RichEdit editQuery = new RichEdit();
	Label label1 = new Label();
	ListView listViewFields = new ListView();
	Panel panel2 = new Panel();
	Splitter splitter1 = new Splitter();
	ColumnHeader columnHeader1 = new ColumnHeader();
	ColumnHeader columnHeader2 = new ColumnHeader();
	Button button1 = new Button();
	Panel panel3 = new Panel();
	ComboBox comboBoxConnections = new ComboBox();
	Label label2 = new Label();
	Button button2 = new Button();
	Button button3 = new Button();
	Button button4 = new Button();

	private void initForm()
	{
		// NOTA: questo form contiene informazioni relative alle risorse in
		// un file esterno. Non modificare il parametro di tipo String delle
		// chiamate alla funzione resources.getObject(). Ad esempio, non
		// modificare"foo1_location" nella seguente riga di codice,
		// nemmeno se il nome dell'oggetto Foo viene modificato: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "QueryForm");
		this.setText("Report query...");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setClientSize(new Point(381, 325));
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.addOnDeactivate(new EventHandler(this.QueryForm_deactivate));

		panel1.setDock(ControlDock.FILL);
		panel1.setSize(new Point(381, 325));
		panel1.setTabIndex(0);
		panel1.setText("panel1");

		editQuery.setDock(ControlDock.TOP);
		editQuery.setLocation(new Point(0, 60));
		editQuery.setSize(new Point(381, 104));
		editQuery.setTabIndex(0);
		editQuery.setText("");
		editQuery.setMultiline(true);
		editQuery.setScrollBars(ScrollBars.BOTH);
		editQuery.setWordWrap(false);

		label1.setDock(ControlDock.TOP);
		label1.setLocation(new Point(0, 44));
		label1.setSize(new Point(381, 16));
		label1.setTabIndex(1);
		label1.setTabStop(false);
		label1.setText("Report query");

		panel2.setDock(ControlDock.BOTTOM);
		panel2.setLocation(new Point(0, 289));
		panel2.setSize(new Point(381, 36));
		panel2.setTabIndex(3);
		panel2.setText("panel2");

		splitter1.setCursor(Cursor.HSPLIT);
		splitter1.setDock(ControlDock.TOP);
		splitter1.setLocation(new Point(0, 164));
		splitter1.setSize(new Point(381, 3));
		splitter1.setTabIndex(4);
		splitter1.setTabStop(false);

		columnHeader1.setText("Field name");
		columnHeader1.setWidth(162);

		columnHeader2.setText("Field type");
		columnHeader2.setWidth(212);

		listViewFields.setDock(ControlDock.FILL);
		listViewFields.setLocation(new Point(0, 167));
		listViewFields.setSize(new Point(381, 122));
		listViewFields.setTabIndex(2);
		listViewFields.setText("listView1");
		listViewFields.setFullRowSelect(true);
		listViewFields.setGridLines(true);
		listViewFields.setView(ViewEnum.REPORT);
		listViewFields.setColumns(new ColumnHeader[] {
								  columnHeader1, 
								  columnHeader2});

		button1.setLocation(new Point(4, 8));
		button1.setSize(new Point(84, 24));
		button1.setTabIndex(2);
		button1.setText("Read fields");
		button1.addOnClick(new EventHandler(this.button1_click));

		panel3.setDock(ControlDock.TOP);
		panel3.setSize(new Point(381, 44));
		panel3.setTabIndex(5);
		panel3.setText("panel3");

		comboBoxConnections.setDock(ControlDock.BOTTOM);
		comboBoxConnections.setLocation(new Point(0, 23));
		comboBoxConnections.setSize(new Point(381, 21));
		comboBoxConnections.setTabIndex(0);
		comboBoxConnections.setText("");
		comboBoxConnections.setStyle(ComboBoxStyle.DROPDOWNLIST);

		label2.setLocation(new Point(4, 4));
		label2.setSize(new Point(100, 16));
		label2.setTabIndex(1);
		label2.setTabStop(false);
		label2.setText("Connection");

		button2.setLocation(new Point(304, 8));
		button2.setSize(new Point(76, 24));
		button2.setTabIndex(0);
		button2.setText("&Close");
		button2.setDialogResult(DialogResult.CANCEL);
		button2.addOnClick(new EventHandler(this.button2_click));

		button3.setLocation(new Point(92, 8));
		button3.setSize(new Point(116, 24));
		button3.setTabIndex(1);
		button3.setText("Register fields to report");
		button3.addOnClick(new EventHandler(this.button3_click));

		button4.setLocation(new Point(212, 8));
		button4.setSize(new Point(88, 24));
		button4.setTabIndex(3);
		button4.setText("Save to report");
		button4.addOnClick(new EventHandler(this.button4_click));

		this.setNewControls(new Control[] {
							panel1});
		panel1.setNewControls(new Control[] {
							  panel3, 
							  splitter1, 
							  panel2, 
							  listViewFields, 
							  label1, 
							  editQuery});
		panel2.setNewControls(new Control[] {
							  button4, 
							  button3, 
							  button1, 
							  button2});
		panel3.setNewControls(new Control[] {
							  label2, 
							  comboBoxConnections});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new QueryForm());
	}
}
