/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.lang.Delegate;


/**
 * Questa classe  un componente grafico. Il punto di ingresso per l'esecuzione
 * della classe  il costruttore.
 */
public class GTImageButton extends Control
{
	
	private String text;
	private com.ms.wfc.ui.Image img1;
	private com.ms.wfc.ui.Image img2;
	private com.ms.wfc.ui.Image img3;
	private com.ms.wfc.ui.Image toDraw;
	private boolean toggle;
	private boolean enter;
	private boolean enabled;
	private boolean pressed;
	private boolean buttonDown;
	
	private static final Object EVENT_BUTTONCLICK = new Object();
	private static final Object EVENT_STATECHANGED = new Object();
	
	public GTImageButton()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		//
		initForm();		
		enter = true;
		pressed=false;
		buttonDown=false;
		enabled=true;
	}
	
	
	public void setImg1(com.ms.wfc.ui.Image  img1) {
        this.img1 = img1;
		toDraw = img1;
		invalidate();
    }
	
	public com.ms.wfc.ui.Image getImg1(){
		return img1;
	}
	
	public void setImg2(com.ms.wfc.ui.Image  img2) {
        this.img2 = img2;
    }
	
	public com.ms.wfc.ui.Image getImg3(){
		return img3;
	}
	
	public void setImg3(com.ms.wfc.ui.Image  img3) {
        this.img3 = img3;
    }
	
	public com.ms.wfc.ui.Image getImg2()
	{
		return img2;
	}
	
	
		
	public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }
	
	public boolean getToggle() {
        return toggle;
    }
		
	public void setEnabled(boolean enabled) {
        
		if (this.enabled != enabled && enabled==true)
		{
			
			if (buttonDown== false)
				toDraw = img1;
			else
				toDraw = img2;
			invalidate();
		}
		else if (enabled==false)
		{
			toDraw = img3;
			invalidate();
		}
		this.enabled = enabled;
		
    }
	
	public boolean getEnabled() {
        return enabled;
    }
	
	protected void onButtonClick(Event e) {
		if (getEnabled())
             fireEvent(EVENT_BUTTONCLICK, e);
    }	
	
	public void addOnButtonClick(EventHandler value) {
        addEventHandler(EVENT_BUTTONCLICK, value);
	}

    public void removeOnButtonClick(EventHandler value) {
       removeEventHandler(EVENT_BUTTONCLICK,value);
    }
	
	protected void onStateChanged(Event e) {
			if (getEnabled())
             fireEvent(EVENT_STATECHANGED, e);
    }	
	
	public void addOnStateChanged(EventHandler value) {
        addEventHandler(EVENT_STATECHANGED, value);
	}

    public void removeOnStateChanged(EventHandler value) {
       removeEventHandler(EVENT_STATECHANGED,value);
    }
	

	
	protected void fireEvent(Object key, Event e) {
        com.ms.lang.Delegate handler = getEventHandler(key);
        if (handler != null) ((EventHandler)handler).invoke(this, e);
    }

	private void GTImageButton_paint(Object source, PaintEvent e)
	{
		if (!getEnabled()) toDraw = img3; 
		if (toDraw != null)
		e.graphics.drawImage(toDraw,0,0);
		
	}

	private void GTImageButton_mouseDown(Object source, MouseEvent e)
	{
		if (!getEnabled()) return;
		pressed = true;
		
		toDraw = img2;
		invalidate();
	}
	
	private void GTImageButton_mouseUp(Object source, MouseEvent e)
	{
		if (!getEnabled()) return;
		pressed = false;
		if (enter)
		{
			if (toggle)
			{
				if (buttonDown)
				{
					buttonDown = false;
					toDraw = img1;
				}
				else
				{
					buttonDown = true;
					toDraw = img2;
				}
				invalidate();
				onStateChanged(new Event());
			}
			else
			{
				toDraw = img1;
				invalidate();
				onButtonClick(new Event());
			}
		}
	}
	
	/*
	private void GTImageButton_mouseEnter(Object source, Event e)
	{
		this.setBackColor(Color.WHITE);
		invalidate();
		enter = true;
	}
		
	private void GTImageButton_mouseLeave(Object source, Event e)
	{
		this.setBackColor(Color.BLACK);
		invalidate();
		enter = false;
	}
	*/
	
	private void GTImageButton_mouseMove(Object source, MouseEvent e)
	{
		if (e.x < 0 || e.x > this.getWidth() || e.y < 0 || e.y > this.getHeight())
		{	
			if (enter==true)
			{
				enter= false;
				if (!buttonDown)
					toDraw = img1;
				this.setBackColor(Color.BLACK);
				invalidate();
			}
		}
		else
		{
			if (enter==false)
			{
				enter= true;
				if (pressed)
					toDraw = img2;
				this.setBackColor(Color.WHITE);
				invalidate();
			}
		}
	}
	
	public boolean getPressed()
	{
		return buttonDown;
	}
	
	public void setPressed(boolean b)
	{
		if (toggle && b!=buttonDown)
		{
			if (buttonDown== false)
				toDraw = img2;
			else
				toDraw = img1;
			buttonDown = b;
			invalidate();
		}
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();

	private void initForm()
	{
		this.setSize(new Point(303, 158));
		this.setText("GTImageButton");
		this.addOnMouseDown(new MouseEventHandler(this.GTImageButton_mouseDown));
		this.addOnMouseUp(new MouseEventHandler(this.GTImageButton_mouseUp));
		//this.addOnMouseEnter(new EventHandler(this.GTImageButton_mouseEnter));
		//this.addOnMouseLeave(new EventHandler(this.GTImageButton_mouseLeave));
		this.addOnMouseMove(new MouseEventHandler(this.GTImageButton_mouseMove));
		this.addOnPaint(new PaintEventHandler(this.GTImageButton_paint));
	}

	public static class ClassInfo extends Control.ClassInfo
	{
		public static final PropertyInfo img1 =
                                               new PropertyInfo(GTImageButton.class, "img1", com.ms.wfc.ui.Image.class ,
            CategoryAttribute.Appearance,
            LocalizableAttribute.NO ,
            new DescriptionAttribute("Immagine 1."));
			
		public static final PropertyInfo img2 =
                                               new PropertyInfo(GTImageButton.class, "img2", com.ms.wfc.ui.Image.class ,
            CategoryAttribute.Appearance,
            LocalizableAttribute.NO ,
            new DescriptionAttribute("Immagine 2."));
		
		public static final PropertyInfo img3 =
                                               new PropertyInfo(GTImageButton.class, "img3", com.ms.wfc.ui.Image.class ,
            CategoryAttribute.Appearance,
            LocalizableAttribute.NO ,
            new DescriptionAttribute("Immagine 3."));
		
		public static final PropertyInfo toggle =
                                               new PropertyInfo(GTImageButton.class, "toggle", Boolean.TYPE,
            CategoryAttribute.Appearance,
            LocalizableAttribute.NO ,
            new DescriptionAttribute("Bottone toggle?"));
		
		public static final PropertyInfo enabled =
                                               new PropertyInfo(GTImageButton.class, "enabled", Boolean.TYPE,
            CategoryAttribute.Appearance,
            LocalizableAttribute.NO ,
            new DescriptionAttribute("Enabled?"));
		
		public static final EventInfo OnButtonClick =
            new EventInfo(GTImageButton.class, "buttonClick", EventHandler.class,
            CategoryAttribute.Action ,
           new DescriptionAttribute("Occurs when button is clicked!"));
		
	
		public static final EventInfo OnStateChanged =
            new EventInfo(GTImageButton.class, "stateChanged", EventHandler.class,
            CategoryAttribute.Action ,
           new DescriptionAttribute("Occurs when status is changed!"));
		
				
      // Add the properties.
      public void getProperties(IProperties props) {
		  super.getProperties(props);
         props.add(img1);
		 props.add(img2);
		 props.add(img3);
		 props.add(toggle);
		 props.add(enabled);
         //props.add(backColor);
      }

      // Add the events.
      public void getEvents(IEvents events) {
         super.getEvents(events);
		 events.add(OnButtonClick);
		  events.add(OnStateChanged);
      }
	}   
}
