/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.view;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRPrintAnchorIndex;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintHyperlink;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.JasperPrintManager;
import dori.jasper.engine.util.JRLoader;
import dori.jasper.engine.xml.JRPrintXmlLoader;
import dori.jasper.view.JRHyperlinkListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;

public class JRViewer
extends JPanel
implements JRHyperlinkListener {
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_PRINT = 3;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250};
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    private JasperPrint jasperPrint = null;
    private int pageIndex = 0;
    private float zoom = 1.0f;
    private int downX = 0;
    private int downY = 0;
    private JScrollBar hBar = null;
    private JScrollBar vBar = null;
    private List hyperlinkListeners = new ArrayList();
    private Map linksMap = new HashMap();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent evt) {
            JRViewer.this.hyperlinkClicked(evt);
        }
    };
    protected JToolBar tlbToolBar;
    private JPanel pnlInScroll;
    private JPanel jPanel4;
    private JPanel pnlPage;
    private JLabel jLabel1;
    private JScrollPane scrollPane;
    private JPanel pnlLinks;
    private JPanel pnlMain;
    protected JPanel pnlSep02;
    protected JButton btnLast;
    protected JButton btnReload;
    private JPanel jPanel5;
    protected JButton btnPrevious;
    protected JButton btnZoomOut;
    private JLabel lblPage;
    private JPanel jPanel8;
    protected JButton btnZoomIn;
    private JPanel jPanel7;
    protected JButton btnNext;
    protected JPanel pnlSep01;
    protected JButton btnFirst;
    private JPanel jPanel6;
    protected JComboBox cmbZoom;
    private JPanel jPanel9;
    protected JButton btnPrint;

    public JRViewer(String fileName, boolean isXML) throws JRException {
        this.setZooms();
        this.initComponents();
        this.cmbZoom.setSelectedIndex(2);
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(fileName, isXML);
        this.setPageIndex(0);
        this.refreshPage();
        this.addHyperlinkListener(this);
    }

    public JRViewer(InputStream is, boolean isXML) throws JRException {
        this.setZooms();
        this.initComponents();
        this.cmbZoom.setSelectedIndex(2);
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(is, isXML);
        this.setPageIndex(0);
        this.refreshPage();
        this.addHyperlinkListener(this);
    }

    public JRViewer(JasperPrint jrPrint) throws JRException {
        this.setZooms();
        this.initComponents();
        this.cmbZoom.setSelectedIndex(2);
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(jrPrint);
        this.setPageIndex(0);
        this.refreshPage();
        this.addHyperlinkListener(this);
    }

    protected void setZooms() {
    }

    public void addHyperlinkListener(JRHyperlinkListener listener) throws JRException {
        this.hyperlinkListeners.add(listener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener listener) throws JRException {
        this.hyperlinkListeners.remove(listener);
    }

    public void gotoHyperlink(JRPrintHyperlink hyperlink) throws JRException {
        switch (hyperlink.getHyperlinkType()) {
            case 2: {
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 3: {
                Container container;
                if (hyperlink.getHyperlinkAnchor() == null) break;
                Map anchorIndexes = this.jasperPrint.getAnchorIndexes();
                JRPrintAnchorIndex anchorIndex = (JRPrintAnchorIndex)anchorIndexes.get(hyperlink.getHyperlinkAnchor());
                if (anchorIndex.getPageIndex() != this.pageIndex) {
                    this.setPageIndex(anchorIndex.getPageIndex());
                    this.refreshPage();
                }
                if (!((container = this.pnlInScroll.getParent()) instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                int newX = (int)((float)anchorIndex.getElement().getX() * this.zoom);
                int newY = (int)((float)anchorIndex.getElement().getY() * this.zoom);
                int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
                int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
                if (newX < 0) {
                    newX = 0;
                }
                if (newX > maxX) {
                    newX = maxX;
                }
                if (newY < 0) {
                    newY = 0;
                }
                if (newY > maxY) {
                    newY = maxY;
                }
                viewport.setViewPosition(new Point(newX, newY));
                break;
            }
            case 4: {
                int page = this.pageIndex + 1;
                if (hyperlink.getHyperlinkPage() != null) {
                    page = hyperlink.getHyperlinkPage();
                }
                if (page < 1 || page > this.jasperPrint.getPages().size() || page == this.pageIndex + 1) break;
                this.setPageIndex(page - 1);
                this.refreshPage();
                Container container = this.pnlInScroll.getParent();
                if (!(container instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                viewport.setViewPosition(new Point(0, 0));
                break;
            }
            case 5: {
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink anchor    : " + hyperlink.getHyperlinkAnchor());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 6: {
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink page      : " + hyperlink.getHyperlinkPage());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
        }
    }

    private void initComponents() {
        this.tlbToolBar = new JToolBar();
        this.btnPrint = new JButton();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.pnlSep02 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        while (i < this.zooms.length) {
            model.addElement("" + this.zooms[i] + "%");
            ++i;
        }
        this.cmbZoom.setModel(model);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.pnlLinks = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new JLabel();
        this.setLayout(new BorderLayout());
        this.tlbToolBar.setFloatable(false);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/print.GIF")));
        this.btnPrint.setText("Print");
        this.btnPrint.setToolTipText("Print");
        this.btnPrint.setMaximumSize(new Dimension(80, 23));
        this.btnPrint.setMinimumSize(new Dimension(80, 23));
        this.btnPrint.setPreferredSize(new Dimension(80, 23));
        this.btnPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnPrintActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnPrint);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/reload.GIF")));
        this.btnReload.setText("Reload");
        this.btnReload.setToolTipText("Reload Document");
        this.btnReload.setMaximumSize(new Dimension(80, 23));
        this.btnReload.setMinimumSize(new Dimension(80, 23));
        this.btnReload.setPreferredSize(new Dimension(80, 23));
        this.btnReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnReloadActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/first.GIF")));
        this.btnFirst.setToolTipText("First Page");
        this.btnFirst.setMaximumSize(new Dimension(23, 23));
        this.btnFirst.setMinimumSize(new Dimension(23, 23));
        this.btnFirst.setPreferredSize(new Dimension(23, 23));
        this.btnFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnFirstActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/previous.GIF")));
        this.btnPrevious.setToolTipText("Previous Page");
        this.btnPrevious.setMaximumSize(new Dimension(23, 23));
        this.btnPrevious.setMinimumSize(new Dimension(23, 23));
        this.btnPrevious.setPreferredSize(new Dimension(23, 23));
        this.btnPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnPreviousActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnPrevious);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/next.GIF")));
        this.btnNext.setToolTipText("Next Page");
        this.btnNext.setMaximumSize(new Dimension(23, 23));
        this.btnNext.setMinimumSize(new Dimension(23, 23));
        this.btnNext.setPreferredSize(new Dimension(23, 23));
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnNextActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/last.GIF")));
        this.btnLast.setToolTipText("Last Page");
        this.btnLast.setMaximumSize(new Dimension(23, 23));
        this.btnLast.setMinimumSize(new Dimension(23, 23));
        this.btnLast.setPreferredSize(new Dimension(23, 23));
        this.btnLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnLastActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnLast);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText("Zoom In");
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnZoomInActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText("Zoom Out");
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setToolTipText("Zoom Ratio");
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.cmbZoomActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.pnlLinks.setLayout(null);
        this.pnlLinks.setMinimumSize(new Dimension(5, 5));
        this.pnlLinks.setPreferredSize(new Dimension(5, 5));
        this.pnlLinks.setOpaque(false);
        this.pnlLinks.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JRViewer.this.pnlLinksMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                JRViewer.this.pnlLinksMouseReleased(evt);
            }
        });
        this.pnlLinks.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JRViewer.this.pnlLinksMouseDragged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.pnlLinks, gridBagConstraints);
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
    }

    private void pnlLinksMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    private void pnlLinksMouseReleased(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(0));
    }

    private void pnlLinksMousePressed(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JasperPrintManager.printReport(JRViewer.this.jasperPrint, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error printing report. See console for details.");
                }
            }
        });
        thread.start();
    }

    private void btnLastActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.jasperPrint.getPages().size() - 1);
        this.refreshPage();
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.pageIndex + 1);
        this.refreshPage();
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.pageIndex - 1);
        this.refreshPage();
    }

    private void btnFirstActionPerformed(ActionEvent evt) {
        this.setPageIndex(0);
        this.refreshPage();
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
            this.setPageIndex(0);
            this.cmbZoom.setSelectedIndex(2);
        }
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.cmbZoom.setSelectedIndex(index + 1);
        }
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        if (index > 0) {
            this.cmbZoom.setSelectedIndex(index - 1);
        }
    }

    private void cmbZoomActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        this.zoom = (float)this.zooms[index] / 100.0f;
        this.btnZoomIn.setEnabled(index < this.cmbZoom.getModel().getSize() - 1);
        this.btnZoomOut.setEnabled(index > 0);
        this.refreshPage();
    }

    private void hyperlinkClicked(MouseEvent evt) {
        JPanel link = (JPanel)evt.getSource();
        JRPrintHyperlink element = (JRPrintHyperlink)this.linksMap.get(link);
        try {
            JRHyperlinkListener listener = null;
            int i = 0;
            while (i < this.hyperlinkListeners.size()) {
                listener = (JRHyperlinkListener)this.hyperlinkListeners.get(i);
                listener.gotoHyperlink(element);
                ++i;
            }
        }
        catch (JRException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error encoutered when following hyperlink. See console for details.");
        }
    }

    private void setPageIndex(int index) {
        this.pageIndex = index;
        this.btnFirst.setEnabled(this.pageIndex > 0);
        this.btnPrevious.setEnabled(this.pageIndex > 0);
        this.btnNext.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
        this.btnLast.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
    }

    private void loadReport(String fileName, boolean isXML) throws JRException {
        this.jasperPrint = isXML ? JRPrintXmlLoader.load(fileName) : (JasperPrint)JRLoader.loadObject(fileName);
        this.type = 1;
        this.isXML = isXML;
        this.reportFileName = fileName;
        this.btnReload.setEnabled(true);
    }

    private void loadReport(InputStream is, boolean isXML) throws JRException {
        this.jasperPrint = isXML ? JRPrintXmlLoader.load(is) : (JasperPrint)JRLoader.loadObject(is);
        this.type = 2;
        this.isXML = isXML;
        this.btnReload.setEnabled(false);
    }

    private void loadReport(JasperPrint jrPrint) throws JRException {
        this.jasperPrint = jrPrint;
        this.type = 3;
        this.isXML = false;
        this.btnReload.setEnabled(false);
    }

    private void refreshPage() {
        if (this.jasperPrint == null) {
            return;
        }
        Image image = null;
        ImageIcon imageIcon = null;
        Dimension dim = new Dimension((int)((float)this.jasperPrint.getPageWidth() * this.zoom) + 8, (int)((float)this.jasperPrint.getPageHeight() * this.zoom) + 8);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        try {
            image = JasperPrintManager.printPageToImage(this.jasperPrint, this.pageIndex, this.zoom);
            imageIcon = new ImageIcon(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pnlLinks.removeAll();
        this.linksMap = new HashMap();
        List pages = this.jasperPrint.getPages();
        JRPrintPage page = (JRPrintPage)pages.get(this.pageIndex);
        Collection elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            String toolTip = null;
            JPanel link = null;
            JRPrintElement element = null;
            JRPrintHyperlink hyperlink = null;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (!(element instanceof JRPrintHyperlink) || ((JRPrintHyperlink)((Object)element)).getHyperlinkType() == 1) continue;
                hyperlink = (JRPrintHyperlink)((Object)element);
                link = new JPanel();
                link.setCursor(new Cursor(12));
                link.setLocation((int)((float)element.getX() * this.zoom), (int)((float)element.getY() * this.zoom));
                link.setSize((int)((float)element.getWidth() * this.zoom), (int)((float)element.getHeight() * this.zoom));
                link.setOpaque(false);
                toolTip = null;
                switch (hyperlink.getHyperlinkType()) {
                    case 2: {
                        toolTip = hyperlink.getHyperlinkReference();
                        break;
                    }
                    case 3: {
                        if (hyperlink.getHyperlinkAnchor() == null) break;
                        toolTip = "#" + hyperlink.getHyperlinkAnchor();
                        break;
                    }
                    case 4: {
                        if (hyperlink.getHyperlinkPage() == null) break;
                        toolTip = "#page " + hyperlink.getHyperlinkPage();
                        break;
                    }
                    case 5: {
                        toolTip = "";
                        if (hyperlink.getHyperlinkReference() != null) {
                            toolTip = toolTip + hyperlink.getHyperlinkReference();
                        }
                        if (hyperlink.getHyperlinkAnchor() == null) break;
                        toolTip = toolTip + "#" + hyperlink.getHyperlinkAnchor();
                        break;
                    }
                    case 6: {
                        toolTip = "";
                        if (hyperlink.getHyperlinkReference() != null) {
                            toolTip = toolTip + hyperlink.getHyperlinkReference();
                        }
                        if (hyperlink.getHyperlinkPage() == null) break;
                        toolTip = toolTip + "#page " + hyperlink.getHyperlinkPage();
                        break;
                    }
                }
                link.setToolTipText(toolTip);
                link.addMouseListener(this.mouseListener);
                this.pnlLinks.add(link);
                this.linksMap.put(link, element);
            }
        }
        this.lblPage.setIcon(imageIcon);
    }
}

