/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRDesignReportFont;
import dori.jasper.engine.export.JRExporterGridCell;
import dori.jasper.engine.export.JRHtmlExporterParameter;
import dori.jasper.engine.export.JRXmlExporterParameter;
import dori.jasper.engine.util.JRImageLoader;
import dori.jasper.engine.util.JRLoader;
import dori.jasper.engine.util.JRStringUtil;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class JRHtmlExporter
extends JRAbstractExporter {
    public static final String CSS_TEXT_ALIGN_LEFT = "left";
    public static final String CSS_TEXT_ALIGN_RIGHT = "right";
    public static final String CSS_TEXT_ALIGN_CENTER = "center";
    public static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    private JasperPrint jasperPrint = null;
    private StringBuffer sbuffer = null;
    private Map loadedImagesMap = null;
    private Map imagesMap = null;
    private JRReportFont defaultFont = null;
    private File destFile = null;
    private File imagesDir = null;
    private String imagesURI = null;
    private int startPageIndex = 0;
    private int endPageIndex = 0;
    private String htmlHeader = null;
    private String betweenPagesHtml = null;
    private String htmlFooter = null;
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);
    private JRExporterGridCell[][] grid = null;
    private List xCuts = null;
    private List yCuts = null;

    private JRReportFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRDesignReportFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        Integer start;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < 0 || this.endPageIndex > lastPageIndex) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " of " + lastPageIndex);
            }
        }
        Integer index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
        this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
        this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
        this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
        String uri = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI);
        this.imagesURI = uri != null ? uri : "";
        this.loadedImagesMap = new HashMap();
        this.loadedImagesMap.put(JRImageLoader.loadImageDataFromLocation("dori/jasper/engine/images/pixel.GIF"), "px");
        StringBuffer sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb != null) {
            sb.append(this.exportReportToBuffer().toString());
        } else {
            OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
            if (os != null) {
                String xmlString = this.exportReportToBuffer().toString();
                try {
                    byte[] bytes = xmlString.getBytes("UTF-8");
                    os.write(bytes, 0, bytes.length);
                }
                catch (Exception e) {
                    throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e);
                }
            } else {
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + "_files");
                this.imagesURI = this.imagesDir.getName() + "/";
                this.exportReportToFile();
            }
        }
        Map map = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
        if (map != null) {
            this.imagesMap = map;
            Set imageKeys = this.loadedImagesMap.keySet();
            if (imageKeys != null && imageKeys.size() > 0) {
                byte[] imageData = null;
                String imageName = null;
                Iterator it = imageKeys.iterator();
                while (it.hasNext()) {
                    imageData = (byte[])it.next();
                    imageName = (String)this.loadedImagesMap.get(imageData);
                    this.imagesMap.put(imageName, imageData);
                }
            }
        }
    }

    private void exportReportToFile() throws JRException {
        String xmlString = this.exportReportToBuffer().toString();
        try {
            byte[] bytes = xmlString.getBytes("UTF-8");
            FileOutputStream fos = new FileOutputStream(this.destFile);
            fos.write(bytes, 0, bytes.length);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new JRException("Error writing to file : " + this.destFile, e);
        }
        Set imageKeys = this.loadedImagesMap.keySet();
        if (imageKeys != null && imageKeys.size() > 0) {
            if (!this.imagesDir.exists()) {
                this.imagesDir.mkdir();
            }
            byte[] imageData = null;
            File imageFile = null;
            FileOutputStream fos = null;
            Iterator it = imageKeys.iterator();
            while (it.hasNext()) {
                imageData = (byte[])it.next();
                imageFile = new File(this.imagesDir, (String)this.loadedImagesMap.get(imageData));
                try {
                    fos = new FileOutputStream(imageFile);
                    fos.write(imageData, 0, imageData.length);
                    fos.close();
                }
                catch (Exception e) {
                    throw new JRException("Error writing to image file : " + imageFile, e);
                }
            }
        }
    }

    private StringBuffer exportReportToBuffer() throws JRException {
        this.sbuffer = new StringBuffer();
        if (this.htmlHeader == null) {
            this.sbuffer.append("<html>\n");
            this.sbuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
            this.sbuffer.append("<head>\n");
            this.sbuffer.append("  <style type=\"text/css\">\n");
            this.sbuffer.append("    a {text-decoration: none}\n");
            this.sbuffer.append("  </style>\n");
            this.sbuffer.append("</head>\n");
            this.sbuffer.append("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.sbuffer.append("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.sbuffer.append("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.sbuffer.append("\n");
        } else {
            this.sbuffer.append(this.htmlHeader);
        }
        List pages = this.jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            int i = this.startPageIndex;
            while (i <= this.endPageIndex) {
                page = (JRPrintPage)pages.get(i);
                this.sbuffer.append("<a name=\"JR_PAGE_ANCHOR_" + (i + 1) + "\">\n");
                this.exportPage(page);
                if (this.betweenPagesHtml == null) {
                    this.sbuffer.append("<br>\n<br>\n");
                } else {
                    this.sbuffer.append(this.betweenPagesHtml);
                }
                this.sbuffer.append("\n");
                ++i;
            }
        }
        if (this.htmlFooter == null) {
            this.sbuffer.append("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.sbuffer.append("</table>\n");
            this.sbuffer.append("</body>\n");
            this.sbuffer.append("</html>\n");
        } else {
            this.sbuffer.append(this.htmlFooter);
        }
        return this.sbuffer;
    }

    private void exportPage(JRPrintPage page) throws JRException {
        this.sbuffer.append("<table width=" + this.jasperPrint.getPageWidth() + " cellpadding=0 cellspacing=0 border=0 bgcolor=white>\n");
        this.layoutGrid(page);
        this.sbuffer.append("<tr>\n");
        int width = 0;
        int i = 1;
        while (i < this.xCuts.size()) {
            width = (Integer)this.xCuts.get(i) - (Integer)this.xCuts.get(i - 1);
            this.sbuffer.append("  <td><img src=\"" + this.imagesURI + "px\" width=" + width + " height=1></td>\n");
            ++i;
        }
        this.sbuffer.append("</tr>\n");
        JRPrintElement element = null;
        int y = 0;
        while (y < this.grid.length) {
            this.sbuffer.append("<tr valign=top>\n");
            int emptyCellColSpan = 0;
            int emptyCellWidth = 0;
            int lastRowHeight = this.grid[y][0].height;
            int x = 0;
            while (x < this.grid[y].length) {
                if (this.grid[y][x].element != null) {
                    if (emptyCellColSpan > 0) {
                        this.sbuffer.append("  <td");
                        if (emptyCellColSpan > 1) {
                            this.sbuffer.append(" colspan=" + emptyCellColSpan);
                        }
                        this.sbuffer.append("><img src=\"" + this.imagesURI + "px\" width=" + emptyCellWidth + " height=" + lastRowHeight + "></td>\n");
                        emptyCellColSpan = 0;
                        emptyCellWidth = 0;
                    }
                    if (!((element = this.grid[y][x].element) instanceof JRPrintLine) && !(element instanceof JRPrintRectangle)) {
                        if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, this.grid[y][x]);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, this.grid[y][x]);
                        }
                    }
                    x += this.grid[y][x].colSpan - 1;
                } else {
                    ++emptyCellColSpan;
                    emptyCellWidth += this.grid[y][x].width;
                }
                ++x;
            }
            if (emptyCellColSpan > 0) {
                this.sbuffer.append("  <td");
                if (emptyCellColSpan > 1) {
                    this.sbuffer.append(" colspan=" + emptyCellColSpan);
                }
                this.sbuffer.append("><img src=\"" + this.imagesURI + "px\" width=" + emptyCellWidth + " height=" + lastRowHeight + "></td>\n");
            }
            this.sbuffer.append("</tr>\n");
            ++y;
        }
        this.sbuffer.append("</table>\n");
    }

    private void exportText(JRPrintText text, JRExporterGridCell gridCell) {
        JRFont font;
        this.sbuffer.append("  <td");
        if (gridCell.colSpan > 1) {
            this.sbuffer.append(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.sbuffer.append(" rowspan=" + gridCell.rowSpan);
        }
        StringBuffer styleBuffer = new StringBuffer();
        if (text.getBackcolor().getRGB() != Color.white.getRGB() && text.getMode() == 1) {
            styleBuffer.append("background-color: #");
            String hexa = Integer.toHexString(text.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            styleBuffer.append(hexa);
            styleBuffer.append("; ");
        }
        String textAlignment = CSS_TEXT_ALIGN_LEFT;
        if (text.getText() != null && text.getText().length() > 0) {
            switch (text.getTextAlignment()) {
                case 1: {
                    textAlignment = CSS_TEXT_ALIGN_LEFT;
                    break;
                }
                case 2: {
                    textAlignment = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case 3: {
                    textAlignment = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case 4: {
                    textAlignment = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    textAlignment = CSS_TEXT_ALIGN_LEFT;
                }
            }
            if (textAlignment != CSS_TEXT_ALIGN_LEFT) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(textAlignment);
                styleBuffer.append(";");
            }
        }
        if (styleBuffer.length() > 0) {
            this.sbuffer.append(" style=\"");
            this.sbuffer.append(styleBuffer.toString());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">");
        if (text.getAnchorName() != null) {
            this.sbuffer.append("<a name=\"");
            this.sbuffer.append(text.getAnchorName());
            this.sbuffer.append("\">");
        }
        String href = null;
        switch (text.getHyperlinkType()) {
            case 2: {
                if (text.getHyperlinkReference() == null) break;
                href = text.getHyperlinkReference();
                break;
            }
            case 3: {
                if (text.getHyperlinkAnchor() == null) break;
                href = "#" + text.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (text.getHyperlinkPage() == null) break;
                href = "#JR_PAGE_ANCHOR_" + text.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkAnchor() == null) break;
                href = text.getHyperlinkReference() + "#" + text.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkPage() == null) break;
                href = text.getHyperlinkReference() + "#JR_PAGE_ANCHOR_" + text.getHyperlinkPage().toString();
                break;
            }
        }
        if (href != null) {
            this.sbuffer.append("<a href=\"");
            this.sbuffer.append(href);
            this.sbuffer.append("\">");
        }
        if ((font = text.getFont()) == null) {
            font = this.getDefaultFont();
        }
        if (text.getText() != null && text.getText().length() > 0) {
            this.sbuffer.append("<font face=\"");
            this.sbuffer.append(font.getFontName());
            this.sbuffer.append("\" style=\"");
            if (text.getForecolor().getRGB() != Color.black.getRGB()) {
                this.sbuffer.append("color: #");
                String hexa = Integer.toHexString(text.getForecolor().getRGB() & colorMask).toUpperCase();
                hexa = ("000000" + hexa).substring(hexa.length());
                this.sbuffer.append(hexa);
                this.sbuffer.append("; ");
            }
            this.sbuffer.append("font-size: ");
            this.sbuffer.append(font.getSize());
            this.sbuffer.append("px;");
            if (textAlignment != CSS_TEXT_ALIGN_LEFT) {
                this.sbuffer.append(" text-align: ");
                this.sbuffer.append(textAlignment);
                this.sbuffer.append(";");
            }
            if (font.isUnderline()) {
                this.sbuffer.append(" text-decoration: underline;");
            }
            if (font.isStrikeThrough()) {
                this.sbuffer.append(" text-decoration: line-through;");
            }
            this.sbuffer.append("\">");
            if (font.isBold()) {
                this.sbuffer.append("<b>");
            }
            if (font.isItalic()) {
                this.sbuffer.append("<i>");
            }
            this.sbuffer.append(JRHtmlExporter.replaceNewLineWithBR(JRStringUtil.xmlEncode(text.getText())));
            if (font.isItalic()) {
                this.sbuffer.append("</i>");
            }
            if (font.isBold()) {
                this.sbuffer.append("</b>");
            }
            this.sbuffer.append("</font>");
        } else {
            this.sbuffer.append("<img src=\"" + this.imagesURI + "px\" border=0>");
        }
        if (href != null) {
            this.sbuffer.append("</a>");
        }
        this.sbuffer.append("</td>\n");
    }

    private void exportImage(JRPrintImage image, JRExporterGridCell gridCell) throws JRException {
        this.sbuffer.append("  <td");
        if (gridCell.colSpan > 1) {
            this.sbuffer.append(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.sbuffer.append(" rowspan=" + gridCell.rowSpan);
        }
        if (image.getBackcolor().getRGB() != Color.white.getRGB() && image.getMode() == 1) {
            this.sbuffer.append(" bgcolor=#");
            String hexa = Integer.toHexString(image.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.sbuffer.append(hexa);
        }
        this.sbuffer.append(">");
        if (image.getAnchorName() != null) {
            this.sbuffer.append("<a name=\"");
            this.sbuffer.append(image.getAnchorName());
            this.sbuffer.append("\">");
        }
        String href = null;
        switch (image.getHyperlinkType()) {
            case 2: {
                if (image.getHyperlinkReference() == null) break;
                href = image.getHyperlinkReference();
                break;
            }
            case 3: {
                if (image.getHyperlinkAnchor() == null) break;
                href = "#" + image.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (image.getHyperlinkPage() == null) break;
                href = "#JR_PAGE_ANCHOR_" + image.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (image.getHyperlinkReference() == null || image.getHyperlinkAnchor() == null) break;
                href = image.getHyperlinkReference() + "#" + image.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (image.getHyperlinkReference() == null || image.getHyperlinkPage() == null) break;
                href = image.getHyperlinkReference() + "#JR_PAGE_ANCHOR_" + image.getHyperlinkPage().toString();
                break;
            }
        }
        if (href != null) {
            this.sbuffer.append("<a href=\"");
            this.sbuffer.append(href);
            this.sbuffer.append("\">");
        }
        this.sbuffer.append("<img");
        String imageSource = "";
        byte[] imageData = image.getImageData();
        if (this.loadedImagesMap.containsKey(imageData)) {
            imageSource = this.imagesURI + (String)this.loadedImagesMap.get(imageData);
        } else {
            imageSource = "img_" + String.valueOf(this.loadedImagesMap.size());
            this.loadedImagesMap.put(imageData, imageSource);
            imageSource = this.imagesURI + imageSource;
        }
        this.sbuffer.append(" src=\"");
        this.sbuffer.append(imageSource);
        this.sbuffer.append("\"");
        int borderWidth = 0;
        switch (image.getPen()) {
            case 4: {
                borderWidth = 1;
                break;
            }
            case 3: {
                borderWidth = 4;
                break;
            }
            case 2: {
                borderWidth = 2;
                break;
            }
            case 0: {
                borderWidth = 0;
                break;
            }
            case 5: {
                borderWidth = 1;
                break;
            }
            default: {
                borderWidth = 1;
            }
        }
        this.sbuffer.append(" border=");
        this.sbuffer.append(borderWidth);
        switch (image.getScaleImage()) {
            case 2: {
                this.sbuffer.append(" width=");
                this.sbuffer.append(image.getWidth());
                this.sbuffer.append(" height=");
                this.sbuffer.append(image.getHeight());
                break;
            }
            default: {
                Image awtImage = JRImageLoader.loadImage(imageData);
                if (image.getHeight() <= 0) break;
                double ratio = (double)awtImage.getWidth(null) / (double)awtImage.getHeight(null);
                if (ratio > (double)image.getWidth() / (double)image.getHeight()) {
                    this.sbuffer.append(" width=");
                    this.sbuffer.append(image.getWidth());
                    break;
                }
                this.sbuffer.append(" height=");
                this.sbuffer.append(image.getHeight());
            }
        }
        this.sbuffer.append(">");
        if (href != null) {
            this.sbuffer.append("</a>");
        }
        this.sbuffer.append("</td>\n");
    }

    private void layoutGrid(JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.jasperPrint.getPageHeight()));
        Integer x = null;
        Integer y = null;
        Collection elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            if (element instanceof JRPrintLine || element instanceof JRPrintRectangle || !(element instanceof JRPrintImage) && !(element instanceof JRPrintText)) continue;
            x = new Integer(element.getX());
            if (!this.xCuts.contains(x)) {
                this.xCuts.add(x);
            }
            if (!this.xCuts.contains(x = new Integer(element.getX() + element.getWidth()))) {
                this.xCuts.add(x);
            }
            if (!this.yCuts.contains(y = new Integer(element.getY()))) {
                this.yCuts.add(y);
            }
            if (this.yCuts.contains(y = new Integer(element.getY() + element.getHeight()))) continue;
            this.yCuts.add(y);
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        int j = 0;
        while (j < yCellCount) {
            int i = 0;
            while (i < xCellCount) {
                this.grid[j][i] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
                ++i;
            }
            ++j;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        Iterator it2 = elems.iterator();
        while (it2.hasNext()) {
            JRPrintElement element = (JRPrintElement)it2.next();
            if (element instanceof JRPrintLine || element instanceof JRPrintRectangle || !(element instanceof JRPrintImage) && !(element instanceof JRPrintText)) continue;
            x1 = this.xCuts.indexOf(new Integer(element.getX()));
            y1 = this.yCuts.indexOf(new Integer(element.getY()));
            x2 = this.xCuts.indexOf(new Integer(element.getX() + element.getWidth()));
            y2 = this.yCuts.indexOf(new Integer(element.getY() + element.getHeight()));
            this.grid[y1][x1].element = element;
            this.grid[y1][x1].width = element.getWidth();
            this.grid[y1][x1].height = element.getHeight();
            this.grid[y1][x1].colSpan = x2 - x1;
            this.grid[y1][x1].rowSpan = y2 - y1;
        }
    }

    private static String replaceNewLineWithBR(String source) {
        String str = null;
        if (source != null) {
            StringBuffer sbuffer = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(source, "\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    sbuffer.append("<br>");
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
        }
        return str;
    }
}

