/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColorDetails;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfColorDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFontDictionary;
import com.lowagie.text.pdf.PdfFormXObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPatternDictionary;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfProcSet;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfXObjectDictionary;
import java.awt.Color;
import java.io.IOException;

public class PdfTemplate
extends PdfContentByte {
    public static final int TYPE_TEMPLATE = 1;
    public static final int TYPE_IMPORTED = 2;
    public static final int TYPE_PATTERN = 3;
    protected int type = 1;
    protected PdfIndirectReference thisReference;
    protected PdfFontDictionary fontDictionary;
    protected PdfXObjectDictionary xObjectDictionary;
    protected PdfColorDictionary colorDictionary;
    protected PdfPatternDictionary patternDictionary;
    protected Rectangle bBox = new Rectangle(0.0f, 0.0f);
    protected PdfArray matrix;

    protected PdfTemplate() {
        super(null);
    }

    PdfTemplate(PdfWriter pdfWriter) {
        super(pdfWriter);
        this.fontDictionary = new PdfFontDictionary();
        this.xObjectDictionary = new PdfXObjectDictionary();
        this.colorDictionary = new PdfColorDictionary();
        this.patternDictionary = new PdfPatternDictionary();
        this.thisReference = this.writer.getPdfIndirectReference();
    }

    public void setWidth(float f) {
        this.bBox.setLeft(0.0f);
        this.bBox.setRight(f);
    }

    public void setHeight(float f) {
        this.bBox.setBottom(0.0f);
        this.bBox.setTop(f);
    }

    public float getWidth() {
        return this.bBox.width();
    }

    public float getHeight() {
        return this.bBox.height();
    }

    public Rectangle getBoundingBox() {
        return this.bBox;
    }

    public void setBoundingBox(Rectangle rectangle) {
        this.bBox = rectangle;
    }

    public void setMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.matrix = new PdfArray();
        this.matrix.add(new PdfNumber(f));
        this.matrix.add(new PdfNumber(f2));
        this.matrix.add(new PdfNumber(f3));
        this.matrix.add(new PdfNumber(f4));
        this.matrix.add(new PdfNumber(f5));
        this.matrix.add(new PdfNumber(f6));
    }

    PdfArray getMatrix() {
        return this.matrix;
    }

    PdfIndirectReference getIndirectReference() {
        return this.thisReference;
    }

    public void addTemplate(PdfTemplate pdfTemplate, float f, float f2, float f3, float f4, float f5, float f6) {
        this.checkNoPattern(pdfTemplate);
        PdfName pdfName = this.writer.addDirectTemplateSimple(pdfTemplate);
        this.content.append("q ");
        this.content.append(f).append(' ');
        this.content.append(f2).append(' ');
        this.content.append(f3).append(' ');
        this.content.append(f4).append(' ');
        this.content.append(f5).append(' ');
        this.content.append(f6).append(" cm ");
        this.content.append(pdfName.toString()).append(" Do Q").append_i(this.separator);
        this.xObjectDictionary.put(pdfName, pdfTemplate.getIndirectReference());
    }

    public void addImage(Image image, float f, float f2, float f3, float f4, float f5, float f6) throws DocumentException {
        try {
            PdfName pdfName;
            if (image.isImgTemplate()) {
                pdfName = this.pdf.addDirectImageSimple(image);
                PdfTemplate pdfTemplate = image.templateData();
                float f7 = pdfTemplate.getWidth();
                float f8 = pdfTemplate.getHeight();
                this.addTemplate(pdfTemplate, f / f7, f2 / f7, f3 / f8, f4 / f8, f5, f6);
            } else {
                Image image2 = image.getImageMask();
                if (image2 != null) {
                    PdfName pdfName2 = this.pdf.addDirectImageSimple(image2);
                    this.xObjectDictionary.put(pdfName2, this.writer.getImageReference(pdfName2));
                }
                pdfName = this.pdf.addDirectImageSimple(image);
                this.content.append("q ");
                this.content.append(f).append(' ');
                this.content.append(f2).append(' ');
                this.content.append(f3).append(' ');
                this.content.append(f4).append(' ');
                this.content.append(f5).append(' ');
                this.content.append(f6).append(" cm ");
                this.content.append(pdfName.toString()).append(" Do Q").append_i(this.separator);
            }
            if (!image.isImgTemplate()) {
                this.xObjectDictionary.put(pdfName, this.writer.getImageReference(pdfName));
            }
        }
        catch (Exception exception) {
            throw new DocumentException(exception.getMessage());
        }
    }

    public void setColorFill(PdfSpotColor pdfSpotColor, float f) {
        this.state.colorDetails = this.writer.addSimple(pdfSpotColor);
        this.colorDictionary.put(this.state.colorDetails.getColorName(), this.state.colorDetails.getIndirectReference());
        this.content.append(this.state.colorDetails.getColorName().toPdf(null)).append(" cs ").append(f).append(" scn").append_i(this.separator);
    }

    public void setColorStroke(PdfSpotColor pdfSpotColor, float f) {
        this.state.colorDetails = this.writer.addSimple(pdfSpotColor);
        this.colorDictionary.put(this.state.colorDetails.getColorName(), this.state.colorDetails.getIndirectReference());
        this.content.append(this.state.colorDetails.getColorName().toPdf(null)).append(" CS ").append(f).append(" SCN").append_i(this.separator);
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter) {
        if (pdfPatternPainter.isStencil()) {
            this.setPatternFill(pdfPatternPainter, pdfPatternPainter.getDefaultColor());
            return;
        }
        this.checkWriter();
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        this.patternDictionary.put(pdfName, pdfPatternPainter.getIndirectReference());
        this.content.append(PdfName.PATTERN.toPdf(null)).append(" cs ").append(pdfName.toPdf(null)).append(" scn").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter) {
        if (pdfPatternPainter.isStencil()) {
            this.setPatternStroke(pdfPatternPainter, pdfPatternPainter.getDefaultColor());
            return;
        }
        this.checkWriter();
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        this.patternDictionary.put(pdfName, pdfPatternPainter.getIndirectReference());
        this.content.append(PdfName.PATTERN.toPdf(null)).append(" CS ").append(pdfName.toPdf(null)).append(" SCN").append_i(this.separator);
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter, Color color, float f) {
        this.checkWriter();
        if (!pdfPatternPainter.isStencil()) {
            throw new RuntimeException("An uncolored pattern was expected.");
        }
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        this.patternDictionary.put(pdfName, pdfPatternPainter.getIndirectReference());
        ColorDetails colorDetails = this.writer.addSimplePatternColorspace(color);
        this.colorDictionary.put(colorDetails.getColorName(), colorDetails.getIndirectReference());
        this.content.append(colorDetails.getColorName().toPdf(null)).append(" cs").append_i(this.separator);
        this.outputColorNumbers(color, f);
        this.content.append(' ').append(pdfName.toPdf(null)).append(" scn").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter, Color color, float f) {
        this.checkWriter();
        if (!pdfPatternPainter.isStencil()) {
            throw new RuntimeException("An uncolored pattern was expected.");
        }
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        this.patternDictionary.put(pdfName, pdfPatternPainter.getIndirectReference());
        ColorDetails colorDetails = this.writer.addSimplePatternColorspace(color);
        this.colorDictionary.put(colorDetails.getColorName(), colorDetails.getIndirectReference());
        this.content.append(colorDetails.getColorName().toPdf(null)).append(" CS").append_i(this.separator);
        this.outputColorNumbers(color, f);
        this.content.append(' ').append(pdfName.toPdf(null)).append(" SCN").append_i(this.separator);
    }

    public void beginVariableText() {
        this.content.append("/Tx BMC ");
    }

    public void endVariableText() {
        this.content.append("EMC ");
    }

    PdfObject getResources() {
        PdfResources pdfResources = new PdfResources();
        int n = 1;
        if (this.fontDictionary.containsFont()) {
            pdfResources.add(this.fontDictionary);
            n |= 2;
        }
        if (this.xObjectDictionary.containsXObject()) {
            pdfResources.add(this.xObjectDictionary);
            n |= 8;
        }
        if (this.colorDictionary.containsColorSpace()) {
            pdfResources.add(this.colorDictionary);
        }
        if (this.patternDictionary.containsPattern()) {
            pdfResources.add(this.patternDictionary);
        }
        pdfResources.add(new PdfProcSet(n));
        return pdfResources;
    }

    PdfStream getFormXObject() throws IOException {
        return new PdfFormXObject(this);
    }

    public void setFontAndSize(BaseFont baseFont, float f) {
        this.state.size = f;
        this.state.fontDetails = this.writer.addSimple(baseFont);
        PdfName pdfName = this.state.fontDetails.getFontName();
        this.content.append(pdfName.toPdf(null)).append(' ').append(f).append(" Tf").append_i(this.separator);
        this.fontDictionary.put(pdfName, this.state.fontDetails.getIndirectReference());
    }

    public PdfContentByte getDuplicate() {
        PdfTemplate pdfTemplate = new PdfTemplate();
        pdfTemplate.writer = this.writer;
        pdfTemplate.pdf = this.pdf;
        pdfTemplate.thisReference = this.thisReference;
        pdfTemplate.fontDictionary = this.fontDictionary;
        pdfTemplate.xObjectDictionary = this.xObjectDictionary;
        pdfTemplate.colorDictionary = this.colorDictionary;
        pdfTemplate.patternDictionary = this.patternDictionary;
        pdfTemplate.bBox = new Rectangle(this.bBox);
        if (this.matrix != null) {
            pdfTemplate.matrix = new PdfArray(this.matrix);
        }
        return pdfTemplate;
    }

    public int getType() {
        return this.type;
    }
}

