/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPrintable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.UnsupportedEncodingException;

class PdfString
extends PdfObject
implements PdfPrintable {
    protected String value = "";
    protected String encoding = "ISO-8859-1";

    PdfString() {
        super(3, "");
    }

    PdfString(String string) {
        super(3, string);
        this.value = string;
    }

    PdfString(String string, String string2) {
        super(3, string);
        this.value = string;
        this.encoding = string2;
    }

    PdfString(byte[] byArray) {
        super(3, byArray);
        try {
            this.value = new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ExceptionConverter(unsupportedEncodingException);
        }
    }

    public final byte[] toPdf(PdfWriter pdfWriter) {
        byte[] byArray;
        try {
            byArray = this.value.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ExceptionConverter(unsupportedEncodingException);
        }
        PdfEncryption pdfEncryption = pdfWriter.getEncryption();
        if (pdfEncryption != null) {
            pdfEncryption.prepareKey();
            pdfEncryption.encryptRC4(byArray);
        }
        return PdfContentByte.escapeString(byArray);
    }

    public String toString() {
        return this.value;
    }

    byte[] get(PdfWriter pdfWriter) {
        return this.toPdf(pdfWriter);
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }
}

