/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRBand;
import dori.jasper.engine.JRElement;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillElement;
import dori.jasper.engine.fill.JRFillElementGroup;
import dori.jasper.engine.fill.JRFillGraphicElement;
import dori.jasper.engine.fill.JRFillSubreport;
import dori.jasper.engine.fill.JRPrintBand;
import dori.jasper.engine.fill.JRYComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JRFillBand
extends JRFillElementGroup
implements JRBand {
    private JRBand parent = null;
    protected JRBaseFiller filler = null;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    private boolean isOverflow = false;
    private boolean isPrintWhenExpressionNull = true;
    private boolean isPrintWhenTrue = true;
    private int stretchHeight = 0;
    private int firstY = 0;
    private boolean isFirstYFound = false;
    private boolean isNewPageColumn = false;
    private Map isNewGroupMap = new HashMap();

    protected JRFillBand(JRBaseFiller filler, JRBand band, Map fillObjectsMap) {
        super(filler, band, fillObjectsMap);
        this.parent = band;
        this.filler = filler;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> sortedElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> stretchElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> bandBottomElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> removableElemsList = new ArrayList<JRFillElement>();
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].setBand(this);
                this.elements[i].setBandBottomY(this.getHeight() - this.elements[i].getY() - this.elements[i].getHeight());
                sortedElemsList.add(this.elements[i]);
                if (this.elements[i] instanceof JRFillGraphicElement && ((JRFillGraphicElement)this.elements[i]).getStretchType() != 0) {
                    stretchElemsList.add(this.elements[i]);
                }
                if (this.elements[i].getPositionType() == 3) {
                    bandBottomElemsList.add(this.elements[i]);
                }
                if (this.elements[i].isRemoveLineWhenBlank()) {
                    removableElemsList.add(this.elements[i]);
                }
                ++i;
            }
            Collections.sort(sortedElemsList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            sortedElemsList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[stretchElemsList.size()];
            stretchElemsList.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[bandBottomElemsList.size()];
            bandBottomElemsList.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[removableElemsList.size()];
            removableElemsList.toArray(this.removableElements);
        }
        this.setDependentElements();
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            JRFillElement iElem = null;
            JRFillElement jElem = null;
            int left = 0;
            int right = 0;
            int i = 0;
            while (i < this.ySortedElements.length - 1) {
                iElem = this.ySortedElements[i];
                int j = i + 1;
                while (j < this.ySortedElements.length) {
                    jElem = this.ySortedElements[j];
                    left = iElem.getX() <= jElem.getX() ? iElem.getX() : jElem.getX();
                    int n = right = iElem.getX() + iElem.getWidth() >= jElem.getX() + jElem.getWidth() ? iElem.getX() + iElem.getWidth() : jElem.getX() + jElem.getWidth();
                    if (jElem.getPositionType() == 1 && iElem.getY() + iElem.getHeight() < jElem.getY() && iElem.getWidth() + jElem.getWidth() >= right - left) {
                        iElem.addDependantElement(jElem);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void setNewPageColumn(boolean isNew) {
        this.isNewPageColumn = isNew;
    }

    protected boolean isNewPageColumn() {
        return this.isNewPageColumn;
    }

    protected void setNewGroup(JRGroup group, boolean isNew) {
        this.isNewGroupMap.put(group, new Boolean(isNew));
    }

    protected boolean isNewGroup(JRGroup group) {
        Boolean value = (Boolean)this.isNewGroupMap.get(group);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public int getHeight() {
        return this.parent != null ? this.parent.getHeight() : 0;
    }

    public JRExpression getPrintWhenExpression() {
        return this.parent != null ? this.parent.getPrintWhenExpression() : null;
    }

    protected boolean willOverflow() {
        return this.willOverflow;
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.isPrintWhenExpressionNull;
    }

    protected void setPrintWhenExpressionNull(boolean isPrintWhenExpressionNull) {
        this.isPrintWhenExpressionNull = isPrintWhenExpressionNull;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected void evaluate(byte evaluation) throws JRException {
        JRElement[] elements = this.getElements();
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                ((JRFillElement)elements[i]).evaluate(evaluation);
                ++i;
            }
        }
    }

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isPrintWhenExpressionNull = true;
        boolean isPrintWhenTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            isPrintWhenExpressionNull = false;
            Boolean printWhenExpressionValue = (Boolean)this.filler.calculator.evaluate(expression, evaluation);
            isPrintWhenTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenExpressionNull(isPrintWhenExpressionNull);
        this.setPrintWhenTrue(isPrintWhenTrue);
    }

    protected JRPrintBand fill(int availableStretchHeight) throws JRException {
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.isFirstYFound = false;
        this.resetElements();
        this.prepareElements(availableStretchHeight);
        this.stretchElements();
        this.moveBandBottomElements();
        this.removeBlankElements();
        this.isNewPageColumn = false;
        this.isNewGroupMap = new HashMap();
        return this.fillElements();
    }

    private void resetElements() throws JRException {
        JRFillElement[] elements = this.ySortedElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            int i = 0;
            while (i < elements.length) {
                element = elements[i];
                element.reset();
                if (!this.isOverflow) {
                    element.setAlreadyPrinted(false);
                }
                ++i;
            }
        }
    }

    private void prepareElements(int availableStretchHeight) throws JRException {
        boolean willOverflow = false;
        int maxStretch = 0;
        int stretch = 0;
        JRFillElement[] elements = this.ySortedElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            int i = 0;
            while (i < elements.length) {
                element = elements[i];
                willOverflow = element.prepare(availableStretchHeight, this.isOverflow) || willOverflow;
                element.moveDependantElements();
                if (element.isToPrint()) {
                    if (this.isOverflow) {
                        if (element.isReprinted()) {
                            this.firstY = 0;
                        } else if (!this.isFirstYFound) {
                            this.firstY = element.getY();
                        }
                        this.isFirstYFound = true;
                    }
                    if ((stretch = element.getRelativeY() + element.getStretchHeight() - element.getY() - element.getHeight()) > maxStretch) {
                        maxStretch = stretch;
                    }
                }
                ++i;
            }
        }
        this.stretchHeight = willOverflow ? this.getHeight() + availableStretchHeight : this.getHeight() + maxStretch;
        this.willOverflow = willOverflow;
    }

    private void stretchElements() throws JRException {
        JRFillElement[] elements = this.stretchElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            int i = 0;
            while (i < elements.length) {
                element = elements[i];
                element.stretchElement(this.stretchHeight - this.getHeight());
                element.moveDependantElements();
                ++i;
            }
        }
    }

    private void moveBandBottomElements() throws JRException {
        JRFillElement[] elements = this.bandBottomElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            int i = 0;
            while (i < elements.length) {
                element = elements[i];
                element.setRelativeY(element.getY() + this.stretchHeight - this.getHeight());
                element.setToPrint(!this.willOverflow);
                ++i;
            }
        }
    }

    private void removeBlankElements() throws JRException {
        JRFillElement[] remElems = this.removableElements;
        if (remElems != null && remElems.length > 0) {
            JRFillElement[] elems = this.ySortedElements;
            JRFillElement iElem = null;
            JRFillElement jElem = null;
            int top = 0;
            int bottom = 0;
            boolean isToRemove = true;
            int i = 0;
            while (i < remElems.length) {
                iElem = remElems[i];
                if (!iElem.isToPrint() && iElem.getRelativeY() + iElem.getStretchHeight() <= this.stretchHeight && iElem.getRelativeY() >= this.firstY) {
                    isToRemove = true;
                    int j = 0;
                    while (j < elems.length) {
                        jElem = elems[j];
                        if (iElem != jElem && jElem.isToPrint()) {
                            top = iElem.getRelativeY() <= jElem.getRelativeY() ? iElem.getRelativeY() : jElem.getRelativeY();
                            int n = bottom = iElem.getRelativeY() + iElem.getHeight() >= jElem.getRelativeY() + jElem.getStretchHeight() ? iElem.getRelativeY() + iElem.getHeight() : jElem.getRelativeY() + jElem.getStretchHeight();
                            if (iElem.getHeight() + jElem.getStretchHeight() >= bottom - top) {
                                isToRemove = false;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (isToRemove) {
                        int j2 = 0;
                        while (j2 < elems.length) {
                            jElem = elems[j2];
                            if (jElem.getRelativeY() >= iElem.getRelativeY() + iElem.getHeight()) {
                                jElem.setRelativeY(jElem.getRelativeY() - iElem.getHeight());
                            }
                            ++j2;
                        }
                        this.stretchHeight -= iElem.getHeight();
                    }
                }
                ++i;
            }
        }
    }

    private JRPrintBand fillElements() throws JRException {
        JRPrintBand printBand = new JRPrintBand();
        JRElement[] elements = this.getElements();
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            JRPrintElement printElement = null;
            int i = 0;
            while (i < elements.length) {
                element = (JRFillElement)elements[i];
                element.setRelativeY(element.getRelativeY() - this.firstY);
                if (element.getRelativeY() + element.getStretchHeight() > this.stretchHeight) {
                    element.setToPrint(false);
                }
                element.setAlreadyPrinted(element.isToPrint() || element.isAlreadyPrinted());
                if (element.isToPrint() && (printElement = element.fill()) != null) {
                    Collection printElements;
                    printBand.addElement(printElement);
                    if (element instanceof JRFillSubreport && (printElements = ((JRFillSubreport)element).getPrintElements()) != null && printElements.size() > 0) {
                        Iterator it = printElements.iterator();
                        while (it.hasNext()) {
                            printElement = (JRPrintElement)it.next();
                            printElement.setX(element.getX() + printElement.getX());
                            printElement.setY(element.getRelativeY() + printElement.getY());
                            printBand.addElement(printElement);
                        }
                    }
                }
                ++i;
            }
        }
        printBand.setHeight(this.stretchHeight - this.firstY);
        return printBand;
    }
}

