/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.export.JRGraphics2DExporter;
import dori.jasper.engine.export.JRGraphics2DExporterParameter;
import dori.jasper.engine.export.JRPrintServiceExporterParameter;
import dori.jasper.engine.util.JRLoader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;

public class JRPrintServiceExporter
extends JRAbstractExporter
implements Printable {
    private JasperPrint jasperPrint = null;
    private JRGraphics2DExporter exporter = null;
    private PrintService printService = null;
    private PrintRequestAttributeSet printRequestAttributeSet = null;
    private PrintServiceAttributeSet printServiceAttributeSet = null;
    private boolean displayPageDialog = false;
    private boolean displayPrintDialog = false;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportReport() throws JRException {
        Boolean printDialog;
        Boolean pageDialog;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName == null) throw new JRException("No input source supplied to the exporter.");
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                    }
                }
            }
        }
        this.exporter = new JRGraphics2DExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
        this.printRequestAttributeSet = (PrintRequestAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET);
        if (this.printRequestAttributeSet == null) {
            this.printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        HashAttributeSet attributeSet = new HashAttributeSet();
        attributeSet.addAll(this.printRequestAttributeSet);
        this.printServiceAttributeSet = (PrintServiceAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET);
        if (this.printRequestAttributeSet != null) {
            attributeSet.addAll(this.printServiceAttributeSet);
        }
        if ((pageDialog = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG)) != null) {
            this.displayPageDialog = pageDialog;
        }
        if ((printDialog = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG)) != null) {
            this.displayPrintDialog = printDialog;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, attributeSet);
        if (services.length <= 0) throw new JRException("No suitable print service found.");
        try {
            printerJob.setPrintService(services[0]);
            if (!this.printRequestAttributeSet.containsKey(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = JRPrintServiceExporter.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
                this.printRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, (float)this.jasperPrint.getPageWidth() / 72.0f, (float)this.jasperPrint.getPageHeight() / 72.0f, 25400));
            }
            if (this.displayPageDialog) {
                printerJob.pageDialog(this.printRequestAttributeSet);
            }
            if (this.displayPrintDialog) {
                if (!printerJob.printDialog(this.printRequestAttributeSet)) return;
                printerJob.print(this.printRequestAttributeSet);
                return;
            } else {
                printerJob.print(this.printRequestAttributeSet);
            }
            return;
        }
        catch (PrinterException e) {
            throw new JRException(e);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex < 0 || pageIndex >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, (Graphics2D)graphics);
        this.exporter.setParameter(JRGraphics2DExporterParameter.PAGE_INDEX, new Integer(pageIndex));
        try {
            this.exporter.exportReport();
        }
        catch (JRException e) {
            throw new PrinterException(e.getMessage());
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

