/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.SSTRecordHeader;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.LittleEndian;

class RecordProcessor {
    private byte[] data;
    private int recordOffset;
    private int available;
    private SSTRecordHeader sstRecordHeader;

    public RecordProcessor(byte[] data, int available, int numStrings, int numUniqueStrings) {
        this.data = data;
        this.available = available;
        this.sstRecordHeader = new SSTRecordHeader(numStrings, numUniqueStrings);
    }

    public int getAvailable() {
        return this.available;
    }

    public void writeRecordHeader(int offset, int totalWritten, int recordLength, boolean first_record) {
        if (first_record) {
            this.available -= 8;
            this.recordOffset = this.sstRecordHeader.writeSSTHeader(this.data, this.recordOffset + offset + totalWritten, recordLength);
        } else {
            this.recordOffset = this.writeContinueHeader(this.data, this.recordOffset + offset + totalWritten, recordLength);
        }
    }

    public byte[] writeStringRemainder(boolean lastStringCompleted, byte[] stringreminant, int offset, int totalWritten) {
        if (!lastStringCompleted) {
            System.arraycopy(stringreminant, 0, this.data, this.recordOffset + offset + totalWritten, stringreminant.length);
            this.adjustPointers(stringreminant.length);
        } else {
            System.arraycopy(stringreminant, 0, this.data, this.recordOffset + offset + totalWritten, this.available);
            byte[] leftover = new byte[stringreminant.length - this.available + 1];
            System.arraycopy(stringreminant, this.available, leftover, 1, stringreminant.length - this.available);
            leftover[0] = stringreminant[0];
            stringreminant = leftover;
            this.adjustPointers(this.available);
        }
        return stringreminant;
    }

    public void writeWholeString(UnicodeString unistr, int offset, int totalWritten) {
        unistr.serialize(this.recordOffset + offset + totalWritten, this.data);
        int rsize = unistr.getRecordSize();
        this.adjustPointers(rsize);
    }

    public byte[] writePartString(UnicodeString unistr, int offset, int totalWritten) {
        byte[] ucs = unistr.serialize();
        System.arraycopy(ucs, 0, this.data, this.recordOffset + offset + totalWritten, this.available);
        byte[] stringReminant = new byte[ucs.length - this.available + 1];
        System.arraycopy(ucs, this.available, stringReminant, 1, ucs.length - this.available);
        stringReminant[0] = ucs[2];
        this.available = 0;
        return stringReminant;
    }

    private int writeContinueHeader(byte[] data, int pos, int recsize) {
        int offset = pos;
        LittleEndian.putShort(data, offset, (short)60);
        LittleEndian.putShort(data, offset += 2, (short)recsize);
        return (offset += 2) - pos;
    }

    private void adjustPointers(int amount) {
        this.recordOffset += amount;
        this.available -= amount;
    }
}

