/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfPrintable;

class PdfFont
implements Comparable {
    public static final int COURIER = 0;
    public static final int COURIER_BOLD = 1;
    public static final int COURIER_OBLIQUE = 2;
    public static final int COURIER_BOLDOBLIQUE = 3;
    public static final int HELVETICA = 4;
    public static final int HELVETICA_BOLD = 5;
    public static final int HELVETICA_OBLIQUE = 6;
    public static final int HELVETICA_BOLDOBLIQUE = 7;
    public static final int SYMBOL = 8;
    public static final int TIMES_ROMAN = 9;
    public static final int TIMES_BOLD = 10;
    public static final int TIMES_ITALIC = 11;
    public static final int TIMES_BOLDITALIC = 12;
    public static final int ZAPFDINGBATS = 13;
    private PdfName name;
    private BaseFont font;
    private float size;
    protected Image image;

    PdfFont(String string, int n, float f, int n2) {
        String string2 = "Helvetica";
        this.size = f;
        switch (n) {
            case 0: {
                string2 = "Courier";
                break;
            }
            case 1: {
                string2 = "Courier-Bold";
                break;
            }
            case 2: {
                string2 = "Courier-Oblique";
                break;
            }
            case 3: {
                string2 = "Courier-BoldOblique";
                break;
            }
            case 4: {
                string2 = "Helvetica";
                break;
            }
            case 5: {
                string2 = "Helvetica-Bold";
                break;
            }
            case 6: {
                string2 = "Helvetica-Oblique";
                break;
            }
            case 7: {
                string2 = "Helvetica-BoldOblique";
                break;
            }
            case 8: {
                string2 = "Symbol";
                break;
            }
            case 9: {
                string2 = "Times-Roman";
                break;
            }
            case 10: {
                string2 = "Times-Bold";
                break;
            }
            case 11: {
                string2 = "Times-Italic";
                break;
            }
            case 12: {
                string2 = "Times-BoldItalic";
                break;
            }
            case 13: {
                string2 = "ZapfDingbats";
            }
        }
        try {
            this.font = BaseFont.createFont(string2, "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    PdfFont(int n, float f, int n2) {
        this("F" + n, n, f, n2);
    }

    PdfFont(int n, float f) {
        this("F" + n, n, f, -1);
    }

    PdfFont(BaseFont baseFont, float f) {
        this.size = f;
        this.font = baseFont;
    }

    public final int compareTo(Object object) {
        if (this.image != null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        try {
            PdfFont pdfFont = (PdfFont)object;
            if (this.font != pdfFont.font) {
                return 1;
            }
            if (this.size() != pdfFont.size()) {
                return 2;
            }
            return 0;
        }
        catch (ClassCastException classCastException) {
            return -2;
        }
    }

    float size() {
        if (this.image == null) {
            return this.size;
        }
        return this.image.scaledHeight();
    }

    PdfName getName() {
        return this.name;
    }

    void setName(PdfName pdfName) {
        this.name = pdfName;
    }

    float width() {
        if (this.image == null) {
            return this.font.getWidthPoint(" ", this.size);
        }
        return this.image.scaledWidth();
    }

    float width(char c) {
        if (this.image == null) {
            return this.font.getWidthPoint(c, this.size);
        }
        return this.image.scaledWidth();
    }

    float width(PdfPrintable pdfPrintable) {
        if (this.image == null) {
            return this.font.getWidthPoint(pdfPrintable.toString(), this.size);
        }
        return this.image.scaledWidth();
    }

    BaseFont getFont() {
        return this.font;
    }

    void setImage(Image image) {
        this.image = image;
    }
}

