/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class FontDetails {
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    byte[] shortTag;
    HashMap longTag;
    int fontType;
    boolean symbolic;
    protected boolean subset = true;

    FontDetails(PdfName pdfName, PdfIndirectReference pdfIndirectReference, BaseFont baseFont) {
        this.fontName = pdfName;
        this.indirectReference = pdfIndirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    byte[] convertToBytes(String string) {
        byte[] byArray = null;
        switch (this.fontType) {
            case 0: 
            case 1: {
                byArray = this.baseFont.convertToBytes(string);
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    this.shortTag[byArray[n2] & 0xFF] = 1;
                    ++n2;
                }
                break;
            }
            case 2: {
                byArray = this.baseFont.convertToBytes(string);
                break;
            }
            case 3: {
                try {
                    int n;
                    int n3 = string.length();
                    int[] nArray = null;
                    char[] cArray = new char[n3];
                    int n4 = 0;
                    if (this.symbolic) {
                        try {
                            byArray = string.getBytes("ISO-8859-1");
                        }
                        catch (Exception exception) {
                            throw new ExceptionConverter(exception);
                        }
                        n3 = byArray.length;
                        n = 0;
                        while (n < n3) {
                            nArray = this.ttu.getMetricsTT(byArray[n] & 0xFF);
                            if (nArray != null) {
                                this.longTag.put(new Integer(nArray[0]), new int[]{nArray[0], nArray[1], this.ttu.getUnicodeDifferences(byArray[n] & 0xFF)});
                                cArray[n4++] = (char)nArray[0];
                            }
                            ++n;
                        }
                    } else {
                        n = 0;
                        while (n < n3) {
                            char c = string.charAt(n);
                            nArray = this.ttu.getMetricsTT(c);
                            if (nArray != null) {
                                int n5 = nArray[0];
                                Integer n6 = new Integer(n5);
                                if (!this.longTag.containsKey(n6)) {
                                    this.longTag.put(n6, new int[]{n5, nArray[1], c});
                                }
                                cArray[n4++] = (char)n5;
                            }
                            ++n;
                        }
                    }
                    String string2 = new String(cArray, 0, n4);
                    byArray = string2.getBytes("UnicodeBigUnmarked");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ExceptionConverter(unsupportedEncodingException);
                }
            }
        }
        return byArray;
    }

    void writeFont(PdfWriter pdfWriter) {
        try {
            switch (this.fontType) {
                case 0: 
                case 1: {
                    int n;
                    int n2;
                    if (this.subset) {
                        n2 = 0;
                        while (n2 < 256) {
                            if (this.shortTag[n2] != 0) break;
                            ++n2;
                        }
                        n = 255;
                        while (n >= n2) {
                            if (this.shortTag[n] != 0) break;
                            --n;
                        }
                        if (n2 > 255) {
                            n2 = 255;
                            n = 255;
                        }
                    } else {
                        int n3 = 0;
                        while (n3 < this.shortTag.length) {
                            this.shortTag[n3] = 1;
                            ++n3;
                        }
                        n2 = 0;
                        n = this.shortTag.length - 1;
                    }
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{new Integer(n2), new Integer(n), this.shortTag});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, null);
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{this.longTag});
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }
}

