/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Paragraph;
import com.lowagie.text.TextElementArray;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class Section
extends ArrayList
implements TextElementArray {
    protected Paragraph title;
    protected int numberDepth;
    protected float indentationLeft;
    protected float indentationRight;
    protected float sectionIndent;
    protected int subsections = 0;
    protected ArrayList numbers = null;
    protected boolean bookmarkOpen = true;

    protected Section() {
        this.title = new Paragraph();
        this.numberDepth = 1;
    }

    Section(Paragraph paragraph, int n) {
        this.numberDepth = n;
        this.title = paragraph;
    }

    private final void setNumbers(int n, ArrayList arrayList) {
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(n));
        this.numbers.addAll(arrayList);
    }

    public final boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = ((AbstractList)this).iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 13;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void add(int n, Object object) {
        try {
            Element element = (Element)object;
            if (element.type() != 12 && element.type() != 14 && element.type() != 10 && element.type() != 11 && element.type() != 17 && element.type() != 29 && element.type() != 22 && element.type() != 23 && element.type() != 35 && element.type() != 31 && element.type() != 32 && element.type() != 33 && element.type() != 34) {
                throw new ClassCastException(String.valueOf(element.type()));
            }
            super.add(n, element);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean add(Object object) {
        try {
            Element element = (Element)object;
            if (element.type() == 12 || element.type() == 14 || element.type() == 10 || element.type() == 11 || element.type() == 17 || element.type() == 29 || element.type() == 22 || element.type() == 35 || element.type() == 23 || element.type() == 31 || element.type() == 32 || element.type() == 33 || element.type() == 34) {
                return super.add(object);
            }
            if (element.type() == 13) {
                Section section = (Section)object;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(section);
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public final Section addSection(float f, Paragraph paragraph, int n) {
        Section section = new Section(paragraph, n);
        section.setIndentation(f);
        this.add(section);
        return section;
    }

    public final Section addSection(float f, Paragraph paragraph) {
        Section section = new Section(paragraph, 1);
        section.setIndentation(f);
        this.add(section);
        return section;
    }

    public final Section addSection(Paragraph paragraph, int n) {
        Section section = new Section(paragraph, n);
        this.add(section);
        return section;
    }

    public final Section addSection(Paragraph paragraph) {
        Section section = new Section(paragraph, 1);
        this.add(section);
        return section;
    }

    public final Section addSection(float f, String string, int n) {
        Section section = new Section(new Paragraph(string), n);
        section.setIndentation(f);
        this.add(section);
        return section;
    }

    public final Section addSection(String string, int n) {
        Section section = new Section(new Paragraph(string), n);
        this.add(section);
        return section;
    }

    public final Section addSection(float f, String string) {
        Section section = new Section(new Paragraph(string), 1);
        section.setIndentation(f);
        this.add(section);
        return section;
    }

    public final Section addSection(String string) {
        Section section = new Section(new Paragraph(string), 1);
        this.add(section);
        return section;
    }

    public Section addSection(Properties properties) {
        Section section = new Section(new Paragraph(""), 1);
        String string = (String)((Hashtable)properties).remove("number");
        if (string != null) {
            this.subsections = Integer.parseInt(string) - 1;
        }
        section.set(properties);
        this.add(section);
        return section;
    }

    public void set(Properties properties) {
        String string = (String)((Hashtable)properties).remove("numberdepth");
        if (string != null) {
            this.setNumberDepth(Integer.parseInt(string));
        }
        if ((string = (String)((Hashtable)properties).remove("indent")) != null) {
            this.setIndentation(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)((Hashtable)properties).remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)((Hashtable)properties).remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(string + "f").floatValue());
        }
    }

    public void setTitle(Paragraph paragraph) {
        this.title = paragraph;
    }

    public void setNumberDepth(int n) {
        this.numberDepth = n;
    }

    public final void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public final void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public final void setIndentation(float f) {
        this.sectionIndent = f;
    }

    public final boolean isChapter() {
        return this.type() == 16;
    }

    public final boolean isSection() {
        return this.type() == 13;
    }

    public final int numberDepth() {
        return this.numberDepth;
    }

    public final float indentationLeft() {
        return this.indentationLeft;
    }

    public final float indentationRight() {
        return this.indentationRight;
    }

    public final float indentation() {
        return this.sectionIndent;
    }

    public final int depth() {
        return this.numbers.size();
    }

    public Paragraph title() {
        if (this.title == null) {
            return null;
        }
        int n = Math.min(this.numbers.size(), this.numberDepth);
        if (n < 1) {
            return this.title;
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.insert(0, ".");
            stringBuffer.insert(0, (Integer)this.numbers.get(n2));
            ++n2;
        }
        Paragraph paragraph = new Paragraph(this.title);
        paragraph.setMarkupAttributes(this.title.getMarkupAttributes());
        paragraph.add(0, new Chunk(stringBuffer.toString(), this.title.font()));
        return paragraph;
    }

    public static boolean isTitle(String string) {
        return "title".equals(string);
    }

    public static boolean isTag(String string) {
        return "section".equals(string);
    }

    public boolean isBookmarkOpen() {
        return this.bookmarkOpen;
    }

    public void setBookmarkOpen(boolean bl) {
        this.bookmarkOpen = bl;
    }
}

