/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Chunk
implements Element,
MarkupAttributes {
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String STRIKETHRU = "STRIKETHRU";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String IMAGE = "IMAGE";
    public static final String GENERICTAG = "GENERICTAG";
    public static final String NEWPAGE = "NEWPAGE";
    public static final String SPLITCHARACTER = "SPLITCHARACTER";
    public static final String ACTION = "ACTION";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String PDFANNOTATION = "PDFANNOTATION";
    public static final String HYPHENATION = "HYPHENATION";
    protected StringBuffer content = null;
    protected Font font = null;
    protected HashMap attributes = null;
    protected Properties markupAttributes = null;

    protected Chunk() {
    }

    public Chunk(String string, Font font) {
        this.content = new StringBuffer(string);
        this.font = font;
    }

    public Chunk(String string) {
        this(string, new Font());
    }

    public Chunk(Image image, float f, float f2) {
        this("*", new Font());
        this.setAttribute(IMAGE, new Object[]{image, new Float(f), new Float(f2)});
    }

    public Chunk(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string = (String)((Hashtable)properties).remove("itext");
        if (string != null) {
            this.append(string);
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.LOCALGOTO)) != null) {
            this.setLocalGoto(string);
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.REMOTEGOTO)) != null) {
            String string2 = (String)((Hashtable)properties).remove(ElementTags.DESTINATION);
            String string3 = (String)((Hashtable)properties).remove(ElementTags.PAGE);
            if (string3 != null) {
                this.setRemoteGoto(string, Integer.valueOf(string3));
            } else if (string2 != null) {
                this.setRemoteGoto(string, string2);
            }
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.LOCALDESTINATION)) != null) {
            this.setLocalDestination(string);
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.SUBSUPSCRIPT)) != null) {
            this.setTextRise(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)((Hashtable)properties).remove("vertical-align")) != null && string.endsWith("%")) {
            float f = Float.valueOf(string.substring(0, string.length() - 1) + "f").floatValue() / 100.0f;
            this.setTextRise(f * this.font.size());
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.GENERICTAG)) != null) {
            this.setGenericTag(string);
        }
        if (((Hashtable)properties).size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 10;
    }

    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        arrayList.add(this);
        return arrayList;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public final Font font() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public final String content() {
        return this.content.toString();
    }

    public final boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf("\n") == -1 && this.attributes == null;
    }

    public Chunk setTextRise(float f) {
        return this.setAttribute(SUBSUPSCRIPT, new Float(f));
    }

    public Chunk setAction(PdfAction pdfAction) {
        return this.setAttribute(ACTION, pdfAction);
    }

    public Chunk setAnchor(URL uRL) {
        return this.setAttribute(ACTION, new PdfAction(uRL.toExternalForm()));
    }

    public Chunk setAnchor(String string) {
        return this.setAttribute(ACTION, new PdfAction(string));
    }

    public Chunk setLocalGoto(String string) {
        return this.setAttribute(LOCALGOTO, string);
    }

    public Chunk setBackground(Color color) {
        return this.setAttribute(BACKGROUND, color);
    }

    public Chunk setAnnotation(PdfAnnotation pdfAnnotation) {
        return this.setAttribute(PDFANNOTATION, pdfAnnotation);
    }

    public Chunk setHyphenation(HyphenationEvent hyphenationEvent) {
        return this.setAttribute(HYPHENATION, hyphenationEvent);
    }

    public Chunk setRemoteGoto(String string, String string2) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, string2});
    }

    public Chunk setRemoteGoto(String string, int n) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, new Integer(n)});
    }

    public Chunk setLocalDestination(String string) {
        return this.setAttribute(LOCALDESTINATION, string);
    }

    public Chunk setGenericTag(String string) {
        return this.setAttribute(GENERICTAG, string);
    }

    public Chunk setSplitCharacter(SplitCharacter splitCharacter) {
        return this.setAttribute(SPLITCHARACTER, splitCharacter);
    }

    public Chunk setNewPage() {
        return this.setAttribute(NEWPAGE, null);
    }

    private Chunk setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
        return this;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public Image getImage() {
        if (this.attributes == null) {
            return null;
        }
        Object[] objectArray = (Object[])this.attributes.get(IMAGE);
        if (objectArray == null) {
            return null;
        }
        return (Image)objectArray[0];
    }

    public static boolean isTag(String string) {
        return "chunk".equals(string);
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public static Set getKeySet(Hashtable hashtable) {
        return hashtable == null ? Collections.EMPTY_SET : hashtable.keySet();
    }
}

