package com.businesslogic.ireport.ui;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "SRParamForm"
 * non viene creato nel metodo main().
 */
public class SRParamForm extends Form
{
	public String name="";
	public String expression="";
	public SRParamForm(String name, String expression)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		this.name = name;
		this.expression = expression;
		editName.setText(name);
		editExpression.setText(expression);
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	/**
	 * SRParamForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void button2_click(Object source, Event e)
	{
		if (name.trim().length()==0)
		{
			MessageBox.show("Plese, insert a valid name!");
			return;
		}
		
		this.setDialogResult( DialogResult.OK);
		this.dispose();
	}

	private void editName_textChanged(Object source, Event e)
	{
		this.name = editName.getText();
	}

	private void editExpression_textChanged(Object source, Event e)
	{
		this.expression = editExpression.getText();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Edit editName = new Edit();
	Label label1 = new Label();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Button button2 = new Button();
	Label label2 = new Label();
	Edit editExpression = new Edit();

	private void initForm()
	{
		this.setText("Subreport parameter");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(302, 172));

		editName.setLocation(new Point(4, 16));
		editName.setSize(new Point(276, 20));
		editName.setTabIndex(0);
		editName.setText("");
		editName.addOnTextChanged(new EventHandler(this.editName_textChanged));

		label1.setLocation(new Point(4, 0));
		label1.setSize(new Point(180, 16));
		label1.setTabIndex(2);
		label1.setTabStop(false);
		label1.setText("Subreport parameter name");

		groupBox1.setLocation(new Point(0, 128));
		groupBox1.setSize(new Point(292, 4));
		groupBox1.setTabIndex(3);
		groupBox1.setTabStop(false);
		groupBox1.setText("");

		button1.setLocation(new Point(224, 140));
		button1.setSize(new Point(68, 24));
		button1.setTabIndex(4);
		button1.setText("Cancel");
		button1.setDialogResult(DialogResult.CANCEL);

		button2.setLocation(new Point(152, 140));
		button2.setSize(new Point(64, 24));
		button2.setTabIndex(5);
		button2.setText("Ok");
		button2.addOnClick(new EventHandler(this.button2_click));

		label2.setLocation(new Point(4, 40));
		label2.setSize(new Point(168, 16));
		label2.setTabIndex(1);
		label2.setTabStop(false);
		label2.setText("Parameter expression");

		editExpression.setLocation(new Point(4, 56));
		editExpression.setSize(new Point(284, 68));
		editExpression.setTabIndex(6);
		editExpression.setText("");
		editExpression.setMultiline(true);
		editExpression.addOnTextChanged(new EventHandler(this.editExpression_textChanged));

		this.setNewControls(new Control[] {
							editExpression, 
							label2, 
							button2, 
							button1, 
							groupBox1, 
							label1, 
							editName});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */

}
