/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;
import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "VariablesForm"
 * non viene creato nel metodo main().
 */
public class VariablesForm extends Form
{
	Report report=null;
	public VariablesForm()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	/**
	 * VariablesForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}
	
	public void setReport( Report rp)
	{
		report = rp;
		this.listViewVariables.removeAllItems();
		Enumeration enum = rp.variables.elements(); 
		while (enum.hasMoreElements())
		{
			JRVariable v = (JRVariable)enum.nextElement();
			DataListItem lid = new DataListItem(v,v.name,0);
			lid.setSubItem(0,v.builtin+"");
			listViewVariables.addItem(lid);
		}
		
		this.listViewFields.removeAllItems();
		enum = rp.fields.elements(); 
		while (enum.hasMoreElements())
		{
			JRField f = (JRField)enum.nextElement();
			DataListItem lid = new DataListItem(f,f.name,0);
			lid.setSubItem(0,f.classType+"");
			listViewFields.addItem(lid);
		}
		
		this.listViewParameters.removeAllItems();
		enum = rp.parameters.elements(); 
		while (enum.hasMoreElements())
		{
			JRParameter p = (JRParameter)enum.nextElement();
			DataListItem lid = new DataListItem(p,p.name,0);
			lid.setSubItem(0,p.classType );
			lid.setSubItem(1,p.isForPrompting+"" );
			listViewParameters.addItem(lid);
		}
	}

	private void listViewVariables_mouseMove(Object source, MouseEvent e)
	{
		  if (getMouseButtons() == MouseButton.LEFT) { 
            DataObject data=new DataObject();
			DragElementsData ded =  new DragElementsData();
			ListItem[] li = listViewVariables.getSelectedItems(); 
            for (int i=0; i<li.length; ++i)
			{
				ded.elements.addElement( ((DataListItem)li[i]).getData() );
			}
			data.setData(DragElementsData.class,ded);
			listViewVariables.doDragDrop(data,DragDropEffect.COPY);
		  }
	}

	private void listViewVariables_giveFeedback(Object source, GiveFeedbackEvent e)
	{
		 if (e.effect == DragDropEffect.COPY) { 
                setCursor ( Cursor.HELP );
        }
	}

	private void listViewVariables_queryContinueDrag(Object source, QueryContinueDragEvent e)
	{
		if (e.action != DragAction.CONTINUE) 
            setCursor(Cursor.DEFAULT);
	}

	private void listViewFields_mouseMove(Object source, MouseEvent e)
	{
		if (getMouseButtons() == MouseButton.LEFT) { 
            DataObject data=new DataObject();
			DragElementsData ded =  new DragElementsData();
			ListItem[] li = listViewFields.getSelectedItems(); 
            for (int i=0; i<li.length; ++i)
			{
				ded.elements.addElement( ((DataListItem)li[i]).getData() );
			}
			data.setData(DragElementsData.class,ded);
			listViewFields.doDragDrop(data,DragDropEffect.COPY);
		  }
	}

	private void listViewFields_giveFeedback(Object source, GiveFeedbackEvent e)
	{
		if (e.effect == DragDropEffect.COPY) { 
                setCursor ( Cursor.HELP );
        }
	}

	private void listViewFields_queryContinueDrag(Object source, QueryContinueDragEvent e)
	{
		if (e.action != DragAction.CONTINUE) 
            setCursor(Cursor.DEFAULT);
	}

	private void listViewParameters_mouseMove(Object source, MouseEvent e)
	{
				if (getMouseButtons() == MouseButton.LEFT) { 
            DataObject data=new DataObject();
			DragElementsData ded =  new DragElementsData();
			ListItem[] li = listViewParameters.getSelectedItems(); 
            for (int i=0; i<li.length; ++i)
			{
				ded.elements.addElement( ((DataListItem)li[i]).getData() );
			}
			data.setData(DragElementsData.class,ded);
			listViewParameters.doDragDrop(data,DragDropEffect.COPY);
		  }
	}

	private void listViewParameters_giveFeedback(Object source, GiveFeedbackEvent e)
	{
		if (e.effect == DragDropEffect.COPY) { 
                setCursor ( Cursor.HELP );
        }
	}

	private void listViewParameters_queryContinueDrag(Object source, QueryContinueDragEvent e)
	{
		if (e.action != DragAction.CONTINUE) 
            setCursor(Cursor.DEFAULT);
	}

	private void buttonNewF_click(Object source, Event e)
	{
		
			FieldForm ff = new FieldForm();
			ff.setOwner(this);
			if (ff.showDialog() == DialogResult.OK)
			{
				JRField f = new JRField("","");
				
				f.name = ff.getFieldName();
				f.classType = ff.getClassType();
				DataListItem dli = new DataListItem(f, f.name,0);
				dli.setSubItem(0,f.classType);
				listViewFields.addItem(dli);
				report.fields.addElement(f);
			}
			;
	}

	private void buttonModF_click(Object source, Event e)
	{
		
		if (listViewFields.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewFields.getSelectedItems()[0]);
			JRField f = (JRField)dli.getData();
		
			FieldForm ff = new FieldForm();
			ff.setOwner(this);
			ff.setFieldName( f.name );
			ff.setClassType( f.classType);
			if (ff.showDialog() == DialogResult.OK)
			{
				f.name = ff.getFieldName();
				f.classType = ff.getClassType();
				
				dli.setText( f.name);
				dli.setSubItem(0,f.classType);
			}
		}
		;
	}

	private void buttonDelF_click(Object source, Event e)
	{
		while (listViewFields.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewFields.getSelectedItems()[0]);
			JRField f = (JRField)dli.getData();
			report.fields.removeElement(f);
			listViewFields.removeItem(dli);
	    }
	}

	private void listViewFields_doubleClick(Object source, Event e)
	{
		
		if (listViewFields.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewFields.getSelectedItems()[0]);
			JRField f = (JRField)dli.getData();
		
			FieldForm ff = new FieldForm();
			ff.setOwner(this);
			ff.setFieldName( f.name );
			ff.setClassType( f.classType);
			if (ff.showDialog() == DialogResult.OK)
			{
				f.name = ff.getFieldName();
				f.classType = ff.getClassType();
				dli.setText( f.name);
				dli.setSubItem(0,f.classType);
			}
		}
		;
	}

	private void buttonNewP_click(Object source, Event e)
	{
		
		ParameterForm ff = new ParameterForm();
		ff.setOwner(this);
		
		if (ff.showDialog() == DialogResult.OK)
		{
			JRParameter f = new JRParameter("","");
			
			f.name = ff.getFieldName();
			f.classType = ff.getClassType();
			f.isForPrompting = ff.isForPrompting;
			DataListItem dli = new DataListItem(f, f.name,0);
			dli.setSubItem(0,f.classType);
			dli.setSubItem(1,f.isForPrompting+"");
			listViewParameters.addItem(dli);
			report.parameters.addElement(f);
		}
		;
	}

	private void buttonModP_click(Object source, Event e)
	{
		
		if (listViewParameters.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewParameters.getSelectedItems()[0]);
			JRParameter f = (JRParameter)dli.getData();
		
			ParameterForm ff = new ParameterForm();
			ff.setOwner(this);
			ff.setFieldName( f.name );
			ff.setClassType(f.classType);
			ff.setIsForPrompting(f.isForPrompting);
			
			if (ff.showDialog() == DialogResult.OK)
			{
				f.name = ff.getFieldName();
				f.classType = ff.getClassType();
				f.isForPrompting = ff.isForPrompting;
				dli.setText( f.name);
				dli.setSubItem(0,f.classType);
				dli.setSubItem(1,f.isForPrompting+"");
			}
		}
		;
	}

	private void buttonDelP_click(Object source, Event e)
	{
		while (listViewParameters.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewParameters.getSelectedItems()[0]);
			JRParameter f = (JRParameter)dli.getData();
			report.parameters.removeElement(f);
			listViewParameters.removeItem(dli);
	    }
	}

	private void buttonNewV_click(Object source, Event e)
	{
		
			VariableForm ff = new VariableForm();
			ff.setOwner(this);
			if (ff.showDialog() == DialogResult.OK)
			{
				JRVariable f = new JRVariable("",false);
				
				f.name = ff.getFieldName();
				f.classType = ff.getClassType();
				
				f.initialValueExpression = ff.getInitVal();
				f.expression = ff.getExpression();
				f.resetType = ff.getResetType();
				f.resetGroup = ff.getResetGroup();
				f.calculation = ff.getCalcType();
				
				
				DataListItem dli = new DataListItem(f,f.name ,0);
				dli.setSubItem(0,f.builtin +"");
				listViewVariables.addItem(dli);
				report.variables.addElement(f);
			}
			;
	}

	private void buttonModV_click(Object source, Event e)
	{
		
		if (listViewVariables.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewVariables.getSelectedItems()[0]);
			JRVariable f = (JRVariable)dli.getData();
		
			if (f.builtin) return; 
			
			VariableForm ff = new VariableForm();
			ff.setFieldName( f.name );
			ff.setClassType( f.classType);
			
			ff.setInitVal(f.initialValueExpression);
			ff.setExpression(f.expression);
			ff.setResetType( f.resetType );
			ff.setResetGroup( f.resetGroup);
			ff.setCalcType(f.calculation);
			ff.setOwner(this);
			if (ff.showDialog() == DialogResult.OK)
			{
				f.name = ff.getFieldName();
				f.classType = ff.getClassType();
				f.initialValueExpression  = ff.getInitVal();
				f.expression = ff.getExpression();
				f.resetType = ff.getResetType();
				f.resetGroup = ff.getResetGroup( );
				f.calculation = ff.getCalcType();
			
				dli.setText( f.name);
				dli.setSubItem(0,f.classType);
			}
		}
		;
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	TabPage tabPage3 = new TabPage();
	TabPage tabPage2 = new TabPage();
	TabPage tabPage1 = new TabPage();
	TabControl tabControl1 = new TabControl();
	Panel panel1 = new Panel();
	ListView listViewFields = new ListView();
	Button buttonNewF = new Button();
	Button buttonModF = new Button();
	Button buttonDelF = new Button();
	ColumnHeader columnHeader1 = new ColumnHeader();
	ColumnHeader columnHeader2 = new ColumnHeader();
	Panel panel2 = new Panel();
	ColumnHeader columnHeader4 = new ColumnHeader();
	ColumnHeader columnHeader3 = new ColumnHeader();
	ListView listViewVariables = new ListView();
	Panel panel3 = new Panel();
	ListView listViewParameters = new ListView();
	ColumnHeader columnHeader5 = new ColumnHeader();
	ColumnHeader columnHeader6 = new ColumnHeader();
	Button buttonModV = new Button();
	Button button3 = new Button();
	Button buttonNewP = new Button();
	Button buttonModP = new Button();
	Button buttonDelP = new Button();
	Button buttonNewV = new Button();
	ColumnHeader columnHeader7 = new ColumnHeader();

	private void initForm()
	{
		// NOTA: questo form contiene informazioni relative alle risorse in
		// un file esterno. Non modificare il parametro di tipo String delle
		// chiamate alla funzione resources.getObject(). Ad esempio, non
		// modificare"foo1_location" nella seguente riga di codice,
		// nemmeno se il nome dell'oggetto Foo viene modificato: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "VariablesForm");
		this.setText("Values");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.SIZABLE_TOOLWINDOW);
		this.setClientSize(new Point(391, 286));
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setShowInTaskbar(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		tabPage3.setLocation(new Point(4, 25));
		tabPage3.setSize(new Point(383, 257));
		tabPage3.setTabIndex(2);
		tabPage3.setText("Parameters");

		tabPage2.setLocation(new Point(4, 25));
		tabPage2.setSize(new Point(383, 257));
		tabPage2.setTabIndex(1);
		tabPage2.setText("Variables");

		tabPage1.setLocation(new Point(4, 25));
		tabPage1.setSize(new Point(383, 257));
		tabPage1.setTabIndex(0);
		tabPage1.setText("Fields");

		tabControl1.setDock(ControlDock.FILL);
		tabControl1.setSize(new Point(391, 286));
		tabControl1.setTabIndex(0);
		tabControl1.setText("tabControl1");
		tabControl1.setSelectedIndex(2);

		panel1.setDock(ControlDock.RIGHT);
		panel1.setLocation(new Point(299, 0));
		panel1.setSize(new Point(84, 257));
		panel1.setTabIndex(0);
		panel1.setText("panel1");

		buttonNewF.setLocation(new Point(4, 4));
		buttonNewF.setSize(new Point(76, 24));
		buttonNewF.setTabIndex(2);
		buttonNewF.setText("New");
		buttonNewF.addOnClick(new EventHandler(this.buttonNewF_click));

		buttonModF.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		buttonModF.setLocation(new Point(4, 28));
		buttonModF.setSize(new Point(76, 24));
		buttonModF.setTabIndex(1);
		buttonModF.setText("Modify");
		buttonModF.addOnClick(new EventHandler(this.buttonModF_click));

		buttonDelF.setLocation(new Point(4, 52));
		buttonDelF.setSize(new Point(76, 24));
		buttonDelF.setTabIndex(0);
		buttonDelF.setText("Delete");
		buttonDelF.addOnClick(new EventHandler(this.buttonDelF_click));

		columnHeader1.setText("Field name");
		columnHeader1.setWidth(131);

		columnHeader2.setText("Class Type");
		columnHeader2.setWidth(153);

		listViewFields.setDock(ControlDock.FILL);
		listViewFields.setSize(new Point(299, 257));
		listViewFields.setTabIndex(1);
		listViewFields.setText("listView1");
		listViewFields.setFullRowSelect(true);
		listViewFields.setGridLines(true);
		listViewFields.setView(ViewEnum.REPORT);
		listViewFields.setColumns(new ColumnHeader[] {
								  columnHeader1, 
								  columnHeader2});
		listViewFields.addOnDoubleClick(new EventHandler(this.listViewFields_doubleClick));
		listViewFields.addOnMouseMove(new MouseEventHandler(this.listViewFields_mouseMove));
		listViewFields.addOnQueryContinueDrag(new QueryContinueDragEventHandler(this.listViewFields_queryContinueDrag));
		listViewFields.addOnGiveFeedback(new GiveFeedbackEventHandler(this.listViewFields_giveFeedback));

		panel2.setDock(ControlDock.RIGHT);
		panel2.setLocation(new Point(299, 0));
		panel2.setSize(new Point(84, 257));
		panel2.setTabIndex(0);
		panel2.setText("panel2");

		columnHeader4.setText(" Name");
		columnHeader4.setWidth(197);

		columnHeader3.setText("Builtin");
		columnHeader3.setWidth(55);

		listViewVariables.setDock(ControlDock.FILL);
		listViewVariables.setSize(new Point(299, 257));
		listViewVariables.setTabIndex(1);
		listViewVariables.setText("listView1");
		listViewVariables.setFullRowSelect(true);
		listViewVariables.setGridLines(true);
		listViewVariables.setView(ViewEnum.REPORT);
		listViewVariables.setColumns(new ColumnHeader[] {
									 columnHeader4, 
									 columnHeader3});
		listViewVariables.addOnMouseMove(new MouseEventHandler(this.listViewVariables_mouseMove));
		listViewVariables.addOnQueryContinueDrag(new QueryContinueDragEventHandler(this.listViewVariables_queryContinueDrag));
		listViewVariables.addOnGiveFeedback(new GiveFeedbackEventHandler(this.listViewVariables_giveFeedback));

		panel3.setDock(ControlDock.RIGHT);
		panel3.setLocation(new Point(299, 0));
		panel3.setSize(new Point(84, 257));
		panel3.setTabIndex(0);
		panel3.setText("panel3");

		columnHeader5.setText("Class Type");
		columnHeader5.setWidth(114);

		columnHeader6.setText("Field name");
		columnHeader6.setWidth(93);

		buttonModV.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		buttonModV.setLocation(new Point(4, 28));
		buttonModV.setSize(new Point(76, 24));
		buttonModV.setTabIndex(2);
		buttonModV.setText("Modify");
		buttonModV.addOnClick(new EventHandler(this.buttonModV_click));

		button3.setLocation(new Point(4, 52));
		button3.setSize(new Point(76, 24));
		button3.setTabIndex(1);
		button3.setText("Delete");

		buttonNewP.setLocation(new Point(4, 4));
		buttonNewP.setSize(new Point(76, 24));
		buttonNewP.setTabIndex(0);
		buttonNewP.setText("New");
		buttonNewP.addOnClick(new EventHandler(this.buttonNewP_click));

		buttonModP.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		buttonModP.setLocation(new Point(4, 28));
		buttonModP.setSize(new Point(76, 24));
		buttonModP.setTabIndex(2);
		buttonModP.setText("Modify");
		buttonModP.addOnClick(new EventHandler(this.buttonModP_click));

		buttonDelP.setLocation(new Point(4, 52));
		buttonDelP.setSize(new Point(76, 24));
		buttonDelP.setTabIndex(1);
		buttonDelP.setText("Delete");
		buttonDelP.addOnClick(new EventHandler(this.buttonDelP_click));

		buttonNewV.setLocation(new Point(4, 4));
		buttonNewV.setSize(new Point(76, 24));
		buttonNewV.setTabIndex(0);
		buttonNewV.setText("New");
		buttonNewV.addOnClick(new EventHandler(this.buttonNewV_click));

		columnHeader7.setText("Is for prompting");
		columnHeader7.setWidth(86);

		listViewParameters.setDock(ControlDock.FILL);
		listViewParameters.setSize(new Point(299, 257));
		listViewParameters.setTabIndex(1);
		listViewParameters.setText("listView1");
		listViewParameters.setFullRowSelect(true);
		listViewParameters.setGridLines(true);
		listViewParameters.setView(ViewEnum.REPORT);
		listViewParameters.setColumns(new ColumnHeader[] {
									  columnHeader6, 
									  columnHeader5, 
									  columnHeader7});
		listViewParameters.addOnMouseMove(new MouseEventHandler(this.listViewParameters_mouseMove));
		listViewParameters.addOnQueryContinueDrag(new QueryContinueDragEventHandler(this.listViewParameters_queryContinueDrag));
		listViewParameters.addOnGiveFeedback(new GiveFeedbackEventHandler(this.listViewParameters_giveFeedback));

		this.setNewControls(new Control[] {
							tabControl1});
		tabPage3.setNewControls(new Control[] {
								listViewParameters, 
								panel3});
		tabPage2.setNewControls(new Control[] {
								listViewVariables, 
								panel2});
		tabPage1.setNewControls(new Control[] {
								listViewFields, 
								panel1});
		tabControl1.setNewControls(new Control[] {
								   tabPage1, 
								   tabPage2, 
								   tabPage3});
		panel1.setNewControls(new Control[] {
							  buttonDelF, 
							  buttonModF, 
							  buttonNewF});
		panel2.setNewControls(new Control[] {
							  button3, 
							  buttonModV, 
							  buttonNewV});
		panel3.setNewControls(new Control[] {
							  buttonDelP, 
							  buttonModP, 
							  buttonNewP});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new VariablesForm());
	}
}
