/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ElementProperties"
 * non viene creato nel metodo main().
 */
public class ElementProperties extends Form
{
	Color backcolor;
	Color forecolor;
	ReportForm reportForm = null;
	ReportElement reportElement = null;
	int y_relative;
	
	
	public ElementProperties()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		backcolor = Color.WHITE;
		forecolor = Color.BLACK;
		
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	public void setEelement(ReportForm rf, ReportElement re)
	{
		if (rf==null)
		{
			this.dispose();
			return;
		}
		
		// Save selected tab for restore if possible...
		TabPage selectedtp = tabControl1.getSelectedTab(); 
		
		reportElement = re;
		reportForm = rf;
			
		if (tabControl1.getTabCount() > 0)
		{
			TabPage[] tp = tabControl1.getTabs();
			
			for (int i=1; i<tp.length; ++i)
			{
				if (tp[i] != tabPage1) 
				tabControl1.remove(tp[i]);
			}
		}
		
		if (reportElement == null)
		{
			this.tabPage1.setVisible(false);
			this.setText("No element selected!");
			return;
		}
		else
			this.tabPage1.setVisible(true);
		
		this.setText("Properties of "+reportElement.name);
		this.backcolor = reportElement.bgcolor;
		this.forecolor = reportElement.fgcolor;
		
		panel1.setBackColor(forecolor);
		panel2.setBackColor(backcolor);
		
		//Load bands...
		updateBands();

		// Calculate y relative...
		y_relative = reportForm.getReport().getBandYLocation(reportElement.band);
		
		this.numberEditLeft.setValue(reportElement.position.x-10);
		this.numberEditTop.setValue(reportElement.position.y-y_relative-10); 
		this.numberEditHeight.setValue( reportElement.height);
		this.numberEditWidth.setValue(reportElement.width);
		
		this.comboBoxBands.setSelectedItem(re.band);
		this.checkBoxTransparent.setChecked( re.mode.equalsIgnoreCase("Transparent"));
		
		
		if (reportElement instanceof TextReportElement)
		{
			TextReportElement tre = (TextReportElement)reportElement;
			editFont.setText(tre.fontName);
			numberComboBoxFontSize.setValue( tre.size);
			checkBoxBold.setChecked( tre.bold);
			checkBoxItalic.setChecked( tre.italic);
			checkBoxUnderline.setChecked( tre.underline);
			checkBoxStrike.setChecked( tre.stroke);
			editStaticText.setText(tre.text);
		}
		
		if (reportElement instanceof StaticTextReportElement)
		{
			tabControl1.add(tabPageStaticText);
			tabControl1.add(tabPageTextProperties);
			
			TextReportElement stre = (StaticTextReportElement)reportElement;
			editStaticText.setText(stre.text);
			comboBoxLineSpacing.setSelectedItem(stre.lineSpacing);
			comboBoxAlign.setSelectedItem(stre.align);
		}
		else if (reportElement instanceof TextFieldReportElement)
		{
			tabControl1.add(tabPageTextField);
			tabControl1.add(tabPageTextProperties);
			TextFieldReportElement tfre = (TextFieldReportElement)reportElement;
			if (tfre.font != null)
			{
				editStaticText.setText(tfre.text);
			}
			editTextFieldExpression.setText( tfre.text);
			comboBoxExpressionClass.setSelectedItem(tfre.fieldClass);
			comboBoxTextTime.setSelectedItem(tfre.evaluationTime);
			comboBoxLineSpacing.setSelectedItem(tfre.lineSpacing);
			comboBoxAlign.setSelectedItem(tfre.align);
		}
		else if (reportElement instanceof ImageReportElement)
		{
			tabControl1.add(tabPageImage);
			tabControl1.add(tabPageGraphicElement);
			ImageReportElement ire = (ImageReportElement)reportElement;
			editImageExpression.setText(ire.imageExpression);
			comboBoxImageClass.setSelectedItem(ire.imageClass);
			comboBoxScaleImage.setSelectedItem(ire.scaleImage);
			checkBoxUsingCache.setChecked(ire.isUsingCache);
			comboBoxPen.setSelectedItem(ire.graphicElementPen);
		}
		else if (reportElement instanceof RectangleReportElement)
		{
			tabControl1.add(tabPageGraphicElement);
			RectangleReportElement rre = (RectangleReportElement)reportElement;
			comboBoxPen.setSelectedItem(rre.graphicElementPen);
		}
		else if (reportElement instanceof LineReportElement)
		{
			tabControl1.add(tabPageLine);
			tabControl1.add(tabPageGraphicElement);
			LineReportElement lre = (LineReportElement)reportElement;
			comboBoxPen.setSelectedItem(lre.graphicElementPen);
			comboBoxDirection.setSelectedItem(lre.direction);
		}
		tabControl1.setSelectedTab(selectedtp); 
	}
	
	
	public void updateBands()
	{
		this.comboBoxBands.removeAll();
		if (reportForm != null)
		{
			Enumeration enum = reportForm.getReport().bands.elements();
			while (enum.hasMoreElements())
			{
				Band b = (Band)enum.nextElement();
				comboBoxBands.addItem(b);
			}
		}
	}
	
	/**
	 * ElementProperties esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}




	private void panel1_click(Object source, Event e)
	{
		ColorDialog cd = new ColorDialog();
		cd.setColor(forecolor);
		if (cd.showDialog() == DialogResult.OK)
		{
			forecolor = cd.getColor();
			panel1.setBackColor(forecolor);
			
			reportElement.fgcolor = forecolor;
			reportForm.updateElement(reportElement,null);
		}
	}

	private void panel2_click(Object source, Event e)
	{
		ColorDialog cd = new ColorDialog();
		cd.setColor(backcolor);
		if (cd.showDialog() == DialogResult.OK)
		{
			backcolor = cd.getColor();
			panel2.setBackColor(backcolor);
			
			reportElement.bgcolor = backcolor;
			reportForm.updateElement(reportElement,null);
		}
	}


	private Rectangle createOldRect()
	{
		return new Rectangle(reportElement.position.x-5,reportElement.position.y-5,reportElement.width+10, reportElement.height+10);
	}

	private void comboBoxBands_selectedIndexChanged(Object source, Event e)
	{
		reportElement.band =  (Band)comboBoxBands.getSelectedItem();
		// recalculate top coord
		y_relative = reportForm.getReport().getBandYLocation(reportElement.band);
		this.numberEditTop.setValue(reportElement.position.y-y_relative-10); 
	}

	private void numberEditTop_valueChanged(Object source, Event e)
	{
		Rectangle rect = createOldRect();
		reportElement.position.y = (int)numberEditTop.getValue()+y_relative+10;
		reportForm.updateElement(reportElement,rect);
	}

	private void buttonSelectFont_click(Object source, Event e)
	{

	}

	private void editStaticText_textChanged(Object source, Event e)
	{
		if (reportElement instanceof StaticTextReportElement)
		{	
				((StaticTextReportElement)reportElement).text=  editStaticText.getText();	
		}
		reportForm.updateElement(reportElement,null);
	}

	private void comboBoxAlign_selectedIndexChanged(Object source, Event e)
	{
		if (reportElement instanceof TextReportElement)
		{	
				((TextReportElement)reportElement).align=  (String)comboBoxAlign.getSelectedItem();	
		}
		reportForm.updateElement(reportElement,null);
	}

	private void comboBoxLineSpacing_selectedIndexChanged(Object source, Event e)
	{
		if (reportElement instanceof StaticTextReportElement)
		{	
				((StaticTextReportElement)reportElement).lineSpacing=  (String)comboBoxLineSpacing.getSelectedItem();	
		}
		reportForm.updateElement(reportElement,null);
	}

	private void editImageExpression_textChanged(Object source, Event e)
	{
		if (reportElement instanceof ImageReportElement)
		{	
				((ImageReportElement)reportElement).imageExpression  =  (String)editImageExpression.getText();
				try {
					Bitmap bmp = new Bitmap(((ImageReportElement)reportElement).imageExpression);
					if (bmp != null)
					{
						((ImageReportElement)reportElement).img  =  bmp;		
						((ImageReportElement)reportElement).imageClass = "java.lang.String";
						comboBoxImageClass.setSelectedItem("java.lang.String");
						reportForm.updateElement(reportElement,null);
					}
				} catch (Exception ex) {}
		}
		//reportForm.updateElement(reportElement,null);
	}

	private void comboBoxImageClass_selectedIndexChanged(Object source, Event e)
	{
		if (reportElement instanceof ImageReportElement)
		{	
				((ImageReportElement)reportElement).imageClass  =  (String)comboBoxImageClass.getSelectedItem();		
		}
	}

	private void comboBoxScaleImage_selectedIndexChanged(Object source, Event e)
	{
		if (reportElement instanceof ImageReportElement)
		{	
				((ImageReportElement)reportElement).scaleImage  =  (String)comboBoxScaleImage.getSelectedItem();		
		}
		reportForm.updateElement(reportElement,null);
	}

	private void checkBoxUsingCache_click(Object source, Event e)
	{
		if (reportElement instanceof ImageReportElement)
		{	
				((ImageReportElement)reportElement).isUsingCache  =  checkBoxUsingCache.getChecked();		
		}
	}

	private void button1_click(Object source, Event e)
	{
		OpenFileDialog ofd = new OpenFileDialog();
		ofd.setFilter("Jpeg (*.jpg)|*.jpg|Gif (*.gif)|*.gif|Bitmap (*.bmp)|*.bmp|All files (*.*)|*.*");
		ofd.setDefaultExt("jpg");
		if (ofd.showDialog() == DialogResult.OK)
		{
			String filename = ofd.getFileName();
			editImageExpression.setText( filename );
			((ImageReportElement)reportElement).imageExpression = string_replace("\\\\","\\", filename) ; 
			try {
				Bitmap bmp = new Bitmap(filename);
				if (bmp != null)
				{
					if (reportElement instanceof ImageReportElement)
					{	
						((ImageReportElement)reportElement).img  =  bmp;		
						((ImageReportElement)reportElement).imageClass = "java.lang.String";
						comboBoxImageClass.setSelectedItem("java.lang.String");
						reportForm.updateElement(reportElement,null);
					}
				}
			} catch (Exception ex) {}
			
		}
	}
	
public static String string_replace(String s1, String s2, String s3)
 {
	   String string="";
	   string = "";

    	if (s2 == null || s3 == null || s2.length() == 0) return s3;
	   
	   int pos_i = 0; // posizione corrente.
	   int pos_f = 0; // posizione corrente finale
	   
	   int len = s2.length();
	   while ( (pos_f = s3.indexOf(s2, pos_i)) >= 0)
	   {
		   string += s3.substring(pos_i,pos_f)+s1;
		   //+string.substring(pos+ s2.length());
		   pos_f = pos_i = pos_f + len;

	   }

	   string += s3.substring(pos_i);

	   return string;
 }
	private void comboBoxPen_selectedIndexChanged(Object source, Event e)
	{
		if (reportElement instanceof ImageReportElement)
		{	
				((ImageReportElement)reportElement).graphicElementPen  =  (String)comboBoxPen.getSelectedItem(); 		
		}
		else if (reportElement instanceof RectangleReportElement)
		{	
				((RectangleReportElement)reportElement).graphicElementPen  =  (String)comboBoxPen.getSelectedItem(); 		
		}
		else if (reportElement instanceof LineReportElement)
		{	
				((LineReportElement)reportElement).graphicElementPen  =  (String)comboBoxPen.getSelectedItem(); 		
		}
		reportForm.updateElement(reportElement,null);
	}


	private void comboBoxDirection_selectedIndexChanged(Object source, Event e)
	{
		if (reportElement instanceof LineReportElement)
		{	
				((LineReportElement)reportElement).direction  =  (String)comboBoxDirection.getSelectedItem(); 		
		}
		reportForm.updateElement(reportElement,null);
	}

	private void checkBoxTransparent_click(Object source, Event e)
	{
		reportElement.mode = (checkBoxTransparent.getChecked()) ? "Transparent" : "Opaque";
		reportForm.updateElement(reportElement,null);
	}

	private void label18_click(Object source, Event e)
	{
		
	}

	private void comboBoxTextTime_selectedIndexChanged(Object source, Event e)
	{
		((TextFieldReportElement)reportElement).evaluationTime  =  (String)comboBoxTextTime.getSelectedItem() ; 		
	}

	private void editTextFieldExpression_textChanged(Object source, Event e)
	{
		if (reportElement instanceof TextFieldReportElement)
		{	
				((TextFieldReportElement)reportElement).text  =  (String)editTextFieldExpression.getText(); 		
		}
		reportForm.updateElement(reportElement,null);
	}

	private void comboBoxExpressionClass_selectedIndexChanged(Object source, Event e)
	{
		((TextFieldReportElement)reportElement).fieldClass =  (String)comboBoxExpressionClass.getSelectedItem() ; 		
	}

	private void tabPageTextProperties_paint(Object source, PaintEvent e)
	{
		
	}

	private void editFont_leave(Object source, Event e)
	{
		if (reportElement instanceof TextReportElement)
		{	
				TextReportElement re = (TextReportElement)reportElement;
				re.bold = checkBoxBold.getChecked();
				re.italic = checkBoxItalic.getChecked();
				re.underline = checkBoxUnderline.getChecked();
				re.stroke = checkBoxStrike.getChecked();
				re.fontName = editFont.getText();
				re.size = (int)numberComboBoxFontSize.getValue();
				
				// Create font....
				re.font = null;
		}
		reportForm.updateElement(reportElement,null);
	}



	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	TabControl tabControl1 = new TabControl();
	TabPage tabPage1 = new TabPage();
	ComboBox comboBoxBands = new ComboBox();
	Label label1 = new Label();
	NumberEdit numberEditTop = new NumberEdit();
	Label label7 = new Label();
	NumberEdit numberEditWidth = new NumberEdit();
	Label label6 = new Label();
	NumberEdit numberEditLeft = new NumberEdit();
	Label label4 = new Label();
	NumberEdit numberEditHeight = new NumberEdit();
	Label label5 = new Label();
	CheckBox checkBoxTransparent = new CheckBox();
	Panel panel1 = new Panel();
	Label label3 = new Label();
	Label label2 = new Label();
	Panel panel2 = new Panel();
	Label label8 = new Label();
	TabPage tabPageStaticText = new TabPage();
	Edit editStaticText = new Edit();
	Label label9 = new Label();
	TabPage tabPageTextProperties = new TabPage();
	Label label10 = new Label();
	ComboBox editFont = new ComboBox();
	NumberComboBox numberComboBoxFontSize = new NumberComboBox();
	Label label11 = new Label();
	ComboBox comboBoxAlign = new ComboBox();
	Label label12 = new Label();
	ComboBox comboBoxLineSpacing = new ComboBox();
	TabPage tabPageImage = new TabPage();
	Edit editImageExpression = new Edit();
	Label label13 = new Label();
	Label label14 = new Label();
	ComboBox comboBoxImageClass = new ComboBox();
	Button button1 = new Button();
	Label label15 = new Label();
	ComboBox comboBoxScaleImage = new ComboBox();
	CheckBox checkBoxUsingCache = new CheckBox();
	TabPage tabPageGraphicElement = new TabPage();
	Label label16 = new Label();
	ComboBox comboBoxPen = new ComboBox();
	TabPage tabPageLine = new TabPage();
	Label label17 = new Label();
	ComboBox comboBoxDirection = new ComboBox();
	TabPage tabPageTextField = new TabPage();
	Label label18 = new Label();
	ComboBox comboBoxTextTime = new ComboBox();
	Label label19 = new Label();
	Edit editTextFieldExpression = new Edit();
	ComboBox comboBoxExpressionClass = new ComboBox();
	Label label20 = new Label();
	CheckBox checkBoxBold = new CheckBox();
	CheckBox checkBoxItalic = new CheckBox();
	CheckBox checkBoxUnderline = new CheckBox();
	CheckBox checkBoxStrike = new CheckBox();
	Button button2 = new Button();

	private void initForm()
	{
		// NOTA: questo form contiene informazioni relative alle risorse in
		// un file esterno. Non modificare il parametro di tipo String delle
		// chiamate alla funzione resources.getObject(). Ad esempio, non
		// modificare"foo1_location" nella seguente riga di codice,
		// nemmeno se il nome dell'oggetto Foo viene modificato: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "ElementProperties");
		this.setText("Element properties");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_DIALOG);
		this.setClientSize(new Point(304, 186));
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setMaximizeBox(false);
		this.setMinimizeBox(false);
		this.setShowInTaskbar(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);
		this.setTopMost(true);

		tabControl1.setDock(ControlDock.FILL);
		tabControl1.setSize(new Point(304, 186));
		tabControl1.setTabIndex(0);
		tabControl1.setText("tabControl1");
		tabControl1.setSelectedIndex(2);

		tabPage1.setLocation(new Point(4, 25));
		tabPage1.setSize(new Point(296, 157));
		tabPage1.setTabIndex(0);
		tabPage1.setText("Common");

		comboBoxBands.setLocation(new Point(68, 8));
		comboBoxBands.setSize(new Point(204, 21));
		comboBoxBands.setTabIndex(0);
		comboBoxBands.setText("");
		comboBoxBands.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxBands.addOnSelectedIndexChanged(new EventHandler(this.comboBoxBands_selectedIndexChanged));

		label1.setLocation(new Point(4, 12));
		label1.setSize(new Point(56, 12));
		label1.setTabIndex(1);
		label1.setTabStop(false);
		label1.setText("Band");
		label1.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditTop.setLocation(new Point(68, 32));
		numberEditTop.setSize(new Point(40, 20));
		numberEditTop.setTabIndex(13);
		numberEditTop.setText("0");
		numberEditTop.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditTop.setIsDouble(false);
		numberEditTop.setDecimals(0);
		numberEditTop.setValue(0.0d);
		numberEditTop.setViewPlus(false);
		numberEditTop.setSeparatoreMigliaia(true);
		numberEditTop.addOnValueChanged(new EventHandler(this.numberEditTop_valueChanged));

		label7.setLocation(new Point(8, 84));
		label7.setSize(new Point(56, 16));
		label7.setTabIndex(4);
		label7.setTabStop(false);
		label7.setText("Forecolor");
		label7.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditWidth.setLocation(new Point(164, 32));
		numberEditWidth.setSize(new Point(40, 20));
		numberEditWidth.setTabIndex(12);
		numberEditWidth.setText("0");
		numberEditWidth.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditWidth.setIsDouble(false);
		numberEditWidth.setDecimals(0);
		numberEditWidth.setValue(0.0d);
		numberEditWidth.setViewPlus(false);
		numberEditWidth.setSeparatoreMigliaia(true);

		label6.setLocation(new Point(8, 108));
		label6.setSize(new Point(56, 16));
		label6.setTabIndex(6);
		label6.setTabStop(false);
		label6.setText("Backcolor");
		label6.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditLeft.setLocation(new Point(68, 56));
		numberEditLeft.setSize(new Point(40, 20));
		numberEditLeft.setTabIndex(11);
		numberEditLeft.setText("0");
		numberEditLeft.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditLeft.setIsDouble(false);
		numberEditLeft.setDecimals(0);
		numberEditLeft.setValue(0.0d);
		numberEditLeft.setViewPlus(false);
		numberEditLeft.setSeparatoreMigliaia(true);

		label4.setLocation(new Point(120, 40));
		label4.setSize(new Point(40, 16));
		label4.setTabIndex(9);
		label4.setTabStop(false);
		label4.setText("Width");
		label4.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditHeight.setLocation(new Point(164, 56));
		numberEditHeight.setSize(new Point(40, 20));
		numberEditHeight.setTabIndex(10);
		numberEditHeight.setText("0");
		numberEditHeight.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditHeight.setIsDouble(false);
		numberEditHeight.setDecimals(0);
		numberEditHeight.setValue(0.0d);
		numberEditHeight.setViewPlus(false);
		numberEditHeight.setSeparatoreMigliaia(true);

		label5.setLocation(new Point(120, 60));
		label5.setSize(new Point(40, 16));
		label5.setTabIndex(2);
		label5.setTabStop(false);
		label5.setText("Height");
		label5.setTextAlign(HorizontalAlignment.RIGHT);

		checkBoxTransparent.setLocation(new Point(68, 128));
		checkBoxTransparent.setSize(new Point(16, 16));
		checkBoxTransparent.setTabIndex(15);
		checkBoxTransparent.setText("checkBox1");
		checkBoxTransparent.addOnClick(new EventHandler(this.checkBoxTransparent_click));

		panel1.setBackColor(Color.WINDOWTEXT);
		panel1.setLocation(new Point(68, 80));
		panel1.setSize(new Point(40, 20));
		panel1.setTabIndex(14);
		panel1.setText("panel1");
		panel1.setBorderStyle(BorderStyle.FIXED_3D);
		panel1.addOnClick(new EventHandler(this.panel1_click));

		label3.setLocation(new Point(4, 60));
		label3.setSize(new Point(56, 16));
		label3.setTabIndex(7);
		label3.setTabStop(false);
		label3.setText("Left");
		label3.setTextAlign(HorizontalAlignment.RIGHT);

		label2.setLocation(new Point(4, 36));
		label2.setSize(new Point(56, 16));
		label2.setTabIndex(8);
		label2.setTabStop(false);
		label2.setText("Top");
		label2.setTextAlign(HorizontalAlignment.RIGHT);

		panel2.setBackColor(Color.INFO);
		panel2.setLocation(new Point(68, 104));
		panel2.setSize(new Point(40, 20));
		panel2.setTabIndex(3);
		panel2.setText("panel1");
		panel2.setBorderStyle(BorderStyle.FIXED_3D);
		panel2.addOnClick(new EventHandler(this.panel2_click));

		label8.setLocation(new Point(8, 128));
		label8.setSize(new Point(56, 16));
		label8.setTabIndex(5);
		label8.setTabStop(false);
		label8.setText("Transparent");
		label8.setTextAlign(HorizontalAlignment.RIGHT);

		tabPageStaticText.setLocation(new Point(4, 25));
		tabPageStaticText.setSize(new Point(296, 157));
		tabPageStaticText.setTabIndex(1);
		tabPageStaticText.setText("Static Text");

		editStaticText.setLocation(new Point(4, 25));
		editStaticText.setSize(new Point(288, 128));
		editStaticText.setTabIndex(0);
		editStaticText.setText("");
		editStaticText.setMultiline(true);
		editStaticText.addOnTextChanged(new EventHandler(this.editStaticText_textChanged));

		label9.setLocation(new Point(4, 8));
		label9.setSize(new Point(68, 16));
		label9.setTabIndex(1);
		label9.setTabStop(false);
		label9.setText("Text");

		tabPageTextProperties.setLocation(new Point(4, 25));
		tabPageTextProperties.setSize(new Point(296, 157));
		tabPageTextProperties.setTabIndex(2);
		tabPageTextProperties.setText("Text properties");
		tabPageTextProperties.addOnPaint(new PaintEventHandler(this.tabPageTextProperties_paint));

		label10.setLocation(new Point(8, 8));
		label10.setSize(new Point(100, 16));
		label10.setTabIndex(0);
		label10.setTabStop(false);
		label10.setText("Font name");

		editFont.setLocation(new Point(4, 24));
		editFont.setSize(new Point(168, 21));
		editFont.setTabIndex(5);
		editFont.setText("Arial");
		editFont.setItems(new Object[] {
						  "Arial"});
		editFont.addOnLeave(new EventHandler(this.editFont_leave));
		editFont.addOnSelectedIndexChanged(new EventHandler(this.editFont_leave));

		numberComboBoxFontSize.setCursor(Cursor.DEFAULT);
		numberComboBoxFontSize.setLocation(new Point(240, 24));
		numberComboBoxFontSize.setSize(new Point(52, 21));
		numberComboBoxFontSize.setTabIndex(10);
		numberComboBoxFontSize.setText("0");
		numberComboBoxFontSize.setIsDouble(false);
		numberComboBoxFontSize.setDecimals(0);
		numberComboBoxFontSize.setValue(0.0d);
		numberComboBoxFontSize.setViewPlus(false);
		numberComboBoxFontSize.setSeparatoreMigliaia(false);
		numberComboBoxFontSize.addOnLeave(new EventHandler(this.editFont_leave));

		label11.setLocation(new Point(128, 92));
		label11.setSize(new Point(100, 16));
		label11.setTabIndex(3);
		label11.setTabStop(false);
		label11.setText("Align");

		comboBoxAlign.setLocation(new Point(128, 108));
		comboBoxAlign.setSize(new Point(156, 21));
		comboBoxAlign.setTabIndex(4);
		comboBoxAlign.setText("");
		comboBoxAlign.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxAlign.setItems(new Object[] {
							   "Left", 
							   "Right", 
							   "Center", 
							   "Justify"});
		comboBoxAlign.addOnSelectedIndexChanged(new EventHandler(this.comboBoxAlign_selectedIndexChanged));

		label12.setLocation(new Point(128, 48));
		label12.setSize(new Point(100, 16));
		label12.setTabIndex(1);
		label12.setTabStop(false);
		label12.setText("Line spacing");

		comboBoxLineSpacing.setLocation(new Point(128, 64));
		comboBoxLineSpacing.setSize(new Point(156, 21));
		comboBoxLineSpacing.setTabIndex(2);
		comboBoxLineSpacing.setText("");
		comboBoxLineSpacing.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxLineSpacing.setItems(new Object[] {
									 "Single", 
									 "1_1_2", 
									 "Double"});
		comboBoxLineSpacing.addOnSelectedIndexChanged(new EventHandler(this.comboBoxLineSpacing_selectedIndexChanged));

		tabPageImage.setLocation(new Point(4, 25));
		tabPageImage.setSize(new Point(296, 157));
		tabPageImage.setTabIndex(3);
		tabPageImage.setText("Image properties");

		editImageExpression.setLocation(new Point(8, 24));
		editImageExpression.setSize(new Point(204, 20));
		editImageExpression.setTabIndex(0);
		editImageExpression.setText("");
		editImageExpression.addOnTextChanged(new EventHandler(this.editImageExpression_textChanged));

		label13.setLocation(new Point(8, 8));
		label13.setSize(new Point(88, 16));
		label13.setTabIndex(4);
		label13.setTabStop(false);
		label13.setText("Image expression");

		label14.setLocation(new Point(8, 48));
		label14.setSize(new Point(128, 16));
		label14.setTabIndex(2);
		label14.setTabStop(false);
		label14.setText("Image expression class");

		comboBoxImageClass.setLocation(new Point(8, 64));
		comboBoxImageClass.setSize(new Point(280, 21));
		comboBoxImageClass.setTabIndex(5);
		comboBoxImageClass.setText("");
		comboBoxImageClass.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxImageClass.setItems(new Object[] {
									"java.lang.String", 
									"java.io.File", 
									"java.net.URL", 
									"java.io.InputStream", 
									"java.awt.Image"});
		comboBoxImageClass.addOnSelectedIndexChanged(new EventHandler(this.comboBoxImageClass_selectedIndexChanged));

		button1.setLocation(new Point(216, 20));
		button1.setSize(new Point(72, 24));
		button1.setTabIndex(6);
		button1.setText("Find...");
		button1.addOnClick(new EventHandler(this.button1_click));

		label15.setLocation(new Point(8, 88));
		label15.setSize(new Point(128, 16));
		label15.setTabIndex(1);
		label15.setTabStop(false);
		label15.setText("Scale image");

		comboBoxScaleImage.setLocation(new Point(8, 104));
		comboBoxScaleImage.setSize(new Point(280, 21));
		comboBoxScaleImage.setTabIndex(3);
		comboBoxScaleImage.setText("");
		comboBoxScaleImage.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxScaleImage.setItems(new Object[] {
									"Clip", 
									"FillFrame", 
									"RetainShape"});
		comboBoxScaleImage.addOnSelectedIndexChanged(new EventHandler(this.comboBoxScaleImage_selectedIndexChanged));

		checkBoxUsingCache.setLocation(new Point(8, 128));
		checkBoxUsingCache.setSize(new Point(100, 23));
		checkBoxUsingCache.setTabIndex(7);
		checkBoxUsingCache.setText("Using chache");
		checkBoxUsingCache.addOnClick(new EventHandler(this.checkBoxUsingCache_click));

		tabPageGraphicElement.setLocation(new Point(4, 25));
		tabPageGraphicElement.setSize(new Point(296, 157));
		tabPageGraphicElement.setTabIndex(4);
		tabPageGraphicElement.setText("Graphics Element");

		label16.setLocation(new Point(8, 8));
		label16.setSize(new Point(72, 16));
		label16.setTabIndex(0);
		label16.setTabStop(false);
		label16.setText("Pen");

		comboBoxPen.setLocation(new Point(8, 24));
		comboBoxPen.setSize(new Point(284, 21));
		comboBoxPen.setTabIndex(1);
		comboBoxPen.setText("");
		comboBoxPen.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxPen.setItems(new Object[] {
							 "None", 
							 "Thin", 
							 "1Point", 
							 "2Point", 
							 "4Point", 
							 "Dotted"});
		comboBoxPen.addOnSelectedIndexChanged(new EventHandler(this.comboBoxPen_selectedIndexChanged));

		tabPageLine.setLocation(new Point(4, 25));
		tabPageLine.setSize(new Point(296, 157));
		tabPageLine.setTabIndex(5);
		tabPageLine.setText("Line");

		label17.setLocation(new Point(4, 8));
		label17.setSize(new Point(72, 16));
		label17.setTabIndex(0);
		label17.setTabStop(false);
		label17.setText("Line direction");

		comboBoxDirection.setLocation(new Point(4, 24));
		comboBoxDirection.setSize(new Point(284, 21));
		comboBoxDirection.setTabIndex(1);
		comboBoxDirection.setText("");
		comboBoxDirection.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxDirection.setItems(new Object[] {
								   "TopDown", 
								   "BottomUp"});
		comboBoxDirection.addOnSelectedIndexChanged(new EventHandler(this.comboBoxDirection_selectedIndexChanged));

		tabPageTextField.setLocation(new Point(4, 25));
		tabPageTextField.setSize(new Point(296, 157));
		tabPageTextField.setTabIndex(6);
		tabPageTextField.setText("Text Field");

		label18.setLocation(new Point(8, 8));
		label18.setSize(new Point(136, 12));
		label18.setTabIndex(2);
		label18.setTabStop(false);
		label18.setText("Evaluation time");
		label18.addOnClick(new EventHandler(this.label18_click));

		comboBoxTextTime.setLocation(new Point(8, 24));
		comboBoxTextTime.setSize(new Point(100, 21));
		comboBoxTextTime.setTabIndex(0);
		comboBoxTextTime.setText("");
		comboBoxTextTime.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxTextTime.setItems(new Object[] {
								  "Now", 
								  "Report", 
								  "Page", 
								  "Column", 
								  "Group"});
		comboBoxTextTime.addOnSelectedIndexChanged(new EventHandler(this.comboBoxTextTime_selectedIndexChanged));

		label19.setLocation(new Point(8, 52));
		label19.setSize(new Point(144, 16));
		label19.setTabIndex(3);
		label19.setTabStop(false);
		label19.setText("Textfield Expression");

		editTextFieldExpression.setLocation(new Point(8, 68));
		editTextFieldExpression.setSize(new Point(276, 80));
		editTextFieldExpression.setTabIndex(4);
		editTextFieldExpression.setText("");
		editTextFieldExpression.setMultiline(true);
		editTextFieldExpression.addOnTextChanged(new EventHandler(this.editTextFieldExpression_textChanged));

		comboBoxExpressionClass.setLocation(new Point(112, 24));
		comboBoxExpressionClass.setSize(new Point(176, 21));
		comboBoxExpressionClass.setTabIndex(5);
		comboBoxExpressionClass.setText("");
		comboBoxExpressionClass.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxExpressionClass.setItems(new Object[] {
										 "", 
										 "java.lang.Boolean", 
										 "java.lang.Byte", 
										 "java.util.Date", 
										 "java.sql.Timestamp", 
										 "java.lang.Double", 
										 "java.lang.Float", 
										 "java.lang.Integer", 
										 "java.lang.Long", 
										 "java.lang.Short", 
										 "java.math.BigDecimal", 
										 "java.lang.String"});
		comboBoxExpressionClass.addOnSelectedIndexChanged(new EventHandler(this.comboBoxExpressionClass_selectedIndexChanged));

		label20.setLocation(new Point(112, 8));
		label20.setSize(new Point(136, 12));
		label20.setTabIndex(1);
		label20.setTabStop(false);
		label20.setText("Expression Class");
		label20.addOnClick(new EventHandler(this.label18_click));

		checkBoxBold.setLocation(new Point(8, 52));
		checkBoxBold.setSize(new Point(48, 20));
		checkBoxBold.setTabIndex(6);
		checkBoxBold.setText("Bold");
		checkBoxBold.addOnClick(new EventHandler(this.editFont_leave));

		checkBoxItalic.setLocation(new Point(8, 72));
		checkBoxItalic.setSize(new Point(52, 20));
		checkBoxItalic.setTabIndex(9);
		checkBoxItalic.setText("Italic");
		checkBoxItalic.addOnClick(new EventHandler(this.editFont_leave));

		checkBoxUnderline.setLocation(new Point(8, 92));
		checkBoxUnderline.setSize(new Point(68, 20));
		checkBoxUnderline.setTabIndex(8);
		checkBoxUnderline.setText("Underline");
		checkBoxUnderline.addOnClick(new EventHandler(this.editFont_leave));

		checkBoxStrike.setLocation(new Point(8, 112));
		checkBoxStrike.setSize(new Point(92, 20));
		checkBoxStrike.setTabIndex(7);
		checkBoxStrike.setText("Strike Through");
		checkBoxStrike.addOnClick(new EventHandler(this.editFont_leave));

		button2.setLocation(new Point(176, 20));
		button2.setSize(new Point(56, 24));
		button2.setTabIndex(11);
		button2.setText("Search");

		this.setNewControls(new Control[] {
							tabControl1});
		tabControl1.setNewControls(new Control[] {
								   tabPage1, 
								   tabPageStaticText, 
								   tabPageTextProperties, 
								   tabPageImage, 
								   tabPageGraphicElement, 
								   tabPageLine, 
								   tabPageTextField});
		tabPage1.setNewControls(new Control[] {
								label8, 
								checkBoxTransparent, 
								label7, 
								label1, 
								panel2, 
								label3, 
								label2, 
								panel1, 
								label5, 
								numberEditHeight, 
								label4, 
								numberEditLeft, 
								numberEditWidth, 
								numberEditTop, 
								comboBoxBands, 
								label6});
		tabPageStaticText.setNewControls(new Control[] {
										 label9, 
										 editStaticText});
		tabPageTextProperties.setNewControls(new Control[] {
											 button2, 
											 numberComboBoxFontSize, 
											 checkBoxStrike, 
											 checkBoxUnderline, 
											 checkBoxItalic, 
											 checkBoxBold, 
											 editFont, 
											 comboBoxLineSpacing, 
											 label12, 
											 comboBoxAlign, 
											 label11, 
											 label10});
		tabPageImage.setNewControls(new Control[] {
									checkBoxUsingCache, 
									comboBoxScaleImage, 
									label15, 
									button1, 
									comboBoxImageClass, 
									label14, 
									label13, 
									editImageExpression});
		tabPageGraphicElement.setNewControls(new Control[] {
											 comboBoxPen, 
											 label16});
		tabPageLine.setNewControls(new Control[] {
								   comboBoxDirection, 
								   label17});
		tabPageTextField.setNewControls(new Control[] {
										label20, 
										comboBoxExpressionClass, 
										editTextFieldExpression, 
										label19, 
										label18, 
										comboBoxTextTime});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ElementProperties());
	}
}
