import dori.jasper.engine.*;
import dori.jasper.view.*;
import java.util.*;
import java.sql.*;
import java.io.*;


/**
//C:\Documenti\progetti\iReport\src>java -Dorg.xml.sax.driver=org.apache.xerces.pa
//rsers.SAXParser IReportCompiler -jdriverorg.gjt.mm.mysql.Driver -juserroot -jpas
//swdsa -jurljdbc:mysql://localhost/mysql -c -pdf -query"SELECT * FROM USER" C:\Do
//cumenti\progetti\iReport\tmpuser.xml
 */
public class IReportCompiler
{

	public static void main(String[] args)
	{
		String fileName = null;
		boolean compile = false;
		boolean pdf     = false;
		String query     = "";
		String jdbDriver = "";
		String jdbcUser  ="";
		String jdbcPassword ="";
		String jdbcUrl   ="";
		
		System.setErr(System.out);
		try {
			
		long start = System.currentTimeMillis();
		if(args.length == 0)
		{
			usage();
			System.exit(1);
		}
		
		for (int i=0; i<args.length; ++i)
		{
			//System.out.println(args[i]);
			if (args[i].equals("-c"))  compile = true;
			else if (args[i].equals("-pdf")) pdf = true;
			else if (args[i].startsWith("-jdriver"))
				jdbDriver = args[i].substring(8);
			else if (args[i].startsWith("-juser"))
				jdbcUser = args[i].substring(6);
			else if (args[i].startsWith("-jpasswd"))
				jdbcPassword = args[i].substring(8);
			else if (args[i].startsWith("-jurl"))
				jdbcUrl = args[i].substring(5);
			else if (args[i].equals("-query"))
			{
				if (i+1 < args.length) i++;
				query = args[i].replace('\"',' ');
			}
			else
			{
				fileName = args[i];
				if (i+1 != args.length)
				{
					System.out.println("No more params expected after file name ("+fileName+")");
					usage();
					System.exit(1);
				}
			}
		}
		
		if (fileName == null)
		{
			usage();
			System.exit(1);
		}

		System.out.println("File:  "+fileName);
		if (compile);
		{
			System.out.println("Compiling...");
			System.out.flush();
			JasperCompileManager.compileReportToFile(fileName);
			
			fileName = fileName.substring(0,fileName.length()-3)+"jasper";
		}
		if (pdf);
		{
			System.out.println("Generating pdf...");
			System.out.flush();
		
			if (jdbDriver.length()>0)
			{
				System.out.println("Opening connection....");
				System.out.flush();
				//System.out.println("JDBC connection...");
				//System.out.println("Driver: "+jdbDriver);
				//System.out.println("Url:    "+jdbcUrl);
				//System.out.println("User:   "+jdbcUser);
				//System.out.println(jdbcPassword);
				
				Class.forName( jdbDriver );
				Connection conn = DriverManager.getConnection(jdbcUrl,
				jdbcUser,
				jdbcPassword); 
			
				
				
				if (query.length()>0)
				{	
					System.out.println("Executing  query " + query);
					System.out.flush();
					Statement stmt = conn.createStatement();
					ResultSet rs = stmt.executeQuery(query);
					
					
					 
					JasperRunManager.runReportToPdfFile(fileName, null, new JRResultSetDataSource(rs));	
				}
				else
				{
					JasperRunManager.runReportToPdfFile(fileName,null, conn);
				}
			} else {
				JasperRunManager.runReportToPdfFile(fileName, null, new JREmptyDataSource());			
			}	
			System.out.println("PDF running time : " + (System.currentTimeMillis() - start));
			System.out.flush();
			System.exit(0);
		}
			
				
		/*
		int k = 0;
		while ( args.length > k )
		{
			if ( args[k].startsWith("-T") )
				taskName = args[k].substring(2);
			if ( args[k].startsWith("-F") )
				fileName = args[k].substring(2);
			
			k++;	
		}

		try
		{
			long start = System.currentTimeMillis();
			if (TASK_COMPILE.equals(taskName))
			{
				System.out.println("Compiling "+fileName+" Pleas wait...");
				JasperCompileManager.compileReportToFile(fileName);
				System.out.println("Compile time : " + (System.currentTimeMillis() - start));
				System.out.println("Compile "+fileName+" terminated succesfully");
				System.exit(0);
			}
			else if (TASK_FILL.equals(taskName))
			{
				JasperFillManager.fillReportToFile(fileName, null, new JREmptyDataSource());
				System.out.println("Filling time : " + (System.currentTimeMillis() - start));
				System.exit(0);
			}
			else if (TASK_PRINT.equals(taskName))
			{
				JasperPrintManager.printReport(fileName, true);
				System.out.println("Printing time : " + (System.currentTimeMillis() - start));
				System.exit(0);
			}
			else if (TASK_RUN.equals(taskName))
			{
				System.out.println("Running "+fileName+" Pleas wait...");
				JasperRunManager.runReportToPdfFile(fileName, null, new JREmptyDataSource());
				System.out.println("PDF running time : " + (System.currentTimeMillis() - start));
				System.out.println("Running "+fileName+" terminated succesfully");
				System.exit(0);
			}
			else
			{
				usage();
				System.exit(0);
			}
		*/
		
		}
		catch (JRException e)
		{
			java.io.StringWriter s = new java.io.StringWriter();
			e.printStackTrace(new java.io.PrintWriter(s));
			System.out.println(s);
			System.out.flush();
			System.exit(1);
		}
		catch (Exception e)
		{
			java.io.StringWriter s = new java.io.StringWriter();
			e.printStackTrace(new java.io.PrintWriter(s));
			System.out.println(s);
			System.out.flush();
			System.exit(1);
		}
		
	}


	/**
	 *
	 */
	private static void usage()
	{
		System.out.println( "IReportCompiler usage:" );
		System.out.println( "\tjava IReportCompiler [options] file\n" );
		System.out.println( "\t -c\tcompile file" );
		System.out.println( "\t -pdf\tcreate pdf file" );
		System.out.println( "\t -jdriver<jdbcdriver>\tuse this JDBC driver" );
		System.out.println( "\t -juser<jdbc user>\tdatabase user" );
		System.out.println( "\t -jpasswd<jdbc pass>\tdatabase password" );
		System.out.println( "\t -jurl<jdbc url>\tJDBC url" );
		System.out.println( "\t -query\"<query>\"\tQuery to execute" );
	}


}


