/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ElementsBrowser"
 * non viene creato nel metodo main().
 */
public class ElementsBrowser extends Form
{
	ReportForm reportForm;
	public ElementsBrowser()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		

		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	public void setReportForm(ReportForm rf)
	{
		reportForm = rf; 
		updateElementsList();
	}
	
	public void updateElementsList()
	{
		listBox1.removeAll();
		Enumeration enum = reportForm.getReport().getElements().elements();
		while (enum.hasMoreElements())
		{
			listBox1.addItem((ReportElement)enum.nextElement());
		}
	}
	/**
	 * ElementsBrowser esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void listBox1_doubleClick(Object source, Event e)
	{
		ReportElement re = (ReportElement)listBox1.getSelectedItem();
		if (reportForm != null)
		reportForm.setSelectedElement(re);
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	ListBox listBox1 = new ListBox();

	private void initForm()
	{
		this.setText("ElementsBrowser");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setClientSize(new Point(300, 300));

		listBox1.setDock(ControlDock.FILL);
		listBox1.setSize(new Point(300, 290));
		listBox1.setTabIndex(0);
		listBox1.setText("listBox1");
		listBox1.setUseTabStops(true);
		listBox1.addOnDoubleClick(new EventHandler(this.listBox1_doubleClick));

		this.setNewControls(new Control[] {
							listBox1});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ElementsBrowser());
	}
}
