/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.TypeDescriptor;

class TypeDescriptorFactory
implements ORADataFactory {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:20_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    TypeDescriptorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData create(Datum d2, int type) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(d2) + ", " + OracleLog.argument(type));
                OracleLog.recursiveTrace = false;
            }
            if (d2 == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                ORAData oRAData = null;
                return oRAData;
            }
            if (type == 2007) {
                OPAQUE opq = (OPAQUE)d2;
                byte[] image = opq.getBytesValue();
                short[] rdbmsTypeCodeArr = new short[1];
                TypeDescriptor td = TypeDescriptor.unpickleOpaqueTypeImage(new PickleContext(image, 0L), opq.getPhysicalConnection(), rdbmsTypeCodeArr);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "return: " + td);
                    OracleLog.recursiveTrace = false;
                }
                TypeDescriptor typeDescriptor = td;
                return typeDescriptor;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptorFactory.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            ORAData oRAData = null;
            return oRAData;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptorFactory.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.TypeDescriptorFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

