/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    final int LOCAL_TYPE = 0;
    final int LOOK_FOR_USER_SYNONYM = 1;
    final int LOOK_FOR_PUBLIC_SYNONYM = 2;
    final String[] initMetaData1_9_0_SQL = new String[]{"SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT  TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT  INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT  TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT  INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;"};
    String sqlHint = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:20_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        StructDescriptor structDescriptor;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                    OracleLog.recursiveTrace = false;
                }
                StructDescriptor __result__ = StructDescriptor.createDescriptor(name, conn, false, false);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                structDescriptor = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return structDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(String name, Connection conn, boolean recurse, boolean force) throws SQLException {
        StructDescriptor structDescriptor;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(recurse) + ", " + OracleLog.argument(force));
                    OracleLog.recursiveTrace = false;
                }
                if (name == null || name.length() == 0 || conn == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 60Invalid arguments");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 60, "Invalid arguments");
                }
                SQLName sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn);
                StructDescriptor sd = StructDescriptor.createDescriptor(sqlName, conn, recurse, force);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + sd);
                    OracleLog.recursiveTrace = false;
                }
                structDescriptor = sd;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return structDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(SQLName sqlName, Connection conn, boolean recurse, boolean force) throws SQLException {
        StructDescriptor structDescriptor;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(recurse) + ", " + OracleLog.argument(force));
                    OracleLog.recursiveTrace = false;
                }
                String qualifiedName = sqlName.getName();
                StructDescriptor descriptor = null;
                if (!force && (descriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName)) == null) {
                    descriptor = new StructDescriptor(sqlName, conn);
                    if (recurse) {
                        descriptor.initNamesRecursively();
                    }
                    ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + descriptor);
                    OracleLog.recursiveTrace = false;
                }
                structDescriptor = descriptor;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return structDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(SQLName name, Connection conn) throws SQLException {
        StructDescriptor structDescriptor;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                    OracleLog.recursiveTrace = false;
                }
                StructDescriptor __result__ = StructDescriptor.createDescriptor(name, conn, false, false);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                structDescriptor = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return structDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(OracleTypeADT otype) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(otype));
                OracleLog.recursiveTrace = false;
            }
            String fullName = otype.getFullName();
            OracleConnection conn = otype.getConnection();
            StructDescriptor descriptor = (StructDescriptor)conn.getDescriptor(fullName);
            if (descriptor == null) {
                SQLName sqlName = new SQLName(otype.getSchemaName(), otype.getSimpleName(), otype.getConnection());
                descriptor = new StructDescriptor(sqlName, otype, (Connection)conn);
                conn.putDescriptor(fullName, (Object)descriptor);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + descriptor);
                OracleLog.recursiveTrace = false;
            }
            StructDescriptor structDescriptor = descriptor;
            return structDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(typoid) + ", " + OracleLog.argument(version) + ", " + OracleLog.argument(tds) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            OracleTypeADT pickler = new OracleTypeADT(sqlName, typoid, version, tds, conn);
            StructDescriptor __result__ = new StructDescriptor(sqlName, pickler, (Connection)conn);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            StructDescriptor structDescriptor = __result__;
            return structDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(OracleTypeADT type, Connection conn) throws SQLException {
        super((short)108, type, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(String name, Connection conn) throws SQLException {
        super((short)108, name, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.initPickler();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(SQLName name, Connection conn) throws SQLException {
        super((short)108, name, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.initPickler();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor(SQLName name, OracleTypeADT type, Connection conn) throws SQLException {
        super((short)108, name, type, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.toid = type.getTOID();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StructDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)108);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_toid) + ", " + OracleLog.argument(_toidVersion) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.toid = _toid;
            this.toidVersion = _toidVersion;
            this.setPhysicalConnectionOf(conn);
            this.initPickler();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StructDescriptor(AttributeDescriptor[] _ados, Connection conn) throws SQLException {
        super((short)108);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_ados) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.attributesDescriptor = _ados;
            this.setPhysicalConnectionOf(conn);
            this.isTransient = true;
            this.initPickler();
            this.isInstanciable = new Boolean(true);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPickler() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.isTransient) {
                    this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
                } else {
                    this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
                    ((OracleTypeADT)this.pickler).init(this.connection);
                    this.toid = ((OracleTypeADT)this.pickler).getTOID();
                }
                this.pickler.setDescriptor(this);
            }
            catch (Exception e2) {
                if (e2 instanceof SQLException) {
                    throw (SQLException)e2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Unable to resolve type \"" + this.getName() + "\"");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + this.getName() + "\"");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeCode() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int typeCode = this.getOracleTypeADT().getTypeCode();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + typeCode);
                    OracleLog.recursiveTrace = false;
                }
                n2 = typeCode;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeVersion() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int typeVersion = this.getOracleTypeADT().getTypeVersion();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + typeVersion);
                    OracleLog.recursiveTrace = false;
                }
                n2 = typeVersion;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributesDescriptor(AttributeDescriptor[] _attributesDescriptor) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_attributesDescriptor));
                OracleLog.recursiveTrace = false;
            }
            this.attributesDescriptor = _attributesDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDescriptor[] getAttributesDescriptor() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.attributesDescriptor);
                OracleLog.recursiveTrace = false;
            }
            AttributeDescriptor[] attributeDescriptorArray = this.attributesDescriptor;
            return attributeDescriptorArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toBytes(STRUCT s2, boolean keepLocalCopy) throws SQLException {
        try {
            byte[] bytes;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(keepLocalCopy));
                OracleLog.recursiveTrace = false;
            }
            if ((bytes = s2.shareBytes()) == null) {
                if (s2.datumArray != null) {
                    bytes = this.pickler.linearize(s2);
                    if (!keepLocalCopy) {
                        s2.setShareBytes(null);
                    }
                } else if (s2.objectArray != null) {
                    s2.datumArray = this.toOracleArray(s2.objectArray);
                    bytes = this.pickler.linearize(s2);
                    if (!keepLocalCopy) {
                        s2.datumArray = null;
                        s2.setShareBytes(null);
                    }
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
                }
            } else if (s2.imageLength != 0L && (s2.imageOffset != 0L || s2.imageLength != (long)bytes.length)) {
                byte[] image = new byte[(int)s2.imageLength];
                System.arraycopy(bytes, (int)s2.imageOffset, image, 0, (int)s2.imageLength);
                s2.setImage(image, 0L, 0L);
                bytes = image;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + bytes);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum[] toOracleArray(STRUCT s2, boolean keepLocalCopy) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(keepLocalCopy));
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = s2.datumArray;
            Datum[] ret = null;
            if (datumArray == null) {
                if (s2.objectArray != null) {
                    datumArray = this.toOracleArray(s2.objectArray);
                } else if (s2.shareBytes() != null) {
                    if ((s2.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                        this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                    }
                    this.pickler.unlinearize(s2.shareBytes(), s2.imageOffset, s2, 1, null);
                    datumArray = s2.datumArray;
                    if (!keepLocalCopy) {
                        s2.datumArray = null;
                    }
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
                }
            }
            if (keepLocalCopy) {
                s2.datumArray = datumArray;
                ret = (Datum[])datumArray.clone();
            } else {
                ret = datumArray;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray2 = ret;
            return datumArray2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] toArray(STRUCT s2, Map map, boolean saveLocalCopy) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(map) + ", " + OracleLog.argument(saveLocalCopy));
                OracleLog.recursiveTrace = false;
            }
            Object[] objArray = null;
            if (s2.objectArray == null) {
                if (s2.datumArray != null) {
                    objArray = new Object[s2.datumArray.length];
                    for (int i2 = 0; i2 < s2.datumArray.length; ++i2) {
                        if (s2.datumArray[i2] == null) continue;
                        objArray[i2] = s2.datumArray[i2] instanceof STRUCT ? ((STRUCT)s2.datumArray[i2]).toJdbc(map) : s2.datumArray[i2].toJdbc();
                    }
                } else if (s2.shareBytes() != null) {
                    if ((s2.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                        this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                    }
                    this.pickler.unlinearize(s2.shareBytes(), s2.imageOffset, s2, 2, map);
                    objArray = s2.objectArray;
                    s2.objectArray = null;
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
                }
            } else {
                objArray = (Object[])s2.objectArray.clone();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + objArray);
                OracleLog.recursiveTrace = false;
            }
            Object[] objectArray = objArray;
            return objectArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = this.getFieldTypes().length;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeADT getOracleTypeADT() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.pickler == null) {
                this.initPickler();
            }
            OracleTypeADT ret = (OracleTypeADT)this.pickler;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            OracleTypeADT oracleTypeADT = ret;
            return oracleTypeADT;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleType[] getFieldTypes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleType[] __result__ = ((OracleTypeADT)this.pickler).getAttrTypes();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleType[] oracleTypeArray = __result__;
            return oracleTypeArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLInput toJdbc2SQLInput(STRUCT s2, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            OracleJdbc2SQLInput __result__ = new OracleJdbc2SQLInput(this.toOracleArray(s2, false), map, this.connection);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleJdbc2SQLInput oracleJdbc2SQLInput = __result__;
            return oracleJdbc2SQLInput;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleSQLOutput __result__ = new OracleSQLOutput(this, this.connection);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleSQLOutput oracleSQLOutput = __result__;
            return oracleSQLOutput;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toOracleArray(Object[] attributes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(attributes));
                OracleLog.recursiveTrace = false;
            }
            Datum[] datum = null;
            if (attributes != null) {
                OracleType[] oracleTypes = this.getFieldTypes();
                int oracleTypesLen = oracleTypes.length;
                if (attributes.length != oracleTypesLen) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 49" + null);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, null);
                }
                datum = new Datum[oracleTypesLen];
                OracleConnection iconn = this.connection;
                for (int i2 = 0; i2 < oracleTypesLen; ++i2) {
                    datum[i2] = oracleTypes[i2].toDatum(attributes[i2], iconn);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + datum);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = datum;
            return datumArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toOracleArray(Map attributes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(attributes));
                OracleLog.recursiveTrace = false;
            }
            Datum[] datum = null;
            int nonNullAttrCount = 0;
            if (attributes != null) {
                OracleType[] oracleTypes = this.getFieldTypes();
                int oracleTypesLen = oracleTypes.length;
                int attributesSize = attributes.size();
                datum = new Datum[oracleTypesLen];
                OracleConnection iconn = this.connection;
                for (int i2 = 0; i2 < oracleTypesLen; ++i2) {
                    Object o2 = attributes.get(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1));
                    datum[i2] = oracleTypes[i2].toDatum(o2, iconn);
                    if (o2 == null && !attributes.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1))) continue;
                    ++nonNullAttrCount;
                }
                if (nonNullAttrCount < attributesSize) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 68" + null);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, null);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + datum);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = datum;
            return datumArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                ResultSetMetaData __result__ = this.connection.newStructMetaData(this);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                resultSetMetaData = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return resultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinalType() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = this.getOracleTypeADT().isFinalType();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubtype() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = this.getOracleTypeADT().isSubType();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(checkThisName));
                OracleLog.recursiveTrace = false;
            }
            StructDescriptor currentDescriptor = this;
            String currentName = currentDescriptor.getName();
            boolean ret = false;
            if (checkThisName.equals(currentName)) {
                ret = true;
            } else {
                while (true) {
                    if ((currentName = currentDescriptor.getSupertypeName()) == null) {
                        ret = false;
                        break;
                    }
                    if (checkThisName.equals(currentName)) {
                        ret = true;
                        break;
                    }
                    currentDescriptor = StructDescriptor.createDescriptor(currentName, (Connection)this.connection);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstantiable() throws SQLException {
        boolean bl;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.isInstanciable == null) {
                    this.initMetaData1();
                }
                boolean __result__ = this.isInstanciable;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaObject() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = this.getOracleTypeADT().isJavaObject();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSupertypeName() throws SQLException {
        String string;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String ret = null;
                if (this.isSubtype()) {
                    if (this.supertype == null) {
                        this.initMetaData1();
                    }
                    ret = this.supertype;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                string = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalAttributeCount() throws SQLException {
        int n2;
        block8: {
            try {
                int ret;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isSubtype()) {
                    ret = this.getOracleTypeADT().getAttrTypes().length;
                } else {
                    if (this.numLocalAttrs == -1) {
                        this.initMetaData1();
                    }
                    ret = this.numLocalAttrs;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                n2 = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubtypeNames() throws SQLException {
        String[] stringArray;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.subtypes == null) {
                    this.initMetaData2();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.subtypes);
                    OracleLog.recursiveTrace = false;
                }
                stringArray = this.subtypes;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaClassName() throws SQLException {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String ret = null;
                if (this.isJavaObject()) {
                    ret = StructDescriptor.getJavaObjectClassName(this.connection, this);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                string = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeJavaName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            String ret = null;
            if (this.isJavaObject()) {
                if (this.attrJavaNames == null) {
                    this.initMetaData3();
                }
                ret = this.attrJavaNames[column];
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttributeJavaNames() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String[] ret = null;
            if (this.isJavaObject()) {
                if (this.attrJavaNames == null) {
                    this.initMetaData3();
                }
                ret = this.attrJavaNames;
            } else {
                ret = new String[]{};
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLanguage() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String ret = null;
                ret = this.isJavaObject() ? "JAVA" : "SQL";
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                string = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getClass(Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            String qualifiedName = this.getName();
            Class c2 = (Class)map.get(qualifiedName);
            String schema = this.getSchemaName();
            String type = this.getTypeName();
            if (c2 == null) {
                c2 = (Class)map.get(type);
            }
            if (SQLName.s_parseAllFormat) {
                if (c2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(schema)) {
                    c2 = (Class)map.get("\"" + type + "\"");
                }
                if (c2 == null) {
                    c2 = (Class)map.get("\"" + schema + "\"" + "." + "\"" + type + "\"");
                }
                if (c2 == null) {
                    c2 = (Class)map.get("\"" + schema + "\"" + "." + type);
                }
                if (c2 == null) {
                    c2 = (Class)map.get(schema + "." + "\"" + type + "\"");
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + c2);
                OracleLog.recursiveTrace = false;
            }
            Class clazz = c2;
            return clazz;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection conn, StructDescriptor desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = StructDescriptor.getJavaObjectClassName(conn, desc.getSchemaName(), desc.getTypeName());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection conn, String schema, String typename) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(schema) + ", " + OracleLog.argument(typename));
                OracleLog.recursiveTrace = false;
            }
            PreparedStatement pstmt = null;
            ResultSet rset = null;
            String ret = null;
            try {
                pstmt = conn.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                pstmt.setString(1, schema);
                pstmt.setString(2, typename);
                rset = pstmt.executeQuery();
                if (rset.next()) {
                    ret = rset.getString(1);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 100");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 100);
                }
            }
            catch (SQLException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.TRACE_20, "Debug:  SQL exception caught." + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String descType() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                StringBuffer strBuf = new StringBuffer();
                String __result__ = this.descType(strBuf, 0);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            StructDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String descType(StringBuffer strBuf, int level) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(strBuf) + ", " + OracleLog.argument(level));
                OracleLog.recursiveTrace = false;
            }
            String level_one = "";
            for (int i2 = 0; i2 < level; ++i2) {
                level_one = level_one + "  ";
            }
            String level_two = level_one + "  ";
            strBuf.append(level_one);
            strBuf.append(this.getTypeName());
            strBuf.append("\n");
            strBuf.append(level_one);
            strBuf.append("Subtype=" + this.getOracleTypeADT().isSubType());
            strBuf.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
            strBuf.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
            strBuf.append("\n");
            ResultSetMetaData md = this.getMetaData();
            int numCols = md.getColumnCount();
            for (int i3 = 0; i3 < numCols; ++i3) {
                int tcode = md.getColumnType(i3 + 1);
                if (tcode == 2002 || tcode == 2008) {
                    StructDescriptor adt_desc = StructDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.connection);
                    adt_desc.descType(strBuf, level + 1);
                    continue;
                }
                if (tcode == 2003) {
                    ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.connection);
                    array_desc.descType(strBuf, level + 1);
                    continue;
                }
                if (tcode == 2007) {
                    OpaqueDescriptor opq_desc = OpaqueDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.connection);
                    opq_desc.descType(strBuf, level + 1);
                    continue;
                }
                strBuf.append(level_two);
                strBuf.append(md.getColumnTypeName(i3 + 1));
                strBuf.append("\n");
            }
            String __result__ = strBuf.substring(0, strBuf.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object[] attributes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Datum[] datums = this.toOracleArray(attributes);
            byte[] __result__ = this.toBytes(datums);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Datum[] attributes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(attributes));
                OracleLog.recursiveTrace = false;
            }
            STRUCT s2 = new STRUCT(this, (byte[])null, this.connection);
            s2.setDatumArray(attributes);
            byte[] __result__ = this.pickler.linearize(s2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toArray(Object[] attributes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(attributes));
                OracleLog.recursiveTrace = false;
            }
            Datum[] __result__ = this.toOracleArray(attributes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = __result__;
            return datumArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toArray(byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            STRUCT s2 = new STRUCT(this, bytes, this.connection);
            Datum[] __result__ = this.toOracleArray(s2, false);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = __result__;
            return datumArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1() throws SQLException {
        try {
            short version;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((version = this.connection.getVersionNumber()) >= 9000) {
                this.initMetaData1_9_0();
            } else {
                this.initMetaData1_pre_9_0();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSqlHint() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlHint == null) {
                this.sqlHint = this.connection.getVersionNumber() >= 11000 ? "" : "/*+RULE*/";
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.sqlHint);
                OracleLog.recursiveTrace = false;
            }
            String string = this.sqlHint;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            block28: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    int state = 0;
                    if (this.numLocalAttrs != -1) break block28;
                    Statement pstmt = null;
                    Statement cstmt = null;
                    ResultSet rset = null;
                    int temp_numLocalAttrs = -1;
                    try {
                        block15: while (true) {
                            switch (state) {
                                case 0: {
                                    pstmt = this.connection.prepareStatement(this.getSqlHint() + this.initMetaData1_9_0_SQL[state]);
                                    pstmt.setString(1, this.getTypeName());
                                    pstmt.setString(2, this.getSchemaName());
                                    pstmt.setFetchSize(1);
                                    rset = pstmt.executeQuery();
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    try {
                                        cstmt = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + this.initMetaData1_9_0_SQL[state]);
                                        cstmt.setString(1, this.getTypeName());
                                        cstmt.registerOutParameter(2, -10);
                                        cstmt.execute();
                                        rset = cstmt.getCursor(2);
                                        rset.setFetchSize(1);
                                        break;
                                    }
                                    catch (SQLException ea) {
                                        if (ea.getErrorCode() == 1403) {
                                            if (state == 1) {
                                                cstmt.close();
                                                ++state;
                                                continue block15;
                                            }
                                            if (TRACE && !OracleLog.recursiveTrace) {
                                                OracleLog.recursiveTrace = true;
                                                StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1Inconsistent catalog view");
                                                OracleLog.recursiveTrace = false;
                                            }
                                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view");
                                            break;
                                        }
                                        throw ea;
                                    }
                                }
                            }
                            if (rset.next()) {
                                this.isInstanciable = new Boolean(rset.getString(1).equals("YES"));
                                this.supertype = rset.getString(2) + "." + rset.getString(3);
                                temp_numLocalAttrs = rset.getInt(4);
                                break;
                            }
                            if (state == 2) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    StructDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1Inconsistent catalog view");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view");
                                continue;
                            }
                            rset.close();
                            if (cstmt != null) {
                                cstmt.close();
                            }
                            ++state;
                        }
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    this.numLocalAttrs = temp_numLocalAttrs;
                }
                finally {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_pre_9_0() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.isInstanciable = new Boolean(true);
                this.supertype = "";
                this.numLocalAttrs = 0;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2() throws SQLException {
        try {
            short version;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((version = this.connection.getVersionNumber()) >= 9000) {
                this.initMetaData2_9_0();
            } else {
                this.initMetaData2_pre_9_0();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_9_0() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            block15: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.subtypes != null) break block15;
                    PreparedStatement pstmt = null;
                    ResultSet rset = null;
                    String[] temp_names_array = null;
                    try {
                        pstmt = this.connection.prepareStatement("select owner, type_name from all_types where supertype_name = :1 and supertype_owner = :2");
                        pstmt.setString(1, this.getTypeName());
                        pstmt.setString(2, this.getSchemaName());
                        rset = pstmt.executeQuery();
                        Vector<String> _vector = new Vector<String>();
                        while (rset.next()) {
                            _vector.addElement(rset.getString(1) + "." + rset.getString(2));
                        }
                        temp_names_array = new String[_vector.size()];
                        for (int i2 = 0; i2 < temp_names_array.length; ++i2) {
                            temp_names_array[i2] = (String)_vector.elementAt(i2);
                        }
                        _vector.removeAllElements();
                        _vector = null;
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    this.subtypes = temp_names_array;
                }
                finally {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_pre_9_0() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.subtypes = new String[0];
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            block14: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.attrJavaNames != null) break block14;
                    String[] temp_attrJavaNames = null;
                    PreparedStatement pstmt = null;
                    ResultSet rset = null;
                    try {
                        pstmt = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = :1 and type_name = :2");
                        pstmt.setString(1, this.getSchemaName());
                        pstmt.setString(2, this.getTypeName());
                        rset = pstmt.executeQuery();
                        temp_attrJavaNames = new String[this.getOracleTypeADT().getAttrTypes().length];
                        int i2 = 0;
                        while (rset.next()) {
                            temp_attrJavaNames[i2] = rset.getString(1);
                            ++i2;
                        }
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    this.attrJavaNames = temp_attrJavaNames;
                }
                finally {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String tagName() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_30, "return: StructDescriptor");
                OracleLog.recursiveTrace = false;
            }
            String string = "StructDescriptor";
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_20, "Debug: do nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_20, "Debug: do nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.StructDescriptor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

