/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection
implements Struct {
    StructDescriptor descriptor;
    Datum[] datumArray;
    Object[] objectArray;
    boolean enableLocalCache;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:20_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT(StructDescriptor type, Connection conn, Object[] attributes) throws SQLException {
        block8: {
            this.enableLocalCache = false;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(attributes));
                    OracleLog.recursiveTrace = false;
                }
                STRUCT.assertNotNull(type);
                this.descriptor = type;
                STRUCT.assertNotNull(conn);
                if (!type.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin())) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 1Cannot construct STRUCT instance + invalid connection");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
                }
                type.setConnection(conn);
                if (!this.descriptor.isInstantiable()) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 1Cannot construct STRUCT instance for a non-instantiable object type");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
                }
                this.setPhysicalConnectionOf(conn);
                this.datumArray = attributes != null ? this.descriptor.toArray(attributes) : new Datum[0];
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT(StructDescriptor type, Connection conn, Map attrList) throws SQLException {
        block8: {
            this.enableLocalCache = false;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(attrList));
                    OracleLog.recursiveTrace = false;
                }
                STRUCT.assertNotNull(type);
                this.descriptor = type;
                STRUCT.assertNotNull(conn);
                if (!type.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin())) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 1Cannot construct STRUCT instance + invalid connection");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
                }
                type.setConnection(conn);
                if (!this.descriptor.isInstantiable()) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 1Cannot construct STRUCT instance for a non-instantiable object type");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
                }
                this.setPhysicalConnectionOf(conn);
                this.datumArray = this.descriptor.toOracleArray(attrList);
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT(StructDescriptor type, byte[] elements, Connection conn) throws SQLException {
        super(elements);
        this.enableLocalCache = false;
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(elements) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            STRUCT.assertNotNull(type);
            this.descriptor = type;
            STRUCT.assertNotNull(conn);
            if (!type.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin())) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 1Cannot construct STRUCT instance + invalid connection");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
            }
            type.setConnection(conn);
            this.setPhysicalConnectionOf(conn);
            this.datumArray = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLTypeName() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            String string;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    String __result__ = this.descriptor.getName();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    string = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getAttributes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    Object[] ret = this.getAttributes(this.getMap());
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                        OracleLog.recursiveTrace = false;
                    }
                    objectArray = ret;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributes(Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(map));
                        OracleLog.recursiveTrace = false;
                    }
                    Object[] __result__ = this.descriptor.toArray(this, map, this.enableLocalCache);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    objectArray = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor getDescriptor() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            StructDescriptor structDescriptor;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.descriptor);
                        OracleLog.recursiveTrace = false;
                    }
                    structDescriptor = this.descriptor;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return structDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescriptor(StructDescriptor desc) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            this.descriptor = desc;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] getOracleAttributes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Datum[] datumArray;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    Datum[] __result__ = this.descriptor.toOracleArray(this, this.enableLocalCache);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    datumArray = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return datumArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap() {
        Map map;
        block8: {
            try {
                Map ret;
                block7: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    ret = null;
                    try {
                        ret = this.getInternalConnection().getTypeMap();
                    }
                    catch (SQLException ex) {
                        if (!TRACE || OracleLog.recursiveTrace) break block7;
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.TRACE_20, "Debug: STRUCT.getMap: Internal error. " + ex.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                map = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            byte[] byArray;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    byte[] __result__ = this.descriptor.toBytes(this, this.enableLocalCache);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    byArray = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatumArray(Datum[] darray) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(darray));
                OracleLog.recursiveTrace = false;
            }
            this.datumArray = darray == null ? new Datum[]{} : darray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjArray(Object[] oarray) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oarray));
                    OracleLog.recursiveTrace = false;
                }
                this.objectArray = oarray == null ? new Object[]{} : oarray;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static STRUCT toSTRUCT(Object obj, oracle.jdbc.OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            STRUCT s2 = null;
            if (obj != null) {
                if (obj instanceof STRUCT) {
                    s2 = (STRUCT)obj;
                } else if (obj instanceof ORAData) {
                    s2 = (STRUCT)((ORAData)obj).toDatum(conn);
                } else if (obj instanceof CustomDatum) {
                    s2 = (STRUCT)((OracleConnection)conn).toDatum((CustomDatum)obj);
                } else if (obj instanceof SQLData) {
                    SQLData sqldataObj = (SQLData)obj;
                    StructDescriptor desc = StructDescriptor.createDescriptor(sqldataObj.getSQLTypeName(), (Connection)conn);
                    SQLOutput sqlOutput = desc.toJdbc2SQLOutput();
                    sqldataObj.writeSQL(sqlOutput);
                    s2 = ((OracleSQLOutput)sqlOutput).getSTRUCT();
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 59" + obj);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 59, obj);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + s2);
                OracleLog.recursiveTrace = false;
            }
            STRUCT sTRUCT = s2;
            return sTRUCT;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toJdbc() throws SQLException {
        Object object;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Map map = this.getMap();
                Object __result__ = this.toJdbc(map);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                object = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toJdbc(Map map) throws SQLException {
        STRUCT sTRUCT;
        block6: {
            try {
                Class c2;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(map));
                    OracleLog.recursiveTrace = false;
                }
                Object jdbcObject = this;
                if (map != null && (c2 = this.descriptor.getClass(map)) != null) {
                    jdbcObject = this.toClass(c2, map);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + jdbcObject);
                    OracleLog.recursiveTrace = false;
                }
                sTRUCT = jdbcObject;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toClass(Class clazz) throws SQLException {
        Object object;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(clazz));
                    OracleLog.recursiveTrace = false;
                }
                Object __result__ = this.toClass(clazz, this.getMap());
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                object = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toClass(Class clazz, Map map) throws SQLException {
        STRUCT sTRUCT;
        block19: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(clazz) + ", " + OracleLog.argument(map));
                    OracleLog.recursiveTrace = false;
                }
                Object obj = null;
                try {
                    if (clazz == null || clazz == STRUCT.class || clazz == Struct.class) {
                        obj = this;
                    } else {
                        Object i2 = clazz.newInstance();
                        if (i2 instanceof SQLData) {
                            ((SQLData)i2).readSQL(this.descriptor.toJdbc2SQLInput(this, map), this.descriptor.getName());
                            obj = i2;
                        } else if (i2 instanceof ORADataFactory) {
                            ORADataFactory f2 = (ORADataFactory)i2;
                            obj = f2.create(this, 2002);
                        } else if (i2 instanceof CustomDatumFactory) {
                            CustomDatumFactory f3 = (CustomDatumFactory)i2;
                            obj = f3.create(this, 2002);
                        } else {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 49" + this.descriptor.getName());
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
                        }
                    }
                }
                catch (InstantiationException ex) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 49InstantiationException: " + ex.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 49IllegalAccessException: " + ex.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + ex.getMessage());
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + obj);
                    OracleLog.recursiveTrace = false;
                }
                sTRUCT = obj;
                if (!TRACE || OracleLog.recursiveTrace) break block19;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleTo(Class jClass) {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(jClass));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object makeJdbcArray(int arraySize) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(arraySize));
                OracleLog.recursiveTrace = false;
            }
            Object[] __result__ = new Object[arraySize];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Object[] objectArray = __result__;
            return objectArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBuffering(boolean enable) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(enable));
                        OracleLog.recursiveTrace = false;
                    }
                    this.enableLocalCache = enable;
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoBuffering() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            boolean bl;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.enableLocalCache);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = this.enableLocalCache;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(byte[] image, long offset, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(image) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setShareBytes(image);
            this.imageOffset = offset;
            this.imageLength = length;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageLength(long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.imageLength = length;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getImageOffset() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + this.imageOffset);
                OracleLog.recursiveTrace = false;
            }
            long l2 = this.imageOffset;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getImageLength() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + this.imageLength);
                OracleLog.recursiveTrace = false;
            }
            long l2 = this.imageLength;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatumFactory getFactory(Hashtable map, String classname) throws SQLException {
        try {
            String sqlTypeName;
            Object factory;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(map) + ", " + OracleLog.argument(classname));
                OracleLog.recursiveTrace = false;
            }
            if ((factory = map.get(sqlTypeName = this.getSQLTypeName())) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 1Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"");
            }
            CustomDatumFactory __result__ = (CustomDatumFactory)factory;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CustomDatumFactory customDatumFactory = __result__;
            return customDatumFactory;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORADataFactory getORADataFactory(Hashtable map, String classname) throws SQLException {
        try {
            String sqlTypeName;
            Object factory;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(map) + ", " + OracleLog.argument(classname));
                OracleLog.recursiveTrace = false;
            }
            if ((factory = map.get(sqlTypeName = this.getSQLTypeName())) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(Level.SEVERE, "Throwing SQLException: 1Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"");
            }
            ORADataFactory __result__ = (ORADataFactory)factory;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ORADataFactory oRADataFactory = __result__;
            return oRADataFactory;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debugString() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            StringWriter result = new StringWriter();
            String ret = null;
            try {
                StructDescriptor desc = this.getDescriptor();
                result.write("name = " + desc.getName());
                int length = desc.getLength();
                result.write(" length = " + length);
                Object[] attr = this.getAttributes();
                for (int i2 = 0; i2 < length; ++i2) {
                    result.write(" attribute[" + i2 + "] = " + attr[i2]);
                }
                ret = result.toString();
            }
            catch (SQLException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.TRACE_20, "Debug: STRUCT.debugString: StructDescriptor missing or bad formatted.");
                    OracleLog.recursiveTrace = false;
                }
                ret = "StructDescriptor missing or bad";
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(checkThisName));
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = this.getDescriptor().isInHierarchyOf(checkThisName);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        Connection connection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Connection __result__ = super.getJavaSqlConnection();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                connection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String __result__ = STRUCT.dump(this);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            STRUCT.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dump(Object o2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(0));
                OracleLog.recursiveTrace = false;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            STRUCT.dump(o2, pw);
            String __result__ = sw.getBuffer().substring(0);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                STRUCT.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public static void dump(Object o2, PrintStream ps) throws SQLException {
        STRUCT.dump(o2, new PrintWriter(ps, true));
    }

    public static void dump(Object o2, PrintWriter pw) throws SQLException {
        STRUCT.dump(o2, pw, 0);
    }

    static void dump(Object o2, PrintWriter pw, int indent) throws SQLException {
        if (o2 instanceof STRUCT) {
            STRUCT.dump((STRUCT)o2, pw, indent);
            return;
        }
        if (o2 instanceof ARRAY) {
            ARRAY.dump((ARRAY)o2, pw, indent);
            return;
        }
        if (o2 == null) {
            pw.println("null");
        } else {
            pw.println(o2.toString());
        }
    }

    static void dump(STRUCT x, PrintWriter pw, int indent) throws SQLException {
        int i2;
        StructDescriptor desc = x.getDescriptor();
        ResultSetMetaData md = desc.getMetaData();
        for (i2 = 0; i2 < indent; ++i2) {
            pw.print(' ');
        }
        pw.println("name = " + desc.getName());
        for (i2 = 0; i2 < indent; ++i2) {
            pw.print(' ');
        }
        int length = desc.getLength();
        pw.println("length = " + length);
        Object[] attr = x.getAttributes();
        for (i2 = 0; i2 < length; ++i2) {
            for (int j2 = 0; j2 < indent; ++j2) {
                pw.print(' ');
            }
            pw.print(md.getColumnName(i2 + 1) + " = ");
            STRUCT.dump(attr[i2], pw, indent + 1);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.STRUCT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

