/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OpaqueDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:19_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpaqueDescriptor(String name, Connection conn) throws SQLException {
        super((short)58, name, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.initPickler();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpaqueDescriptor(SQLName name, Connection conn) throws SQLException {
        super((short)58, name, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.initPickler();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpaqueDescriptor(SQLName name, OracleTypeOPAQUE type, Connection conn) throws SQLException {
        super((short)58, name, type, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpaqueDescriptor(OracleTypeADT type, Connection conn) throws SQLException {
        super((short)58, type, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpaqueDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)108);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_toid) + ", " + OracleLog.argument(_toidVersion) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.toid = _toid;
            this.toidVersion = _toidVersion;
            this.setPhysicalConnectionOf(conn);
            this.initPickler();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpaqueDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        OpaqueDescriptor opaqueDescriptor;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                    OracleLog.recursiveTrace = false;
                }
                if (name == null || name.length() == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OpaqueDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Invalid argument + 'name' shouldn't be null nor an empty string and 'conn' should not be null");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 60, "Invalid argument,'name' shouldn't be null nor an empty string and 'conn' should not be null");
                }
                SQLName sqlName = new SQLName(name, (OracleConnection)conn);
                OpaqueDescriptor __result__ = OpaqueDescriptor.createDescriptor(sqlName, conn);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                opaqueDescriptor = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return opaqueDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpaqueDescriptor createDescriptor(SQLName sqlName, Connection conn) throws SQLException {
        OpaqueDescriptor opaqueDescriptor;
        block12: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(conn));
                    OracleLog.recursiveTrace = false;
                }
                String qualifiedName = sqlName.getName();
                OpaqueDescriptor descriptor = null;
                if (conn != null) {
                    descriptor = (OpaqueDescriptor)((OracleConnection)conn).getDescriptor(qualifiedName);
                }
                if (descriptor == null) {
                    OracleTypeOPAQUE pickler;
                    if (qualifiedName.equals("SYS.ANYTYPE")) {
                        pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, qualifiedName, 7L);
                        descriptor = new OpaqueDescriptor(sqlName, pickler, conn);
                    } else if (qualifiedName.equals("SYS.ANYDATA")) {
                        pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, qualifiedName, 7L);
                        descriptor = new OpaqueDescriptor(sqlName, pickler, conn);
                    } else {
                        descriptor = new OpaqueDescriptor(sqlName, conn);
                    }
                    if (conn != null) {
                        ((OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + descriptor);
                    OracleLog.recursiveTrace = false;
                }
                opaqueDescriptor = descriptor;
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return opaqueDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPickler() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
                ((OracleTypeADT)this.pickler).init(this.connection);
                this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
                this.pickler.setDescriptor(this);
            }
            catch (Exception e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.TRACE_20, "Debug: OpaqueDescriptor.initPickler: exception caught and thrown." + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
                if (e2 instanceof SQLException) {
                    throw (SQLException)e2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Unable to resolve type \"" + this.getName() + "\"");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + this.getName() + "\"");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toBytes(OPAQUE obj, boolean keepLocalCopy) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(keepLocalCopy));
                OracleLog.recursiveTrace = false;
            }
            byte[] ret = null;
            if (obj.shareBytes() != null) {
                ret = obj.shareBytes();
            } else {
                try {
                    ret = this.pickler.linearize(obj);
                }
                finally {
                    if (!keepLocalCopy) {
                        obj.setShareBytes(null);
                    }
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE obj, boolean keepLocalCopy) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(keepLocalCopy));
                OracleLog.recursiveTrace = false;
            }
            byte[] ret = null;
            if (obj.value != null) {
                ret = obj.value;
            } else {
                try {
                    this.pickler.unlinearize(obj.shareBytes(), 0L, obj, 1, null);
                    ret = obj.value;
                }
                finally {
                    if (!keepLocalCopy) {
                        obj.value = null;
                    }
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeCode() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 2007");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 2007;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLength() throws SQLException {
        long l2;
        block5: {
            try {
                long ret;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                long l3 = ret = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.pickler).getMaxLength();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                l2 = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrustedLibrary() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = ((OracleTypeOPAQUE)this.pickler).isTrustedLibrary();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModeledInC() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = ((OracleTypeOPAQUE)this.pickler).isModeledInC();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnboundedSize() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = ((OracleTypeOPAQUE)this.pickler).isUnboundedSized();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFixedSize() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = ((OracleTypeOPAQUE)this.pickler).isFixedSized();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String descType() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                StringBuffer strBuf = new StringBuffer();
                String __result__ = this.descType(strBuf, 0);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OpaqueDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String descType(StringBuffer strBuf, int level) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(strBuf) + ", " + OracleLog.argument(level));
                OracleLog.recursiveTrace = false;
            }
            String level_one = "";
            for (int i2 = 0; i2 < level; ++i2) {
                level_one = level_one + "  ";
            }
            String level_two = level_one + "  ";
            strBuf.append(level_one);
            strBuf.append(this.getTypeName());
            strBuf.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
            strBuf.append("\n");
            String __result__ = strBuf.toString();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getClass(Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            Class ret = null;
            String qualifiedName = this.getName();
            Class c2 = (Class)map.get(qualifiedName);
            String schema = this.getSchemaName();
            String type = this.getTypeName();
            if (c2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(schema)) {
                c2 = (Class)map.get(type);
            }
            if (!SQLName.s_parseAllFormat) {
                ret = c2;
            } else {
                if (c2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(schema)) {
                    c2 = (Class)map.get("\"" + type + "\"");
                }
                if (c2 == null) {
                    c2 = (Class)map.get("\"" + schema + "\"" + "." + "\"" + type + "\"");
                }
                if (c2 == null) {
                    c2 = (Class)map.get("\"" + schema + "\"" + "." + type);
                }
                if (c2 == null) {
                    c2 = (Class)map.get(schema + "." + "\"" + type + "\"");
                }
                ret = c2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            Class clazz = ret;
            return clazz;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(out));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_20, "Debug: does nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_20, "Debug: does nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OpaqueDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.OpaqueDescriptor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

