/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.NClob;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CLOB;

public class NCLOB
extends CLOB
implements NClob {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:19_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    protected NCLOB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCLOB(OracleConnection conn) throws SQLException {
        this(conn, null);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NCLOB.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NCLOB.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCLOB(OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(conn, lob_descriptor, (short)2);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NCLOB.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob_descriptor));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NCLOB.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public NCLOB(CLOB clob) throws SQLException {
        this(clob.getPhysicalConnection(), clob.getBytes());
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.NCLOB"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

