/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.AttributeDescriptor;
import oracle.sql.TypeDescriptor;

class Kotad {
    static final int KOTADSIG = -1365573631;
    static final int KOTPDSIG = -1365442559;
    static final int KOTRDSIG = -1365377023;
    static final int KOTCDSIG = -1365311487;
    static final int KOTODSIG = -1365307391;
    static final int KOTADXSIG = -1365303295;
    static final int KOTADPRV = 1;
    static final int KOTADPUB = 2;
    static final int KOTADCNT = 4;
    static final int KOTADCFM = 248;
    static final int KOTADSUB = 256;
    static final int KOTADPTR = 16384;
    static final int KOTADREF = 32768;
    static final int KOTADCNN = 65536;
    static final int KOTADCFN = 131072;
    static final int KOTADCVN = 262144;
    static final int KOTADTRN = 512;
    static final int KOTADCPT = 4096;
    static final int KOTADIN = 256;
    static final int KOTADOUT = 512;
    static final int KOTADCBR = 1024;
    static final int KOTADREQ = 2048;
    static final int KOTADNCP = 0x100000;
    private int kotadkvn;
    private byte[] kotadnam;
    private byte[] kotadtrf;
    private short kotadtvn;
    private short kotadid;
    private byte[] kotadprf;
    private short kotadpvn;
    private int kotadflg;
    private long kotadpre;
    private int kotadcid;
    private byte kotadscl;
    private int kotadcne;
    private byte[] kotaddft;
    private long kotadtyp;
    private byte[] kotadadd;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:18_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    private Kotad() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Kotad unpickleKotad(PickleContext context) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context));
                OracleLog.recursiveTrace = false;
            }
            Kotad kotad = new Kotad();
            context.skipBytes(2);
            long length = context.readLength(true) - 2;
            context.skipBytes(1);
            kotad.kotadkvn = (int)context.readUB4();
            kotad.kotadnam = context.readDataValue();
            kotad.kotadtrf = context.readDataValue();
            context.skipBytes(1);
            kotad.kotadtvn = (short)context.readUB2();
            context.skipBytes(1);
            kotad.kotadid = (short)context.readUB2();
            kotad.kotadprf = context.readDataValue();
            context.skipBytes(1);
            kotad.kotadpvn = (short)context.readUB2();
            context.skipBytes(1);
            kotad.kotadflg = (int)context.readUB4();
            context.skipBytes(1);
            kotad.kotadpre = context.readUB4();
            context.skipBytes(1);
            kotad.kotadcid = context.readUB2();
            context.skipBytes(1);
            kotad.kotadscl = context.readByte();
            context.skipBytes(1);
            kotad.kotadcne = (int)context.readUB4();
            kotad.kotaddft = context.readDataValue();
            context.skipBytes(1);
            kotad.kotadtyp = context.readUB4();
            kotad.kotadadd = context.readDataValue();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "return: " + kotad);
                OracleLog.recursiveTrace = false;
            }
            Kotad kotad2 = kotad;
            return kotad2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final TypeDescriptor unpickleTypeDescriptorImage(PickleContext context) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context));
                OracleLog.recursiveTrace = false;
            }
            Kotad kotad = Kotad.unpickleKotad(context);
            if (kotad.kotadkvn != -1365311487) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(OracleLog.TRACE_20, "Debug: Kotad.unpickleTypeDescriptorImage: encountered a non-collection type description for what a predefined type.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(Level.SEVERE, "Throwing SQLException: 179");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 179);
            }
            TypeDescriptor td = Kotad.constructPredefinedTypeDescriptor(kotad);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "return: " + td);
                OracleLog.recursiveTrace = false;
            }
            TypeDescriptor typeDescriptor = td;
            return typeDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final AttributeDescriptor unpickleAttributeImage(boolean isPredefined, PickleContext context) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(isPredefined) + ", " + OracleLog.argument(context));
                OracleLog.recursiveTrace = false;
            }
            Kotad kotad = Kotad.unpickleKotad(context);
            if (kotad.kotadkvn != -1365573631) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(OracleLog.TRACE_20, "Debug: Kotad.unpickleAttributeImage: the type isn't an attribute.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(Level.SEVERE, "Throwing SQLException: 179");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 179);
            }
            TypeDescriptor td = null;
            if (isPredefined) {
                td = Kotad.constructPredefinedTypeDescriptor(kotad);
            }
            AttributeDescriptor ret = new AttributeDescriptor(new String(kotad.kotadnam), kotad.kotadid, kotad.kotadflg, td);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            AttributeDescriptor attributeDescriptor = ret;
            return attributeDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TypeDescriptor constructPredefinedTypeDescriptor(Kotad kotad) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(kotad));
                OracleLog.recursiveTrace = false;
            }
            if (kotad.kotadtrf.length != 36) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(OracleLog.TRACE_20, "Debug: kotadtrf is malformed");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(Level.SEVERE, "Throwing SQLException: 180");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 180);
            }
            for (int i2 = 4; i2 < 18; ++i2) {
                if (kotad.kotadtrf[i2] == 0) continue;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(OracleLog.TRACE_20, "Debug: this CREF isn't for a predefined type.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Kotad.logger().log(Level.SEVERE, "Throwing SQLException: 180");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 180);
            }
            short rdbmsTypeCode = TypeDescriptor.OID_TO_TYPECODE[kotad.kotadtrf[19]];
            TypeDescriptor td = new TypeDescriptor(rdbmsTypeCode);
            td.setPrecision(kotad.kotadpre);
            td.setScale(kotad.kotadscl);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "return: " + td);
                OracleLog.recursiveTrace = false;
            }
            TypeDescriptor typeDescriptor = td;
            return typeDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Kotad.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.Kotad"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

