/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSet12Byte;
import oracle.sql.CharacterSet1Byte;
import oracle.sql.CharacterSet2ByteFixed;
import oracle.sql.CharacterSetGB18030;
import oracle.sql.CharacterSetJAEUC;
import oracle.sql.CharacterSetLCFixed;
import oracle.sql.CharacterSetSJIS;
import oracle.sql.CharacterSetShift;
import oracle.sql.CharacterSetZHTEUC;
import oracle.sql.converter.CharacterConverterFactory;
import oracle.sql.converter.CharacterConverterFactoryJDBC;
import oracle.sql.converter.JdbcCharacterConverters;

public abstract class CharacterSetWithConverter
extends CharacterSet {
    public static CharacterConverterFactory ccFactory = new CharacterConverterFactoryJDBC();
    JdbcCharacterConverters m_converter;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:18_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetWithConverter(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
            this.m_converter = charConverter;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSet getInstance(int oracleId) {
        try {
            JdbcCharacterConverters charConverter;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId));
                OracleLog.recursiveTrace = false;
            }
            if ((charConverter = ccFactory.make(oracleId)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSet characterSet = null;
                return characterSet;
            }
            CharacterSetWithConverter charSetInstance = null;
            charSetInstance = CharacterSet1Byte.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSet1Byte characterSet1Byte = charSetInstance;
                return characterSet1Byte;
            }
            charSetInstance = CharacterSetSJIS.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetShift.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSet2ByteFixed.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetGB18030.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSet12Byte.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetJAEUC.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetZHTEUC.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + charSetInstance);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            CharacterSetLCFixed __result__ = CharacterSetLCFixed.getInstance(oracleId, charConverter);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CharacterSetLCFixed characterSetLCFixed = __result__;
            return characterSetLCFixed;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLossyFrom(CharacterSet from) {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(from));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = from.getOracleId() != this.getOracleId();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(source));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = source.getOracleId() == this.getOracleId();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.m_converter.toUnicodeStringWithReplacement(bytes, offset, count);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.m_converter.toUnicodeString(bytes, offset, count);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(String s2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2));
                OracleLog.recursiveTrace = false;
            }
            byte[] __result__ = this.m_converter.toOracleString(s2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertWithReplacement(String s2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2));
                OracleLog.recursiveTrace = false;
            }
            byte[] __result__ = this.m_converter.toOracleStringWithReplacement(s2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(from) + ", " + OracleLog.argument(source) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            if (from.getOracleId() == this.getOracleId()) {
                byte[] __result__ = CharacterSetWithConverter.useOrCopy(source, offset, count);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                return byArray;
            }
            byte[] __result__ = this.convert(from.toString(source, offset, count));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetWithConverter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetWithConverter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

