/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetLCFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterLCFixed";
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:18_PDT_2007";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetLCFixed(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
            this.m_leadingCodes = charConverter.getLeadingCodes();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetLCFixed getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
            if (charConverter.getGroupId() == 3) {
                CharacterSetLCFixed __result__ = new CharacterSetLCFixed(oracleId, charConverter);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetLCFixed characterSetLCFixed = __result__;
                return characterSetLCFixed;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            CharacterSetLCFixed characterSetLCFixed = null;
            return characterSetLCFixed;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(walker));
                OracleLog.recursiveTrace = false;
            }
            if (walker.bytes.length - walker.next < 4) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetLCFixed.logger().log(Level.SEVERE, "Throwing SQLException: 182destination too small");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
            }
            int leadingCode = walker.bytes[walker.next] << 8 | walker.bytes[walker.next + 1];
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                int c2 = 0;
                for (int j2 = 0; j2 < 4; ++j2) {
                    c2 = c2 << 8 | walker.bytes[walker.next++];
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, "return: " + c2);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = c2;
                return n2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(Level.SEVERE, "Throwing SQLException: 181Leading code invalid");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            int leadingCode = c2 >> 16;
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                CharacterSetLCFixed.need(buffer, 4);
                for (int j2 = 3; j2 >= 0; --j2) {
                    buffer.bytes[buffer.next++] = (byte)(c2 >> 8 * j2 & 0xFF);
                }
                return;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(Level.SEVERE, "Throwing SQLException: 181Leading code invalid");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetLCFixed"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

