/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;

abstract class CharacterSetFactory {
    public static final short DEFAULT_CHARSET = -1;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short UNICODE_1_CHARSET = 870;
    public static final short UNICODE_2_CHARSET = 871;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:17_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    CharacterSetFactory() {
    }

    public abstract CharacterSet make(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetFactory.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(argv));
                OracleLog.recursiveTrace = false;
            }
            CharacterSet unicode = CharacterSet.make(871);
            int[] charSets = new int[]{1, 31, 870, 871};
            for (int idX = 0; idX < charSets.length; ++idX) {
                CharacterSet cs = CharacterSet.make(charSets[idX]);
                String longString = "longlonglonglong";
                longString = longString + longString + longString + longString;
                longString = longString + longString + longString + longString;
                longString = longString + longString + longString + longString;
                longString = longString + longString + longString + longString;
                String[] testStrings = new String[]{"abc", "ab?c", "XYZ", longString};
                for (int idS = 0; idS < testStrings.length; ++idS) {
                    boolean ok;
                    block17: {
                        String testString;
                        String shortString = testString = testStrings[idS];
                        if (testString.length() > 16) {
                            shortString = shortString.substring(0, 16) + "...";
                        }
                        System.out.println("testing " + cs + " against <" + shortString + ">");
                        ok = true;
                        try {
                            byte[] utf;
                            byte[] rawWithoutReplacement;
                            String withoutReplacement;
                            byte[] raw = cs.convertWithReplacement(testString);
                            String withReplacement = cs.toStringWithReplacement(raw, 0, raw.length);
                            raw = cs.convert(withReplacement);
                            String roundTrip = cs.toString(raw, 0, raw.length);
                            if (!withReplacement.equals(roundTrip)) {
                                System.out.println("    FAILED roundTrip " + roundTrip);
                                ok = false;
                            }
                            if (cs.isLossyFrom(unicode)) {
                                try {
                                    byte[] bad = cs.convert(testString);
                                    String badString = cs.toString(bad, 0, bad.length);
                                    if (!badString.equals(roundTrip)) {
                                        System.out.println("    FAILED roundtrip, no throw");
                                    }
                                    break block17;
                                }
                                catch (SQLException ex) {}
                                break block17;
                            }
                            if (!roundTrip.equals(testString)) {
                                System.out.println("    FAILED roundTrip " + roundTrip);
                                ok = false;
                            }
                            if (!(withoutReplacement = cs.toString(rawWithoutReplacement = cs.convert(unicode, utf = unicode.convert(testString), 0, utf.length), 0, rawWithoutReplacement.length)).equals(testString)) {
                                System.out.println("    FAILED withoutReplacement " + withoutReplacement);
                                ok = false;
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("    FAILED with Exception " + ex);
                        }
                    }
                    if (!ok) continue;
                    System.out.println("    PASSED " + (cs.isLossyFrom(unicode) ? "LOSSY" : ""));
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetFactory.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

