/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.io.IOException;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;

public class TNSNamesNamingAdapter
implements NamingAdapterInterface {
    private NLParamParser tnsEntriesHdl;
    private String tnsDir;
    private long lastModifiedTime;
    private long nextPollTime;
    private static final String TNSFILE = "tnsnames.ora";
    private static final long REFRESH_INTERVAL = 0L;

    public TNSNamesNamingAdapter(String tnsAdmin) {
        this.tnsDir = tnsAdmin;
        this.resetAttr();
    }

    private void resetAttr() {
        this.tnsEntriesHdl = null;
        this.lastModifiedTime = 0L;
        this.nextPollTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolve(String connId) throws NetException {
        NVPair nvp = null;
        TNSNamesNamingAdapter tNSNamesNamingAdapter = this;
        synchronized (tNSNamesNamingAdapter) {
            this.checkAndReload();
            nvp = this.tnsEntriesHdl.getNLPListElement(connId);
        }
        if (nvp == null) {
            throw new NetException(122, "\"" + connId + "\"");
        }
        return nvp.valueToString();
    }

    private void loadFile() throws NetException {
        File f2 = new File(this.tnsDir, TNSFILE);
        String filename = f2.getAbsolutePath();
        if (!f2.isFile() || !f2.canRead()) {
            this.resetAttr();
            throw new NetException(123, ": " + filename);
        }
        long lastFileChange = f2.lastModified();
        if (this.lastModifiedTime != lastFileChange) {
            try {
                this.tnsEntriesHdl = new NLParamParser(filename, 1);
                this.lastModifiedTime = lastFileChange;
            }
            catch (IOException ioex) {
                this.resetAttr();
                throw new NetException(123, ": " + filename);
            }
            catch (NLException nlex) {
                // empty catch block
            }
        }
    }

    private void checkAndReload() throws NetException {
        long currTime = System.currentTimeMillis();
        if (currTime > this.nextPollTime) {
            this.nextPollTime = currTime + 0L;
            this.loadFile();
        }
    }
}

