/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.jndi.JndiAttrs;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NameResolver;
import oracle.net.resolver.NameResolverFactory;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

public class AddrResolution {
    private ConnStrategy cs;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "orclnetdescstring";
    private static final int length_of_alias_prefix = 6;
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_CONNECT_PROTOCOL = "TCP";
    private boolean newSyntax = true;
    public boolean connection_revised = false;
    public boolean connection_redirected = false;
    private String TNSAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddrResolution(String TNSdesc, Properties _up) throws NetException {
        this.up = _up;
        this.TNSAddress = TNSdesc;
        if (this.up.containsKey("java.naming.provider.url") || TNSdesc.startsWith("ldap:") || TNSdesc.startsWith("ldaps:")) {
            boolean isLdapUrlList = false;
            if (TNSdesc.startsWith("ldap:") || TNSdesc.startsWith("ldaps:")) {
                if (TNSdesc.indexOf(32) > 0) {
                    isLdapUrlList = true;
                } else {
                    int pos = TNSdesc.lastIndexOf(47);
                    if (pos == -1) {
                        throw new NetException(124);
                    }
                    this.up.put("java.naming.provider.url", TNSdesc.substring(0, pos));
                    this.TNSAddress = TNSdesc.substring(pos + 1, TNSdesc.length());
                }
            }
            if (!isLdapUrlList) {
                String[] attrname = new String[1];
                JndiAttrs ja = new JndiAttrs(this.up);
                attrname[0] = service_attr_name;
                Vector _service = null;
                try {
                    _service = ja.getAttrs(this.TNSAddress, attrname);
                }
                finally {
                    ja.close();
                }
                this.TNSAddress = (String)_service.firstElement();
                this.connection_revised = true;
            } else {
                this.processLdapFailoverLoadblance(TNSdesc);
            }
        }
        if (this.up.getProperty("oracle.net.oldSyntax") == "YES") {
            this.newSyntax = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLdapFailoverLoadblance(String tnsDesc) throws NetException {
        String url;
        int urlStart = 0;
        Vector urlList = new Vector(10);
        char[] tnsDescChars = tnsDesc.toCharArray();
        int length = tnsDescChars.length;
        while (urlStart < length) {
            int urlEnd;
            for (urlEnd = urlStart + 1; urlEnd < length && tnsDescChars[urlEnd] != ' '; ++urlEnd) {
            }
            url = new String(tnsDescChars, urlStart, urlEnd - urlStart);
            if (!url.startsWith("ldap")) {
                throw new NetException(124);
            }
            urlList.addElement(url);
            for (urlStart = urlEnd + 1; urlStart < length && tnsDescChars[urlStart] == ' '; ++urlStart) {
            }
        }
        if (urlList.size() <= 0) {
            throw new NetException(124);
        }
        boolean ldapFailover = true;
        boolean ldapLoadbalance = true;
        String prop = this.up.getProperty("oracle.net.ldap_failover");
        if (prop != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
            ldapFailover = false;
        }
        if ((prop = this.up.getProperty("oracle.net.ldap_loadbalance")) != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
            ldapLoadbalance = false;
        }
        if (urlList.size() > 1) {
            urlList = NavDescriptionList.setActiveChildren(urlList, ldapFailover, ldapLoadbalance);
        }
        StringBuffer sbJndiUrlList = new StringBuffer();
        int listSize = urlList.size();
        Hashtable<String, String> tabMapUrlToTns = new Hashtable<String, String>(listSize);
        for (int i2 = 0; i2 < listSize; ++i2) {
            url = (String)urlList.elementAt(i2);
            int pos = url.lastIndexOf(47);
            if (pos == -1) {
                throw new NetException(124);
            }
            String jndiUrl = url.substring(0, pos);
            String tnsAddr = url.substring(pos + 1, url.length());
            sbJndiUrlList.append(jndiUrl);
            if (i2 < listSize - 1) {
                sbJndiUrlList.append(' ');
            }
            tabMapUrlToTns.put(jndiUrl, tnsAddr);
        }
        String jndiUrlList = new String(sbJndiUrlList);
        this.up.put("java.naming.provider.url", jndiUrlList);
        JndiAttrs ja = new JndiAttrs(this.up);
        String ldapUlrConnected = ja.getLdapUrlUsed();
        this.TNSAddress = (String)tabMapUrlToTns.get(ldapUlrConnected);
        Vector serviceList = null;
        String[] attrNames = new String[]{service_attr_name};
        try {
            serviceList = ja.getAttrs(this.TNSAddress, attrNames);
        }
        finally {
            ja.close();
        }
        this.TNSAddress = (String)serviceList.firstElement();
        this.connection_revised = true;
    }

    public String getTNSAddress() {
        return this.TNSAddress.toUpperCase();
    }

    public ConnOption resolveAndExecute(String TNSdesc) throws NetException, IOException {
        ConnStrategy orig_cs = this.cs;
        if (TNSdesc != null) {
            this.cs = new ConnStrategy(this.up);
            if (this.connection_redirected) {
                this.cs.sdu = orig_cs.sdu;
                this.cs.tdu = orig_cs.tdu;
                this.cs.socketOptions = orig_cs.socketOptions;
                this.cs.reuseOpt = true;
                this.connection_redirected = false;
            }
            if (TNSdesc.indexOf(41) == -1) {
                int firstColon = 0;
                if (TNSdesc.startsWith("//")) {
                    firstColon = 2;
                }
                if (TNSdesc.charAt(firstColon) == '[') {
                    firstColon = TNSdesc.indexOf(93, firstColon + 1);
                }
                if ((firstColon = TNSdesc.indexOf(58, firstColon)) != -1 && TNSdesc.indexOf(58, firstColon + 1) != -1) {
                    this.resolveSimple(TNSdesc);
                } else {
                    String tnsAdmin = System.getProperty("oracle.net.tns_admin");
                    NameResolver nr = NameResolverFactory.getNameResolver(tnsAdmin, this.cs.getOSUsername());
                    this.resolveAddrTree(nr.resolveName(TNSdesc));
                }
            } else if (this.newSyntax) {
                this.resolveAddrTree(TNSdesc);
            } else {
                this.resolveAddr(TNSdesc);
            }
        } else if (this.cs == null || !this.cs.hasMoreOptions()) {
            return null;
        }
        return this.cs.execute();
    }

    private void resolveSimple(String TNSdesc) throws NetException {
        ConnOption co = new ConnOption();
        int fColon = 0;
        int sColon = 0;
        int eColon = 0;
        int initialIndex = 0;
        boolean isIPV6Literal = false;
        if (TNSdesc.startsWith("[")) {
            initialIndex = TNSdesc.indexOf(93);
            if (initialIndex == -1) {
                throw new NetException(115);
            }
            isIPV6Literal = true;
        }
        if ((fColon = TNSdesc.indexOf(58, initialIndex)) == -1 || (sColon = TNSdesc.indexOf(58, fColon + 1)) == -1) {
            throw new NetException(115);
        }
        eColon = TNSdesc.indexOf(58, sColon + 1);
        if (eColon != -1) {
            throw new NetException(115);
        }
        try {
            co.host = isIPV6Literal ? TNSdesc.substring(1, fColon - 1) : TNSdesc.substring(0, fColon);
            co.port = Integer.parseInt(TNSdesc.substring(fColon + 1, sColon));
            co.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + co.host + ")(PORT=" + co.port + "))";
            co.sid = TNSdesc.substring(sColon + 1, TNSdesc.length());
            String connData = "(DESCRIPTION=(CONNECT_DATA=(SID=" + co.sid + ")(CID=(PROGRAM=)(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))" + "(ADDRESS=" + "(PROTOCOL=tcp)(HOST=" + co.host + ")(PORT=" + co.port + ")))";
            co.protocol = DEFAULT_CONNECT_PROTOCOL;
            co.conn_data = new StringBuffer(connData);
            this.cs.addOption(co);
        }
        catch (NumberFormatException nfe) {
            throw new NetException(116);
        }
    }

    private void resolveAddr(String TNSdesc) throws NetException {
        if (TNSdesc.startsWith("alias=")) {
            String desc = TNSdesc;
            TNSdesc = desc.substring(desc.indexOf("alias=") + 6, desc.length());
        }
        ConnOption co = new ConnOption();
        NVFactory nvf = new NVFactory();
        NVNavigator nvn = new NVNavigator();
        NVPair cid = null;
        NVPair addr = null;
        try {
            cid = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "CID");
            addr = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "address");
        }
        catch (NLException exp) {
            System.err.println(exp.getMessage());
        }
        NVPair cnvp = nvn.findNVPair(addr, "protocol");
        if (cnvp == null) {
            throw new NetException(100);
        }
        co.protocol = cnvp.getAtom();
        if (!(co.protocol.equals(DEFAULT_CONNECT_PROTOCOL) || co.protocol.equals("tcp") || co.protocol.equals("SSL") || co.protocol.equals("ssl") || co.protocol.equals("ANO") || co.protocol.equals("ano"))) {
            throw new NetException(102);
        }
        cnvp = nvn.findNVPair(addr, "Host");
        if (cnvp == null) {
            throw new NetException(103);
        }
        co.host = cnvp.getAtom();
        cnvp = nvn.findNVPair(addr, "Port");
        if (cnvp == null) {
            throw new NetException(104);
        }
        co.port = Integer.parseInt(cnvp.getAtom());
        cnvp = nvn.findNVPair(addr, "sduSize");
        if (cnvp != null) {
            co.sdu = Integer.parseInt(cnvp.getAtom());
        }
        if ((cnvp = nvn.findNVPair(addr, "tduSize")) != null) {
            co.tdu = Integer.parseInt(cnvp.getAtom());
        }
        NVPair cdata = null;
        try {
            cdata = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "connect_data");
        }
        catch (NLException exp) {
            System.err.println(exp.getMessage());
        }
        StringBuffer tnsSB = new StringBuffer(TNSdesc);
        co.conn_data = cdata != null ? this.insertCID(TNSdesc) : tnsSB;
        co.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + co.host + ")(PORT=" + co.port + "))";
        this.cs.addOption(co);
    }

    private void resolveAddrTree(String TNSdesc) throws NetException {
        NavSchemaObjectFactory fac = new NavSchemaObjectFactory();
        NavServiceAlias sa = (NavServiceAlias)fac.create(4);
        try {
            String alias = TNSdesc.startsWith("alias=") ? TNSdesc : "alias=" + TNSdesc;
            sa.initFromString(alias);
        }
        catch (NLException nle) {
            throw new NetException(501);
        }
        catch (SOException soe) {
            throw new NetException(502, soe.getMessage());
        }
        sa.navigate(this.cs, null);
    }

    private StringBuffer insertCID(String TNSaddr) throws NetException {
        NVFactory nvf = new NVFactory();
        NVNavigator nvn = new NVNavigator();
        StringBuffer tns = new StringBuffer(2048);
        NVPair desc = null;
        NVPair addrl = null;
        NVPair addr = null;
        NVPair cdata = null;
        NVPair sroute = null;
        try {
            desc = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "description");
            addrl = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "address_list");
            addr = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "address");
            cdata = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "connect_data");
            sroute = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "source_route");
        }
        catch (NLException exp) {
            System.err.println(exp.getMessage());
        }
        NVPair sid = null;
        NVPair cid = null;
        NVPair sn = null;
        if (cdata == null) {
            throw new NetException(105);
        }
        sid = nvn.findNVPair(cdata, "SID");
        cid = nvn.findNVPair(cdata, "CID");
        sn = nvn.findNVPair(cdata, "SERVICE_NAME");
        if (sid == null && sn == null) {
            throw new NetException(106);
        }
        tns.append("(DESCRIPTION=");
        if (addrl != null && addrl.getListSize() > 0) {
            for (int i2 = 0; i2 < addrl.getListSize(); ++i2) {
                NVPair nvp = addrl.getListElement(i2);
                tns.append(nvp.toString());
            }
        } else if (addr != null) {
            tns.append(addr.toString());
        } else {
            throw new NetException(107);
        }
        if (sn != null) {
            tns.append("(CONNECT_DATA=" + sn.toString() + "(CID=(PROGRAM=)(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))");
        } else {
            tns.append("(CONNECT_DATA=" + sid.toString() + "(CID=(PROGRAM=)(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))");
        }
        if (sroute != null) {
            tns.append(sroute.toString());
        }
        tns.append(")");
        return tns;
    }

    public Properties getUp() {
        return this.up;
    }
}

