/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    int port;
    String host;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;

    public TcpNTAdapter(String address, Properties socketOptions) throws NLException {
        this.socketOptions = socketOptions;
        NVNavigator nav = new NVNavigator();
        NVPair nvpAddr = new NVFactory().createNVPair(address);
        NVPair nvpHost = nav.findNVPair(nvpAddr, "HOST");
        NVPair nvpPort = nav.findNVPair(nvpAddr, "PORT");
        if (nvpHost == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nvpHost.getAtom();
        if (nvpPort != null) {
            try {
                this.port = Integer.parseInt(nvpPort.getAtom());
            }
            catch (Exception e2) {
                throw new NLException(new NetException(116).getMessage());
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
    }

    @Override
    public void connect() throws IOException {
        String c_timeout = (String)this.socketOptions.get(new Integer(2));
        if (c_timeout != null) {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, this.port), Integer.parseInt(c_timeout));
            this.setOption(3, c_timeout);
        } else {
            this.socket = new Socket(this.host, this.port);
            String temp = (String)this.socketOptions.get(new Integer(3));
            if (temp != null) {
                this.setOption(3, temp);
            }
        }
        this.setSocketOptions();
    }

    public void setSocketOptions() throws IOException {
        String temp = (String)this.socketOptions.get(new Integer(0));
        if (temp != null) {
            this.setOption(0, temp);
        }
        if ((temp = (String)this.socketOptions.get(new Integer(1))) != null) {
            this.setOption(1, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        switch (option) {
            case 0: {
                String tmp = (String)value;
                this.socket.setTcpNoDelay(tmp.equals("YES"));
                break;
            }
            case 1: {
                String tmp = (String)value;
                if (!tmp.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: {
                this.sockTimeout = Integer.parseInt((String)value);
                this.socket.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        switch (option) {
            case 1: {
                return "" + this.sockTimeout;
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
        this.socket.sendUrgentData(urgentData);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

