/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;

public class CustomSSLSocketFactory {
    static final boolean DEBUG = false;
    public static final String CLEAR_WALLET_FILE_NAME = "cwallet.sso";
    public static final String CLEAR_WALLET_TYPE = "SSO";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    public static SSLSocketFactory defSSLFactory;
    public static String defPropString;
    public static boolean initDefFactory;

    private CustomSSLSocketFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactory(Properties sslSocketProperties) throws IOException {
        String keyStoreType = null;
        String keyStorePassword = null;
        String keyStore = null;
        String trustStoreType = null;
        String trustStorePassword = null;
        String trustStore = null;
        String keyManagerFacAlgo = null;
        String trustManagerFacAlgo = null;
        String propConcatenation = null;
        String walletDirectory = null;
        String walletLocation = null;
        SSLSocketFactory result = null;
        walletLocation = (String)sslSocketProperties.get(new Integer(5));
        if (walletLocation == null) {
            walletLocation = System.getProperty("oracle.net.wallet_location");
        }
        if (walletLocation == null || sslSocketProperties.get(new Integer(5)) == null && sslSocketProperties.get(new Integer(8)) != null) {
            keyStore = (String)sslSocketProperties.get(new Integer(8));
            if (keyStore == null) {
                keyStore = System.getProperty("javax.net.ssl.keyStore");
            }
            if (keyStore != null) {
                keyStoreType = (String)sslSocketProperties.get(new Integer(9));
                if (keyStoreType == null) {
                    keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                }
                if ((keyStorePassword = (String)sslSocketProperties.get(new Integer(10))) == null) {
                    keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
                }
                if ((keyManagerFacAlgo = (String)sslSocketProperties.get(new Integer(14))) == null) {
                    keyManagerFacAlgo = Security.getProperty("ssl.keyManagerFactory.algorithm");
                }
                if (keyManagerFacAlgo == null) {
                    keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
                }
            }
            if ((trustStore = (String)sslSocketProperties.get(new Integer(11))) == null) {
                trustStore = System.getProperty("javax.net.ssl.trustStore");
            }
            if (trustStore != null) {
                trustStoreType = (String)sslSocketProperties.get(new Integer(12));
                if (trustStoreType == null) {
                    trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                }
                if ((trustStorePassword = (String)sslSocketProperties.get(new Integer(13))) == null) {
                    trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
                }
                if ((trustManagerFacAlgo = (String)sslSocketProperties.get(new Integer(15))) == null) {
                    trustManagerFacAlgo = Security.getProperty("ssl.trustManagerFactory.algorithm");
                }
                if (trustManagerFacAlgo == null) {
                    trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
                }
            }
            propConcatenation = keyStore + "#" + keyStoreType + "#" + keyStorePassword + "#" + trustStore + "#" + trustStoreType + "#" + trustStorePassword + "#" + keyManagerFacAlgo + "#" + trustManagerFacAlgo;
        } else {
            walletDirectory = CustomSSLSocketFactory.processWalletLocation(walletLocation);
            keyStore = walletDirectory + System.getProperty("file.separator") + CLEAR_WALLET_FILE_NAME;
            keyStoreType = CLEAR_WALLET_TYPE;
            keyStorePassword = "";
            keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            trustStore = keyStore;
            trustStoreType = CLEAR_WALLET_TYPE;
            trustStorePassword = "";
            trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            propConcatenation = walletLocation + "#" + keyManagerFacAlgo + "#" + trustManagerFacAlgo;
        }
        if (propConcatenation.equals(defPropString)) {
            if (initDefFactory) {
                return defSSLFactory;
            }
            Class<CustomSSLSocketFactory> clazz = CustomSSLSocketFactory.class;
            synchronized (CustomSSLSocketFactory.class) {
                if (!initDefFactory) {
                    try {
                        KeyManager[] keyManagerArray = null;
                        TrustManager[] trustManagerArray = null;
                        if (keyStore != null) {
                            keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(keyStore, keyStorePassword, keyStoreType, keyManagerFacAlgo);
                        }
                        if (trustStore != null) {
                            trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(trustStore, trustStorePassword, trustStoreType, trustManagerFacAlgo);
                        }
                        SSLContext l_context = SSLContext.getInstance("SSL");
                        l_context.init(keyManagerArray, trustManagerArray, null);
                        defSSLFactory = l_context.getSocketFactory();
                        if (defSSLFactory != null) {
                            initDefFactory = true;
                        }
                    }
                    catch (Exception ex) {
                        throw new NetException(410, ex.toString());
                    }
                }
                // ** MonitorExit[var13_13] (shouldn't be in output)
                return defSSLFactory;
            }
        }
        try {
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (keyStore != null) {
                keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(keyStore, keyStorePassword, keyStoreType, keyManagerFacAlgo);
            }
            if (trustStore != null) {
                trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(trustStore, trustStorePassword, trustStoreType, trustManagerFacAlgo);
            }
            SSLContext l_context = SSLContext.getInstance("SSL");
            l_context.init(keyManagerArray, trustManagerArray, null);
            result = l_context.getSocketFactory();
            return result;
        }
        catch (Exception ex) {
            throw new NetException(410, ex.toString());
        }
    }

    public static KeyManager[] getKeyManagerArray(String keyStore, String keyStorePassword, String keyStoreType, String keyManagerFacAlgo) throws IOException {
        try {
            KeyStore instKeyStore = KeyStore.getInstance(keyStoreType);
            FileInputStream inputKeyStream = new FileInputStream(keyStore);
            instKeyStore.load(inputKeyStream, keyStorePassword.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFacAlgo);
            keyManagerFactory.init(instKeyStore, keyStorePassword.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            throw new NetException(408, ex.toString());
        }
    }

    public static TrustManager[] getTrustManagerArray(String trustStore, String trustStorePassword, String trustStoreType, String trustManagerFacAlgo) throws IOException {
        try {
            KeyStore instTrustStore = KeyStore.getInstance(trustStoreType);
            FileInputStream inputTrustStream = new FileInputStream(trustStore);
            instTrustStore.load(inputTrustStream, trustStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFacAlgo);
            trustManagerFactory.init(instTrustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            throw new NetException(409, ex.toString());
        }
    }

    public static String processWalletLocation(String walletLocation) throws NetException {
        String method = null;
        try {
            NVNavigator nav = new NVNavigator();
            NVPair nvpWallet = new NVFactory().createNVPair(walletLocation);
            NVPair nvpMethod = nav.findNVPair(nvpWallet, "METHOD");
            NVPair nvpMethodData = nav.findNVPair(nvpWallet, "METHOD_DATA");
            NVPair nvpDirectory = nav.findNVPair(nvpMethodData, "DIRECTORY");
            method = nvpMethod.getAtom();
            if (method.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String directoryLoc = nvpDirectory.getAtom();
                return directoryLoc;
            }
            throw new NetException(412, method);
        }
        catch (Exception ex) {
            throw new NetException(407, ex.toString());
        }
    }

    public static String getDefaultPropertiesString() {
        String defaultPropString = null;
        String walletLocation = null;
        Object walletDirectory = null;
        String keyManagerFacAlgo = null;
        String trustManagerFacAlgo = null;
        walletLocation = System.getProperty("oracle.net.wallet_location");
        defaultPropString = walletLocation != null ? walletLocation : System.getProperty("javax.net.ssl.keyStore", "") + "#" + System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.keyStorePassword", "") + "#" + System.getProperty("javax.net.ssl.trustStore", "") + "#" + System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.trustStorePassword", "");
        if (keyManagerFacAlgo == null) {
            keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (trustManagerFacAlgo == null) {
            trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        }
        return defaultPropString + "#" + keyManagerFacAlgo + "#" + trustManagerFacAlgo;
    }

    static {
        defPropString = CustomSSLSocketFactory.getDefaultPropertiesString();
    }
}

