/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import oracle.net.ano.Ano;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.resolver.AddrResolution;

public class NSProtocol
implements Communication,
SQLnetDef {
    private static final boolean ACTIVATE_ANO = true;
    private AddrResolution addrRes;
    private SessionAtts sAtts = new SessionAtts(Short.MAX_VALUE, Short.MAX_VALUE);
    private MarkerPacket mkPkt;
    private Packet packet;

    public NSProtocol() {
        this.sAtts.connected = false;
    }

    @Override
    public void connect(String connection, Properties userProperties) throws IOException, NetException {
        String verifyString;
        RefusePacket rfPkt;
        RedirectPacket rdPkt;
        AcceptPacket acPkt;
        ConnectPacket cnPkt;
        boolean disableOOB;
        if (this.sAtts.connected) {
            throw new NetException(201);
        }
        if (connection == null) {
            throw new NetException(208);
        }
        NVFactory nvf = new NVFactory();
        NVNavigator nvn = new NVNavigator();
        NVPair errvp = null;
        String errCode = null;
        this.addrRes = new AddrResolution(connection, userProperties);
        String s2 = (String)userProperties.get("DISABLE_OOB");
        boolean bl = disableOOB = s2 != null && "true".equals(s2);
        if (this.addrRes.connection_revised) {
            connection = this.addrRes.getTNSAddress();
            userProperties = this.addrRes.getUp();
        }
        this.sAtts.profile = new ClientProfile(userProperties);
        this.establishConnection(connection);
        Object objAno = null;
        try {
            objAno = Class.forName("oracle.net.ano.Ano").newInstance();
            this.sAtts.anoEnabled = true;
        }
        catch (Exception e2) {
            this.sAtts.anoEnabled = false;
        }
        if (objAno != null) {
            ((Ano)objAno).init(this.sAtts);
            this.sAtts.ano = objAno;
            this.sAtts.anoEnabled = true;
        }
        block15: while (true) {
            IOException stashedException = null;
            cnPkt = new ConnectPacket(this.sAtts, !disableOOB);
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            try {
                cnPkt.send();
                this.packet.receive();
            }
            catch (InterruptedIOException ea) {
                throw ea;
            }
            catch (IOException ea) {
                this.packet.type = 4;
                stashedException = ea;
            }
            switch (this.packet.type) {
                case 2: {
                    acPkt = new AcceptPacket(this.packet);
                    break block15;
                }
                case 5: {
                    rdPkt = new RedirectPacket(this.packet);
                    ConnOption origConnOption = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts = this.establishConnection(rdPkt.getData());
                    this.sAtts.cOption.restoreFromOrigCoption(origConnOption);
                    break;
                }
                case 4: {
                    rfPkt = new RefusePacket(this.packet);
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    this.establishConnection(null);
                    if (this.sAtts.cOption != null) continue block15;
                    if (stashedException != null) {
                        throw stashedException;
                    }
                    try {
                        NVPair nvPair;
                        errvp = nvn.findNVPairRecurse(nvf.createNVPair(rfPkt.getData()), "ERROR");
                        if (errvp != null && (nvPair = nvn.findNVPairRecurse(errvp, "CODE")) != null) {
                            errCode = nvPair.valueToString();
                        }
                    }
                    catch (NLException exp) {
                        System.err.println(exp.getMessage());
                    }
                    throw new NetException(errCode == null ? 206 : Integer.parseInt(errCode), connection + "\n");
                }
                case 11: {
                    break;
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
        }
        this.setNetStreams();
        this.sAtts.connected = true;
        if (userProperties.get("oracle.net.CONNECT_TIMEOUT") != null) {
            String tmp = (String)userProperties.get("oracle.net.READ_TIMEOUT");
            this.sAtts.cOption.nt.setOption(3, tmp == null ? "0" : tmp);
        }
        if ((verifyString = (String)this.sAtts.nt.getOption(6)) != null && verifyString.equalsIgnoreCase("false")) {
            throw new NetException(405);
        }
        if (this.sAtts.ano != null) {
            this.sAtts.ano.negotiation();
            String transportEncryptionEnabled = (String)this.sAtts.nt.getOption(2);
            if (transportEncryptionEnabled != null && transportEncryptionEnabled.equals("TRUE")) {
                try {
                    Method getEncMethod = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                    if (getEncMethod.invoke((Object)this.sAtts.ano, (Object[])null) != null) {
                        throw new NetException(406);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        this.packet = null;
        cnPkt = null;
        acPkt = null;
        rdPkt = null;
        rfPkt = null;
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException ioException = null;
        try {
            this.sAtts.nsOutputStream.close();
        }
        catch (IOException ea) {
            ioException = ea;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        if (ioException != null) {
            throw ioException;
        }
    }

    @Override
    public void sendBreak() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(1);
            }
        } else {
            this.sendMarker(1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(3);
            }
        } else {
            this.sendMarker(3);
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(2);
        while (this.sAtts.onBreakReset) {
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            this.packet.receive();
            if (this.packet.type != 12) continue;
            this.mkPkt = new MarkerPacket(this.packet);
            if (this.mkPkt.data != 2) continue;
            this.sAtts.onBreakReset = false;
        }
        this.mkPkt = null;
    }

    @Override
    public InputStream getInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    private SessionAtts establishConnection(String connection) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(connection);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
        this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
        return this.sAtts;
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    private void sendMarker(int type) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.mkPkt = new MarkerPacket(this.sAtts, type);
        this.mkPkt.send();
        this.mkPkt = null;
    }

    @Override
    public void setO3logSessionKey(byte[] sessionKey) throws NetException {
        if (sessionKey != null) {
            this.sAtts.ano.setO3logSessionKey(sessionKey);
        }
    }

    @Override
    public void setOption(int option, Object value) throws NetException, IOException {
        if (option > 0 && option < 10) {
            NTAdapter nt = this.sAtts.getNTAdapter();
            nt.setOption(option, value);
        }
    }

    @Override
    public Object getOption(int option) throws NetException, IOException {
        if (option > 0 && option < 10) {
            NTAdapter nt = this.sAtts.getNTAdapter();
            return nt.getOption(option);
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        NTAdapter nt = this.sAtts.getNTAdapter();
        if (nt != null) {
            nt.abort();
        }
    }

    @Override
    public String getEncryptionName() {
        String ret = "";
        if (this.sAtts.ano != null) {
            ret = this.sAtts.ano.getEncryptionName();
        }
        return ret;
    }

    @Override
    public String getDataIntegrityName() {
        String ret = "";
        if (this.sAtts.ano != null) {
            ret = this.sAtts.ano.getDataIntegrityName();
        }
        return ret;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String ret = "";
        if (this.sAtts.ano != null) {
            ret = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return ret;
    }
}

