/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataPacket
extends Packet
implements SQLnetDef {
    static final boolean DEBUG2 = false;
    protected int pktOffset;
    protected int dataFlags;
    protected boolean isBufferFull = false;
    protected boolean isBufferEmpty = false;
    protected int availableBytesToSend = 0;
    protected int availableBytesToRead = 0;

    public DataPacket(SessionAtts sAtts, int len) {
        super(sAtts, len, 6, 0);
        this.initialize(len);
    }

    public DataPacket(SessionAtts sAtts) {
        this(sAtts, sAtts.getSDU());
    }

    @Override
    protected void receive() throws IOException, NetException {
        super.receive();
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = this.length - this.dataOff;
        this.dataFlags = this.buffer[8] & 0xFF;
        this.dataFlags <<= 8;
        this.dataFlags |= this.buffer[9] & 0xFF;
        if (this.type == 6 && (this.dataFlags & 0x40) != 0) {
            this.sAtts.dataEOF = true;
        }
        if (this.type == 6 && 0 == this.dataLen) {
            this.type = 7;
        }
    }

    @Override
    protected void send() throws IOException {
        this.send(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int dataFlags) throws IOException {
        this.buffer[8] = (byte)(dataFlags / 256);
        this.buffer[9] = (byte)(dataFlags % 256);
        this.setBufferLength(this.pktOffset);
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
        }
        this.pktOffset = 10;
        this.availableBytesToSend = 0;
        this.isBufferFull = false;
    }

    protected int putDataInBuffer(byte[] userBuffer, int off, int len) throws IOException {
        int bytes2copy;
        int n2 = bytes2copy = this.buffer.length - this.pktOffset <= len ? this.buffer.length - this.pktOffset : len;
        if (bytes2copy > 0) {
            System.arraycopy(userBuffer, off, this.buffer, this.pktOffset, bytes2copy);
            this.pktOffset += bytes2copy;
            this.isBufferFull = this.pktOffset == this.buffer.length;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return bytes2copy;
    }

    protected int getDataFromBuffer(byte[] userBuffer, int off, int len) throws NetException {
        int bytes2copy;
        int n2 = bytes2copy = this.length - this.pktOffset <= len ? this.length - this.pktOffset : len;
        if (bytes2copy > 0) {
            System.arraycopy(this.buffer, this.pktOffset, userBuffer, off, bytes2copy);
            this.pktOffset += bytes2copy;
            this.isBufferEmpty = this.pktOffset == this.length;
            this.availableBytesToRead = this.dataOff + this.dataLen - this.pktOffset;
        }
        return bytes2copy;
    }

    protected void setBufferLength(int length) throws NetException {
        this.buffer[0] = (byte)(length / 256);
        this.buffer[1] = (byte)(length % 256);
    }

    protected void initialize(int bufferSize) {
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = bufferSize - this.dataOff;
        this.dataFlags = 0;
    }
}

