/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class ConnectPacket
extends Packet
implements SQLnetDef {
    private boolean connDataOflow;

    public ConnectPacket(SessionAtts sAtts, boolean sendAttention) throws IOException {
        super(sAtts);
        this.data = sAtts.cOption.conn_data.toString();
        this.dataLen = this.data == null ? 0 : this.data.length();
        this.connDataOflow = this.dataLen > 230;
        int bufferLength = !this.connDataOflow ? 34 + this.dataLen : 34;
        this.createBuffer(bufferLength, 1, 0);
        this.buffer[8] = 1;
        this.buffer[9] = 52;
        this.buffer[10] = 1;
        this.buffer[11] = 44;
        int opt = 0;
        if (sendAttention && sAtts.nt.isCharacteristicUrgentSupported()) {
            opt = 3073;
        }
        this.buffer[12] = (byte)(opt >> 8 & 0xFF);
        this.buffer[13] = (byte)(opt & 0xFF);
        this.buffer[14] = (byte)(this.sdu / 256);
        this.buffer[15] = (byte)(this.sdu % 256);
        this.buffer[16] = (byte)(this.tdu / 256);
        this.buffer[17] = (byte)(this.tdu % 256);
        this.buffer[18] = 79;
        this.buffer[19] = -104;
        this.buffer[22] = 0;
        this.buffer[23] = 1;
        this.buffer[24] = (byte)(this.dataLen / 256);
        this.buffer[25] = (byte)(this.dataLen % 256);
        this.buffer[27] = 34;
        if (!sAtts.anoEnabled) {
            this.buffer[33] = 4;
            this.buffer[32] = 4;
        } else {
            this.buffer[32] = this.buffer[33] = (byte)sAtts.getANOFlags();
        }
        if (!this.connDataOflow && this.dataLen > 0) {
            this.data.getBytes(0, this.dataLen, this.buffer, 34);
        }
    }

    @Override
    protected void send() throws IOException {
        super.send();
        if (this.connDataOflow) {
            byte[] userBuffer = new byte[this.dataLen];
            this.data.getBytes(0, this.dataLen, userBuffer, 0);
            this.sAtts.nsOutputStream.write(userBuffer);
            this.sAtts.nsOutputStream.flush();
        }
    }
}

