/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import oracle.net.ns.NetException;

public class JndiAttrs {
    private Properties env;
    private static final String nFactory = "java.naming.factory.initial";
    private static final String nProvider = "java.naming.provider.url";
    private static final String nProfile = "ora-net-profile";
    private static final String default_nFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    DirContext ctx;

    public JndiAttrs(Properties up) throws NetException {
        String providerURL = null;
        this.env = new Properties();
        if (up.containsKey(nFactory)) {
            this.env.put(nFactory, up.getProperty(nFactory));
        } else {
            this.env.put(nFactory, default_nFactory);
        }
        if (up.containsKey(nProvider)) {
            providerURL = up.getProperty(nProvider);
            if (providerURL.startsWith("ldaps")) {
                this.env.put("java.naming.ldap.factory.socket", "oracle.net.jndi.CustomSSLSocketFactory");
                this.env.put("java.naming.security.protocol", "ssl");
                providerURL = "ldap:" + providerURL.substring(6);
            }
            this.env.put(nProvider, providerURL);
        }
        if (up.containsKey("oracle.net.profile")) {
            this.env.put(nProfile, up.getProperty("oracle.net.profile"));
        }
        try {
            Class<?> jclass = Class.forName("javax.naming.directory.InitialDirContext");
            if (this.env.get(nFactory) == null) {
                this.env.put(nFactory, default_nFactory);
            }
            if (this.env.get(nProvider) == null) {
                this.env.put(nProvider, providerURL);
            }
        }
        catch (Exception classE) {
            throw new NetException(110, classE.toString());
        }
        Object prop = up.get("java.naming.security.authentication");
        if (prop != null) {
            this.env.put("java.naming.security.authentication", prop);
        }
        if ((prop = up.get("java.naming.security.principal")) != null) {
            this.env.put("java.naming.security.principal", prop);
        }
        if ((prop = up.get("java.naming.security.credentials")) != null) {
            this.env.put("java.naming.security.credentials", prop);
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                this.ctx = new InitialDirContext(this.env);
                break;
            }
            catch (NamingException namingE) {
                Class<?> l_class = null;
                try {
                    l_class = Class.forName("javax.net.ssl.SSLException");
                }
                catch (Exception classE) {
                    throw new NetException(108, namingE.toString());
                }
                if (l_class.isInstance(namingE.getRootCause()) && i2 < 3) continue;
                throw new NetException(108, namingE.toString());
            }
        }
    }

    public Vector getProfileAttrs(String cn) throws NetException {
        String _cn = "cn=";
        Attributes attrs = null;
        try {
            _cn = _cn.concat(cn);
            attrs = this.ctx.getAttributes(_cn);
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
        return this.setAttrs(attrs);
    }

    public Vector getAttrs(String alias, String[] attrname) throws NetException {
        String _cn = "cn=";
        Attributes attrs = null;
        try {
            _cn = _cn.concat(alias);
            attrs = this.ctx.getAttributes(_cn, attrname);
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
        return this.setAttrs(attrs);
    }

    private Vector setAttrs(Attributes attrs) throws NetException {
        Vector nattr = new Vector(1, 1);
        if (attrs == null) {
            System.out.println("No attributes");
        } else {
            try {
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae != null && ae.hasMoreElements()) {
                    Attribute attr = ae.next();
                    NamingEnumeration<?> e2 = attr.getAll();
                    while (e2.hasMoreElements()) {
                        nattr.addElement(e2.nextElement());
                    }
                }
            }
            catch (NamingException namingE) {
                throw new NetException(108, namingE.toString());
            }
        }
        return nattr;
    }

    public void setEnv(String envP, String envV) {
        this.env.put(envP, envV);
    }

    public void close() throws NetException {
        try {
            if (null != this.ctx) {
                this.ctx.close();
            }
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
    }

    public final String getLdapUrlUsed() throws NetException {
        String url = null;
        try {
            url = (String)this.ctx.getEnvironment().get(nProvider);
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
        return url;
    }
}

