/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private static final boolean DEBUG = false;
    private static SSLSocketFactory ossl = null;

    protected static boolean isFactorySet() {
        return null != ossl;
    }

    protected static void setFactory(SSLSocketFactory factory) {
        if (null == ossl) {
            ossl = factory;
        }
    }

    protected void setDefaultFactory() {
        CustomSSLSocketFactory.setFactory((SSLSocketFactory)SSLSocketFactory.getDefault());
    }

    protected CustomSSLSocketFactory() {
    }

    public static SocketFactory getDefault() {
        CustomSSLSocketFactory sf = null;
        try {
            Class<?> c2 = Class.forName("oracle.net.jndi.TrustManagerSSLSocketFactory");
            Class.forName("javax.net.ssl.TrustManagerFactory");
            sf = (CustomSSLSocketFactory)c2.newInstance();
        }
        catch (Exception e2) {
            sf = new CustomSSLSocketFactory();
        }
        sf.setDefaultFactory();
        return sf;
    }

    @Override
    public Socket createSocket(String s2, int i2) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(s2, i2);
        return this.init(sock);
    }

    @Override
    public Socket createSocket(InetAddress iaddr, int i2) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(iaddr, i2);
        return this.init(sock);
    }

    @Override
    public Socket createSocket(String s2, int i2, InetAddress iaddr, int j2) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(s2, i2, iaddr, j2);
        return this.init(sock);
    }

    @Override
    public Socket createSocket(InetAddress iaddr1, int i2, InetAddress iaddr2, int j2) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(iaddr1, i2, iaddr2, j2);
        return this.init(sock);
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(s2, host, port, autoClose);
        return this.init(sock);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return ossl.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return ossl.getSupportedCipherSuites();
    }

    private SSLSocket init(SSLSocket sock) throws IOException {
        sock.setUseClientMode(true);
        String[] cipherSuite = new String[]{"SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
        sock.setEnabledCipherSuites(cipherSuite);
        sock.startHandshake();
        return sock;
    }
}

