/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit;
    protected boolean savedXAConnectionAutoCommit;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection;
    protected OracleXAConnection xaconnection;
    protected int timeout;
    protected String dblink;
    private Connection logicalConnection;
    private String synchronizeBeforeRecoverNewCall;
    private String synchronizeBeforeRecoverOldCall;
    private String recoverySqlRows;
    protected Vector locallySuspendedTransactions;
    protected boolean canBeMigratablySuspended;
    protected XidListEntry xidHead;
    protected XidListEntry xidTail;
    protected XidListEntry currentXidListEntry;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:44_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource() {
        block4: {
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.locallySuspendedTransactions = new Vector();
            this.canBeMigratablySuspended = false;
            this.xidHead = null;
            this.xidTail = null;
            this.currentXidListEntry = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        block6: {
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.locallySuspendedTransactions = new Vector();
            this.canBeMigratablySuspended = false;
            this.xidHead = null;
            this.xidTail = null;
            this.currentXidListEntry = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(pm_conn) + ", " + OracleLog.argument(xaconn));
                    OracleLog.recursiveTrace = false;
                }
                this.connection = pm_conn;
                this.xaconnection = xaconn;
                if (this.connection == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -7");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-7);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnection(Connection pm_conn) throws XAException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(pm_conn));
                    OracleLog.recursiveTrace = false;
                }
                this.connection = pm_conn;
                if (this.connection == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -7");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-7);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final XidListEntry getMatchingXidListEntry(Xid xid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            XidListEntry x = this.xidHead;
            while (x != null && !this.isSameXid(x.xid, xid)) {
                x = x.next;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "return: " + x);
                OracleLog.recursiveTrace = false;
            }
            XidListEntry xidListEntry = x;
            return xidListEntry;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeXidFromList(Xid xid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            if (!this.isXidListEmpty()) {
                if (this.isSameXid(this.xidHead.xid, xid)) {
                    this.xidHead = this.xidHead.next;
                    if (this.xidHead == null) {
                        this.xidTail = this.xidHead;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_30, "return: true");
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl = true;
                    return bl;
                }
                XidListEntry x = this.xidHead.next;
                XidListEntry prev = this.xidHead;
                while (x != null) {
                    if (this.isSameXid(x.xid, xid)) {
                        prev.next = x.next;
                        if (this.xidTail == x) {
                            this.xidTail = prev;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_30, "return: true");
                            OracleLog.recursiveTrace = false;
                        }
                        boolean bl = true;
                        return bl;
                    }
                    prev = x;
                    x = x.next;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isSameXid(Xid xid1, Xid xid2) {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid1) + ", " + OracleLog.argument(xid2));
                OracleLog.recursiveTrace = false;
            }
            if (xid1 == xid2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_30, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            byte[] xid1Gtrid = xid1.getGlobalTransactionId();
            byte[] xid2Gtrid = xid2.getGlobalTransactionId();
            byte[] xid1Bqual = xid1.getBranchQualifier();
            byte[] xid2Bqual = xid2.getBranchQualifier();
            if (xid1.getFormatId() != xid2.getFormatId() || xid1Gtrid == null || xid2Gtrid == null || xid1Bqual == null || xid2Bqual == null || xid1Gtrid.length != xid2Gtrid.length || xid1Bqual.length != xid2Bqual.length) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            for (i2 = 0; i2 < xid1Gtrid.length; ++i2) {
                if (xid1Gtrid[i2] == xid2Gtrid[i2]) continue;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            for (i2 = 0; i2 < xid1Bqual.length; ++i2) {
                if (xid1Bqual[i2] == xid2Bqual[i2]) continue;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "return: true");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isXidListEmpty() {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = this.xidHead == null;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isCurrentXidSuspended(Xid xid) {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = this.currentXidListEntry != null && this.isSameXid(this.currentXidListEntry.xid, xid) && this.currentXidListEntry.isSuspended;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createOrUpdateXid(Xid xid, boolean isSuspended, boolean[] isLocallySuspended) {
        try {
            XidListEntry x;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(isSuspended) + ", " + OracleLog.argument(isLocallySuspended));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.putXidToList (xid = " + xid + ", isSusended = " + isSuspended + " ): stacking xid");
                OracleLog.recursiveTrace = false;
            }
            if ((x = this.getMatchingXidListEntry(xid)) != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.putXidToList (xid = " + xid + ", isSusended = " + isSuspended + " ): x(not supposed to be null) = " + x);
                    OracleLog.recursiveTrace = false;
                }
                isLocallySuspended[0] = true;
                x.isSuspended = isSuspended;
            } else {
                x = new XidListEntry(xid, isSuspended);
                if (this.xidTail == null) {
                    this.xidHead = this.xidTail = x;
                } else {
                    this.xidTail.next = x;
                    this.xidTail = x;
                }
            }
            if (!isSuspended) {
                this.enterGlobalTxnMode();
            }
            this.currentXidListEntry = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateXidList(Xid xid, boolean[] flags) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.updateXidList (" + xid + "): trying to clear stacked xid");
                OracleLog.recursiveTrace = false;
            }
            boolean foundXid = false;
            XidListEntry x = this.getMatchingXidListEntry(xid);
            if (x != null) {
                foundXid = true;
                flags[0] = true;
                flags[1] = x.isSuspended;
                if (x.isSuspended) {
                    this.enterGlobalTxnMode();
                } else {
                    this.exitGlobalTxnMode();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + foundXid);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = foundXid;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xid suspendStacked(Xid xid) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            Xid stackedXid = null;
            if (!this.isXidListEmpty() && this.currentXidListEntry != null && !this.isSameXid(this.currentXidListEntry.xid, xid)) {
                stackedXid = this.xidTail.xid;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.suspendStacked(xid): Before calling end()");
                    OracleLog.recursiveTrace = false;
                }
                this.end(stackedXid, 0x2000000);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + stackedXid);
                OracleLog.recursiveTrace = false;
            }
            Xid xid2 = stackedXid;
            return xid2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xid suspendStacked(Xid xid, int endFlags) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(endFlags));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.suspendStacked(xid = " + xid + ", endFlags = " + Integer.toHexString(endFlags) + ")");
                OracleLog.recursiveTrace = false;
            }
            Xid stackedXid = null;
            if (endFlags == 0x4000000 && this.xidTail != null && this.currentXidListEntry != null && !this.isSameXid(this.currentXidListEntry.xid, xid)) {
                this.allowGlobalTxnModeOnly(-3);
                stackedXid = this.xidTail.xid;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.suspendStacked(xid, endFlags): Before end()");
                    OracleLog.recursiveTrace = false;
                }
                this.end(stackedXid, 0x2000000);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.suspendStacked(xid, endFlags): Before start()");
                    OracleLog.recursiveTrace = false;
                }
                this.start(xid, 0x8000000);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + stackedXid);
                OracleLog.recursiveTrace = false;
            }
            Xid xid2 = stackedXid;
            return xid2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeStacked(Xid xid) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            if (xid != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.resumeStacked(xid): Before calling start()");
                    OracleLog.recursiveTrace = false;
                }
                this.start(xid, 0x8000000);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int flag) throws XAException {
        Xid[] xidArray;
        block26: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(flag));
                    OracleLog.recursiveTrace = false;
                }
                if ((flag & 0x1800000) != flag) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.recover(flag): XAER_INVAL, invalid flag");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                Statement stmt = null;
                ResultSet rset = null;
                ArrayList<OracleXid> xidCollection = new ArrayList<OracleXid>(50);
                try {
                    stmt = this.connection.createStatement();
                    try {
                        stmt.execute(this.synchronizeBeforeRecoverNewCall);
                    }
                    catch (Exception exc) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.recover(flag): DBMS_XA.dist_txn_sync failed: " + exc);
                            OracleLog.recursiveTrace = false;
                        }
                        stmt.execute(this.synchronizeBeforeRecoverOldCall);
                    }
                    rset = stmt.executeQuery(this.recoverySqlRows);
                    while (rset.next()) {
                        xidCollection.add(new OracleXid(rset.getInt(1), rset.getBytes(2), rset.getBytes(3)));
                    }
                }
                catch (SQLException sqe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.recover(flag): SQLException(internal) " + sqe);
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -3");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-3);
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (rset != null) {
                            rset.close();
                        }
                    }
                    catch (Exception ignore) {}
                }
                int xidSize = xidCollection.size();
                Xid[] xids = new Xid[xidSize];
                System.arraycopy(xidCollection.toArray(), 0, xids, 0, xidSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + xids);
                    OracleLog.recursiveTrace = false;
                }
                xidArray = xids;
                if (!TRACE || OracleLog.recursiveTrace) break block26;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
                try {
                    this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                    this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
                }
                catch (SQLException ignoreException) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.restoreAutoCommitModeForGlobalTransaction got exception: " + ignoreException);
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                this.xaconnection.setAutoCommit(false);
            }
            catch (SQLException ignoreException) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.saveAndAlterAutoCommitModeForGlobalTransaction got exception: " + ignoreException);
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Xid xid) throws XAException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                this.start(xid, 0x8000000);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Xid xid) throws XAException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                this.start(xid, 0x200000);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Xid xid) throws XAException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                this.end(xid, 0x2000000);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Xid xid, int timeout) throws XAException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(timeout));
                    OracleLog.recursiveTrace = false;
                }
                this.timeout = timeout;
                this.start(xid, 0x200000);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Xid xid, int timeout) throws XAException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(timeout));
                    OracleLog.recursiveTrace = false;
                }
                this.timeout = timeout;
                this.start(xid, 0x8000000);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        Connection connection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.connection);
                    OracleLog.recursiveTrace = false;
                }
                connection = this.connection;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionTimeout() throws XAException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.timeout);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.timeout;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        boolean bl;
        block20: {
            block21: {
                block18: {
                    boolean bl2;
                    block19: {
                        boolean _returnVal;
                        Connection conn1;
                        block16: {
                            boolean bl3;
                            block17: {
                                block14: {
                                    boolean bl4;
                                    block15: {
                                        try {
                                            if (TRACE && !OracleLog.recursiveTrace) {
                                                OracleLog.recursiveTrace = true;
                                                OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xares));
                                                OracleLog.recursiveTrace = false;
                                            }
                                            conn1 = null;
                                            if (xares instanceof OracleXAResource) {
                                                conn1 = ((OracleXAResource)xares).getConnection();
                                                break block14;
                                            }
                                            if (TRACE && !OracleLog.recursiveTrace) {
                                                OracleLog.recursiveTrace = true;
                                                OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                                OracleLog.recursiveTrace = false;
                                            }
                                            bl4 = false;
                                            if (!TRACE || OracleLog.recursiveTrace) break block15;
                                            OracleLog.recursiveTrace = true;
                                        }
                                        catch (Throwable throwable) {
                                            if (TRACE && !OracleLog.recursiveTrace) {
                                                OracleLog.recursiveTrace = true;
                                                OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                                OracleLog.recursiveTrace = false;
                                            }
                                            throw throwable;
                                        }
                                        OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    return bl4;
                                }
                                if (this.connection != null && !((OracleConnection)this.connection).isClosed()) break block16;
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                    OracleLog.recursiveTrace = false;
                                }
                                bl3 = false;
                                if (!TRACE || OracleLog.recursiveTrace) break block17;
                                OracleLog.recursiveTrace = true;
                                OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return bl3;
                        }
                        String l_url = ((OracleConnection)this.connection).getURL();
                        String l_prt = ((OracleConnection)this.connection).getProtocolType();
                        if (conn1 == null) break block18;
                        boolean bl5 = _returnVal = conn1.equals(this.connection) || ((OracleConnection)conn1).getURL().equals(l_url) || ((OracleConnection)conn1).getProtocolType().equals(l_prt) && l_prt.equals("kprb");
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + _returnVal);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = _returnVal;
                        if (!TRACE || OracleLog.recursiveTrace) break block19;
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                break block21;
                catch (SQLException sqe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -3");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-3);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            bl = false;
            if (!TRACE || OracleLog.recursiveTrace) break block20;
            OracleLog.recursiveTrace = true;
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        boolean bl;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(seconds));
                    OracleLog.recursiveTrace = false;
                }
                if (seconds < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                this.timeout = seconds;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                bl = true;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBLink() {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.dblink);
                    OracleLog.recursiveTrace = false;
                }
                string = this.dblink;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDBLink(String dblink) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(dblink));
                    OracleLog.recursiveTrace = false;
                }
                this.dblink = dblink;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogicalConnection(Connection conn) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(conn));
                    OracleLog.recursiveTrace = false;
                }
                this.logicalConnection = conn;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allowGlobalTxnModeOnly(int errorCode) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(errorCode));
                OracleLog.recursiveTrace = false;
            }
            if (((OracleConnection)this.connection).getTxnMode() != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: " + errorCode);
                    OracleLog.recursiveTrace = false;
                }
                throw new XAException(errorCode);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitGlobalTxnMode() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            ((OracleConnection)this.connection).setTxnMode(0);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enterGlobalTxnMode() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            ((OracleConnection)this.connection).setTxnMode(1);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(int error) throws OracleXAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(error));
                OracleLog.recursiveTrace = false;
            }
            if ((error & 0xFFFF) != 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(Level.SEVERE, "Throwing OracleXAException: " + error);
                    OracleLog.recursiveTrace = false;
                }
                throw new OracleXAException(error);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(int error, int defaultXAError) throws OracleXAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(error) + ", " + OracleLog.argument(defaultXAError));
                OracleLog.recursiveTrace = false;
            }
            if ((error & 0xFFFF) != 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(Level.SEVERE, "Throwing OracleXAException: " + error + defaultXAError);
                    OracleLog.recursiveTrace = false;
                }
                throw new OracleXAException(error, defaultXAError);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;
        XidListEntry next = null;

        XidListEntry(Xid x, boolean s2) {
            this.xid = x;
            this.isSuspended = s2;
        }
    }
}

